/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportsResponse;
import software.amazon.awssdk.services.codebuild.model.CreateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.CreateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.CreateReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.CreateReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.CreateWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.CreateWebhookResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteReportRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteReportResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest;
import software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse;
import software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest;
import software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse;
import software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendRequest;
import software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendResponse;
import software.amazon.awssdk.services.codebuild.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.codebuild.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsRequest;
import software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsResponse;
import software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheRequest;
import software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesRequest;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse;
import software.amazon.awssdk.services.codebuild.model.ListProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse;
import software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.ListReportsRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportsResponse;
import software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse;
import software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsResponse;
import software.amazon.awssdk.services.codebuild.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.codebuild.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.codebuild.model.RetryBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.RetryBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.RetryBuildRequest;
import software.amazon.awssdk.services.codebuild.model.RetryBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StartBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.StartBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.StartBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StartBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StopBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.StopBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.StopBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StopBuildResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateWebhookResponse;
import software.amazon.awssdk.services.codebuild.paginators.DescribeCodeCoveragesPublisher;
import software.amazon.awssdk.services.codebuild.paginators.DescribeTestCasesPublisher;
import software.amazon.awssdk.services.codebuild.paginators.ListBuildBatchesForProjectPublisher;
import software.amazon.awssdk.services.codebuild.paginators.ListBuildBatchesPublisher;
import software.amazon.awssdk.services.codebuild.paginators.ListBuildsForProjectPublisher;
import software.amazon.awssdk.services.codebuild.paginators.ListBuildsPublisher;
import software.amazon.awssdk.services.codebuild.paginators.ListProjectsPublisher;
import software.amazon.awssdk.services.codebuild.paginators.ListReportGroupsPublisher;
import software.amazon.awssdk.services.codebuild.paginators.ListReportsForReportGroupPublisher;
import software.amazon.awssdk.services.codebuild.paginators.ListReportsPublisher;
import software.amazon.awssdk.services.codebuild.paginators.ListSharedProjectsPublisher;
import software.amazon.awssdk.services.codebuild.paginators.ListSharedReportGroupsPublisher;

/**
 * Service client for accessing AWS CodeBuild asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>CodeBuild</fullname>
 * <p>
 * CodeBuild is a fully managed build service in the cloud. CodeBuild compiles your source code, runs unit tests, and
 * produces artifacts that are ready to deploy. CodeBuild eliminates the need to provision, manage, and scale your own
 * build servers. It provides prepackaged build environments for the most popular programming languages and build tools,
 * such as Apache Maven, Gradle, and more. You can also fully customize build environments in CodeBuild to use your own
 * build tools. CodeBuild scales automatically to meet peak build requests. You pay only for the build time you consume.
 * For more information about CodeBuild, see the <i> <a
 * href="https://docs.aws.amazon.com/codebuild/latest/userguide/welcome.html">CodeBuild User Guide</a>.</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CodeBuildAsyncClient extends AwsClient {
    String SERVICE_NAME = "codebuild";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "codebuild";

    /**
     * <p>
     * Deletes one or more builds.
     * </p>
     *
     * @param batchDeleteBuildsRequest
     * @return A Java Future containing the result of the BatchDeleteBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchDeleteBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchDeleteBuilds" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteBuildsResponse> batchDeleteBuilds(BatchDeleteBuildsRequest batchDeleteBuildsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more builds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteBuildsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDeleteBuildsRequest#builder()}
     * </p>
     *
     * @param batchDeleteBuildsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteBuildsInput.Builder} to create a request.
     * @return A Java Future containing the result of the BatchDeleteBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchDeleteBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchDeleteBuilds" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchDeleteBuildsResponse> batchDeleteBuilds(
            Consumer<BatchDeleteBuildsRequest.Builder> batchDeleteBuildsRequest) {
        return batchDeleteBuilds(BatchDeleteBuildsRequest.builder().applyMutation(batchDeleteBuildsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about one or more batch builds.
     * </p>
     *
     * @param batchGetBuildBatchesRequest
     * @return A Java Future containing the result of the BatchGetBuildBatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetBuildBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuildBatches"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetBuildBatchesResponse> batchGetBuildBatches(
            BatchGetBuildBatchesRequest batchGetBuildBatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about one or more batch builds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetBuildBatchesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetBuildBatchesRequest#builder()}
     * </p>
     *
     * @param batchGetBuildBatchesRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetBuildBatchesInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetBuildBatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetBuildBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuildBatches"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetBuildBatchesResponse> batchGetBuildBatches(
            Consumer<BatchGetBuildBatchesRequest.Builder> batchGetBuildBatchesRequest) {
        return batchGetBuildBatches(BatchGetBuildBatchesRequest.builder().applyMutation(batchGetBuildBatchesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more builds.
     * </p>
     *
     * @param batchGetBuildsRequest
     * @return A Java Future containing the result of the BatchGetBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetBuildsResponse> batchGetBuilds(BatchGetBuildsRequest batchGetBuildsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more builds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetBuildsRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetBuildsRequest#builder()}
     * </p>
     *
     * @param batchGetBuildsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetBuildsInput.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetBuildsResponse> batchGetBuilds(Consumer<BatchGetBuildsRequest.Builder> batchGetBuildsRequest) {
        return batchGetBuilds(BatchGetBuildsRequest.builder().applyMutation(batchGetBuildsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more build projects.
     * </p>
     *
     * @param batchGetProjectsRequest
     * @return A Java Future containing the result of the BatchGetProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetProjectsResponse> batchGetProjects(BatchGetProjectsRequest batchGetProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more build projects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetProjectsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetProjectsRequest#builder()}
     * </p>
     *
     * @param batchGetProjectsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetProjectsInput.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetProjectsResponse> batchGetProjects(
            Consumer<BatchGetProjectsRequest.Builder> batchGetProjectsRequest) {
        return batchGetProjects(BatchGetProjectsRequest.builder().applyMutation(batchGetProjectsRequest).build());
    }

    /**
     * <p>
     * Returns an array of report groups.
     * </p>
     *
     * @param batchGetReportGroupsRequest
     * @return A Java Future containing the result of the BatchGetReportGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetReportGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetReportGroupsResponse> batchGetReportGroups(
            BatchGetReportGroupsRequest batchGetReportGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of report groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetReportGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetReportGroupsRequest#builder()}
     * </p>
     *
     * @param batchGetReportGroupsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetReportGroupsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchGetReportGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetReportGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetReportGroupsResponse> batchGetReportGroups(
            Consumer<BatchGetReportGroupsRequest.Builder> batchGetReportGroupsRequest) {
        return batchGetReportGroups(BatchGetReportGroupsRequest.builder().applyMutation(batchGetReportGroupsRequest).build());
    }

    /**
     * <p>
     * Returns an array of reports.
     * </p>
     *
     * @param batchGetReportsRequest
     * @return A Java Future containing the result of the BatchGetReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetReports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetReportsResponse> batchGetReports(BatchGetReportsRequest batchGetReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of reports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetReportsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetReportsRequest#builder()}
     * </p>
     *
     * @param batchGetReportsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetReportsInput.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetReports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetReportsResponse> batchGetReports(
            Consumer<BatchGetReportsRequest.Builder> batchGetReportsRequest) {
        return batchGetReports(BatchGetReportsRequest.builder().applyMutation(batchGetReportsRequest).build());
    }

    /**
     * <p>
     * Creates a build project.
     * </p>
     *
     * @param createProjectRequest
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a build project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on {@link CreateProjectInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Creates a report group. A report group contains a collection of reports.
     * </p>
     *
     * @param createReportGroupRequest
     * @return A Java Future containing the result of the CreateReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.CreateReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateReportGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateReportGroupResponse> createReportGroup(CreateReportGroupRequest createReportGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a report group. A report group contains a collection of reports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReportGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateReportGroupRequest#builder()}
     * </p>
     *
     * @param createReportGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateReportGroupInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.CreateReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateReportGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateReportGroupResponse> createReportGroup(
            Consumer<CreateReportGroupRequest.Builder> createReportGroupRequest) {
        return createReportGroup(CreateReportGroupRequest.builder().applyMutation(createReportGroupRequest).build());
    }

    /**
     * <p>
     * For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository,
     * enables CodeBuild to start rebuilding the source code every time a code change is pushed to the repository.
     * </p>
     * <important>
     * <p>
     * If you enable webhooks for an CodeBuild project, and the project is used as a build step in CodePipeline, then
     * two identical builds are created for each commit. One build is triggered through webhooks, and one through
     * CodePipeline. Because billing is on a per-build basis, you are billed for both builds. Therefore, if you are
     * using CodePipeline, we recommend that you disable webhooks in CodeBuild. In the CodeBuild console, clear the
     * Webhook box. For more information, see step 5 in <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/change-project.html#change-project-console">Change a
     * Build Project's Settings</a>.
     * </p>
     * </important>
     *
     * @param createWebhookRequest
     * @return A Java Future containing the result of the CreateWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>OAuthProviderException There was a problem with the underlying OAuth provider.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.CreateWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWebhookResponse> createWebhook(CreateWebhookRequest createWebhookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository,
     * enables CodeBuild to start rebuilding the source code every time a code change is pushed to the repository.
     * </p>
     * <important>
     * <p>
     * If you enable webhooks for an CodeBuild project, and the project is used as a build step in CodePipeline, then
     * two identical builds are created for each commit. One build is triggered through webhooks, and one through
     * CodePipeline. Because billing is on a per-build basis, you are billed for both builds. Therefore, if you are
     * using CodePipeline, we recommend that you disable webhooks in CodeBuild. In the CodeBuild console, clear the
     * Webhook box. For more information, see step 5 in <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/change-project.html#change-project-console">Change a
     * Build Project's Settings</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWebhookRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWebhookRequest#builder()}
     * </p>
     *
     * @param createWebhookRequest
     *        A {@link Consumer} that will call methods on {@link CreateWebhookInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>OAuthProviderException There was a problem with the underlying OAuth provider.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.CreateWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWebhookResponse> createWebhook(Consumer<CreateWebhookRequest.Builder> createWebhookRequest) {
        return createWebhook(CreateWebhookRequest.builder().applyMutation(createWebhookRequest).build());
    }

    /**
     * <p>
     * Deletes a batch build.
     * </p>
     *
     * @param deleteBuildBatchRequest
     * @return A Java Future containing the result of the DeleteBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteBuildBatch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBuildBatchResponse> deleteBuildBatch(DeleteBuildBatchRequest deleteBuildBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a batch build.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBuildBatchRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBuildBatchRequest#builder()}
     * </p>
     *
     * @param deleteBuildBatchRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBuildBatchInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteBuildBatch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBuildBatchResponse> deleteBuildBatch(
            Consumer<DeleteBuildBatchRequest.Builder> deleteBuildBatchRequest) {
        return deleteBuildBatch(DeleteBuildBatchRequest.builder().applyMutation(deleteBuildBatchRequest).build());
    }

    /**
     * <p>
     * Deletes a build project. When you delete a project, its builds are not deleted.
     * </p>
     *
     * @param deleteProjectRequest
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a build project. When you delete a project, its builds are not deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProjectInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Deletes a report.
     * </p>
     *
     * @param deleteReportRequest
     * @return A Java Future containing the result of the DeleteReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteReport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReportResponse> deleteReport(DeleteReportRequest deleteReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReportRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteReportRequest#builder()}
     * </p>
     *
     * @param deleteReportRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReportInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteReport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReportResponse> deleteReport(Consumer<DeleteReportRequest.Builder> deleteReportRequest) {
        return deleteReport(DeleteReportRequest.builder().applyMutation(deleteReportRequest).build());
    }

    /**
     * <p>
     * Deletes a report group. Before you delete a report group, you must delete its reports.
     * </p>
     *
     * @param deleteReportGroupRequest
     * @return A Java Future containing the result of the DeleteReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteReportGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReportGroupResponse> deleteReportGroup(DeleteReportGroupRequest deleteReportGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a report group. Before you delete a report group, you must delete its reports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReportGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReportGroupRequest#builder()}
     * </p>
     *
     * @param deleteReportGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReportGroupInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteReportGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReportGroupResponse> deleteReportGroup(
            Consumer<DeleteReportGroupRequest.Builder> deleteReportGroupRequest) {
        return deleteReportGroup(DeleteReportGroupRequest.builder().applyMutation(deleteReportGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a resource policy that is identified by its resource ARN.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource policy that is identified by its resource ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials.
     * </p>
     *
     * @param deleteSourceCredentialsRequest
     * @return A Java Future containing the result of the DeleteSourceCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteSourceCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteSourceCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSourceCredentialsResponse> deleteSourceCredentials(
            DeleteSourceCredentialsRequest deleteSourceCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSourceCredentialsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSourceCredentialsRequest#builder()}
     * </p>
     *
     * @param deleteSourceCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSourceCredentialsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSourceCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteSourceCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteSourceCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSourceCredentialsResponse> deleteSourceCredentials(
            Consumer<DeleteSourceCredentialsRequest.Builder> deleteSourceCredentialsRequest) {
        return deleteSourceCredentials(DeleteSourceCredentialsRequest.builder().applyMutation(deleteSourceCredentialsRequest)
                .build());
    }

    /**
     * <p>
     * For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository,
     * stops CodeBuild from rebuilding the source code every time a code change is pushed to the repository.
     * </p>
     *
     * @param deleteWebhookRequest
     * @return A Java Future containing the result of the DeleteWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>OAuthProviderException There was a problem with the underlying OAuth provider.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWebhookResponse> deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository,
     * stops CodeBuild from rebuilding the source code every time a code change is pushed to the repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWebhookRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWebhookRequest#builder()}
     * </p>
     *
     * @param deleteWebhookRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWebhookInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>OAuthProviderException There was a problem with the underlying OAuth provider.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWebhookResponse> deleteWebhook(Consumer<DeleteWebhookRequest.Builder> deleteWebhookRequest) {
        return deleteWebhook(DeleteWebhookRequest.builder().applyMutation(deleteWebhookRequest).build());
    }

    /**
     * <p>
     * Retrieves one or more code coverage reports.
     * </p>
     *
     * @param describeCodeCoveragesRequest
     * @return A Java Future containing the result of the DescribeCodeCoverages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DescribeCodeCoverages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DescribeCodeCoverages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCodeCoveragesResponse> describeCodeCoverages(
            DescribeCodeCoveragesRequest describeCodeCoveragesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves one or more code coverage reports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCodeCoveragesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCodeCoveragesRequest#builder()}
     * </p>
     *
     * @param describeCodeCoveragesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCodeCoveragesInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCodeCoverages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DescribeCodeCoverages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DescribeCodeCoverages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCodeCoveragesResponse> describeCodeCoverages(
            Consumer<DescribeCodeCoveragesRequest.Builder> describeCodeCoveragesRequest) {
        return describeCodeCoverages(DescribeCodeCoveragesRequest.builder().applyMutation(describeCodeCoveragesRequest).build());
    }

    /**
     * <p>
     * Retrieves one or more code coverage reports.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCodeCoverages(software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.DescribeCodeCoveragesPublisher publisher = client.describeCodeCoveragesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.DescribeCodeCoveragesPublisher publisher = client.describeCodeCoveragesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCodeCoverages(software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCodeCoveragesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DescribeCodeCoverages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DescribeCodeCoverages"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCodeCoveragesPublisher describeCodeCoveragesPaginator(
            DescribeCodeCoveragesRequest describeCodeCoveragesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves one or more code coverage reports.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCodeCoverages(software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.DescribeCodeCoveragesPublisher publisher = client.describeCodeCoveragesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.DescribeCodeCoveragesPublisher publisher = client.describeCodeCoveragesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCodeCoverages(software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCodeCoveragesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCodeCoveragesRequest#builder()}
     * </p>
     *
     * @param describeCodeCoveragesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCodeCoveragesInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DescribeCodeCoverages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DescribeCodeCoverages"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCodeCoveragesPublisher describeCodeCoveragesPaginator(
            Consumer<DescribeCodeCoveragesRequest.Builder> describeCodeCoveragesRequest) {
        return describeCodeCoveragesPaginator(DescribeCodeCoveragesRequest.builder().applyMutation(describeCodeCoveragesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of details about test cases for a report.
     * </p>
     *
     * @param describeTestCasesRequest
     * @return A Java Future containing the result of the DescribeTestCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DescribeTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DescribeTestCases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTestCasesResponse> describeTestCases(DescribeTestCasesRequest describeTestCasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of details about test cases for a report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTestCasesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeTestCasesRequest#builder()}
     * </p>
     *
     * @param describeTestCasesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTestCasesInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTestCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DescribeTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DescribeTestCases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTestCasesResponse> describeTestCases(
            Consumer<DescribeTestCasesRequest.Builder> describeTestCasesRequest) {
        return describeTestCases(DescribeTestCasesRequest.builder().applyMutation(describeTestCasesRequest).build());
    }

    /**
     * <p>
     * Returns a list of details about test cases for a report.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTestCases(software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.DescribeTestCasesPublisher publisher = client.describeTestCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.DescribeTestCasesPublisher publisher = client.describeTestCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTestCases(software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTestCasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DescribeTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DescribeTestCases" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTestCasesPublisher describeTestCasesPaginator(DescribeTestCasesRequest describeTestCasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of details about test cases for a report.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTestCases(software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.DescribeTestCasesPublisher publisher = client.describeTestCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.DescribeTestCasesPublisher publisher = client.describeTestCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTestCases(software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTestCasesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeTestCasesRequest#builder()}
     * </p>
     *
     * @param describeTestCasesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTestCasesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DescribeTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DescribeTestCases" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTestCasesPublisher describeTestCasesPaginator(
            Consumer<DescribeTestCasesRequest.Builder> describeTestCasesRequest) {
        return describeTestCasesPaginator(DescribeTestCasesRequest.builder().applyMutation(describeTestCasesRequest).build());
    }

    /**
     * <p>
     * Analyzes and accumulates test report values for the specified test reports.
     * </p>
     *
     * @param getReportGroupTrendRequest
     * @return A Java Future containing the result of the GetReportGroupTrend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.GetReportGroupTrend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/GetReportGroupTrend" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReportGroupTrendResponse> getReportGroupTrend(
            GetReportGroupTrendRequest getReportGroupTrendRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Analyzes and accumulates test report values for the specified test reports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReportGroupTrendRequest.Builder} avoiding the
     * need to create one manually via {@link GetReportGroupTrendRequest#builder()}
     * </p>
     *
     * @param getReportGroupTrendRequest
     *        A {@link Consumer} that will call methods on {@link GetReportGroupTrendInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetReportGroupTrend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.GetReportGroupTrend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/GetReportGroupTrend" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReportGroupTrendResponse> getReportGroupTrend(
            Consumer<GetReportGroupTrendRequest.Builder> getReportGroupTrendRequest) {
        return getReportGroupTrend(GetReportGroupTrendRequest.builder().applyMutation(getReportGroupTrendRequest).build());
    }

    /**
     * <p>
     * Gets a resource policy that is identified by its resource ARN.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a resource policy that is identified by its resource ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePolicyInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Imports the source repository credentials for an CodeBuild project that has its source code stored in a GitHub,
     * GitHub Enterprise, or Bitbucket repository.
     * </p>
     *
     * @param importSourceCredentialsRequest
     * @return A Java Future containing the result of the ImportSourceCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ImportSourceCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ImportSourceCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportSourceCredentialsResponse> importSourceCredentials(
            ImportSourceCredentialsRequest importSourceCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the source repository credentials for an CodeBuild project that has its source code stored in a GitHub,
     * GitHub Enterprise, or Bitbucket repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportSourceCredentialsRequest.Builder} avoiding
     * the need to create one manually via {@link ImportSourceCredentialsRequest#builder()}
     * </p>
     *
     * @param importSourceCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link ImportSourceCredentialsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportSourceCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ImportSourceCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ImportSourceCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportSourceCredentialsResponse> importSourceCredentials(
            Consumer<ImportSourceCredentialsRequest.Builder> importSourceCredentialsRequest) {
        return importSourceCredentials(ImportSourceCredentialsRequest.builder().applyMutation(importSourceCredentialsRequest)
                .build());
    }

    /**
     * <p>
     * Resets the cache for a project.
     * </p>
     *
     * @param invalidateProjectCacheRequest
     * @return A Java Future containing the result of the InvalidateProjectCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.InvalidateProjectCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/InvalidateProjectCache"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InvalidateProjectCacheResponse> invalidateProjectCache(
            InvalidateProjectCacheRequest invalidateProjectCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets the cache for a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvalidateProjectCacheRequest.Builder} avoiding the
     * need to create one manually via {@link InvalidateProjectCacheRequest#builder()}
     * </p>
     *
     * @param invalidateProjectCacheRequest
     *        A {@link Consumer} that will call methods on {@link InvalidateProjectCacheInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvalidateProjectCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.InvalidateProjectCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/InvalidateProjectCache"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InvalidateProjectCacheResponse> invalidateProjectCache(
            Consumer<InvalidateProjectCacheRequest.Builder> invalidateProjectCacheRequest) {
        return invalidateProjectCache(InvalidateProjectCacheRequest.builder().applyMutation(invalidateProjectCacheRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the identifiers of your build batches in the current region.
     * </p>
     *
     * @param listBuildBatchesRequest
     * @return A Java Future containing the result of the ListBuildBatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildBatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBuildBatchesResponse> listBuildBatches(ListBuildBatchesRequest listBuildBatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the identifiers of your build batches in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildBatchesRequest.Builder} avoiding the need
     * to create one manually via {@link ListBuildBatchesRequest#builder()}
     * </p>
     *
     * @param listBuildBatchesRequest
     *        A {@link Consumer} that will call methods on {@link ListBuildBatchesInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListBuildBatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildBatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBuildBatchesResponse> listBuildBatches(
            Consumer<ListBuildBatchesRequest.Builder> listBuildBatchesRequest) {
        return listBuildBatches(ListBuildBatchesRequest.builder().applyMutation(listBuildBatchesRequest).build());
    }

    /**
     * <p>
     * Retrieves the identifiers of the build batches for a specific project.
     * </p>
     *
     * @param listBuildBatchesForProjectRequest
     * @return A Java Future containing the result of the ListBuildBatchesForProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildBatchesForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildBatchesForProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuildBatchesForProjectResponse> listBuildBatchesForProject(
            ListBuildBatchesForProjectRequest listBuildBatchesForProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the identifiers of the build batches for a specific project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildBatchesForProjectRequest.Builder} avoiding
     * the need to create one manually via {@link ListBuildBatchesForProjectRequest#builder()}
     * </p>
     *
     * @param listBuildBatchesForProjectRequest
     *        A {@link Consumer} that will call methods on {@link ListBuildBatchesForProjectInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBuildBatchesForProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildBatchesForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildBatchesForProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuildBatchesForProjectResponse> listBuildBatchesForProject(
            Consumer<ListBuildBatchesForProjectRequest.Builder> listBuildBatchesForProjectRequest) {
        return listBuildBatchesForProject(ListBuildBatchesForProjectRequest.builder()
                .applyMutation(listBuildBatchesForProjectRequest).build());
    }

    /**
     * <p>
     * Retrieves the identifiers of the build batches for a specific project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuildBatchesForProject(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildBatchesForProjectPublisher publisher = client.listBuildBatchesForProjectPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildBatchesForProjectPublisher publisher = client.listBuildBatchesForProjectPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuildBatchesForProject(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuildBatchesForProjectRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildBatchesForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildBatchesForProject"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuildBatchesForProjectPublisher listBuildBatchesForProjectPaginator(
            ListBuildBatchesForProjectRequest listBuildBatchesForProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the identifiers of the build batches for a specific project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuildBatchesForProject(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildBatchesForProjectPublisher publisher = client.listBuildBatchesForProjectPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildBatchesForProjectPublisher publisher = client.listBuildBatchesForProjectPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuildBatchesForProject(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildBatchesForProjectRequest.Builder} avoiding
     * the need to create one manually via {@link ListBuildBatchesForProjectRequest#builder()}
     * </p>
     *
     * @param listBuildBatchesForProjectRequest
     *        A {@link Consumer} that will call methods on {@link ListBuildBatchesForProjectInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildBatchesForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildBatchesForProject"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuildBatchesForProjectPublisher listBuildBatchesForProjectPaginator(
            Consumer<ListBuildBatchesForProjectRequest.Builder> listBuildBatchesForProjectRequest) {
        return listBuildBatchesForProjectPaginator(ListBuildBatchesForProjectRequest.builder()
                .applyMutation(listBuildBatchesForProjectRequest).build());
    }

    /**
     * <p>
     * Retrieves the identifiers of your build batches in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuildBatches(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildBatchesPublisher publisher = client.listBuildBatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildBatchesPublisher publisher = client.listBuildBatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListBuildBatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuildBatches(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest)} operation.</b>
     * </p>
     *
     * @param listBuildBatchesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildBatches" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBuildBatchesPublisher listBuildBatchesPaginator(ListBuildBatchesRequest listBuildBatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the identifiers of your build batches in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuildBatches(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildBatchesPublisher publisher = client.listBuildBatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildBatchesPublisher publisher = client.listBuildBatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListBuildBatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuildBatches(software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildBatchesRequest.Builder} avoiding the need
     * to create one manually via {@link ListBuildBatchesRequest#builder()}
     * </p>
     *
     * @param listBuildBatchesRequest
     *        A {@link Consumer} that will call methods on {@link ListBuildBatchesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildBatches" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBuildBatchesPublisher listBuildBatchesPaginator(Consumer<ListBuildBatchesRequest.Builder> listBuildBatchesRequest) {
        return listBuildBatchesPaginator(ListBuildBatchesRequest.builder().applyMutation(listBuildBatchesRequest).build());
    }

    /**
     * <p>
     * Gets a list of build IDs, with each build ID representing a single build.
     * </p>
     *
     * @param listBuildsRequest
     * @return A Java Future containing the result of the ListBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBuildsResponse> listBuilds(ListBuildsRequest listBuildsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of build IDs, with each build ID representing a single build.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBuildsRequest#builder()}
     * </p>
     *
     * @param listBuildsRequest
     *        A {@link Consumer} that will call methods on {@link ListBuildsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBuildsResponse> listBuilds(Consumer<ListBuildsRequest.Builder> listBuildsRequest) {
        return listBuilds(ListBuildsRequest.builder().applyMutation(listBuildsRequest).build());
    }

    /**
     * <p>
     * Gets a list of build IDs, with each build ID representing a single build.
     * </p>
     *
     * @return A Java Future containing the result of the ListBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBuildsResponse> listBuilds() {
        return listBuilds(ListBuildsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of build identifiers for the specified build project, with each build identifier representing a
     * single build.
     * </p>
     *
     * @param listBuildsForProjectRequest
     * @return A Java Future containing the result of the ListBuildsForProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildsForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuildsForProjectResponse> listBuildsForProject(
            ListBuildsForProjectRequest listBuildsForProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of build identifiers for the specified build project, with each build identifier representing a
     * single build.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildsForProjectRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuildsForProjectRequest#builder()}
     * </p>
     *
     * @param listBuildsForProjectRequest
     *        A {@link Consumer} that will call methods on {@link ListBuildsForProjectInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBuildsForProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildsForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBuildsForProjectResponse> listBuildsForProject(
            Consumer<ListBuildsForProjectRequest.Builder> listBuildsForProjectRequest) {
        return listBuildsForProject(ListBuildsForProjectRequest.builder().applyMutation(listBuildsForProjectRequest).build());
    }

    /**
     * <p>
     * Gets a list of build identifiers for the specified build project, with each build identifier representing a
     * single build.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuildsForProject(software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildsForProjectPublisher publisher = client.listBuildsForProjectPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildsForProjectPublisher publisher = client.listBuildsForProjectPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuildsForProject(software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuildsForProjectRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildsForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProject"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuildsForProjectPublisher listBuildsForProjectPaginator(ListBuildsForProjectRequest listBuildsForProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of build identifiers for the specified build project, with each build identifier representing a
     * single build.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuildsForProject(software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildsForProjectPublisher publisher = client.listBuildsForProjectPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildsForProjectPublisher publisher = client.listBuildsForProjectPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuildsForProject(software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildsForProjectRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuildsForProjectRequest#builder()}
     * </p>
     *
     * @param listBuildsForProjectRequest
     *        A {@link Consumer} that will call methods on {@link ListBuildsForProjectInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildsForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProject"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuildsForProjectPublisher listBuildsForProjectPaginator(
            Consumer<ListBuildsForProjectRequest.Builder> listBuildsForProjectRequest) {
        return listBuildsForProjectPaginator(ListBuildsForProjectRequest.builder().applyMutation(listBuildsForProjectRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of build IDs, with each build ID representing a single build.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBuilds(software.amazon.awssdk.services.codebuild.model.ListBuildsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListBuildsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListBuildsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuilds(software.amazon.awssdk.services.codebuild.model.ListBuildsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsPublisher listBuildsPaginator() {
        return listBuildsPaginator(ListBuildsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of build IDs, with each build ID representing a single build.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBuilds(software.amazon.awssdk.services.codebuild.model.ListBuildsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListBuildsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListBuildsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuilds(software.amazon.awssdk.services.codebuild.model.ListBuildsRequest)} operation.</b>
     * </p>
     *
     * @param listBuildsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsPublisher listBuildsPaginator(ListBuildsRequest listBuildsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of build IDs, with each build ID representing a single build.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBuilds(software.amazon.awssdk.services.codebuild.model.ListBuildsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListBuildsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListBuildsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuilds(software.amazon.awssdk.services.codebuild.model.ListBuildsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBuildsRequest#builder()}
     * </p>
     *
     * @param listBuildsRequest
     *        A {@link Consumer} that will call methods on {@link ListBuildsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsPublisher listBuildsPaginator(Consumer<ListBuildsRequest.Builder> listBuildsRequest) {
        return listBuildsPaginator(ListBuildsRequest.builder().applyMutation(listBuildsRequest).build());
    }

    /**
     * <p>
     * Gets information about Docker images that are managed by CodeBuild.
     * </p>
     *
     * @param listCuratedEnvironmentImagesRequest
     * @return A Java Future containing the result of the ListCuratedEnvironmentImages operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListCuratedEnvironmentImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCuratedEnvironmentImagesResponse> listCuratedEnvironmentImages(
            ListCuratedEnvironmentImagesRequest listCuratedEnvironmentImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about Docker images that are managed by CodeBuild.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCuratedEnvironmentImagesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCuratedEnvironmentImagesRequest#builder()}
     * </p>
     *
     * @param listCuratedEnvironmentImagesRequest
     *        A {@link Consumer} that will call methods on {@link ListCuratedEnvironmentImagesInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCuratedEnvironmentImages operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListCuratedEnvironmentImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCuratedEnvironmentImagesResponse> listCuratedEnvironmentImages(
            Consumer<ListCuratedEnvironmentImagesRequest.Builder> listCuratedEnvironmentImagesRequest) {
        return listCuratedEnvironmentImages(ListCuratedEnvironmentImagesRequest.builder()
                .applyMutation(listCuratedEnvironmentImagesRequest).build());
    }

    /**
     * <p>
     * Gets information about Docker images that are managed by CodeBuild.
     * </p>
     *
     * @return A Java Future containing the result of the ListCuratedEnvironmentImages operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListCuratedEnvironmentImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImages"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCuratedEnvironmentImagesResponse> listCuratedEnvironmentImages() {
        return listCuratedEnvironmentImages(ListCuratedEnvironmentImagesRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of build project names, with each build project name representing a single build project.
     * </p>
     *
     * @param listProjectsRequest
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of build project names, with each build project name representing a single build project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Gets a list of build project names, with each build project name representing a single build project.
     * </p>
     *
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProjectsResponse> listProjects() {
        return listProjects(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of build project names, with each build project name representing a single build project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.codebuild.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.codebuild.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator() {
        return listProjectsPaginator(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of build project names, with each build project name representing a single build project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.codebuild.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.codebuild.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(ListProjectsRequest listProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of build project names, with each build project name representing a single build project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProjects(software.amazon.awssdk.services.codebuild.model.ListProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListProjectsPublisher publisher = client.listProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.codebuild.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProjectsPublisher listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest) {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Gets a list ARNs for the report groups in the current Amazon Web Services account.
     * </p>
     *
     * @param listReportGroupsRequest
     * @return A Java Future containing the result of the ListReportGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReportGroupsResponse> listReportGroups(ListReportGroupsRequest listReportGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list ARNs for the report groups in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReportGroupsRequest#builder()}
     * </p>
     *
     * @param listReportGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListReportGroupsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListReportGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReportGroupsResponse> listReportGroups(
            Consumer<ListReportGroupsRequest.Builder> listReportGroupsRequest) {
        return listReportGroups(ListReportGroupsRequest.builder().applyMutation(listReportGroupsRequest).build());
    }

    /**
     * <p>
     * Gets a list ARNs for the report groups in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReportGroups(software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportGroupsPublisher publisher = client.listReportGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportGroupsPublisher publisher = client.listReportGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportGroups(software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listReportGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReportGroupsPublisher listReportGroupsPaginator(ListReportGroupsRequest listReportGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list ARNs for the report groups in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReportGroups(software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportGroupsPublisher publisher = client.listReportGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportGroupsPublisher publisher = client.listReportGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportGroups(software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReportGroupsRequest#builder()}
     * </p>
     *
     * @param listReportGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListReportGroupsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReportGroupsPublisher listReportGroupsPaginator(Consumer<ListReportGroupsRequest.Builder> listReportGroupsRequest) {
        return listReportGroupsPaginator(ListReportGroupsRequest.builder().applyMutation(listReportGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of ARNs for the reports in the current Amazon Web Services account.
     * </p>
     *
     * @param listReportsRequest
     * @return A Java Future containing the result of the ListReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReportsResponse> listReports(ListReportsRequest listReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ARNs for the reports in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReportsRequest#builder()}
     * </p>
     *
     * @param listReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListReportsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReportsResponse> listReports(Consumer<ListReportsRequest.Builder> listReportsRequest) {
        return listReports(ListReportsRequest.builder().applyMutation(listReportsRequest).build());
    }

    /**
     * <p>
     * Returns a list of ARNs for the reports that belong to a <code>ReportGroup</code>.
     * </p>
     *
     * @param listReportsForReportGroupRequest
     * @return A Java Future containing the result of the ListReportsForReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReportsForReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportsForReportGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReportsForReportGroupResponse> listReportsForReportGroup(
            ListReportsForReportGroupRequest listReportsForReportGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ARNs for the reports that belong to a <code>ReportGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportsForReportGroupRequest.Builder} avoiding
     * the need to create one manually via {@link ListReportsForReportGroupRequest#builder()}
     * </p>
     *
     * @param listReportsForReportGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListReportsForReportGroupInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReportsForReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReportsForReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportsForReportGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReportsForReportGroupResponse> listReportsForReportGroup(
            Consumer<ListReportsForReportGroupRequest.Builder> listReportsForReportGroupRequest) {
        return listReportsForReportGroup(ListReportsForReportGroupRequest.builder()
                .applyMutation(listReportsForReportGroupRequest).build());
    }

    /**
     * <p>
     * Returns a list of ARNs for the reports that belong to a <code>ReportGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReportsForReportGroup(software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportsForReportGroupPublisher publisher = client.listReportsForReportGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportsForReportGroupPublisher publisher = client.listReportsForReportGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportsForReportGroup(software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReportsForReportGroupRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReportsForReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportsForReportGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReportsForReportGroupPublisher listReportsForReportGroupPaginator(
            ListReportsForReportGroupRequest listReportsForReportGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ARNs for the reports that belong to a <code>ReportGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReportsForReportGroup(software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportsForReportGroupPublisher publisher = client.listReportsForReportGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportsForReportGroupPublisher publisher = client.listReportsForReportGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportsForReportGroup(software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportsForReportGroupRequest.Builder} avoiding
     * the need to create one manually via {@link ListReportsForReportGroupRequest#builder()}
     * </p>
     *
     * @param listReportsForReportGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListReportsForReportGroupInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReportsForReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportsForReportGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReportsForReportGroupPublisher listReportsForReportGroupPaginator(
            Consumer<ListReportsForReportGroupRequest.Builder> listReportsForReportGroupRequest) {
        return listReportsForReportGroupPaginator(ListReportsForReportGroupRequest.builder()
                .applyMutation(listReportsForReportGroupRequest).build());
    }

    /**
     * <p>
     * Returns a list of ARNs for the reports in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listReports(software.amazon.awssdk.services.codebuild.model.ListReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportsPublisher publisher = client.listReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportsPublisher publisher = client.listReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReports(software.amazon.awssdk.services.codebuild.model.ListReportsRequest)} operation.</b>
     * </p>
     *
     * @param listReportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportsPublisher listReportsPaginator(ListReportsRequest listReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ARNs for the reports in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listReports(software.amazon.awssdk.services.codebuild.model.ListReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportsPublisher publisher = client.listReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListReportsPublisher publisher = client.listReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReports(software.amazon.awssdk.services.codebuild.model.ListReportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReportsRequest#builder()}
     * </p>
     *
     * @param listReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListReportsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportsPublisher listReportsPaginator(Consumer<ListReportsRequest.Builder> listReportsRequest) {
        return listReportsPaginator(ListReportsRequest.builder().applyMutation(listReportsRequest).build());
    }

    /**
     * <p>
     * Gets a list of projects that are shared with other Amazon Web Services accounts or users.
     * </p>
     *
     * @param listSharedProjectsRequest
     * @return A Java Future containing the result of the ListSharedProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSharedProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSharedProjectsResponse> listSharedProjects(ListSharedProjectsRequest listSharedProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of projects that are shared with other Amazon Web Services accounts or users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSharedProjectsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSharedProjectsRequest#builder()}
     * </p>
     *
     * @param listSharedProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListSharedProjectsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListSharedProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSharedProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSharedProjectsResponse> listSharedProjects(
            Consumer<ListSharedProjectsRequest.Builder> listSharedProjectsRequest) {
        return listSharedProjects(ListSharedProjectsRequest.builder().applyMutation(listSharedProjectsRequest).build());
    }

    /**
     * <p>
     * Gets a list of projects that are shared with other Amazon Web Services accounts or users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSharedProjects(software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListSharedProjectsPublisher publisher = client.listSharedProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListSharedProjectsPublisher publisher = client.listSharedProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSharedProjects(software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSharedProjectsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSharedProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSharedProjectsPublisher listSharedProjectsPaginator(ListSharedProjectsRequest listSharedProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of projects that are shared with other Amazon Web Services accounts or users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSharedProjects(software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListSharedProjectsPublisher publisher = client.listSharedProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListSharedProjectsPublisher publisher = client.listSharedProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSharedProjects(software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSharedProjectsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSharedProjectsRequest#builder()}
     * </p>
     *
     * @param listSharedProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListSharedProjectsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSharedProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSharedProjectsPublisher listSharedProjectsPaginator(
            Consumer<ListSharedProjectsRequest.Builder> listSharedProjectsRequest) {
        return listSharedProjectsPaginator(ListSharedProjectsRequest.builder().applyMutation(listSharedProjectsRequest).build());
    }

    /**
     * <p>
     * Gets a list of report groups that are shared with other Amazon Web Services accounts or users.
     * </p>
     *
     * @param listSharedReportGroupsRequest
     * @return A Java Future containing the result of the ListSharedReportGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSharedReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedReportGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSharedReportGroupsResponse> listSharedReportGroups(
            ListSharedReportGroupsRequest listSharedReportGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of report groups that are shared with other Amazon Web Services accounts or users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSharedReportGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSharedReportGroupsRequest#builder()}
     * </p>
     *
     * @param listSharedReportGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListSharedReportGroupsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSharedReportGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSharedReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedReportGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSharedReportGroupsResponse> listSharedReportGroups(
            Consumer<ListSharedReportGroupsRequest.Builder> listSharedReportGroupsRequest) {
        return listSharedReportGroups(ListSharedReportGroupsRequest.builder().applyMutation(listSharedReportGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of report groups that are shared with other Amazon Web Services accounts or users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSharedReportGroups(software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListSharedReportGroupsPublisher publisher = client.listSharedReportGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListSharedReportGroupsPublisher publisher = client.listSharedReportGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSharedReportGroups(software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSharedReportGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSharedReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedReportGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSharedReportGroupsPublisher listSharedReportGroupsPaginator(
            ListSharedReportGroupsRequest listSharedReportGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of report groups that are shared with other Amazon Web Services accounts or users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSharedReportGroups(software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListSharedReportGroupsPublisher publisher = client.listSharedReportGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codebuild.paginators.ListSharedReportGroupsPublisher publisher = client.listSharedReportGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSharedReportGroups(software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSharedReportGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSharedReportGroupsRequest#builder()}
     * </p>
     *
     * @param listSharedReportGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListSharedReportGroupsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSharedReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedReportGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSharedReportGroupsPublisher listSharedReportGroupsPaginator(
            Consumer<ListSharedReportGroupsRequest.Builder> listSharedReportGroupsRequest) {
        return listSharedReportGroupsPaginator(ListSharedReportGroupsRequest.builder()
                .applyMutation(listSharedReportGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>SourceCredentialsInfo</code> objects.
     * </p>
     *
     * @param listSourceCredentialsRequest
     * @return A Java Future containing the result of the ListSourceCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSourceCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSourceCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSourceCredentialsResponse> listSourceCredentials(
            ListSourceCredentialsRequest listSourceCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>SourceCredentialsInfo</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceCredentialsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSourceCredentialsRequest#builder()}
     * </p>
     *
     * @param listSourceCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link ListSourceCredentialsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSourceCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSourceCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSourceCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSourceCredentialsResponse> listSourceCredentials(
            Consumer<ListSourceCredentialsRequest.Builder> listSourceCredentialsRequest) {
        return listSourceCredentials(ListSourceCredentialsRequest.builder().applyMutation(listSourceCredentialsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>SourceCredentialsInfo</code> objects.
     * </p>
     *
     * @return A Java Future containing the result of the ListSourceCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSourceCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSourceCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSourceCredentialsResponse> listSourceCredentials() {
        return listSourceCredentials(ListSourceCredentialsRequest.builder().build());
    }

    /**
     * <p>
     * Stores a resource policy for the ARN of a <code>Project</code> or <code>ReportGroup</code> object.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stores a resource policy for the ARN of a <code>Project</code> or <code>ReportGroup</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResourcePolicyInput.Builder} to create a request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Restarts a build.
     * </p>
     *
     * @param retryBuildRequest
     * @return A Java Future containing the result of the RetryBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.RetryBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/RetryBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RetryBuildResponse> retryBuild(RetryBuildRequest retryBuildRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a build.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetryBuildRequest.Builder} avoiding the need to
     * create one manually via {@link RetryBuildRequest#builder()}
     * </p>
     *
     * @param retryBuildRequest
     *        A {@link Consumer} that will call methods on {@link RetryBuildInput.Builder} to create a request.
     * @return A Java Future containing the result of the RetryBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.RetryBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/RetryBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RetryBuildResponse> retryBuild(Consumer<RetryBuildRequest.Builder> retryBuildRequest) {
        return retryBuild(RetryBuildRequest.builder().applyMutation(retryBuildRequest).build());
    }

    /**
     * <p>
     * Restarts a failed batch build. Only batch builds that have failed can be retried.
     * </p>
     *
     * @param retryBuildBatchRequest
     * @return A Java Future containing the result of the RetryBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.RetryBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/RetryBuildBatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RetryBuildBatchResponse> retryBuildBatch(RetryBuildBatchRequest retryBuildBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a failed batch build. Only batch builds that have failed can be retried.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetryBuildBatchRequest.Builder} avoiding the need
     * to create one manually via {@link RetryBuildBatchRequest#builder()}
     * </p>
     *
     * @param retryBuildBatchRequest
     *        A {@link Consumer} that will call methods on {@link RetryBuildBatchInput.Builder} to create a request.
     * @return A Java Future containing the result of the RetryBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.RetryBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/RetryBuildBatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RetryBuildBatchResponse> retryBuildBatch(
            Consumer<RetryBuildBatchRequest.Builder> retryBuildBatchRequest) {
        return retryBuildBatch(RetryBuildBatchRequest.builder().applyMutation(retryBuildBatchRequest).build());
    }

    /**
     * <p>
     * Starts running a build.
     * </p>
     *
     * @param startBuildRequest
     * @return A Java Future containing the result of the StartBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StartBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartBuildResponse> startBuild(StartBuildRequest startBuildRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts running a build.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBuildRequest.Builder} avoiding the need to
     * create one manually via {@link StartBuildRequest#builder()}
     * </p>
     *
     * @param startBuildRequest
     *        A {@link Consumer} that will call methods on {@link StartBuildInput.Builder} to create a request.
     * @return A Java Future containing the result of the StartBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StartBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartBuildResponse> startBuild(Consumer<StartBuildRequest.Builder> startBuildRequest) {
        return startBuild(StartBuildRequest.builder().applyMutation(startBuildRequest).build());
    }

    /**
     * <p>
     * Starts a batch build for a project.
     * </p>
     *
     * @param startBuildBatchRequest
     * @return A Java Future containing the result of the StartBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StartBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuildBatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartBuildBatchResponse> startBuildBatch(StartBuildBatchRequest startBuildBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a batch build for a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBuildBatchRequest.Builder} avoiding the need
     * to create one manually via {@link StartBuildBatchRequest#builder()}
     * </p>
     *
     * @param startBuildBatchRequest
     *        A {@link Consumer} that will call methods on {@link StartBuildBatchInput.Builder} to create a request.
     * @return A Java Future containing the result of the StartBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StartBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuildBatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartBuildBatchResponse> startBuildBatch(
            Consumer<StartBuildBatchRequest.Builder> startBuildBatchRequest) {
        return startBuildBatch(StartBuildBatchRequest.builder().applyMutation(startBuildBatchRequest).build());
    }

    /**
     * <p>
     * Attempts to stop running a build.
     * </p>
     *
     * @param stopBuildRequest
     * @return A Java Future containing the result of the StopBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StopBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopBuildResponse> stopBuild(StopBuildRequest stopBuildRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to stop running a build.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBuildRequest.Builder} avoiding the need to
     * create one manually via {@link StopBuildRequest#builder()}
     * </p>
     *
     * @param stopBuildRequest
     *        A {@link Consumer} that will call methods on {@link StopBuildInput.Builder} to create a request.
     * @return A Java Future containing the result of the StopBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StopBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopBuildResponse> stopBuild(Consumer<StopBuildRequest.Builder> stopBuildRequest) {
        return stopBuild(StopBuildRequest.builder().applyMutation(stopBuildRequest).build());
    }

    /**
     * <p>
     * Stops a running batch build.
     * </p>
     *
     * @param stopBuildBatchRequest
     * @return A Java Future containing the result of the StopBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StopBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuildBatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopBuildBatchResponse> stopBuildBatch(StopBuildBatchRequest stopBuildBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a running batch build.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBuildBatchRequest.Builder} avoiding the need to
     * create one manually via {@link StopBuildBatchRequest#builder()}
     * </p>
     *
     * @param stopBuildBatchRequest
     *        A {@link Consumer} that will call methods on {@link StopBuildBatchInput.Builder} to create a request.
     * @return A Java Future containing the result of the StopBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StopBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuildBatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopBuildBatchResponse> stopBuildBatch(Consumer<StopBuildBatchRequest.Builder> stopBuildBatchRequest) {
        return stopBuildBatch(StopBuildBatchRequest.builder().applyMutation(stopBuildBatchRequest).build());
    }

    /**
     * <p>
     * Changes the settings of a build project.
     * </p>
     *
     * @param updateProjectRequest
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProjectResponse> updateProject(UpdateProjectRequest updateProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the settings of a build project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProjectInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProjectResponse> updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest) {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }

    /**
     * <p>
     * Changes the public visibility for a project. The project's build results, logs, and artifacts are available to
     * the general public. For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/public-builds.html">Public build projects</a> in the
     * <i>CodeBuild User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The following should be kept in mind when making your projects public:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All of a project's build results, logs, and artifacts, including builds that were run when the project was
     * private, are available to the general public.
     * </p>
     * </li>
     * <li>
     * <p>
     * All build logs and artifacts are available to the public. Environment variables, source code, and other sensitive
     * information may have been output to the build logs and artifacts. You must be careful about what information is
     * output to the build logs. Some best practice are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Do not store sensitive values, especially Amazon Web Services access key IDs and secret access keys, in
     * environment variables. We recommend that you use an Amazon EC2 Systems Manager Parameter Store or Secrets Manager
     * to store sensitive values.
     * </p>
     * </li>
     * <li>
     * <p>
     * Follow <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/webhooks.html#webhook-best-practices">Best
     * practices for using webhooks</a> in the <i>CodeBuild User Guide</i> to limit which entities can trigger a build,
     * and do not store the buildspec in the project itself, to ensure that your webhooks are as secure as possible.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * A malicious user can use public builds to distribute malicious artifacts. We recommend that you review all pull
     * requests to verify that the pull request is a legitimate change. We also recommend that you validate any
     * artifacts with their checksums to make sure that the correct artifacts are being downloaded.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param updateProjectVisibilityRequest
     * @return A Java Future containing the result of the UpdateProjectVisibility operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateProjectVisibility
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProjectVisibility"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProjectVisibilityResponse> updateProjectVisibility(
            UpdateProjectVisibilityRequest updateProjectVisibilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the public visibility for a project. The project's build results, logs, and artifacts are available to
     * the general public. For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/public-builds.html">Public build projects</a> in the
     * <i>CodeBuild User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The following should be kept in mind when making your projects public:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All of a project's build results, logs, and artifacts, including builds that were run when the project was
     * private, are available to the general public.
     * </p>
     * </li>
     * <li>
     * <p>
     * All build logs and artifacts are available to the public. Environment variables, source code, and other sensitive
     * information may have been output to the build logs and artifacts. You must be careful about what information is
     * output to the build logs. Some best practice are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Do not store sensitive values, especially Amazon Web Services access key IDs and secret access keys, in
     * environment variables. We recommend that you use an Amazon EC2 Systems Manager Parameter Store or Secrets Manager
     * to store sensitive values.
     * </p>
     * </li>
     * <li>
     * <p>
     * Follow <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/webhooks.html#webhook-best-practices">Best
     * practices for using webhooks</a> in the <i>CodeBuild User Guide</i> to limit which entities can trigger a build,
     * and do not store the buildspec in the project itself, to ensure that your webhooks are as secure as possible.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * A malicious user can use public builds to distribute malicious artifacts. We recommend that you review all pull
     * requests to verify that the pull request is a legitimate change. We also recommend that you validate any
     * artifacts with their checksums to make sure that the correct artifacts are being downloaded.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectVisibilityRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateProjectVisibilityRequest#builder()}
     * </p>
     *
     * @param updateProjectVisibilityRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProjectVisibilityInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateProjectVisibility operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateProjectVisibility
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProjectVisibility"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProjectVisibilityResponse> updateProjectVisibility(
            Consumer<UpdateProjectVisibilityRequest.Builder> updateProjectVisibilityRequest) {
        return updateProjectVisibility(UpdateProjectVisibilityRequest.builder().applyMutation(updateProjectVisibilityRequest)
                .build());
    }

    /**
     * <p>
     * Updates a report group.
     * </p>
     *
     * @param updateReportGroupRequest
     * @return A Java Future containing the result of the UpdateReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateReportGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateReportGroupResponse> updateReportGroup(UpdateReportGroupRequest updateReportGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a report group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReportGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateReportGroupRequest#builder()}
     * </p>
     *
     * @param updateReportGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReportGroupInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateReportGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateReportGroupResponse> updateReportGroup(
            Consumer<UpdateReportGroupRequest.Builder> updateReportGroupRequest) {
        return updateReportGroup(UpdateReportGroupRequest.builder().applyMutation(updateReportGroupRequest).build());
    }

    /**
     * <p>
     * Updates the webhook associated with an CodeBuild build project.
     * </p>
     * <note>
     * <p>
     * If you use Bitbucket for your repository, <code>rotateSecret</code> is ignored.
     * </p>
     * </note>
     *
     * @param updateWebhookRequest
     * @return A Java Future containing the result of the UpdateWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>OAuthProviderException There was a problem with the underlying OAuth provider.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWebhookResponse> updateWebhook(UpdateWebhookRequest updateWebhookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the webhook associated with an CodeBuild build project.
     * </p>
     * <note>
     * <p>
     * If you use Bitbucket for your repository, <code>rotateSecret</code> is ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWebhookRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWebhookRequest#builder()}
     * </p>
     *
     * @param updateWebhookRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWebhookInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>OAuthProviderException There was a problem with the underlying OAuth provider.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWebhookResponse> updateWebhook(Consumer<UpdateWebhookRequest.Builder> updateWebhookRequest) {
        return updateWebhook(UpdateWebhookRequest.builder().applyMutation(updateWebhookRequest).build());
    }

    @Override
    default CodeBuildServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CodeBuildAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeBuildAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeBuildAsyncClient}.
     */
    static CodeBuildAsyncClientBuilder builder() {
        return new DefaultCodeBuildAsyncClientBuilder();
    }
}
