/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines when a new instance is auto-scaled into the compute fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetTrackingScalingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetTrackingScalingConfiguration.Builder, TargetTrackingScalingConfiguration> {
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricType").getter(getter(TargetTrackingScalingConfiguration::metricTypeAsString))
            .setter(setter(Builder::metricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricType").build()).build();

    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("targetValue").getter(getter(TargetTrackingScalingConfiguration::targetValue))
            .setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_TYPE_FIELD,
            TARGET_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricType;

    private final Double targetValue;

    private TargetTrackingScalingConfiguration(BuilderImpl builder) {
        this.metricType = builder.metricType;
        this.targetValue = builder.targetValue;
    }

    /**
     * <p>
     * The metric type to determine auto-scaling.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link FleetScalingMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The metric type to determine auto-scaling.
     * @see FleetScalingMetricType
     */
    public final FleetScalingMetricType metricType() {
        return FleetScalingMetricType.fromValue(metricType);
    }

    /**
     * <p>
     * The metric type to determine auto-scaling.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link FleetScalingMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The metric type to determine auto-scaling.
     * @see FleetScalingMetricType
     */
    public final String metricTypeAsString() {
        return metricType;
    }

    /**
     * <p>
     * The value of <code>metricType</code> when to start scaling.
     * </p>
     * 
     * @return The value of <code>metricType</code> when to start scaling.
     */
    public final Double targetValue() {
        return targetValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingScalingConfiguration)) {
            return false;
        }
        TargetTrackingScalingConfiguration other = (TargetTrackingScalingConfiguration) obj;
        return Objects.equals(metricTypeAsString(), other.metricTypeAsString())
                && Objects.equals(targetValue(), other.targetValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetTrackingScalingConfiguration").add("MetricType", metricTypeAsString())
                .add("TargetValue", targetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricType":
            return Optional.ofNullable(clazz.cast(metricTypeAsString()));
        case "targetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingScalingConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingScalingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetTrackingScalingConfiguration> {
        /**
         * <p>
         * The metric type to determine auto-scaling.
         * </p>
         * 
         * @param metricType
         *        The metric type to determine auto-scaling.
         * @see FleetScalingMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetScalingMetricType
         */
        Builder metricType(String metricType);

        /**
         * <p>
         * The metric type to determine auto-scaling.
         * </p>
         * 
         * @param metricType
         *        The metric type to determine auto-scaling.
         * @see FleetScalingMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetScalingMetricType
         */
        Builder metricType(FleetScalingMetricType metricType);

        /**
         * <p>
         * The value of <code>metricType</code> when to start scaling.
         * </p>
         * 
         * @param targetValue
         *        The value of <code>metricType</code> when to start scaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);
    }

    static final class BuilderImpl implements Builder {
        private String metricType;

        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingScalingConfiguration model) {
            metricType(model.metricType);
            targetValue(model.targetValue);
        }

        public final String getMetricType() {
            return metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(FleetScalingMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        @Override
        public TargetTrackingScalingConfiguration build() {
            return new TargetTrackingScalingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
