/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the authorization settings for CodeBuild to access the source code to be built.
 * </p>
 * <p>
 * This information is for the CodeBuild console's use only. Your code should not get or set this information directly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceAuth implements SdkPojo, Serializable, ToCopyableBuilder<SourceAuth.Builder, SourceAuth> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SourceAuth::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(SourceAuth::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, RESOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String resource;

    private SourceAuth(BuilderImpl builder) {
        this.type = builder.type;
        this.resource = builder.resource;
    }

    /**
     * <p>
     * The authorization type to use. Valid options are OAUTH or CODECONNECTIONS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The authorization type to use. Valid options are OAUTH or CODECONNECTIONS.
     * @see SourceAuthType
     */
    public final SourceAuthType type() {
        return SourceAuthType.fromValue(type);
    }

    /**
     * <p>
     * The authorization type to use. Valid options are OAUTH or CODECONNECTIONS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The authorization type to use. Valid options are OAUTH or CODECONNECTIONS.
     * @see SourceAuthType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The resource value that applies to the specified authorization type.
     * </p>
     * 
     * @return The resource value that applies to the specified authorization type.
     */
    public final String resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAuth)) {
            return false;
        }
        SourceAuth other = (SourceAuth) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceAuth").add("Type", typeAsString()).add("Resource", resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceAuth, T> g) {
        return obj -> g.apply((SourceAuth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceAuth> {
        /**
         * <p>
         * The authorization type to use. Valid options are OAUTH or CODECONNECTIONS.
         * </p>
         * 
         * @param type
         *        The authorization type to use. Valid options are OAUTH or CODECONNECTIONS.
         * @see SourceAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceAuthType
         */
        Builder type(String type);

        /**
         * <p>
         * The authorization type to use. Valid options are OAUTH or CODECONNECTIONS.
         * </p>
         * 
         * @param type
         *        The authorization type to use. Valid options are OAUTH or CODECONNECTIONS.
         * @see SourceAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceAuthType
         */
        Builder type(SourceAuthType type);

        /**
         * <p>
         * The resource value that applies to the specified authorization type.
         * </p>
         * 
         * @param resource
         *        The resource value that applies to the specified authorization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String resource;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAuth model) {
            type(model.type);
            resource(model.resource);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceAuthType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public SourceAuth build() {
            return new SourceAuth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
