/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of dedicated instances for your build environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Fleet implements SdkPojo, Serializable, ToCopyableBuilder<Fleet.Builder, Fleet> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Fleet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Fleet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Fleet::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(Fleet::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModified").getter(getter(Fleet::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build()).build();

    private static final SdkField<FleetStatus> STATUS_FIELD = SdkField.<FleetStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(Fleet::status)).setter(setter(Builder::status)).constructor(FleetStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> BASE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("baseCapacity").getter(getter(Fleet::baseCapacity)).setter(setter(Builder::baseCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCapacity").build()).build();

    private static final SdkField<String> ENVIRONMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentType").getter(getter(Fleet::environmentTypeAsString))
            .setter(setter(Builder::environmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentType").build()).build();

    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeType").getter(getter(Fleet::computeTypeAsString)).setter(setter(Builder::computeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeType").build()).build();

    private static final SdkField<ScalingConfigurationOutput> SCALING_CONFIGURATION_FIELD = SdkField
            .<ScalingConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("scalingConfiguration")
            .getter(getter(Fleet::scalingConfiguration)).setter(setter(Builder::scalingConfiguration))
            .constructor(ScalingConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfiguration").build())
            .build();

    private static final SdkField<String> OVERFLOW_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("overflowBehavior").getter(getter(Fleet::overflowBehaviorAsString))
            .setter(setter(Builder::overflowBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overflowBehavior").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(Fleet::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageId").getter(getter(Fleet::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<String> FLEET_SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetServiceRole").getter(getter(Fleet::fleetServiceRole)).setter(setter(Builder::fleetServiceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetServiceRole").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(Fleet::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            ID_FIELD, CREATED_FIELD, LAST_MODIFIED_FIELD, STATUS_FIELD, BASE_CAPACITY_FIELD, ENVIRONMENT_TYPE_FIELD,
            COMPUTE_TYPE_FIELD, SCALING_CONFIGURATION_FIELD, OVERFLOW_BEHAVIOR_FIELD, VPC_CONFIG_FIELD, IMAGE_ID_FIELD,
            FLEET_SERVICE_ROLE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String id;

    private final Instant created;

    private final Instant lastModified;

    private final FleetStatus status;

    private final Integer baseCapacity;

    private final String environmentType;

    private final String computeType;

    private final ScalingConfigurationOutput scalingConfiguration;

    private final String overflowBehavior;

    private final VpcConfig vpcConfig;

    private final String imageId;

    private final String fleetServiceRole;

    private final List<Tag> tags;

    private Fleet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.id = builder.id;
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.status = builder.status;
        this.baseCapacity = builder.baseCapacity;
        this.environmentType = builder.environmentType;
        this.computeType = builder.computeType;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.overflowBehavior = builder.overflowBehavior;
        this.vpcConfig = builder.vpcConfig;
        this.imageId = builder.imageId;
        this.fleetServiceRole = builder.fleetServiceRole;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the compute fleet.
     * </p>
     * 
     * @return The ARN of the compute fleet.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the compute fleet.
     * </p>
     * 
     * @return The name of the compute fleet.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the compute fleet.
     * </p>
     * 
     * @return The ID of the compute fleet.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The time at which the compute fleet was created.
     * </p>
     * 
     * @return The time at which the compute fleet was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The time at which the compute fleet was last modified.
     * </p>
     * 
     * @return The time at which the compute fleet was last modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The status of the compute fleet.
     * </p>
     * 
     * @return The status of the compute fleet.
     */
    public final FleetStatus status() {
        return status;
    }

    /**
     * <p>
     * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in
     * parallel.
     * </p>
     * 
     * @return The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can
     *         run in parallel.
     */
    public final Integer baseCapacity() {
        return baseCapacity;
    }

    /**
     * <p>
     * The environment type of the compute fleet.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East
     * (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore),
     * Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US East
     * (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia
     * Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US East
     * (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>MAC_ARM</code> is available for Medium fleets only in regions US East (N. Virginia),
     * US East (Ohio), US West (Oregon), Asia Pacific (Sydney), and EU (Frankfurt)
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>MAC_ARM</code> is available for Large fleets only in regions US East (N. Virginia), US
     * East (Ohio), US West (Oregon), and Asia Pacific (Sydney).
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N.
     * Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai)
     * and EU (Ireland).
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N.
     * Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific
     * (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment
     * compute types</a> in the <i>CodeBuild user guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environmentType}
     * will return {@link EnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #environmentTypeAsString}.
     * </p>
     * 
     * @return The environment type of the compute fleet.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US
     *         East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific
     *         (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US
     *         East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific
     *         (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia),
     *         US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific
     *         (Sydney).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>MAC_ARM</code> is available for Medium fleets only in regions US East (N.
     *         Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), and EU (Frankfurt)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>MAC_ARM</code> is available for Large fleets only in regions US East (N.
     *         Virginia), US East (Ohio), US West (Oregon), and Asia Pacific (Sydney).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N.
     *         Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific
     *         (Mumbai) and EU (Ireland).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N.
     *         Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia
     *         Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
     *         environment compute types</a> in the <i>CodeBuild user guide</i>.
     * @see EnvironmentType
     */
    public final EnvironmentType environmentType() {
        return EnvironmentType.fromValue(environmentType);
    }

    /**
     * <p>
     * The environment type of the compute fleet.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East
     * (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore),
     * Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US East
     * (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia
     * Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US East
     * (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>MAC_ARM</code> is available for Medium fleets only in regions US East (N. Virginia),
     * US East (Ohio), US West (Oregon), Asia Pacific (Sydney), and EU (Frankfurt)
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>MAC_ARM</code> is available for Large fleets only in regions US East (N. Virginia), US
     * East (Ohio), US West (Oregon), and Asia Pacific (Sydney).
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N.
     * Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai)
     * and EU (Ireland).
     * </p>
     * </li>
     * <li>
     * <p>
     * The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N.
     * Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific
     * (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment
     * compute types</a> in the <i>CodeBuild user guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #environmentType}
     * will return {@link EnvironmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #environmentTypeAsString}.
     * </p>
     * 
     * @return The environment type of the compute fleet.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US
     *         East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific
     *         (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US
     *         East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific
     *         (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia),
     *         US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific
     *         (Sydney).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>MAC_ARM</code> is available for Medium fleets only in regions US East (N.
     *         Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), and EU (Frankfurt)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>MAC_ARM</code> is available for Large fleets only in regions US East (N.
     *         Virginia), US East (Ohio), US West (Oregon), and Asia Pacific (Sydney).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N.
     *         Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific
     *         (Mumbai) and EU (Ireland).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N.
     *         Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia
     *         Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
     *         environment compute types</a> in the <i>CodeBuild user guide</i>.
     * @see EnvironmentType
     */
    public final String environmentTypeAsString() {
        return environmentType;
    }

    /**
     * <p>
     * Information about the compute resources the compute fleet uses. Available values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment
     * type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_XLARGE</code>: Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment
     * type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds.
     * This compute type supports Docker images up to 100 GB uncompressed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you use <code>BUILD_GENERAL1_SMALL</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For environment type <code>LINUX_CONTAINER</code>, you can use up to 3 GB memory and 2 vCPUs for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G
     * Tensor Core GPU for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * For environment type <code>ARM_CONTAINER</code>, you can use up to 4 GB memory and 2 vCPUs on ARM-based
     * processors for builds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you use <code>BUILD_GENERAL1_LARGE</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB memory and 8 vCPUs for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA
     * Tesla V100 GPUs for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB memory and 8 vCPUs on ARM-based
     * processors for builds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment
     * compute types</a> in the <i>CodeBuild User Guide.</i>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return Information about the compute resources the compute fleet uses. Available values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for builds, depending on your
     *         environment type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_XLARGE</code>: Use up to 70 GB memory and 36 vCPUs for builds, depending on your
     *         environment type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for
     *         builds. This compute type supports Docker images up to 100 GB uncompressed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you use <code>BUILD_GENERAL1_SMALL</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For environment type <code>LINUX_CONTAINER</code>, you can use up to 3 GB memory and 2 vCPUs for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 16 GB memory, 4 vCPUs, and 1
     *         NVIDIA A10G Tensor Core GPU for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For environment type <code>ARM_CONTAINER</code>, you can use up to 4 GB memory and 2 vCPUs on ARM-based
     *         processors for builds.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you use <code>BUILD_GENERAL1_LARGE</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB memory and 8 vCPUs for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255 GB memory, 32 vCPUs, and 4
     *         NVIDIA Tesla V100 GPUs for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB memory and 8 vCPUs on ARM-based
     *         processors for builds.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
     *         environment compute types</a> in the <i>CodeBuild User Guide.</i>
     * @see ComputeType
     */
    public final ComputeType computeType() {
        return ComputeType.fromValue(computeType);
    }

    /**
     * <p>
     * Information about the compute resources the compute fleet uses. Available values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment
     * type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_XLARGE</code>: Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment
     * type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds.
     * This compute type supports Docker images up to 100 GB uncompressed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you use <code>BUILD_GENERAL1_SMALL</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For environment type <code>LINUX_CONTAINER</code>, you can use up to 3 GB memory and 2 vCPUs for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G
     * Tensor Core GPU for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * For environment type <code>ARM_CONTAINER</code>, you can use up to 4 GB memory and 2 vCPUs on ARM-based
     * processors for builds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you use <code>BUILD_GENERAL1_LARGE</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB memory and 8 vCPUs for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA
     * Tesla V100 GPUs for builds.
     * </p>
     * </li>
     * <li>
     * <p>
     * For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB memory and 8 vCPUs on ARM-based
     * processors for builds.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment
     * compute types</a> in the <i>CodeBuild User Guide.</i>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return Information about the compute resources the compute fleet uses. Available values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for builds, depending on your
     *         environment type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_XLARGE</code>: Use up to 70 GB memory and 36 vCPUs for builds, depending on your
     *         environment type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for
     *         builds. This compute type supports Docker images up to 100 GB uncompressed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you use <code>BUILD_GENERAL1_SMALL</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For environment type <code>LINUX_CONTAINER</code>, you can use up to 3 GB memory and 2 vCPUs for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 16 GB memory, 4 vCPUs, and 1
     *         NVIDIA A10G Tensor Core GPU for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For environment type <code>ARM_CONTAINER</code>, you can use up to 4 GB memory and 2 vCPUs on ARM-based
     *         processors for builds.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you use <code>BUILD_GENERAL1_LARGE</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB memory and 8 vCPUs for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255 GB memory, 32 vCPUs, and 4
     *         NVIDIA Tesla V100 GPUs for builds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB memory and 8 vCPUs on ARM-based
     *         processors for builds.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
     *         environment compute types</a> in the <i>CodeBuild User Guide.</i>
     * @see ComputeType
     */
    public final String computeTypeAsString() {
        return computeType;
    }

    /**
     * <p>
     * The scaling configuration of the compute fleet.
     * </p>
     * 
     * @return The scaling configuration of the compute fleet.
     */
    public final ScalingConfigurationOutput scalingConfiguration() {
        return scalingConfiguration;
    }

    /**
     * <p>
     * The compute fleet overflow behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For overflow behavior <code>QUEUE</code>, your overflow builds need to wait on the existing fleet instance to
     * become available.
     * </p>
     * </li>
     * <li>
     * <p>
     * For overflow behavior <code>ON_DEMAND</code>, your overflow builds run on CodeBuild on-demand.
     * </p>
     * <note>
     * <p>
     * If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure that you
     * add the required VPC permissions to your project service role. For more information, see <a href=
     * "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface"
     * >Example policy statement to allow CodeBuild access to Amazon Web Services services required to create a VPC
     * network interface</a>.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overflowBehavior}
     * will return {@link FleetOverflowBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #overflowBehaviorAsString}.
     * </p>
     * 
     * @return The compute fleet overflow behavior.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For overflow behavior <code>QUEUE</code>, your overflow builds need to wait on the existing fleet
     *         instance to become available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For overflow behavior <code>ON_DEMAND</code>, your overflow builds run on CodeBuild on-demand.
     *         </p>
     *         <note>
     *         <p>
     *         If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure
     *         that you add the required VPC permissions to your project service role. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface"
     *         >Example policy statement to allow CodeBuild access to Amazon Web Services services required to create a
     *         VPC network interface</a>.
     *         </p>
     *         </note></li>
     * @see FleetOverflowBehavior
     */
    public final FleetOverflowBehavior overflowBehavior() {
        return FleetOverflowBehavior.fromValue(overflowBehavior);
    }

    /**
     * <p>
     * The compute fleet overflow behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For overflow behavior <code>QUEUE</code>, your overflow builds need to wait on the existing fleet instance to
     * become available.
     * </p>
     * </li>
     * <li>
     * <p>
     * For overflow behavior <code>ON_DEMAND</code>, your overflow builds run on CodeBuild on-demand.
     * </p>
     * <note>
     * <p>
     * If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure that you
     * add the required VPC permissions to your project service role. For more information, see <a href=
     * "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface"
     * >Example policy statement to allow CodeBuild access to Amazon Web Services services required to create a VPC
     * network interface</a>.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overflowBehavior}
     * will return {@link FleetOverflowBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #overflowBehaviorAsString}.
     * </p>
     * 
     * @return The compute fleet overflow behavior.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For overflow behavior <code>QUEUE</code>, your overflow builds need to wait on the existing fleet
     *         instance to become available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For overflow behavior <code>ON_DEMAND</code>, your overflow builds run on CodeBuild on-demand.
     *         </p>
     *         <note>
     *         <p>
     *         If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure
     *         that you add the required VPC permissions to your project service role. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface"
     *         >Example policy statement to allow CodeBuild access to Amazon Web Services services required to create a
     *         VPC network interface</a>.
     *         </p>
     *         </note></li>
     * @see FleetOverflowBehavior
     */
    public final String overflowBehaviorAsString() {
        return overflowBehavior;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) of the compute fleet.
     * </p>
     * 
     * @return The Amazon Machine Image (AMI) of the compute fleet.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The service role associated with the compute fleet. For more information, see <a href=
     * "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html"
     * > Allow a user to add a permission policy for a fleet service role</a> in the <i>CodeBuild User Guide</i>.
     * </p>
     * 
     * @return The service role associated with the compute fleet. For more information, see <a href=
     *         "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html"
     *         > Allow a user to add a permission policy for a fleet service role</a> in the <i>CodeBuild User
     *         Guide</i>.
     */
    public final String fleetServiceRole() {
        return fleetServiceRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag key and value pairs associated with this compute fleet.
     * </p>
     * <p>
     * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tag key and value pairs associated with this compute fleet.</p>
     *         <p>
     *         These tags are available for use by Amazon Web Services services that support CodeBuild build project
     *         tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(baseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(environmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(overflowBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetServiceRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(created(), other.created()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(status(), other.status()) && Objects.equals(baseCapacity(), other.baseCapacity())
                && Objects.equals(environmentTypeAsString(), other.environmentTypeAsString())
                && Objects.equals(computeTypeAsString(), other.computeTypeAsString())
                && Objects.equals(scalingConfiguration(), other.scalingConfiguration())
                && Objects.equals(overflowBehaviorAsString(), other.overflowBehaviorAsString())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(fleetServiceRole(), other.fleetServiceRole()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Fleet").add("Arn", arn()).add("Name", name()).add("Id", id()).add("Created", created())
                .add("LastModified", lastModified()).add("Status", status()).add("BaseCapacity", baseCapacity())
                .add("EnvironmentType", environmentTypeAsString()).add("ComputeType", computeTypeAsString())
                .add("ScalingConfiguration", scalingConfiguration()).add("OverflowBehavior", overflowBehaviorAsString())
                .add("VpcConfig", vpcConfig()).add("ImageId", imageId()).add("FleetServiceRole", fleetServiceRole())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "lastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "baseCapacity":
            return Optional.ofNullable(clazz.cast(baseCapacity()));
        case "environmentType":
            return Optional.ofNullable(clazz.cast(environmentTypeAsString()));
        case "computeType":
            return Optional.ofNullable(clazz.cast(computeTypeAsString()));
        case "scalingConfiguration":
            return Optional.ofNullable(clazz.cast(scalingConfiguration()));
        case "overflowBehavior":
            return Optional.ofNullable(clazz.cast(overflowBehaviorAsString()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "fleetServiceRole":
            return Optional.ofNullable(clazz.cast(fleetServiceRole()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Fleet, T> g) {
        return obj -> g.apply((Fleet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Fleet> {
        /**
         * <p>
         * The ARN of the compute fleet.
         * </p>
         * 
         * @param arn
         *        The ARN of the compute fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the compute fleet.
         * </p>
         * 
         * @param name
         *        The name of the compute fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the compute fleet.
         * </p>
         * 
         * @param id
         *        The ID of the compute fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The time at which the compute fleet was created.
         * </p>
         * 
         * @param created
         *        The time at which the compute fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The time at which the compute fleet was last modified.
         * </p>
         * 
         * @param lastModified
         *        The time at which the compute fleet was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The status of the compute fleet.
         * </p>
         * 
         * @param status
         *        The status of the compute fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(FleetStatus status);

        /**
         * <p>
         * The status of the compute fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetStatus.Builder} avoiding the need to
         * create one manually via {@link FleetStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #status(FleetStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link FleetStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(FleetStatus)
         */
        default Builder status(Consumer<FleetStatus.Builder> status) {
            return status(FleetStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run
         * in parallel.
         * </p>
         * 
         * @param baseCapacity
         *        The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that
         *        can run in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseCapacity(Integer baseCapacity);

        /**
         * <p>
         * The environment type of the compute fleet.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East
         * (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific
         * (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US East
         * (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia
         * Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US
         * East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>MAC_ARM</code> is available for Medium fleets only in regions US East (N.
         * Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), and EU (Frankfurt)
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>MAC_ARM</code> is available for Large fleets only in regions US East (N.
         * Virginia), US East (Ohio), US West (Oregon), and Asia Pacific (Sydney).
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N.
         * Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific
         * (Mumbai) and EU (Ireland).
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N.
         * Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia
         * Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         * environment compute types</a> in the <i>CodeBuild user guide</i>.
         * </p>
         * 
         * @param environmentType
         *        The environment type of the compute fleet.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US
         *        East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific
         *        (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia),
         *        US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific
         *        (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N.
         *        Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and
         *        Asia Pacific (Sydney).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>MAC_ARM</code> is available for Medium fleets only in regions US East (N.
         *        Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), and EU (Frankfurt)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>MAC_ARM</code> is available for Large fleets only in regions US East (N.
         *        Virginia), US East (Ohio), US West (Oregon), and Asia Pacific (Sydney).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East
         *        (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia
         *        Pacific (Mumbai) and EU (Ireland).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East
         *        (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney),
         *        Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         *        environment compute types</a> in the <i>CodeBuild user guide</i>.
         * @see EnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentType
         */
        Builder environmentType(String environmentType);

        /**
         * <p>
         * The environment type of the compute fleet.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US East
         * (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific
         * (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia), US East
         * (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia
         * Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N. Virginia), US
         * East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>MAC_ARM</code> is available for Medium fleets only in regions US East (N.
         * Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), and EU (Frankfurt)
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>MAC_ARM</code> is available for Large fleets only in regions US East (N.
         * Virginia), US East (Ohio), US West (Oregon), and Asia Pacific (Sydney).
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East (N.
         * Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific
         * (Mumbai) and EU (Ireland).
         * </p>
         * </li>
         * <li>
         * <p>
         * The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East (N.
         * Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia
         * Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         * environment compute types</a> in the <i>CodeBuild user guide</i>.
         * </p>
         * 
         * @param environmentType
         *        The environment type of the compute fleet.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The environment type <code>ARM_CONTAINER</code> is available only in regions US East (N. Virginia), US
         *        East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific
         *        (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>LINUX_CONTAINER</code> is available only in regions US East (N. Virginia),
         *        US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific
         *        (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>LINUX_GPU_CONTAINER</code> is available only in regions US East (N.
         *        Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and
         *        Asia Pacific (Sydney).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>MAC_ARM</code> is available for Medium fleets only in regions US East (N.
         *        Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), and EU (Frankfurt)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>MAC_ARM</code> is available for Large fleets only in regions US East (N.
         *        Virginia), US East (Ohio), US West (Oregon), and Asia Pacific (Sydney).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>WINDOWS_SERVER_2019_CONTAINER</code> is available only in regions US East
         *        (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia
         *        Pacific (Mumbai) and EU (Ireland).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The environment type <code>WINDOWS_SERVER_2022_CONTAINER</code> is available only in regions US East
         *        (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney),
         *        Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         *        environment compute types</a> in the <i>CodeBuild user guide</i>.
         * @see EnvironmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentType
         */
        Builder environmentType(EnvironmentType environmentType);

        /**
         * <p>
         * Information about the compute resources the compute fleet uses. Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for builds, depending on your
         * environment type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_XLARGE</code>: Use up to 70 GB memory and 36 vCPUs for builds, depending on your
         * environment type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds.
         * This compute type supports Docker images up to 100 GB uncompressed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you use <code>BUILD_GENERAL1_SMALL</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For environment type <code>LINUX_CONTAINER</code>, you can use up to 3 GB memory and 2 vCPUs for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA
         * A10G Tensor Core GPU for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * For environment type <code>ARM_CONTAINER</code>, you can use up to 4 GB memory and 2 vCPUs on ARM-based
         * processors for builds.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you use <code>BUILD_GENERAL1_LARGE</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB memory and 8 vCPUs for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255 GB memory, 32 vCPUs, and 4
         * NVIDIA Tesla V100 GPUs for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB memory and 8 vCPUs on ARM-based
         * processors for builds.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         * environment compute types</a> in the <i>CodeBuild User Guide.</i>
         * </p>
         * 
         * @param computeType
         *        Information about the compute resources the compute fleet uses. Available values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for builds, depending on your
         *        environment type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_XLARGE</code>: Use up to 70 GB memory and 36 vCPUs for builds, depending on your
         *        environment type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for
         *        builds. This compute type supports Docker images up to 100 GB uncompressed.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you use <code>BUILD_GENERAL1_SMALL</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For environment type <code>LINUX_CONTAINER</code>, you can use up to 3 GB memory and 2 vCPUs for
         *        builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 16 GB memory, 4 vCPUs, and 1
         *        NVIDIA A10G Tensor Core GPU for builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For environment type <code>ARM_CONTAINER</code>, you can use up to 4 GB memory and 2 vCPUs on
         *        ARM-based processors for builds.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you use <code>BUILD_GENERAL1_LARGE</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB memory and 8 vCPUs for
         *        builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255 GB memory, 32 vCPUs, and
         *        4 NVIDIA Tesla V100 GPUs for builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB memory and 8 vCPUs on
         *        ARM-based processors for builds.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         *        environment compute types</a> in the <i>CodeBuild User Guide.</i>
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(String computeType);

        /**
         * <p>
         * Information about the compute resources the compute fleet uses. Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for builds, depending on your
         * environment type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_XLARGE</code>: Use up to 70 GB memory and 36 vCPUs for builds, depending on your
         * environment type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds.
         * This compute type supports Docker images up to 100 GB uncompressed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you use <code>BUILD_GENERAL1_SMALL</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For environment type <code>LINUX_CONTAINER</code>, you can use up to 3 GB memory and 2 vCPUs for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA
         * A10G Tensor Core GPU for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * For environment type <code>ARM_CONTAINER</code>, you can use up to 4 GB memory and 2 vCPUs on ARM-based
         * processors for builds.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you use <code>BUILD_GENERAL1_LARGE</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB memory and 8 vCPUs for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255 GB memory, 32 vCPUs, and 4
         * NVIDIA Tesla V100 GPUs for builds.
         * </p>
         * </li>
         * <li>
         * <p>
         * For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB memory and 8 vCPUs on ARM-based
         * processors for builds.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         * environment compute types</a> in the <i>CodeBuild User Guide.</i>
         * </p>
         * 
         * @param computeType
         *        Information about the compute resources the compute fleet uses. Available values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for builds, depending on your
         *        environment type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_XLARGE</code>: Use up to 70 GB memory and 36 vCPUs for builds, depending on your
         *        environment type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for
         *        builds. This compute type supports Docker images up to 100 GB uncompressed.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you use <code>BUILD_GENERAL1_SMALL</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For environment type <code>LINUX_CONTAINER</code>, you can use up to 3 GB memory and 2 vCPUs for
         *        builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 16 GB memory, 4 vCPUs, and 1
         *        NVIDIA A10G Tensor Core GPU for builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For environment type <code>ARM_CONTAINER</code>, you can use up to 4 GB memory and 2 vCPUs on
         *        ARM-based processors for builds.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you use <code>BUILD_GENERAL1_LARGE</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB memory and 8 vCPUs for
         *        builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255 GB memory, 32 vCPUs, and
         *        4 NVIDIA Tesla V100 GPUs for builds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB memory and 8 vCPUs on
         *        ARM-based processors for builds.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         *        environment compute types</a> in the <i>CodeBuild User Guide.</i>
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(ComputeType computeType);

        /**
         * <p>
         * The scaling configuration of the compute fleet.
         * </p>
         * 
         * @param scalingConfiguration
         *        The scaling configuration of the compute fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfiguration(ScalingConfigurationOutput scalingConfiguration);

        /**
         * <p>
         * The scaling configuration of the compute fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingConfigurationOutput.Builder}
         * avoiding the need to create one manually via {@link ScalingConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingConfigurationOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #scalingConfiguration(ScalingConfigurationOutput)}.
         * 
         * @param scalingConfiguration
         *        a consumer that will call methods on {@link ScalingConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfiguration(ScalingConfigurationOutput)
         */
        default Builder scalingConfiguration(Consumer<ScalingConfigurationOutput.Builder> scalingConfiguration) {
            return scalingConfiguration(ScalingConfigurationOutput.builder().applyMutation(scalingConfiguration).build());
        }

        /**
         * <p>
         * The compute fleet overflow behavior.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For overflow behavior <code>QUEUE</code>, your overflow builds need to wait on the existing fleet instance to
         * become available.
         * </p>
         * </li>
         * <li>
         * <p>
         * For overflow behavior <code>ON_DEMAND</code>, your overflow builds run on CodeBuild on-demand.
         * </p>
         * <note>
         * <p>
         * If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure that
         * you add the required VPC permissions to your project service role. For more information, see <a href=
         * "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface"
         * >Example policy statement to allow CodeBuild access to Amazon Web Services services required to create a VPC
         * network interface</a>.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param overflowBehavior
         *        The compute fleet overflow behavior.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For overflow behavior <code>QUEUE</code>, your overflow builds need to wait on the existing fleet
         *        instance to become available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For overflow behavior <code>ON_DEMAND</code>, your overflow builds run on CodeBuild on-demand.
         *        </p>
         *        <note>
         *        <p>
         *        If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make
         *        sure that you add the required VPC permissions to your project service role. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface"
         *        >Example policy statement to allow CodeBuild access to Amazon Web Services services required to create
         *        a VPC network interface</a>.
         *        </p>
         *        </note></li>
         * @see FleetOverflowBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetOverflowBehavior
         */
        Builder overflowBehavior(String overflowBehavior);

        /**
         * <p>
         * The compute fleet overflow behavior.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For overflow behavior <code>QUEUE</code>, your overflow builds need to wait on the existing fleet instance to
         * become available.
         * </p>
         * </li>
         * <li>
         * <p>
         * For overflow behavior <code>ON_DEMAND</code>, your overflow builds run on CodeBuild on-demand.
         * </p>
         * <note>
         * <p>
         * If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make sure that
         * you add the required VPC permissions to your project service role. For more information, see <a href=
         * "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface"
         * >Example policy statement to allow CodeBuild access to Amazon Web Services services required to create a VPC
         * network interface</a>.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param overflowBehavior
         *        The compute fleet overflow behavior.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For overflow behavior <code>QUEUE</code>, your overflow builds need to wait on the existing fleet
         *        instance to become available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For overflow behavior <code>ON_DEMAND</code>, your overflow builds run on CodeBuild on-demand.
         *        </p>
         *        <note>
         *        <p>
         *        If you choose to set your overflow behavior to on-demand while creating a VPC-connected fleet, make
         *        sure that you add the required VPC permissions to your project service role. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface"
         *        >Example policy statement to allow CodeBuild access to Amazon Web Services services required to create
         *        a VPC network interface</a>.
         *        </p>
         *        </note></li>
         * @see FleetOverflowBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetOverflowBehavior
         */
        Builder overflowBehavior(FleetOverflowBehavior overflowBehavior);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The Amazon Machine Image (AMI) of the compute fleet.
         * </p>
         * 
         * @param imageId
         *        The Amazon Machine Image (AMI) of the compute fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The service role associated with the compute fleet. For more information, see <a href=
         * "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html"
         * > Allow a user to add a permission policy for a fleet service role</a> in the <i>CodeBuild User Guide</i>.
         * </p>
         * 
         * @param fleetServiceRole
         *        The service role associated with the compute fleet. For more information, see <a href=
         *        "https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html"
         *        > Allow a user to add a permission policy for a fleet service role</a> in the <i>CodeBuild User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetServiceRole(String fleetServiceRole);

        /**
         * <p>
         * A list of tag key and value pairs associated with this compute fleet.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         * </p>
         * 
         * @param tags
         *        A list of tag key and value pairs associated with this compute fleet.</p>
         *        <p>
         *        These tags are available for use by Amazon Web Services services that support CodeBuild build project
         *        tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tag key and value pairs associated with this compute fleet.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         * </p>
         * 
         * @param tags
         *        A list of tag key and value pairs associated with this compute fleet.</p>
         *        <p>
         *        These tags are available for use by Amazon Web Services services that support CodeBuild build project
         *        tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tag key and value pairs associated with this compute fleet.
         * </p>
         * <p>
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.codebuild.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String id;

        private Instant created;

        private Instant lastModified;

        private FleetStatus status;

        private Integer baseCapacity;

        private String environmentType;

        private String computeType;

        private ScalingConfigurationOutput scalingConfiguration;

        private String overflowBehavior;

        private VpcConfig vpcConfig;

        private String imageId;

        private String fleetServiceRole;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Fleet model) {
            arn(model.arn);
            name(model.name);
            id(model.id);
            created(model.created);
            lastModified(model.lastModified);
            status(model.status);
            baseCapacity(model.baseCapacity);
            environmentType(model.environmentType);
            computeType(model.computeType);
            scalingConfiguration(model.scalingConfiguration);
            overflowBehavior(model.overflowBehavior);
            vpcConfig(model.vpcConfig);
            imageId(model.imageId);
            fleetServiceRole(model.fleetServiceRole);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final FleetStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(FleetStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(FleetStatus status) {
            this.status = status;
            return this;
        }

        public final Integer getBaseCapacity() {
            return baseCapacity;
        }

        public final void setBaseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
        }

        @Override
        public final Builder baseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        public final String getEnvironmentType() {
            return environmentType;
        }

        public final void setEnvironmentType(String environmentType) {
            this.environmentType = environmentType;
        }

        @Override
        public final Builder environmentType(String environmentType) {
            this.environmentType = environmentType;
            return this;
        }

        @Override
        public final Builder environmentType(EnvironmentType environmentType) {
            this.environmentType(environmentType == null ? null : environmentType.toString());
            return this;
        }

        public final String getComputeType() {
            return computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final ScalingConfigurationOutput.Builder getScalingConfiguration() {
            return scalingConfiguration != null ? scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfigurationOutput.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfigurationOutput scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final String getOverflowBehavior() {
            return overflowBehavior;
        }

        public final void setOverflowBehavior(String overflowBehavior) {
            this.overflowBehavior = overflowBehavior;
        }

        @Override
        public final Builder overflowBehavior(String overflowBehavior) {
            this.overflowBehavior = overflowBehavior;
            return this;
        }

        @Override
        public final Builder overflowBehavior(FleetOverflowBehavior overflowBehavior) {
            this.overflowBehavior(overflowBehavior == null ? null : overflowBehavior.toString());
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getFleetServiceRole() {
            return fleetServiceRole;
        }

        public final void setFleetServiceRole(String fleetServiceRole) {
            this.fleetServiceRole = fleetServiceRole;
        }

        @Override
        public final Builder fleetServiceRole(String fleetServiceRole) {
            this.fleetServiceRole = fleetServiceRole;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Fleet build() {
            return new Fleet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
