/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFleetsRequest extends CodeBuildRequest implements
        ToCopyableBuilder<ListFleetsRequest.Builder, ListFleetsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFleetsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListFleetsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListFleetsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListFleetsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String sortOrder;

    private final String sortBy;

    private ListFleetsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
    }

    /**
     * <p>
     * During a previous call, if there are more than 100 items in the list, only the first 100 items are returned,
     * along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this
     * operation again, adding the next token to the call. To get all of the items in the list, keep calling this
     * operation with each subsequent next token that is returned, until no more next tokens are returned.
     * </p>
     * 
     * @return During a previous call, if there are more than 100 items in the list, only the first 100 items are
     *         returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the
     *         list, call this operation again, adding the next token to the call. To get all of the items in the list,
     *         keep calling this operation with each subsequent next token that is returned, until no more next tokens
     *         are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of paginated compute fleets returned per response. Use <code>nextToken</code> to iterate pages
     * in the list of returned compute fleets.
     * </p>
     * 
     * @return The maximum number of paginated compute fleets returned per response. Use <code>nextToken</code> to
     *         iterate pages in the list of returned compute fleets.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The order in which to list compute fleets. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASCENDING</code>: List in ascending order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESCENDING</code>: List in descending order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use <code>sortBy</code> to specify the criterion to be used to list compute fleet names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which to list compute fleets. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASCENDING</code>: List in ascending order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESCENDING</code>: List in descending order.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use <code>sortBy</code> to specify the criterion to be used to list compute fleet names.
     * @see SortOrderType
     */
    public final SortOrderType sortOrder() {
        return SortOrderType.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order in which to list compute fleets. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASCENDING</code>: List in ascending order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESCENDING</code>: List in descending order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use <code>sortBy</code> to specify the criterion to be used to list compute fleet names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which to list compute fleets. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASCENDING</code>: List in ascending order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESCENDING</code>: List in descending order.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use <code>sortBy</code> to specify the criterion to be used to list compute fleet names.
     * @see SortOrderType
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The criterion to be used to list compute fleet names. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATED_TIME</code>: List based on when each compute fleet was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAST_MODIFIED_TIME</code>: List based on when information about each compute fleet was last changed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: List based on each compute fleet's name.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use <code>sortOrder</code> to specify in what order to list the compute fleet names based on the preceding
     * criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link FleetSortByType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The criterion to be used to list compute fleet names. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATED_TIME</code>: List based on when each compute fleet was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAST_MODIFIED_TIME</code>: List based on when information about each compute fleet was last
     *         changed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NAME</code>: List based on each compute fleet's name.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use <code>sortOrder</code> to specify in what order to list the compute fleet names based on the
     *         preceding criteria.
     * @see FleetSortByType
     */
    public final FleetSortByType sortBy() {
        return FleetSortByType.fromValue(sortBy);
    }

    /**
     * <p>
     * The criterion to be used to list compute fleet names. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATED_TIME</code>: List based on when each compute fleet was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAST_MODIFIED_TIME</code>: List based on when information about each compute fleet was last changed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NAME</code>: List based on each compute fleet's name.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use <code>sortOrder</code> to specify in what order to list the compute fleet names based on the preceding
     * criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link FleetSortByType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The criterion to be used to list compute fleet names. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATED_TIME</code>: List based on when each compute fleet was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAST_MODIFIED_TIME</code>: List based on when information about each compute fleet was last
     *         changed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NAME</code>: List based on each compute fleet's name.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use <code>sortOrder</code> to specify in what order to list the compute fleet names based on the
     *         preceding criteria.
     * @see FleetSortByType
     */
    public final String sortByAsString() {
        return sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetsRequest)) {
            return false;
        }
        ListFleetsRequest other = (ListFleetsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFleetsRequest")
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").add("MaxResults", maxResults())
                .add("SortOrder", sortOrderAsString()).add("SortBy", sortByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFleetsRequest, T> g) {
        return obj -> g.apply((ListFleetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFleetsRequest> {
        /**
         * <p>
         * During a previous call, if there are more than 100 items in the list, only the first 100 items are returned,
         * along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this
         * operation again, adding the next token to the call. To get all of the items in the list, keep calling this
         * operation with each subsequent next token that is returned, until no more next tokens are returned.
         * </p>
         * 
         * @param nextToken
         *        During a previous call, if there are more than 100 items in the list, only the first 100 items are
         *        returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the
         *        list, call this operation again, adding the next token to the call. To get all of the items in the
         *        list, keep calling this operation with each subsequent next token that is returned, until no more next
         *        tokens are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of paginated compute fleets returned per response. Use <code>nextToken</code> to iterate
         * pages in the list of returned compute fleets.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of paginated compute fleets returned per response. Use <code>nextToken</code> to
         *        iterate pages in the list of returned compute fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The order in which to list compute fleets. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASCENDING</code>: List in ascending order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESCENDING</code>: List in descending order.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use <code>sortBy</code> to specify the criterion to be used to list compute fleet names.
         * </p>
         * 
         * @param sortOrder
         *        The order in which to list compute fleets. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASCENDING</code>: List in ascending order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESCENDING</code>: List in descending order.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use <code>sortBy</code> to specify the criterion to be used to list compute fleet names.
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order in which to list compute fleets. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASCENDING</code>: List in ascending order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESCENDING</code>: List in descending order.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use <code>sortBy</code> to specify the criterion to be used to list compute fleet names.
         * </p>
         * 
         * @param sortOrder
         *        The order in which to list compute fleets. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASCENDING</code>: List in ascending order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESCENDING</code>: List in descending order.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use <code>sortBy</code> to specify the criterion to be used to list compute fleet names.
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(SortOrderType sortOrder);

        /**
         * <p>
         * The criterion to be used to list compute fleet names. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATED_TIME</code>: List based on when each compute fleet was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAST_MODIFIED_TIME</code>: List based on when information about each compute fleet was last changed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NAME</code>: List based on each compute fleet's name.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use <code>sortOrder</code> to specify in what order to list the compute fleet names based on the preceding
         * criteria.
         * </p>
         * 
         * @param sortBy
         *        The criterion to be used to list compute fleet names. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATED_TIME</code>: List based on when each compute fleet was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAST_MODIFIED_TIME</code>: List based on when information about each compute fleet was last
         *        changed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NAME</code>: List based on each compute fleet's name.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use <code>sortOrder</code> to specify in what order to list the compute fleet names based on the
         *        preceding criteria.
         * @see FleetSortByType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetSortByType
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The criterion to be used to list compute fleet names. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATED_TIME</code>: List based on when each compute fleet was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAST_MODIFIED_TIME</code>: List based on when information about each compute fleet was last changed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NAME</code>: List based on each compute fleet's name.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use <code>sortOrder</code> to specify in what order to list the compute fleet names based on the preceding
         * criteria.
         * </p>
         * 
         * @param sortBy
         *        The criterion to be used to list compute fleet names. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATED_TIME</code>: List based on when each compute fleet was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAST_MODIFIED_TIME</code>: List based on when information about each compute fleet was last
         *        changed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NAME</code>: List based on each compute fleet's name.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use <code>sortOrder</code> to specify in what order to list the compute fleet names based on the
         *        preceding criteria.
         * @see FleetSortByType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetSortByType
         */
        Builder sortBy(FleetSortByType sortBy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String sortOrder;

        private String sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(FleetSortByType sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFleetsRequest build() {
            return new ListFleetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
