/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about S3 logs for a build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3LogsConfig implements SdkPojo, Serializable, ToCopyableBuilder<S3LogsConfig.Builder, S3LogsConfig> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(S3LogsConfig::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(S3LogsConfig::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<Boolean> ENCRYPTION_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("encryptionDisabled").getter(getter(S3LogsConfig::encryptionDisabled))
            .setter(setter(Builder::encryptionDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionDisabled").build())
            .build();

    private static final SdkField<String> BUCKET_OWNER_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketOwnerAccess").getter(getter(S3LogsConfig::bucketOwnerAccessAsString))
            .setter(setter(Builder::bucketOwnerAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketOwnerAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, LOCATION_FIELD,
            ENCRYPTION_DISABLED_FIELD, BUCKET_OWNER_ACCESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String location;

    private final Boolean encryptionDisabled;

    private final String bucketOwnerAccess;

    private S3LogsConfig(BuilderImpl builder) {
        this.status = builder.status;
        this.location = builder.location;
        this.encryptionDisabled = builder.encryptionDisabled;
        this.bucketOwnerAccess = builder.bucketOwnerAccess;
    }

    /**
     * <p>
     * The current status of the S3 build logs. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>: S3 build logs are enabled for this build project.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>: S3 build logs are not enabled for this build project.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LogsConfigStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the S3 build logs. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code>: S3 build logs are enabled for this build project.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code>: S3 build logs are not enabled for this build project.
     *         </p>
     *         </li>
     * @see LogsConfigStatusType
     */
    public final LogsConfigStatusType status() {
        return LogsConfigStatusType.fromValue(status);
    }

    /**
     * <p>
     * The current status of the S3 build logs. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>: S3 build logs are enabled for this build project.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>: S3 build logs are not enabled for this build project.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LogsConfigStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the S3 build logs. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code>: S3 build logs are enabled for this build project.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code>: S3 build logs are not enabled for this build project.
     *         </p>
     *         </li>
     * @see LogsConfigStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3 bucket name is <code>my-bucket</code>,
     * and your path prefix is <code>build-log</code>, then acceptable formats are <code>my-bucket/build-log</code> or
     * <code>arn:aws:s3:::my-bucket/build-log</code>.
     * </p>
     * 
     * @return The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3 bucket name is
     *         <code>my-bucket</code>, and your path prefix is <code>build-log</code>, then acceptable formats are
     *         <code>my-bucket/build-log</code> or <code>arn:aws:s3:::my-bucket/build-log</code>.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * Set to true if you do not want your S3 build log output encrypted. By default S3 build logs are encrypted.
     * </p>
     * 
     * @return Set to true if you do not want your S3 build log output encrypted. By default S3 build logs are
     *         encrypted.
     */
    public final Boolean encryptionDisabled() {
        return encryptionDisabled;
    }

    /**
     * Returns the value of the BucketOwnerAccess property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bucketOwnerAccess}
     * will return {@link BucketOwnerAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bucketOwnerAccessAsString}.
     * </p>
     * 
     * @return The value of the BucketOwnerAccess property for this object.
     * @see BucketOwnerAccess
     */
    public final BucketOwnerAccess bucketOwnerAccess() {
        return BucketOwnerAccess.fromValue(bucketOwnerAccess);
    }

    /**
     * Returns the value of the BucketOwnerAccess property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bucketOwnerAccess}
     * will return {@link BucketOwnerAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bucketOwnerAccessAsString}.
     * </p>
     * 
     * @return The value of the BucketOwnerAccess property for this object.
     * @see BucketOwnerAccess
     */
    public final String bucketOwnerAccessAsString() {
        return bucketOwnerAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(bucketOwnerAccessAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LogsConfig)) {
            return false;
        }
        S3LogsConfig other = (S3LogsConfig) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(location(), other.location())
                && Objects.equals(encryptionDisabled(), other.encryptionDisabled())
                && Objects.equals(bucketOwnerAccessAsString(), other.bucketOwnerAccessAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3LogsConfig").add("Status", statusAsString()).add("Location", location())
                .add("EncryptionDisabled", encryptionDisabled()).add("BucketOwnerAccess", bucketOwnerAccessAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "encryptionDisabled":
            return Optional.ofNullable(clazz.cast(encryptionDisabled()));
        case "bucketOwnerAccess":
            return Optional.ofNullable(clazz.cast(bucketOwnerAccessAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3LogsConfig, T> g) {
        return obj -> g.apply((S3LogsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3LogsConfig> {
        /**
         * <p>
         * The current status of the S3 build logs. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code>: S3 build logs are enabled for this build project.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code>: S3 build logs are not enabled for this build project.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the S3 build logs. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code>: S3 build logs are enabled for this build project.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code>: S3 build logs are not enabled for this build project.
         *        </p>
         *        </li>
         * @see LogsConfigStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogsConfigStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the S3 build logs. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code>: S3 build logs are enabled for this build project.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code>: S3 build logs are not enabled for this build project.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the S3 build logs. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code>: S3 build logs are enabled for this build project.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code>: S3 build logs are not enabled for this build project.
         *        </p>
         *        </li>
         * @see LogsConfigStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogsConfigStatusType
         */
        Builder status(LogsConfigStatusType status);

        /**
         * <p>
         * The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3 bucket name is
         * <code>my-bucket</code>, and your path prefix is <code>build-log</code>, then acceptable formats are
         * <code>my-bucket/build-log</code> or <code>arn:aws:s3:::my-bucket/build-log</code>.
         * </p>
         * 
         * @param location
         *        The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3 bucket name is
         *        <code>my-bucket</code>, and your path prefix is <code>build-log</code>, then acceptable formats are
         *        <code>my-bucket/build-log</code> or <code>arn:aws:s3:::my-bucket/build-log</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * Set to true if you do not want your S3 build log output encrypted. By default S3 build logs are encrypted.
         * </p>
         * 
         * @param encryptionDisabled
         *        Set to true if you do not want your S3 build log output encrypted. By default S3 build logs are
         *        encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionDisabled(Boolean encryptionDisabled);

        /**
         * Sets the value of the BucketOwnerAccess property for this object.
         *
         * @param bucketOwnerAccess
         *        The new value for the BucketOwnerAccess property for this object.
         * @see BucketOwnerAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketOwnerAccess
         */
        Builder bucketOwnerAccess(String bucketOwnerAccess);

        /**
         * Sets the value of the BucketOwnerAccess property for this object.
         *
         * @param bucketOwnerAccess
         *        The new value for the BucketOwnerAccess property for this object.
         * @see BucketOwnerAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketOwnerAccess
         */
        Builder bucketOwnerAccess(BucketOwnerAccess bucketOwnerAccess);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String location;

        private Boolean encryptionDisabled;

        private String bucketOwnerAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LogsConfig model) {
            status(model.status);
            location(model.location);
            encryptionDisabled(model.encryptionDisabled);
            bucketOwnerAccess(model.bucketOwnerAccess);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LogsConfigStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final Boolean getEncryptionDisabled() {
            return encryptionDisabled;
        }

        public final void setEncryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
        }

        @Override
        public final Builder encryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
            return this;
        }

        public final String getBucketOwnerAccess() {
            return bucketOwnerAccess;
        }

        public final void setBucketOwnerAccess(String bucketOwnerAccess) {
            this.bucketOwnerAccess = bucketOwnerAccess;
        }

        @Override
        public final Builder bucketOwnerAccess(String bucketOwnerAccess) {
            this.bucketOwnerAccess = bucketOwnerAccess;
            return this;
        }

        @Override
        public final Builder bucketOwnerAccess(BucketOwnerAccess bucketOwnerAccess) {
            this.bucketOwnerAccess(bucketOwnerAccess == null ? null : bucketOwnerAccess.toString());
            return this;
        }

        @Override
        public S3LogsConfig build() {
            return new S3LogsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
