/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetFleetsResponse extends CodeBuildResponse implements
        ToCopyableBuilder<BatchGetFleetsResponse.Builder, BatchGetFleetsResponse> {
    private static final SdkField<List<Fleet>> FLEETS_FIELD = SdkField
            .<List<Fleet>> builder(MarshallingType.LIST)
            .memberName("fleets")
            .getter(getter(BatchGetFleetsResponse::fleets))
            .setter(setter(Builder::fleets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Fleet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Fleet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FLEETS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("fleetsNotFound")
            .getter(getter(BatchGetFleetsResponse::fleetsNotFound))
            .setter(setter(Builder::fleetsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEETS_FIELD,
            FLEETS_NOT_FOUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Fleet> fleets;

    private final List<String> fleetsNotFound;

    private BatchGetFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.fleets = builder.fleets;
        this.fleetsNotFound = builder.fleetsNotFound;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fleets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFleets() {
        return fleets != null && !(fleets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the requested compute fleets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleets} method.
     * </p>
     * 
     * @return Information about the requested compute fleets.
     */
    public final List<Fleet> fleets() {
        return fleets;
    }

    /**
     * For responses, this returns true if the service returned a value for the FleetsNotFound property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFleetsNotFound() {
        return fleetsNotFound != null && !(fleetsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of compute fleets for which information could not be found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleetsNotFound} method.
     * </p>
     * 
     * @return The names of compute fleets for which information could not be found.
     */
    public final List<String> fleetsNotFound() {
        return fleetsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFleets() ? fleets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetsNotFound() ? fleetsNotFound() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFleetsResponse)) {
            return false;
        }
        BatchGetFleetsResponse other = (BatchGetFleetsResponse) obj;
        return hasFleets() == other.hasFleets() && Objects.equals(fleets(), other.fleets())
                && hasFleetsNotFound() == other.hasFleetsNotFound() && Objects.equals(fleetsNotFound(), other.fleetsNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetFleetsResponse").add("Fleets", hasFleets() ? fleets() : null)
                .add("FleetsNotFound", hasFleetsNotFound() ? fleetsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fleets":
            return Optional.ofNullable(clazz.cast(fleets()));
        case "fleetsNotFound":
            return Optional.ofNullable(clazz.cast(fleetsNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fleets", FLEETS_FIELD);
        map.put("fleetsNotFound", FLEETS_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFleetsResponse, T> g) {
        return obj -> g.apply((BatchGetFleetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetFleetsResponse> {
        /**
         * <p>
         * Information about the requested compute fleets.
         * </p>
         * 
         * @param fleets
         *        Information about the requested compute fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(Collection<Fleet> fleets);

        /**
         * <p>
         * Information about the requested compute fleets.
         * </p>
         * 
         * @param fleets
         *        Information about the requested compute fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(Fleet... fleets);

        /**
         * <p>
         * Information about the requested compute fleets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.Fleet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codebuild.model.Fleet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.Fleet.Builder#build()} is called immediately and its
         * result is passed to {@link #fleets(List<Fleet>)}.
         * 
         * @param fleets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.Fleet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleets(java.util.Collection<Fleet>)
         */
        Builder fleets(Consumer<Fleet.Builder>... fleets);

        /**
         * <p>
         * The names of compute fleets for which information could not be found.
         * </p>
         * 
         * @param fleetsNotFound
         *        The names of compute fleets for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetsNotFound(Collection<String> fleetsNotFound);

        /**
         * <p>
         * The names of compute fleets for which information could not be found.
         * </p>
         * 
         * @param fleetsNotFound
         *        The names of compute fleets for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetsNotFound(String... fleetsNotFound);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private List<Fleet> fleets = DefaultSdkAutoConstructList.getInstance();

        private List<String> fleetsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFleetsResponse model) {
            super(model);
            fleets(model.fleets);
            fleetsNotFound(model.fleetsNotFound);
        }

        public final List<Fleet.Builder> getFleets() {
            List<Fleet.Builder> result = FleetsCopier.copyToBuilder(this.fleets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleets(Collection<Fleet.BuilderImpl> fleets) {
            this.fleets = FleetsCopier.copyFromBuilder(fleets);
        }

        @Override
        public final Builder fleets(Collection<Fleet> fleets) {
            this.fleets = FleetsCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Fleet... fleets) {
            fleets(Arrays.asList(fleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Consumer<Fleet.Builder>... fleets) {
            fleets(Stream.of(fleets).map(c -> Fleet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getFleetsNotFound() {
            if (fleetsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return fleetsNotFound;
        }

        public final void setFleetsNotFound(Collection<String> fleetsNotFound) {
            this.fleetsNotFound = FleetNamesCopier.copy(fleetsNotFound);
        }

        @Override
        public final Builder fleetsNotFound(Collection<String> fleetsNotFound) {
            this.fleetsNotFound = FleetNamesCopier.copy(fleetsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetsNotFound(String... fleetsNotFound) {
            fleetsNotFound(Arrays.asList(fleetsNotFound));
            return this;
        }

        @Override
        public BatchGetFleetsResponse build() {
            return new BatchGetFleetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
