/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFleetsResponse extends CodeBuildResponse implements
        ToCopyableBuilder<ListFleetsResponse.Builder, ListFleetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFleetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> FLEETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("fleets")
            .getter(getter(ListFleetsResponse::fleets))
            .setter(setter(Builder::fleets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_TOKEN_FIELD, FLEETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<String> fleets;

    private ListFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.fleets = builder.fleets;
    }

    /**
     * <p>
     * If there are more than 100 items in the list, only the first 100 items are returned, along with a unique string
     * called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next
     * token to the call.
     * </p>
     * 
     * @return If there are more than 100 items in the list, only the first 100 items are returned, along with a unique
     *         string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again,
     *         adding the next token to the call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fleets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFleets() {
        return fleets != null && !(fleets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of compute fleet names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleets} method.
     * </p>
     * 
     * @return The list of compute fleet names.
     */
    public final List<String> fleets() {
        return fleets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFleets() ? fleets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetsResponse)) {
            return false;
        }
        ListFleetsResponse other = (ListFleetsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasFleets() == other.hasFleets()
                && Objects.equals(fleets(), other.fleets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFleetsResponse").add("NextToken", nextToken()).add("Fleets", hasFleets() ? fleets() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "fleets":
            return Optional.ofNullable(clazz.cast(fleets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("fleets", FLEETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFleetsResponse, T> g) {
        return obj -> g.apply((ListFleetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFleetsResponse> {
        /**
         * <p>
         * If there are more than 100 items in the list, only the first 100 items are returned, along with a unique
         * string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again,
         * adding the next token to the call.
         * </p>
         * 
         * @param nextToken
         *        If there are more than 100 items in the list, only the first 100 items are returned, along with a
         *        unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this
         *        operation again, adding the next token to the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of compute fleet names.
         * </p>
         * 
         * @param fleets
         *        The list of compute fleet names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(Collection<String> fleets);

        /**
         * <p>
         * The list of compute fleet names.
         * </p>
         * 
         * @param fleets
         *        The list of compute fleet names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(String... fleets);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> fleets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetsResponse model) {
            super(model);
            nextToken(model.nextToken);
            fleets(model.fleets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getFleets() {
            if (fleets instanceof SdkAutoConstructList) {
                return null;
            }
            return fleets;
        }

        public final void setFleets(Collection<String> fleets) {
            this.fleets = FleetArnsCopier.copy(fleets);
        }

        @Override
        public final Builder fleets(Collection<String> fleets) {
            this.fleets = FleetArnsCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(String... fleets) {
            fleets(Arrays.asList(fleets));
            return this;
        }

        @Override
        public ListFleetsResponse build() {
            return new ListFleetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
