/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProjectVisibilityRequest extends CodeBuildRequest implements
        ToCopyableBuilder<UpdateProjectVisibilityRequest.Builder, UpdateProjectVisibilityRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(UpdateProjectVisibilityRequest::projectArn))
            .setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<String> PROJECT_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectVisibility").getter(getter(UpdateProjectVisibilityRequest::projectVisibilityAsString))
            .setter(setter(Builder::projectVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectVisibility").build()).build();

    private static final SdkField<String> RESOURCE_ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceAccessRole").getter(getter(UpdateProjectVisibilityRequest::resourceAccessRole))
            .setter(setter(Builder::resourceAccessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceAccessRole").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            PROJECT_VISIBILITY_FIELD, RESOURCE_ACCESS_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectArn;

    private final String projectVisibility;

    private final String resourceAccessRole;

    private UpdateProjectVisibilityRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.projectVisibility = builder.projectVisibility;
        this.resourceAccessRole = builder.resourceAccessRole;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the build project.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the build project.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * Returns the value of the ProjectVisibility property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectVisibility}
     * will return {@link ProjectVisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectVisibilityAsString}.
     * </p>
     * 
     * @return The value of the ProjectVisibility property for this object.
     * @see ProjectVisibilityType
     */
    public final ProjectVisibilityType projectVisibility() {
        return ProjectVisibilityType.fromValue(projectVisibility);
    }

    /**
     * Returns the value of the ProjectVisibility property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #projectVisibility}
     * will return {@link ProjectVisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #projectVisibilityAsString}.
     * </p>
     * 
     * @return The value of the ProjectVisibility property for this object.
     * @see ProjectVisibilityType
     */
    public final String projectVisibilityAsString() {
        return projectVisibility;
    }

    /**
     * <p>
     * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the
     * project's builds.
     * </p>
     * 
     * @return The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for
     *         the project's builds.
     */
    public final String resourceAccessRole() {
        return resourceAccessRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(projectVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAccessRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectVisibilityRequest)) {
            return false;
        }
        UpdateProjectVisibilityRequest other = (UpdateProjectVisibilityRequest) obj;
        return Objects.equals(projectArn(), other.projectArn())
                && Objects.equals(projectVisibilityAsString(), other.projectVisibilityAsString())
                && Objects.equals(resourceAccessRole(), other.resourceAccessRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProjectVisibilityRequest").add("ProjectArn", projectArn())
                .add("ProjectVisibility", projectVisibilityAsString()).add("ResourceAccessRole", resourceAccessRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "projectVisibility":
            return Optional.ofNullable(clazz.cast(projectVisibilityAsString()));
        case "resourceAccessRole":
            return Optional.ofNullable(clazz.cast(resourceAccessRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("projectVisibility", PROJECT_VISIBILITY_FIELD);
        map.put("resourceAccessRole", RESOURCE_ACCESS_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectVisibilityRequest, T> g) {
        return obj -> g.apply((UpdateProjectVisibilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProjectVisibilityRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the build project.
         * </p>
         * 
         * @param projectArn
         *        The Amazon Resource Name (ARN) of the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * Sets the value of the ProjectVisibility property for this object.
         *
         * @param projectVisibility
         *        The new value for the ProjectVisibility property for this object.
         * @see ProjectVisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectVisibilityType
         */
        Builder projectVisibility(String projectVisibility);

        /**
         * Sets the value of the ProjectVisibility property for this object.
         *
         * @param projectVisibility
         *        The new value for the ProjectVisibility property for this object.
         * @see ProjectVisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProjectVisibilityType
         */
        Builder projectVisibility(ProjectVisibilityType projectVisibility);

        /**
         * <p>
         * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the
         * project's builds.
         * </p>
         * 
         * @param resourceAccessRole
         *        The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts
         *        for the project's builds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAccessRole(String resourceAccessRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String projectVisibility;

        private String resourceAccessRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectVisibilityRequest model) {
            super(model);
            projectArn(model.projectArn);
            projectVisibility(model.projectVisibility);
            resourceAccessRole(model.resourceAccessRole);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getProjectVisibility() {
            return projectVisibility;
        }

        public final void setProjectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
        }

        @Override
        public final Builder projectVisibility(String projectVisibility) {
            this.projectVisibility = projectVisibility;
            return this;
        }

        @Override
        public final Builder projectVisibility(ProjectVisibilityType projectVisibility) {
            this.projectVisibility(projectVisibility == null ? null : projectVisibility.toString());
            return this;
        }

        public final String getResourceAccessRole() {
            return resourceAccessRole;
        }

        public final void setResourceAccessRole(String resourceAccessRole) {
            this.resourceAccessRole = resourceAccessRole;
        }

        @Override
        public final Builder resourceAccessRole(String resourceAccessRole) {
            this.resourceAccessRole = resourceAccessRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectVisibilityRequest build() {
            return new UpdateProjectVisibilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
