/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.codebuild.internal.CodeBuildServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codebuild.model.AccountLimitExceededException;
import software.amazon.awssdk.services.codebuild.model.AccountSuspendedException;
import software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetCommandExecutionsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetCommandExecutionsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetFleetsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetFleetsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetSandboxesRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetSandboxesResponse;
import software.amazon.awssdk.services.codebuild.model.CodeBuildException;
import software.amazon.awssdk.services.codebuild.model.CreateFleetRequest;
import software.amazon.awssdk.services.codebuild.model.CreateFleetResponse;
import software.amazon.awssdk.services.codebuild.model.CreateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.CreateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.CreateReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.CreateReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.CreateWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.CreateWebhookResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteFleetRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteFleetResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteReportRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteReportResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest;
import software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse;
import software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest;
import software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse;
import software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendRequest;
import software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendResponse;
import software.amazon.awssdk.services.codebuild.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.codebuild.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsRequest;
import software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsResponse;
import software.amazon.awssdk.services.codebuild.model.InvalidInputException;
import software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheRequest;
import software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.ListCommandExecutionsForSandboxRequest;
import software.amazon.awssdk.services.codebuild.model.ListCommandExecutionsForSandboxResponse;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesRequest;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse;
import software.amazon.awssdk.services.codebuild.model.ListFleetsRequest;
import software.amazon.awssdk.services.codebuild.model.ListFleetsResponse;
import software.amazon.awssdk.services.codebuild.model.ListProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse;
import software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.ListReportsRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportsResponse;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesRequest;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesResponse;
import software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse;
import software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsResponse;
import software.amazon.awssdk.services.codebuild.model.OAuthProviderException;
import software.amazon.awssdk.services.codebuild.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.codebuild.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.codebuild.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.codebuild.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codebuild.model.RetryBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.RetryBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.RetryBuildRequest;
import software.amazon.awssdk.services.codebuild.model.RetryBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StartBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.StartBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.StartBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StartBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StartCommandExecutionRequest;
import software.amazon.awssdk.services.codebuild.model.StartCommandExecutionResponse;
import software.amazon.awssdk.services.codebuild.model.StartSandboxConnectionRequest;
import software.amazon.awssdk.services.codebuild.model.StartSandboxConnectionResponse;
import software.amazon.awssdk.services.codebuild.model.StartSandboxRequest;
import software.amazon.awssdk.services.codebuild.model.StartSandboxResponse;
import software.amazon.awssdk.services.codebuild.model.StopBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.StopBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.StopBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StopBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StopSandboxRequest;
import software.amazon.awssdk.services.codebuild.model.StopSandboxResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateFleetRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateFleetResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateWebhookResponse;
import software.amazon.awssdk.services.codebuild.transform.BatchDeleteBuildsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetBuildBatchesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetBuildsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetCommandExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetFleetsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetProjectsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetReportGroupsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetReportsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetSandboxesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateReportGroupRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateWebhookRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteBuildBatchRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteReportGroupRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteReportRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteSourceCredentialsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteWebhookRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DescribeCodeCoveragesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DescribeTestCasesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.GetReportGroupTrendRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ImportSourceCredentialsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.InvalidateProjectCacheRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildBatchesForProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildBatchesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildsForProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListCommandExecutionsForSandboxRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListCuratedEnvironmentImagesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListReportGroupsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListReportsForReportGroupRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListReportsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListSandboxesForProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListSandboxesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListSharedProjectsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListSharedReportGroupsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListSourceCredentialsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.RetryBuildBatchRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.RetryBuildRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartBuildBatchRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartBuildRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartCommandExecutionRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartSandboxConnectionRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartSandboxRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StopBuildBatchRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StopBuildRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StopSandboxRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateFleetRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateProjectVisibilityRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateReportGroupRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateWebhookRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CodeBuildAsyncClient}.
 *
 * @see CodeBuildAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeBuildAsyncClient implements CodeBuildAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeBuildAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeBuildAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Deletes one or more builds.
     * </p>
     *
     * @param batchDeleteBuildsRequest
     * @return A Java Future containing the result of the BatchDeleteBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchDeleteBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchDeleteBuilds" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteBuildsResponse> batchDeleteBuilds(BatchDeleteBuildsRequest batchDeleteBuildsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteBuildsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteBuildsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteBuilds");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteBuildsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeleteBuildsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchDeleteBuildsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteBuildsRequest, BatchDeleteBuildsResponse>()
                            .withOperationName("BatchDeleteBuilds").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteBuildsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteBuildsRequest));
            CompletableFuture<BatchDeleteBuildsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about one or more batch builds.
     * </p>
     *
     * @param batchGetBuildBatchesRequest
     * @return A Java Future containing the result of the BatchGetBuildBatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetBuildBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuildBatches"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetBuildBatchesResponse> batchGetBuildBatches(
            BatchGetBuildBatchesRequest batchGetBuildBatchesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetBuildBatchesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetBuildBatchesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetBuildBatches");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetBuildBatchesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetBuildBatchesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetBuildBatchesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetBuildBatchesRequest, BatchGetBuildBatchesResponse>()
                            .withOperationName("BatchGetBuildBatches").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetBuildBatchesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetBuildBatchesRequest));
            CompletableFuture<BatchGetBuildBatchesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more builds.
     * </p>
     *
     * @param batchGetBuildsRequest
     * @return A Java Future containing the result of the BatchGetBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetBuildsResponse> batchGetBuilds(BatchGetBuildsRequest batchGetBuildsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetBuildsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetBuildsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetBuilds");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetBuildsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetBuildsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetBuildsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetBuildsRequest, BatchGetBuildsResponse>()
                            .withOperationName("BatchGetBuilds").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetBuildsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetBuildsRequest));
            CompletableFuture<BatchGetBuildsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the command executions.
     * </p>
     *
     * @param batchGetCommandExecutionsRequest
     * @return A Java Future containing the result of the BatchGetCommandExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetCommandExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetCommandExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetCommandExecutionsResponse> batchGetCommandExecutions(
            BatchGetCommandExecutionsRequest batchGetCommandExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetCommandExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetCommandExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetCommandExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetCommandExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetCommandExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetCommandExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetCommandExecutionsRequest, BatchGetCommandExecutionsResponse>()
                            .withOperationName("BatchGetCommandExecutions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetCommandExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetCommandExecutionsRequest));
            CompletableFuture<BatchGetCommandExecutionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more compute fleets.
     * </p>
     *
     * @param batchGetFleetsRequest
     * @return A Java Future containing the result of the BatchGetFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetFleetsResponse> batchGetFleets(BatchGetFleetsRequest batchGetFleetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetFleets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetFleetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetFleetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetFleetsRequest, BatchGetFleetsResponse>()
                            .withOperationName("BatchGetFleets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetFleetsRequest));
            CompletableFuture<BatchGetFleetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about one or more build projects.
     * </p>
     *
     * @param batchGetProjectsRequest
     * @return A Java Future containing the result of the BatchGetProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetProjects" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetProjectsResponse> batchGetProjects(BatchGetProjectsRequest batchGetProjectsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetProjectsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetProjectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetProjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetProjectsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetProjectsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetProjectsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetProjectsRequest, BatchGetProjectsResponse>()
                            .withOperationName("BatchGetProjects").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetProjectsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetProjectsRequest));
            CompletableFuture<BatchGetProjectsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of report groups.
     * </p>
     *
     * @param batchGetReportGroupsRequest
     * @return A Java Future containing the result of the BatchGetReportGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetReportGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetReportGroupsResponse> batchGetReportGroups(
            BatchGetReportGroupsRequest batchGetReportGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetReportGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetReportGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetReportGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetReportGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetReportGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetReportGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetReportGroupsRequest, BatchGetReportGroupsResponse>()
                            .withOperationName("BatchGetReportGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetReportGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetReportGroupsRequest));
            CompletableFuture<BatchGetReportGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of reports.
     * </p>
     *
     * @param batchGetReportsRequest
     * @return A Java Future containing the result of the BatchGetReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetReports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetReportsResponse> batchGetReports(BatchGetReportsRequest batchGetReportsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetReportsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetReportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetReportsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetReportsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetReportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetReportsRequest, BatchGetReportsResponse>()
                            .withOperationName("BatchGetReports").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetReportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetReportsRequest));
            CompletableFuture<BatchGetReportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the sandbox status.
     * </p>
     *
     * @param batchGetSandboxesRequest
     * @return A Java Future containing the result of the BatchGetSandboxes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.BatchGetSandboxes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BatchGetSandboxes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetSandboxesResponse> batchGetSandboxes(BatchGetSandboxesRequest batchGetSandboxesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetSandboxesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetSandboxesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetSandboxes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetSandboxesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetSandboxesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetSandboxesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetSandboxesRequest, BatchGetSandboxesResponse>()
                            .withOperationName("BatchGetSandboxes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetSandboxesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetSandboxesRequest));
            CompletableFuture<BatchGetSandboxesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a compute fleet.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFleetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                            .withOperationName("CreateFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFleetRequest));
            CompletableFuture<CreateFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a build project.
     * </p>
     *
     * @param createProjectRequest
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProjectRequest, CreateProjectResponse>()
                            .withOperationName("CreateProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createProjectRequest));
            CompletableFuture<CreateProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a report group. A report group contains a collection of reports.
     * </p>
     *
     * @param createReportGroupRequest
     * @return A Java Future containing the result of the CreateReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.CreateReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateReportGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReportGroupResponse> createReportGroup(CreateReportGroupRequest createReportGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReportGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReportGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReportGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateReportGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateReportGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateReportGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReportGroupRequest, CreateReportGroupResponse>()
                            .withOperationName("CreateReportGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateReportGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createReportGroupRequest));
            CompletableFuture<CreateReportGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository,
     * enables CodeBuild to start rebuilding the source code every time a code change is pushed to the repository.
     * </p>
     * <important>
     * <p>
     * If you enable webhooks for an CodeBuild project, and the project is used as a build step in CodePipeline, then
     * two identical builds are created for each commit. One build is triggered through webhooks, and one through
     * CodePipeline. Because billing is on a per-build basis, you are billed for both builds. Therefore, if you are
     * using CodePipeline, we recommend that you disable webhooks in CodeBuild. In the CodeBuild console, clear the
     * Webhook box. For more information, see step 5 in <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/change-project.html#change-project-console">Change a
     * Build Project's Settings</a>.
     * </p>
     * </important>
     *
     * @param createWebhookRequest
     * @return A Java Future containing the result of the CreateWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>OAuthProviderException There was a problem with the underlying OAuth provider.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.CreateWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CreateWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWebhookResponse> createWebhook(CreateWebhookRequest createWebhookRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWebhookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWebhook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWebhookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateWebhookResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateWebhookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWebhookRequest, CreateWebhookResponse>()
                            .withOperationName("CreateWebhook").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWebhookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createWebhookRequest));
            CompletableFuture<CreateWebhookResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a batch build.
     * </p>
     *
     * @param deleteBuildBatchRequest
     * @return A Java Future containing the result of the DeleteBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteBuildBatch" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBuildBatchResponse> deleteBuildBatch(DeleteBuildBatchRequest deleteBuildBatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBuildBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBuildBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBuildBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBuildBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBuildBatchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteBuildBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBuildBatchRequest, DeleteBuildBatchResponse>()
                            .withOperationName("DeleteBuildBatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBuildBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBuildBatchRequest));
            CompletableFuture<DeleteBuildBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a compute fleet. When you delete a compute fleet, its builds are not deleted.
     * </p>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFleetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFleetRequest, DeleteFleetResponse>()
                            .withOperationName("DeleteFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFleetRequest));
            CompletableFuture<DeleteFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a build project. When you delete a project, its builds are not deleted.
     * </p>
     *
     * @param deleteProjectRequest
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProjectRequest, DeleteProjectResponse>()
                            .withOperationName("DeleteProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteProjectRequest));
            CompletableFuture<DeleteProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a report.
     * </p>
     *
     * @param deleteReportRequest
     * @return A Java Future containing the result of the DeleteReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteReport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReportResponse> deleteReport(DeleteReportRequest deleteReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReportRequest, DeleteReportResponse>()
                            .withOperationName("DeleteReport").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteReportRequest));
            CompletableFuture<DeleteReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a report group. Before you delete a report group, you must delete its reports.
     * </p>
     *
     * @param deleteReportGroupRequest
     * @return A Java Future containing the result of the DeleteReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteReportGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReportGroupResponse> deleteReportGroup(DeleteReportGroupRequest deleteReportGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReportGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReportGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReportGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReportGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteReportGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteReportGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReportGroupRequest, DeleteReportGroupResponse>()
                            .withOperationName("DeleteReportGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReportGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteReportGroupRequest));
            CompletableFuture<DeleteReportGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a resource policy that is identified by its resource ARN.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                            .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourcePolicyRequest));
            CompletableFuture<DeleteResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials.
     * </p>
     *
     * @param deleteSourceCredentialsRequest
     * @return A Java Future containing the result of the DeleteSourceCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteSourceCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteSourceCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSourceCredentialsResponse> deleteSourceCredentials(
            DeleteSourceCredentialsRequest deleteSourceCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSourceCredentialsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSourceCredentialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSourceCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSourceCredentialsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSourceCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteSourceCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSourceCredentialsRequest, DeleteSourceCredentialsResponse>()
                            .withOperationName("DeleteSourceCredentials").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSourceCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSourceCredentialsRequest));
            CompletableFuture<DeleteSourceCredentialsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository,
     * stops CodeBuild from rebuilding the source code every time a code change is pushed to the repository.
     * </p>
     *
     * @param deleteWebhookRequest
     * @return A Java Future containing the result of the DeleteWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>OAuthProviderException There was a problem with the underlying OAuth provider.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DeleteWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DeleteWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWebhookResponse> deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWebhookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWebhook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWebhookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteWebhookResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteWebhookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWebhookRequest, DeleteWebhookResponse>()
                            .withOperationName("DeleteWebhook").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWebhookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteWebhookRequest));
            CompletableFuture<DeleteWebhookResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves one or more code coverage reports.
     * </p>
     *
     * @param describeCodeCoveragesRequest
     * @return A Java Future containing the result of the DescribeCodeCoverages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DescribeCodeCoverages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DescribeCodeCoverages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCodeCoveragesResponse> describeCodeCoverages(
            DescribeCodeCoveragesRequest describeCodeCoveragesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCodeCoveragesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCodeCoveragesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCodeCoverages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCodeCoveragesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCodeCoveragesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeCodeCoveragesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCodeCoveragesRequest, DescribeCodeCoveragesResponse>()
                            .withOperationName("DescribeCodeCoverages").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCodeCoveragesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCodeCoveragesRequest));
            CompletableFuture<DescribeCodeCoveragesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of details about test cases for a report.
     * </p>
     *
     * @param describeTestCasesRequest
     * @return A Java Future containing the result of the DescribeTestCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.DescribeTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/DescribeTestCases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTestCasesResponse> describeTestCases(DescribeTestCasesRequest describeTestCasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTestCasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTestCasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTestCases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTestCasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTestCasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeTestCasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTestCasesRequest, DescribeTestCasesResponse>()
                            .withOperationName("DescribeTestCases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTestCasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTestCasesRequest));
            CompletableFuture<DescribeTestCasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Analyzes and accumulates test report values for the specified test reports.
     * </p>
     *
     * @param getReportGroupTrendRequest
     * @return A Java Future containing the result of the GetReportGroupTrend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.GetReportGroupTrend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/GetReportGroupTrend" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReportGroupTrendResponse> getReportGroupTrend(
            GetReportGroupTrendRequest getReportGroupTrendRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReportGroupTrendRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReportGroupTrendRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReportGroupTrend");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetReportGroupTrendResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetReportGroupTrendResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetReportGroupTrendResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReportGroupTrendRequest, GetReportGroupTrendResponse>()
                            .withOperationName("GetReportGroupTrend").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReportGroupTrendRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getReportGroupTrendRequest));
            CompletableFuture<GetReportGroupTrendResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a resource policy that is identified by its resource ARN.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourcePolicyRequest, GetResourcePolicyResponse>()
                            .withOperationName("GetResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourcePolicyRequest));
            CompletableFuture<GetResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports the source repository credentials for an CodeBuild project that has its source code stored in a GitHub,
     * GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket repository.
     * </p>
     *
     * @param importSourceCredentialsRequest
     * @return A Java Future containing the result of the ImportSourceCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>ResourceAlreadyExistsException The specified Amazon Web Services resource cannot be created, because
     *         an Amazon Web Services resource with the same settings already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ImportSourceCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ImportSourceCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ImportSourceCredentialsResponse> importSourceCredentials(
            ImportSourceCredentialsRequest importSourceCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importSourceCredentialsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importSourceCredentialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportSourceCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportSourceCredentialsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ImportSourceCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ImportSourceCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportSourceCredentialsRequest, ImportSourceCredentialsResponse>()
                            .withOperationName("ImportSourceCredentials").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ImportSourceCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(importSourceCredentialsRequest));
            CompletableFuture<ImportSourceCredentialsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resets the cache for a project.
     * </p>
     *
     * @param invalidateProjectCacheRequest
     * @return A Java Future containing the result of the InvalidateProjectCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.InvalidateProjectCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/InvalidateProjectCache"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<InvalidateProjectCacheResponse> invalidateProjectCache(
            InvalidateProjectCacheRequest invalidateProjectCacheRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(invalidateProjectCacheRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, invalidateProjectCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InvalidateProjectCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<InvalidateProjectCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, InvalidateProjectCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<InvalidateProjectCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<InvalidateProjectCacheRequest, InvalidateProjectCacheResponse>()
                            .withOperationName("InvalidateProjectCache").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new InvalidateProjectCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(invalidateProjectCacheRequest));
            CompletableFuture<InvalidateProjectCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the identifiers of your build batches in the current region.
     * </p>
     *
     * @param listBuildBatchesRequest
     * @return A Java Future containing the result of the ListBuildBatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildBatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildBatches" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBuildBatchesResponse> listBuildBatches(ListBuildBatchesRequest listBuildBatchesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBuildBatchesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuildBatchesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuildBatches");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBuildBatchesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBuildBatchesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListBuildBatchesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBuildBatchesRequest, ListBuildBatchesResponse>()
                            .withOperationName("ListBuildBatches").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBuildBatchesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBuildBatchesRequest));
            CompletableFuture<ListBuildBatchesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the identifiers of the build batches for a specific project.
     * </p>
     *
     * @param listBuildBatchesForProjectRequest
     * @return A Java Future containing the result of the ListBuildBatchesForProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildBatchesForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildBatchesForProject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBuildBatchesForProjectResponse> listBuildBatchesForProject(
            ListBuildBatchesForProjectRequest listBuildBatchesForProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBuildBatchesForProjectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuildBatchesForProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuildBatchesForProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBuildBatchesForProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBuildBatchesForProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListBuildBatchesForProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBuildBatchesForProjectRequest, ListBuildBatchesForProjectResponse>()
                            .withOperationName("ListBuildBatchesForProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBuildBatchesForProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBuildBatchesForProjectRequest));
            CompletableFuture<ListBuildBatchesForProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of build IDs, with each build ID representing a single build.
     * </p>
     *
     * @param listBuildsRequest
     * @return A Java Future containing the result of the ListBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListBuildsResponse> listBuilds(ListBuildsRequest listBuildsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBuildsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuildsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuilds");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBuildsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListBuildsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListBuildsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBuildsRequest, ListBuildsResponse>().withOperationName("ListBuilds")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBuildsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBuildsRequest));
            CompletableFuture<ListBuildsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of build identifiers for the specified build project, with each build identifier representing a
     * single build.
     * </p>
     *
     * @param listBuildsForProjectRequest
     * @return A Java Future containing the result of the ListBuildsForProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListBuildsForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListBuildsForProject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBuildsForProjectResponse> listBuildsForProject(
            ListBuildsForProjectRequest listBuildsForProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBuildsForProjectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuildsForProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuildsForProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBuildsForProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBuildsForProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListBuildsForProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBuildsForProjectRequest, ListBuildsForProjectResponse>()
                            .withOperationName("ListBuildsForProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBuildsForProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBuildsForProjectRequest));
            CompletableFuture<ListBuildsForProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of command executions for a sandbox.
     * </p>
     *
     * @param listCommandExecutionsForSandboxRequest
     * @return A Java Future containing the result of the ListCommandExecutionsForSandbox operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListCommandExecutionsForSandbox
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCommandExecutionsForSandbox"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCommandExecutionsForSandboxResponse> listCommandExecutionsForSandbox(
            ListCommandExecutionsForSandboxRequest listCommandExecutionsForSandboxRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCommandExecutionsForSandboxRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCommandExecutionsForSandboxRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCommandExecutionsForSandbox");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCommandExecutionsForSandboxResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCommandExecutionsForSandboxResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListCommandExecutionsForSandboxResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCommandExecutionsForSandboxRequest, ListCommandExecutionsForSandboxResponse>()
                            .withOperationName("ListCommandExecutionsForSandbox").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCommandExecutionsForSandboxRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCommandExecutionsForSandboxRequest));
            CompletableFuture<ListCommandExecutionsForSandboxResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about Docker images that are managed by CodeBuild.
     * </p>
     *
     * @param listCuratedEnvironmentImagesRequest
     * @return A Java Future containing the result of the ListCuratedEnvironmentImages operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListCuratedEnvironmentImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCuratedEnvironmentImagesResponse> listCuratedEnvironmentImages(
            ListCuratedEnvironmentImagesRequest listCuratedEnvironmentImagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCuratedEnvironmentImagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCuratedEnvironmentImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCuratedEnvironmentImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCuratedEnvironmentImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCuratedEnvironmentImagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListCuratedEnvironmentImagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCuratedEnvironmentImagesRequest, ListCuratedEnvironmentImagesResponse>()
                            .withOperationName("ListCuratedEnvironmentImages").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCuratedEnvironmentImagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCuratedEnvironmentImagesRequest));
            CompletableFuture<ListCuratedEnvironmentImagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of compute fleet names with each compute fleet name representing a single compute fleet.
     * </p>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFleetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFleetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListFleetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFleetsRequest, ListFleetsResponse>().withOperationName("ListFleets")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFleetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFleetsRequest));
            CompletableFuture<ListFleetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of build project names, with each build project name representing a single build project.
     * </p>
     *
     * @param listProjectsRequest
     * @return A Java Future containing the result of the ListProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProjectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProjectsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListProjectsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListProjectsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProjectsRequest, ListProjectsResponse>()
                            .withOperationName("ListProjects").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProjectsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listProjectsRequest));
            CompletableFuture<ListProjectsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list ARNs for the report groups in the current Amazon Web Services account.
     * </p>
     *
     * @param listReportGroupsRequest
     * @return A Java Future containing the result of the ListReportGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReportGroupsResponse> listReportGroups(ListReportGroupsRequest listReportGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReportGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReportGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReportGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReportGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReportGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListReportGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReportGroupsRequest, ListReportGroupsResponse>()
                            .withOperationName("ListReportGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReportGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listReportGroupsRequest));
            CompletableFuture<ListReportGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of ARNs for the reports in the current Amazon Web Services account.
     * </p>
     *
     * @param listReportsRequest
     * @return A Java Future containing the result of the ListReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListReportsResponse> listReports(ListReportsRequest listReportsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListReportsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListReportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReportsRequest, ListReportsResponse>()
                            .withOperationName("ListReports").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listReportsRequest));
            CompletableFuture<ListReportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of ARNs for the reports that belong to a <code>ReportGroup</code>.
     * </p>
     *
     * @param listReportsForReportGroupRequest
     * @return A Java Future containing the result of the ListReportsForReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListReportsForReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListReportsForReportGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReportsForReportGroupResponse> listReportsForReportGroup(
            ListReportsForReportGroupRequest listReportsForReportGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReportsForReportGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReportsForReportGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReportsForReportGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReportsForReportGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReportsForReportGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListReportsForReportGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReportsForReportGroupRequest, ListReportsForReportGroupResponse>()
                            .withOperationName("ListReportsForReportGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReportsForReportGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listReportsForReportGroupRequest));
            CompletableFuture<ListReportsForReportGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of sandboxes.
     * </p>
     *
     * @param listSandboxesRequest
     * @return A Java Future containing the result of the ListSandboxes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSandboxes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSandboxes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSandboxesResponse> listSandboxes(ListSandboxesRequest listSandboxesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSandboxesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSandboxesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSandboxes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSandboxesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSandboxesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListSandboxesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSandboxesRequest, ListSandboxesResponse>()
                            .withOperationName("ListSandboxes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSandboxesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSandboxesRequest));
            CompletableFuture<ListSandboxesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of sandboxes for a given project.
     * </p>
     *
     * @param listSandboxesForProjectRequest
     * @return A Java Future containing the result of the ListSandboxesForProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSandboxesForProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSandboxesForProject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSandboxesForProjectResponse> listSandboxesForProject(
            ListSandboxesForProjectRequest listSandboxesForProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSandboxesForProjectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSandboxesForProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSandboxesForProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSandboxesForProjectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSandboxesForProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListSandboxesForProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSandboxesForProjectRequest, ListSandboxesForProjectResponse>()
                            .withOperationName("ListSandboxesForProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSandboxesForProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSandboxesForProjectRequest));
            CompletableFuture<ListSandboxesForProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of projects that are shared with other Amazon Web Services accounts or users.
     * </p>
     *
     * @param listSharedProjectsRequest
     * @return A Java Future containing the result of the ListSharedProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSharedProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedProjects" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSharedProjectsResponse> listSharedProjects(ListSharedProjectsRequest listSharedProjectsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSharedProjectsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSharedProjectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSharedProjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSharedProjectsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSharedProjectsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListSharedProjectsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSharedProjectsRequest, ListSharedProjectsResponse>()
                            .withOperationName("ListSharedProjects").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSharedProjectsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSharedProjectsRequest));
            CompletableFuture<ListSharedProjectsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of report groups that are shared with other Amazon Web Services accounts or users.
     * </p>
     *
     * @param listSharedReportGroupsRequest
     * @return A Java Future containing the result of the ListSharedReportGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSharedReportGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSharedReportGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSharedReportGroupsResponse> listSharedReportGroups(
            ListSharedReportGroupsRequest listSharedReportGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSharedReportGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSharedReportGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSharedReportGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSharedReportGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSharedReportGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListSharedReportGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSharedReportGroupsRequest, ListSharedReportGroupsResponse>()
                            .withOperationName("ListSharedReportGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSharedReportGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSharedReportGroupsRequest));
            CompletableFuture<ListSharedReportGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of <code>SourceCredentialsInfo</code> objects.
     * </p>
     *
     * @param listSourceCredentialsRequest
     * @return A Java Future containing the result of the ListSourceCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.ListSourceCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListSourceCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSourceCredentialsResponse> listSourceCredentials(
            ListSourceCredentialsRequest listSourceCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSourceCredentialsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSourceCredentialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSourceCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSourceCredentialsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSourceCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListSourceCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSourceCredentialsRequest, ListSourceCredentialsResponse>()
                            .withOperationName("ListSourceCredentials").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSourceCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSourceCredentialsRequest));
            CompletableFuture<ListSourceCredentialsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stores a resource policy for the ARN of a <code>Project</code> or <code>ReportGroup</code> object.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                            .withOperationName("PutResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putResourcePolicyRequest));
            CompletableFuture<PutResourcePolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts a build.
     * </p>
     *
     * @param retryBuildRequest
     * @return A Java Future containing the result of the RetryBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.RetryBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/RetryBuild" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RetryBuildResponse> retryBuild(RetryBuildRequest retryBuildRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(retryBuildRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, retryBuildRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RetryBuild");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RetryBuildResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RetryBuildResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RetryBuildResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RetryBuildRequest, RetryBuildResponse>().withOperationName("RetryBuild")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RetryBuildRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(retryBuildRequest));
            CompletableFuture<RetryBuildResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts a failed batch build. Only batch builds that have failed can be retried.
     * </p>
     *
     * @param retryBuildBatchRequest
     * @return A Java Future containing the result of the RetryBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.RetryBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/RetryBuildBatch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RetryBuildBatchResponse> retryBuildBatch(RetryBuildBatchRequest retryBuildBatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(retryBuildBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, retryBuildBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RetryBuildBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RetryBuildBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RetryBuildBatchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RetryBuildBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RetryBuildBatchRequest, RetryBuildBatchResponse>()
                            .withOperationName("RetryBuildBatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RetryBuildBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(retryBuildBatchRequest));
            CompletableFuture<RetryBuildBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts running a build with the settings defined in the project. These setting include: how to run a build, where
     * to get the source code, which build environment to use, which build commands to run, and where to store the build
     * output.
     * </p>
     * <p>
     * You can also start a build run by overriding some of the build settings in the project. The overrides only apply
     * for that specific start build request. The settings in the project are unaltered.
     * </p>
     *
     * @param startBuildRequest
     * @return A Java Future containing the result of the StartBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StartBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuild" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartBuildResponse> startBuild(StartBuildRequest startBuildRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startBuildRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startBuildRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartBuild");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartBuildResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartBuildResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartBuildResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartBuildRequest, StartBuildResponse>().withOperationName("StartBuild")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartBuildRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startBuildRequest));
            CompletableFuture<StartBuildResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a batch build for a project.
     * </p>
     *
     * @param startBuildBatchRequest
     * @return A Java Future containing the result of the StartBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StartBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartBuildBatch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartBuildBatchResponse> startBuildBatch(StartBuildBatchRequest startBuildBatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startBuildBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startBuildBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartBuildBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartBuildBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartBuildBatchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartBuildBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartBuildBatchRequest, StartBuildBatchResponse>()
                            .withOperationName("StartBuildBatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartBuildBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startBuildBatchRequest));
            CompletableFuture<StartBuildBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a command execution.
     * </p>
     *
     * @param startCommandExecutionRequest
     * @return A Java Future containing the result of the StartCommandExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StartCommandExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartCommandExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartCommandExecutionResponse> startCommandExecution(
            StartCommandExecutionRequest startCommandExecutionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startCommandExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startCommandExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCommandExecution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartCommandExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartCommandExecutionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartCommandExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartCommandExecutionRequest, StartCommandExecutionResponse>()
                            .withOperationName("StartCommandExecution").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartCommandExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startCommandExecutionRequest));
            CompletableFuture<StartCommandExecutionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a sandbox.
     * </p>
     *
     * @param startSandboxRequest
     * @return A Java Future containing the result of the StartSandbox operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>AccountSuspendedException The CodeBuild access has been suspended for the calling Amazon Web Services
     *         account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StartSandbox
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartSandbox" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartSandboxResponse> startSandbox(StartSandboxRequest startSandboxRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSandboxRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSandboxRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSandbox");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSandboxResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartSandboxResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartSandboxResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSandboxRequest, StartSandboxResponse>()
                            .withOperationName("StartSandbox").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartSandboxRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startSandboxRequest));
            CompletableFuture<StartSandboxResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a sandbox connection.
     * </p>
     *
     * @param startSandboxConnectionRequest
     * @return A Java Future containing the result of the StartSandboxConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StartSandboxConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StartSandboxConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartSandboxConnectionResponse> startSandboxConnection(
            StartSandboxConnectionRequest startSandboxConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSandboxConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSandboxConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSandboxConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSandboxConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartSandboxConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartSandboxConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSandboxConnectionRequest, StartSandboxConnectionResponse>()
                            .withOperationName("StartSandboxConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartSandboxConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startSandboxConnectionRequest));
            CompletableFuture<StartSandboxConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attempts to stop running a build.
     * </p>
     *
     * @param stopBuildRequest
     * @return A Java Future containing the result of the StopBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StopBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuild" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopBuildResponse> stopBuild(StopBuildRequest stopBuildRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopBuildRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopBuildRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopBuild");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopBuildResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopBuildResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopBuildResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopBuildRequest, StopBuildResponse>().withOperationName("StopBuild")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopBuildRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopBuildRequest));
            CompletableFuture<StopBuildResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a running batch build.
     * </p>
     *
     * @param stopBuildBatchRequest
     * @return A Java Future containing the result of the StopBuildBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StopBuildBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopBuildBatch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopBuildBatchResponse> stopBuildBatch(StopBuildBatchRequest stopBuildBatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopBuildBatchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopBuildBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopBuildBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopBuildBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopBuildBatchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopBuildBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopBuildBatchRequest, StopBuildBatchResponse>()
                            .withOperationName("StopBuildBatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopBuildBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopBuildBatchRequest));
            CompletableFuture<StopBuildBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a sandbox.
     * </p>
     *
     * @param stopSandboxRequest
     * @return A Java Future containing the result of the StopSandbox operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.StopSandbox
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/StopSandbox" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopSandboxResponse> stopSandbox(StopSandboxRequest stopSandboxRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopSandboxRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopSandboxRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopSandbox");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopSandboxResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopSandboxResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopSandboxResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopSandboxRequest, StopSandboxResponse>()
                            .withOperationName("StopSandbox").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopSandboxRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopSandboxRequest));
            CompletableFuture<StopSandboxResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a compute fleet.
     * </p>
     *
     * @param updateFleetRequest
     * @return A Java Future containing the result of the UpdateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>AccountLimitExceededException An Amazon Web Services service limit was exceeded for the calling
     *         Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFleetResponse> updateFleet(UpdateFleetRequest updateFleetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFleet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFleetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateFleetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateFleetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFleetRequest, UpdateFleetResponse>()
                            .withOperationName("UpdateFleet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFleetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFleetRequest));
            CompletableFuture<UpdateFleetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the settings of a build project.
     * </p>
     *
     * @param updateProjectRequest
     * @return A Java Future containing the result of the UpdateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProjectResponse> updateProject(UpdateProjectRequest updateProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProjectRequest, UpdateProjectResponse>()
                            .withOperationName("UpdateProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateProjectRequest));
            CompletableFuture<UpdateProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the public visibility for a project. The project's build results, logs, and artifacts are available to
     * the general public. For more information, see <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/public-builds.html">Public build projects</a> in the
     * <i>CodeBuild User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The following should be kept in mind when making your projects public:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All of a project's build results, logs, and artifacts, including builds that were run when the project was
     * private, are available to the general public.
     * </p>
     * </li>
     * <li>
     * <p>
     * All build logs and artifacts are available to the public. Environment variables, source code, and other sensitive
     * information may have been output to the build logs and artifacts. You must be careful about what information is
     * output to the build logs. Some best practice are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Do not store sensitive values in environment variables. We recommend that you use an Amazon EC2 Systems Manager
     * Parameter Store or Secrets Manager to store sensitive values.
     * </p>
     * </li>
     * <li>
     * <p>
     * Follow <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/webhooks.html#webhook-best-practices">Best
     * practices for using webhooks</a> in the <i>CodeBuild User Guide</i> to limit which entities can trigger a build,
     * and do not store the buildspec in the project itself, to ensure that your webhooks are as secure as possible.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * A malicious user can use public builds to distribute malicious artifacts. We recommend that you review all pull
     * requests to verify that the pull request is a legitimate change. We also recommend that you validate any
     * artifacts with their checksums to make sure that the correct artifacts are being downloaded.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param updateProjectVisibilityRequest
     * @return A Java Future containing the result of the UpdateProjectVisibility operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateProjectVisibility
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateProjectVisibility"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProjectVisibilityResponse> updateProjectVisibility(
            UpdateProjectVisibilityRequest updateProjectVisibilityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProjectVisibilityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProjectVisibilityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProjectVisibility");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProjectVisibilityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProjectVisibilityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateProjectVisibilityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProjectVisibilityRequest, UpdateProjectVisibilityResponse>()
                            .withOperationName("UpdateProjectVisibility").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateProjectVisibilityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateProjectVisibilityRequest));
            CompletableFuture<UpdateProjectVisibilityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a report group.
     * </p>
     *
     * @param updateReportGroupRequest
     * @return A Java Future containing the result of the UpdateReportGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateReportGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateReportGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateReportGroupResponse> updateReportGroup(UpdateReportGroupRequest updateReportGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateReportGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateReportGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateReportGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateReportGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateReportGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateReportGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateReportGroupRequest, UpdateReportGroupResponse>()
                            .withOperationName("UpdateReportGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateReportGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateReportGroupRequest));
            CompletableFuture<UpdateReportGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the webhook associated with an CodeBuild build project.
     * </p>
     * <note>
     * <p>
     * If you use Bitbucket for your repository, <code>rotateSecret</code> is ignored.
     * </p>
     * </note>
     *
     * @param updateWebhookRequest
     * @return A Java Future containing the result of the UpdateWebhook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidInputException The input value that was provided is not valid.</li>
     *         <li>ResourceNotFoundException The specified Amazon Web Services resource cannot be found.</li>
     *         <li>OAuthProviderException There was a problem with the underlying OAuth provider.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeBuildException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeBuildAsyncClient.UpdateWebhook
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateWebhook" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWebhookResponse> updateWebhook(UpdateWebhookRequest updateWebhookRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWebhookRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWebhook");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWebhookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateWebhookResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "OAuthProviderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OAuthProviderException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "AccountSuspendedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                case "AccountLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                case "ResourceAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                case "InvalidInputException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidInputException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateWebhookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWebhookRequest, UpdateWebhookResponse>()
                            .withOperationName("UpdateWebhook").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWebhookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateWebhookRequest));
            CompletableFuture<UpdateWebhookResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final CodeBuildServiceClientConfiguration serviceClientConfiguration() {
        return new CodeBuildServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(CodeBuildException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CodeBuildServiceClientConfigurationBuilder serviceConfigBuilder = new CodeBuildServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
