/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies restrictions for the batch build.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchRestrictions implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchRestrictions.Builder, BatchRestrictions> {
    private static final SdkField<Integer> MAXIMUM_BUILDS_ALLOWED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumBuildsAllowed").getter(getter(BatchRestrictions::maximumBuildsAllowed))
            .setter(setter(Builder::maximumBuildsAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBuildsAllowed").build())
            .build();

    private static final SdkField<List<String>> COMPUTE_TYPES_ALLOWED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("computeTypesAllowed")
            .getter(getter(BatchRestrictions::computeTypesAllowed))
            .setter(setter(Builder::computeTypesAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeTypesAllowed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FLEETS_ALLOWED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("fleetsAllowed")
            .getter(getter(BatchRestrictions::fleetsAllowed))
            .setter(setter(Builder::fleetsAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetsAllowed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_BUILDS_ALLOWED_FIELD,
            COMPUTE_TYPES_ALLOWED_FIELD, FLEETS_ALLOWED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maximumBuildsAllowed;

    private final List<String> computeTypesAllowed;

    private final List<String> fleetsAllowed;

    private BatchRestrictions(BuilderImpl builder) {
        this.maximumBuildsAllowed = builder.maximumBuildsAllowed;
        this.computeTypesAllowed = builder.computeTypesAllowed;
        this.fleetsAllowed = builder.fleetsAllowed;
    }

    /**
     * <p>
     * Specifies the maximum number of builds allowed.
     * </p>
     * 
     * @return Specifies the maximum number of builds allowed.
     */
    public final Integer maximumBuildsAllowed() {
        return maximumBuildsAllowed;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputeTypesAllowed property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComputeTypesAllowed() {
        return computeTypesAllowed != null && !(computeTypesAllowed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that specify the compute types that are allowed for the batch build. See <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment
     * compute types</a> in the <i>CodeBuild User Guide</i> for these values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeTypesAllowed} method.
     * </p>
     * 
     * @return An array of strings that specify the compute types that are allowed for the batch build. See <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
     *         environment compute types</a> in the <i>CodeBuild User Guide</i> for these values.
     */
    public final List<String> computeTypesAllowed() {
        return computeTypesAllowed;
    }

    /**
     * For responses, this returns true if the service returned a value for the FleetsAllowed property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFleetsAllowed() {
        return fleetsAllowed != null && !(fleetsAllowed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that specify the fleets that are allowed for the batch build. See <a
     * href="https://docs.aws.amazon.com/codebuild/latest/userguide/fleets.html">Run builds on reserved capacity
     * fleets</a> in the <i>CodeBuild User Guide</i> for more information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleetsAllowed} method.
     * </p>
     * 
     * @return An array of strings that specify the fleets that are allowed for the batch build. See <a
     *         href="https://docs.aws.amazon.com/codebuild/latest/userguide/fleets.html">Run builds on reserved capacity
     *         fleets</a> in the <i>CodeBuild User Guide</i> for more information.
     */
    public final List<String> fleetsAllowed() {
        return fleetsAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumBuildsAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(hasComputeTypesAllowed() ? computeTypesAllowed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetsAllowed() ? fleetsAllowed() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRestrictions)) {
            return false;
        }
        BatchRestrictions other = (BatchRestrictions) obj;
        return Objects.equals(maximumBuildsAllowed(), other.maximumBuildsAllowed())
                && hasComputeTypesAllowed() == other.hasComputeTypesAllowed()
                && Objects.equals(computeTypesAllowed(), other.computeTypesAllowed())
                && hasFleetsAllowed() == other.hasFleetsAllowed() && Objects.equals(fleetsAllowed(), other.fleetsAllowed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchRestrictions").add("MaximumBuildsAllowed", maximumBuildsAllowed())
                .add("ComputeTypesAllowed", hasComputeTypesAllowed() ? computeTypesAllowed() : null)
                .add("FleetsAllowed", hasFleetsAllowed() ? fleetsAllowed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maximumBuildsAllowed":
            return Optional.ofNullable(clazz.cast(maximumBuildsAllowed()));
        case "computeTypesAllowed":
            return Optional.ofNullable(clazz.cast(computeTypesAllowed()));
        case "fleetsAllowed":
            return Optional.ofNullable(clazz.cast(fleetsAllowed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maximumBuildsAllowed", MAXIMUM_BUILDS_ALLOWED_FIELD);
        map.put("computeTypesAllowed", COMPUTE_TYPES_ALLOWED_FIELD);
        map.put("fleetsAllowed", FLEETS_ALLOWED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchRestrictions, T> g) {
        return obj -> g.apply((BatchRestrictions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchRestrictions> {
        /**
         * <p>
         * Specifies the maximum number of builds allowed.
         * </p>
         * 
         * @param maximumBuildsAllowed
         *        Specifies the maximum number of builds allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBuildsAllowed(Integer maximumBuildsAllowed);

        /**
         * <p>
         * An array of strings that specify the compute types that are allowed for the batch build. See <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         * environment compute types</a> in the <i>CodeBuild User Guide</i> for these values.
         * </p>
         * 
         * @param computeTypesAllowed
         *        An array of strings that specify the compute types that are allowed for the batch build. See <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         *        environment compute types</a> in the <i>CodeBuild User Guide</i> for these values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTypesAllowed(Collection<String> computeTypesAllowed);

        /**
         * <p>
         * An array of strings that specify the compute types that are allowed for the batch build. See <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         * environment compute types</a> in the <i>CodeBuild User Guide</i> for these values.
         * </p>
         * 
         * @param computeTypesAllowed
         *        An array of strings that specify the compute types that are allowed for the batch build. See <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build
         *        environment compute types</a> in the <i>CodeBuild User Guide</i> for these values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTypesAllowed(String... computeTypesAllowed);

        /**
         * <p>
         * An array of strings that specify the fleets that are allowed for the batch build. See <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/fleets.html">Run builds on reserved capacity
         * fleets</a> in the <i>CodeBuild User Guide</i> for more information.
         * </p>
         * 
         * @param fleetsAllowed
         *        An array of strings that specify the fleets that are allowed for the batch build. See <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/fleets.html">Run builds on reserved
         *        capacity fleets</a> in the <i>CodeBuild User Guide</i> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetsAllowed(Collection<String> fleetsAllowed);

        /**
         * <p>
         * An array of strings that specify the fleets that are allowed for the batch build. See <a
         * href="https://docs.aws.amazon.com/codebuild/latest/userguide/fleets.html">Run builds on reserved capacity
         * fleets</a> in the <i>CodeBuild User Guide</i> for more information.
         * </p>
         * 
         * @param fleetsAllowed
         *        An array of strings that specify the fleets that are allowed for the batch build. See <a
         *        href="https://docs.aws.amazon.com/codebuild/latest/userguide/fleets.html">Run builds on reserved
         *        capacity fleets</a> in the <i>CodeBuild User Guide</i> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetsAllowed(String... fleetsAllowed);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumBuildsAllowed;

        private List<String> computeTypesAllowed = DefaultSdkAutoConstructList.getInstance();

        private List<String> fleetsAllowed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRestrictions model) {
            maximumBuildsAllowed(model.maximumBuildsAllowed);
            computeTypesAllowed(model.computeTypesAllowed);
            fleetsAllowed(model.fleetsAllowed);
        }

        public final Integer getMaximumBuildsAllowed() {
            return maximumBuildsAllowed;
        }

        public final void setMaximumBuildsAllowed(Integer maximumBuildsAllowed) {
            this.maximumBuildsAllowed = maximumBuildsAllowed;
        }

        @Override
        public final Builder maximumBuildsAllowed(Integer maximumBuildsAllowed) {
            this.maximumBuildsAllowed = maximumBuildsAllowed;
            return this;
        }

        public final Collection<String> getComputeTypesAllowed() {
            if (computeTypesAllowed instanceof SdkAutoConstructList) {
                return null;
            }
            return computeTypesAllowed;
        }

        public final void setComputeTypesAllowed(Collection<String> computeTypesAllowed) {
            this.computeTypesAllowed = ComputeTypesAllowedCopier.copy(computeTypesAllowed);
        }

        @Override
        public final Builder computeTypesAllowed(Collection<String> computeTypesAllowed) {
            this.computeTypesAllowed = ComputeTypesAllowedCopier.copy(computeTypesAllowed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeTypesAllowed(String... computeTypesAllowed) {
            computeTypesAllowed(Arrays.asList(computeTypesAllowed));
            return this;
        }

        public final Collection<String> getFleetsAllowed() {
            if (fleetsAllowed instanceof SdkAutoConstructList) {
                return null;
            }
            return fleetsAllowed;
        }

        public final void setFleetsAllowed(Collection<String> fleetsAllowed) {
            this.fleetsAllowed = FleetsAllowedCopier.copy(fleetsAllowed);
        }

        @Override
        public final Builder fleetsAllowed(Collection<String> fleetsAllowed) {
            this.fleetsAllowed = FleetsAllowedCopier.copy(fleetsAllowed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetsAllowed(String... fleetsAllowed) {
            fleetsAllowed(Arrays.asList(fleetsAllowed));
            return this;
        }

        @Override
        public BatchRestrictions build() {
            return new BatchRestrictions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
