/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about build output artifacts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BuildArtifacts implements SdkPojo, Serializable, ToCopyableBuilder<BuildArtifacts.Builder, BuildArtifacts> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(BuildArtifacts::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> SHA256_SUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sha256sum").getter(getter(BuildArtifacts::sha256sum)).setter(setter(Builder::sha256sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sha256sum").build()).build();

    private static final SdkField<String> MD5_SUM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("md5sum")
            .getter(getter(BuildArtifacts::md5sum)).setter(setter(Builder::md5sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("md5sum").build()).build();

    private static final SdkField<Boolean> OVERRIDE_ARTIFACT_NAME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("overrideArtifactName").getter(getter(BuildArtifacts::overrideArtifactName))
            .setter(setter(Builder::overrideArtifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideArtifactName").build())
            .build();

    private static final SdkField<Boolean> ENCRYPTION_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("encryptionDisabled").getter(getter(BuildArtifacts::encryptionDisabled))
            .setter(setter(Builder::encryptionDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionDisabled").build())
            .build();

    private static final SdkField<String> ARTIFACT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("artifactIdentifier").getter(getter(BuildArtifacts::artifactIdentifier))
            .setter(setter(Builder::artifactIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactIdentifier").build())
            .build();

    private static final SdkField<String> BUCKET_OWNER_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketOwnerAccess").getter(getter(BuildArtifacts::bucketOwnerAccessAsString))
            .setter(setter(Builder::bucketOwnerAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketOwnerAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD,
            SHA256_SUM_FIELD, MD5_SUM_FIELD, OVERRIDE_ARTIFACT_NAME_FIELD, ENCRYPTION_DISABLED_FIELD, ARTIFACT_IDENTIFIER_FIELD,
            BUCKET_OWNER_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String location;

    private final String sha256sum;

    private final String md5sum;

    private final Boolean overrideArtifactName;

    private final Boolean encryptionDisabled;

    private final String artifactIdentifier;

    private final String bucketOwnerAccess;

    private BuildArtifacts(BuilderImpl builder) {
        this.location = builder.location;
        this.sha256sum = builder.sha256sum;
        this.md5sum = builder.md5sum;
        this.overrideArtifactName = builder.overrideArtifactName;
        this.encryptionDisabled = builder.encryptionDisabled;
        this.artifactIdentifier = builder.artifactIdentifier;
        this.bucketOwnerAccess = builder.bucketOwnerAccess;
    }

    /**
     * <p>
     * Information about the location of the build artifacts.
     * </p>
     * 
     * @return Information about the location of the build artifacts.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The SHA-256 hash of the build artifact.
     * </p>
     * <p>
     * You can use this hash along with a checksum tool to confirm file integrity and authenticity.
     * </p>
     * <note>
     * <p>
     * This value is available only if the build project's <code>packaging</code> value is set to <code>ZIP</code>.
     * </p>
     * </note>
     * 
     * @return The SHA-256 hash of the build artifact.</p>
     *         <p>
     *         You can use this hash along with a checksum tool to confirm file integrity and authenticity.
     *         </p>
     *         <note>
     *         <p>
     *         This value is available only if the build project's <code>packaging</code> value is set to
     *         <code>ZIP</code>.
     *         </p>
     */
    public final String sha256sum() {
        return sha256sum;
    }

    /**
     * <p>
     * The MD5 hash of the build artifact.
     * </p>
     * <p>
     * You can use this hash along with a checksum tool to confirm file integrity and authenticity.
     * </p>
     * <note>
     * <p>
     * This value is available only if the build project's <code>packaging</code> value is set to <code>ZIP</code>.
     * </p>
     * </note>
     * 
     * @return The MD5 hash of the build artifact.</p>
     *         <p>
     *         You can use this hash along with a checksum tool to confirm file integrity and authenticity.
     *         </p>
     *         <note>
     *         <p>
     *         This value is available only if the build project's <code>packaging</code> value is set to
     *         <code>ZIP</code>.
     *         </p>
     */
    public final String md5sum() {
        return md5sum;
    }

    /**
     * <p>
     * If this flag is set, a name specified in the buildspec file overrides the artifact name. The name specified in a
     * buildspec file is calculated at build time and uses the Shell Command Language. For example, you can append a
     * date and time to your artifact name so that it is always unique.
     * </p>
     * 
     * @return If this flag is set, a name specified in the buildspec file overrides the artifact name. The name
     *         specified in a buildspec file is calculated at build time and uses the Shell Command Language. For
     *         example, you can append a date and time to your artifact name so that it is always unique.
     */
    public final Boolean overrideArtifactName() {
        return overrideArtifactName;
    }

    /**
     * <p>
     * Information that tells you if encryption for build artifacts is disabled.
     * </p>
     * 
     * @return Information that tells you if encryption for build artifacts is disabled.
     */
    public final Boolean encryptionDisabled() {
        return encryptionDisabled;
    }

    /**
     * <p>
     * An identifier for this artifact definition.
     * </p>
     * 
     * @return An identifier for this artifact definition.
     */
    public final String artifactIdentifier() {
        return artifactIdentifier;
    }

    /**
     * Returns the value of the BucketOwnerAccess property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bucketOwnerAccess}
     * will return {@link BucketOwnerAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bucketOwnerAccessAsString}.
     * </p>
     * 
     * @return The value of the BucketOwnerAccess property for this object.
     * @see BucketOwnerAccess
     */
    public final BucketOwnerAccess bucketOwnerAccess() {
        return BucketOwnerAccess.fromValue(bucketOwnerAccess);
    }

    /**
     * Returns the value of the BucketOwnerAccess property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bucketOwnerAccess}
     * will return {@link BucketOwnerAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bucketOwnerAccessAsString}.
     * </p>
     * 
     * @return The value of the BucketOwnerAccess property for this object.
     * @see BucketOwnerAccess
     */
    public final String bucketOwnerAccessAsString() {
        return bucketOwnerAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(sha256sum());
        hashCode = 31 * hashCode + Objects.hashCode(md5sum());
        hashCode = 31 * hashCode + Objects.hashCode(overrideArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(artifactIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(bucketOwnerAccessAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildArtifacts)) {
            return false;
        }
        BuildArtifacts other = (BuildArtifacts) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(sha256sum(), other.sha256sum())
                && Objects.equals(md5sum(), other.md5sum())
                && Objects.equals(overrideArtifactName(), other.overrideArtifactName())
                && Objects.equals(encryptionDisabled(), other.encryptionDisabled())
                && Objects.equals(artifactIdentifier(), other.artifactIdentifier())
                && Objects.equals(bucketOwnerAccessAsString(), other.bucketOwnerAccessAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BuildArtifacts").add("Location", location()).add("Sha256sum", sha256sum())
                .add("Md5sum", md5sum()).add("OverrideArtifactName", overrideArtifactName())
                .add("EncryptionDisabled", encryptionDisabled()).add("ArtifactIdentifier", artifactIdentifier())
                .add("BucketOwnerAccess", bucketOwnerAccessAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "sha256sum":
            return Optional.ofNullable(clazz.cast(sha256sum()));
        case "md5sum":
            return Optional.ofNullable(clazz.cast(md5sum()));
        case "overrideArtifactName":
            return Optional.ofNullable(clazz.cast(overrideArtifactName()));
        case "encryptionDisabled":
            return Optional.ofNullable(clazz.cast(encryptionDisabled()));
        case "artifactIdentifier":
            return Optional.ofNullable(clazz.cast(artifactIdentifier()));
        case "bucketOwnerAccess":
            return Optional.ofNullable(clazz.cast(bucketOwnerAccessAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("location", LOCATION_FIELD);
        map.put("sha256sum", SHA256_SUM_FIELD);
        map.put("md5sum", MD5_SUM_FIELD);
        map.put("overrideArtifactName", OVERRIDE_ARTIFACT_NAME_FIELD);
        map.put("encryptionDisabled", ENCRYPTION_DISABLED_FIELD);
        map.put("artifactIdentifier", ARTIFACT_IDENTIFIER_FIELD);
        map.put("bucketOwnerAccess", BUCKET_OWNER_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BuildArtifacts, T> g) {
        return obj -> g.apply((BuildArtifacts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BuildArtifacts> {
        /**
         * <p>
         * Information about the location of the build artifacts.
         * </p>
         * 
         * @param location
         *        Information about the location of the build artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The SHA-256 hash of the build artifact.
         * </p>
         * <p>
         * You can use this hash along with a checksum tool to confirm file integrity and authenticity.
         * </p>
         * <note>
         * <p>
         * This value is available only if the build project's <code>packaging</code> value is set to <code>ZIP</code>.
         * </p>
         * </note>
         * 
         * @param sha256sum
         *        The SHA-256 hash of the build artifact.</p>
         *        <p>
         *        You can use this hash along with a checksum tool to confirm file integrity and authenticity.
         *        </p>
         *        <note>
         *        <p>
         *        This value is available only if the build project's <code>packaging</code> value is set to
         *        <code>ZIP</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sha256sum(String sha256sum);

        /**
         * <p>
         * The MD5 hash of the build artifact.
         * </p>
         * <p>
         * You can use this hash along with a checksum tool to confirm file integrity and authenticity.
         * </p>
         * <note>
         * <p>
         * This value is available only if the build project's <code>packaging</code> value is set to <code>ZIP</code>.
         * </p>
         * </note>
         * 
         * @param md5sum
         *        The MD5 hash of the build artifact.</p>
         *        <p>
         *        You can use this hash along with a checksum tool to confirm file integrity and authenticity.
         *        </p>
         *        <note>
         *        <p>
         *        This value is available only if the build project's <code>packaging</code> value is set to
         *        <code>ZIP</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5sum(String md5sum);

        /**
         * <p>
         * If this flag is set, a name specified in the buildspec file overrides the artifact name. The name specified
         * in a buildspec file is calculated at build time and uses the Shell Command Language. For example, you can
         * append a date and time to your artifact name so that it is always unique.
         * </p>
         * 
         * @param overrideArtifactName
         *        If this flag is set, a name specified in the buildspec file overrides the artifact name. The name
         *        specified in a buildspec file is calculated at build time and uses the Shell Command Language. For
         *        example, you can append a date and time to your artifact name so that it is always unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideArtifactName(Boolean overrideArtifactName);

        /**
         * <p>
         * Information that tells you if encryption for build artifacts is disabled.
         * </p>
         * 
         * @param encryptionDisabled
         *        Information that tells you if encryption for build artifacts is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionDisabled(Boolean encryptionDisabled);

        /**
         * <p>
         * An identifier for this artifact definition.
         * </p>
         * 
         * @param artifactIdentifier
         *        An identifier for this artifact definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactIdentifier(String artifactIdentifier);

        /**
         * Sets the value of the BucketOwnerAccess property for this object.
         *
         * @param bucketOwnerAccess
         *        The new value for the BucketOwnerAccess property for this object.
         * @see BucketOwnerAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketOwnerAccess
         */
        Builder bucketOwnerAccess(String bucketOwnerAccess);

        /**
         * Sets the value of the BucketOwnerAccess property for this object.
         *
         * @param bucketOwnerAccess
         *        The new value for the BucketOwnerAccess property for this object.
         * @see BucketOwnerAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketOwnerAccess
         */
        Builder bucketOwnerAccess(BucketOwnerAccess bucketOwnerAccess);
    }

    static final class BuilderImpl implements Builder {
        private String location;

        private String sha256sum;

        private String md5sum;

        private Boolean overrideArtifactName;

        private Boolean encryptionDisabled;

        private String artifactIdentifier;

        private String bucketOwnerAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildArtifacts model) {
            location(model.location);
            sha256sum(model.sha256sum);
            md5sum(model.md5sum);
            overrideArtifactName(model.overrideArtifactName);
            encryptionDisabled(model.encryptionDisabled);
            artifactIdentifier(model.artifactIdentifier);
            bucketOwnerAccess(model.bucketOwnerAccess);
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getSha256sum() {
            return sha256sum;
        }

        public final void setSha256sum(String sha256sum) {
            this.sha256sum = sha256sum;
        }

        @Override
        public final Builder sha256sum(String sha256sum) {
            this.sha256sum = sha256sum;
            return this;
        }

        public final String getMd5sum() {
            return md5sum;
        }

        public final void setMd5sum(String md5sum) {
            this.md5sum = md5sum;
        }

        @Override
        public final Builder md5sum(String md5sum) {
            this.md5sum = md5sum;
            return this;
        }

        public final Boolean getOverrideArtifactName() {
            return overrideArtifactName;
        }

        public final void setOverrideArtifactName(Boolean overrideArtifactName) {
            this.overrideArtifactName = overrideArtifactName;
        }

        @Override
        public final Builder overrideArtifactName(Boolean overrideArtifactName) {
            this.overrideArtifactName = overrideArtifactName;
            return this;
        }

        public final Boolean getEncryptionDisabled() {
            return encryptionDisabled;
        }

        public final void setEncryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
        }

        @Override
        public final Builder encryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
            return this;
        }

        public final String getArtifactIdentifier() {
            return artifactIdentifier;
        }

        public final void setArtifactIdentifier(String artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
        }

        @Override
        public final Builder artifactIdentifier(String artifactIdentifier) {
            this.artifactIdentifier = artifactIdentifier;
            return this;
        }

        public final String getBucketOwnerAccess() {
            return bucketOwnerAccess;
        }

        public final void setBucketOwnerAccess(String bucketOwnerAccess) {
            this.bucketOwnerAccess = bucketOwnerAccess;
        }

        @Override
        public final Builder bucketOwnerAccess(String bucketOwnerAccess) {
            this.bucketOwnerAccess = bucketOwnerAccess;
            return this;
        }

        @Override
        public final Builder bucketOwnerAccess(BucketOwnerAccess bucketOwnerAccess) {
            this.bucketOwnerAccess(bucketOwnerAccess == null ? null : bucketOwnerAccess.toString());
            return this;
        }

        @Override
        public BuildArtifacts build() {
            return new BuildArtifacts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
