/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCommandExecutionRequest extends CodeBuildRequest implements
        ToCopyableBuilder<StartCommandExecutionRequest.Builder, StartCommandExecutionRequest> {
    private static final SdkField<String> SANDBOX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sandboxId").getter(getter(StartCommandExecutionRequest::sandboxId)).setter(setter(Builder::sandboxId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxId").build()).build();

    private static final SdkField<String> COMMAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("command")
            .getter(getter(StartCommandExecutionRequest::command)).setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(StartCommandExecutionRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SANDBOX_ID_FIELD,
            COMMAND_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sandboxId;

    private final String command;

    private final String type;

    private StartCommandExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.sandboxId = builder.sandboxId;
        this.command = builder.command;
        this.type = builder.type;
    }

    /**
     * <p>
     * A <code>sandboxId</code> or <code>sandboxArn</code>.
     * </p>
     * 
     * @return A <code>sandboxId</code> or <code>sandboxArn</code>.
     */
    public final String sandboxId() {
        return sandboxId;
    }

    /**
     * <p>
     * The command that needs to be executed.
     * </p>
     * 
     * @return The command that needs to be executed.
     */
    public final String command() {
        return command;
    }

    /**
     * <p>
     * The command type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CommandType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The command type.
     * @see CommandType
     */
    public final CommandType type() {
        return CommandType.fromValue(type);
    }

    /**
     * <p>
     * The command type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CommandType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The command type.
     * @see CommandType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sandboxId());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCommandExecutionRequest)) {
            return false;
        }
        StartCommandExecutionRequest other = (StartCommandExecutionRequest) obj;
        return Objects.equals(sandboxId(), other.sandboxId()) && Objects.equals(command(), other.command())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCommandExecutionRequest").add("SandboxId", sandboxId())
                .add("Command", command() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sandboxId":
            return Optional.ofNullable(clazz.cast(sandboxId()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sandboxId", SANDBOX_ID_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCommandExecutionRequest, T> g) {
        return obj -> g.apply((StartCommandExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartCommandExecutionRequest> {
        /**
         * <p>
         * A <code>sandboxId</code> or <code>sandboxArn</code>.
         * </p>
         * 
         * @param sandboxId
         *        A <code>sandboxId</code> or <code>sandboxArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sandboxId(String sandboxId);

        /**
         * <p>
         * The command that needs to be executed.
         * </p>
         * 
         * @param command
         *        The command that needs to be executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String command);

        /**
         * <p>
         * The command type.
         * </p>
         * 
         * @param type
         *        The command type.
         * @see CommandType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandType
         */
        Builder type(String type);

        /**
         * <p>
         * The command type.
         * </p>
         * 
         * @param type
         *        The command type.
         * @see CommandType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandType
         */
        Builder type(CommandType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String sandboxId;

        private String command;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCommandExecutionRequest model) {
            super(model);
            sandboxId(model.sandboxId);
            command(model.command);
            type(model.type);
        }

        public final String getSandboxId() {
            return sandboxId;
        }

        public final void setSandboxId(String sandboxId) {
            this.sandboxId = sandboxId;
        }

        @Override
        public final Builder sandboxId(String sandboxId) {
            this.sandboxId = sandboxId;
            return this;
        }

        public final String getCommand() {
            return command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CommandType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCommandExecutionRequest build() {
            return new StartCommandExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
