/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCommandExecutionsResponse extends CodeBuildResponse implements
        ToCopyableBuilder<BatchGetCommandExecutionsResponse.Builder, BatchGetCommandExecutionsResponse> {
    private static final SdkField<List<CommandExecution>> COMMAND_EXECUTIONS_FIELD = SdkField
            .<List<CommandExecution>> builder(MarshallingType.LIST)
            .memberName("commandExecutions")
            .getter(getter(BatchGetCommandExecutionsResponse::commandExecutions))
            .setter(setter(Builder::commandExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommandExecution> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommandExecution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> COMMAND_EXECUTIONS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("commandExecutionsNotFound")
            .getter(getter(BatchGetCommandExecutionsResponse::commandExecutionsNotFound))
            .setter(setter(Builder::commandExecutionsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandExecutionsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_EXECUTIONS_FIELD,
            COMMAND_EXECUTIONS_NOT_FOUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CommandExecution> commandExecutions;

    private final List<String> commandExecutionsNotFound;

    private BatchGetCommandExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.commandExecutions = builder.commandExecutions;
        this.commandExecutionsNotFound = builder.commandExecutionsNotFound;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommandExecutions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCommandExecutions() {
        return commandExecutions != null && !(commandExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the requested command executions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommandExecutions} method.
     * </p>
     * 
     * @return Information about the requested command executions.
     */
    public final List<CommandExecution> commandExecutions() {
        return commandExecutions;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommandExecutionsNotFound property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCommandExecutionsNotFound() {
        return commandExecutionsNotFound != null && !(commandExecutionsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of command executions for which information could not be found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommandExecutionsNotFound} method.
     * </p>
     * 
     * @return The IDs of command executions for which information could not be found.
     */
    public final List<String> commandExecutionsNotFound() {
        return commandExecutionsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCommandExecutions() ? commandExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCommandExecutionsNotFound() ? commandExecutionsNotFound() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCommandExecutionsResponse)) {
            return false;
        }
        BatchGetCommandExecutionsResponse other = (BatchGetCommandExecutionsResponse) obj;
        return hasCommandExecutions() == other.hasCommandExecutions()
                && Objects.equals(commandExecutions(), other.commandExecutions())
                && hasCommandExecutionsNotFound() == other.hasCommandExecutionsNotFound()
                && Objects.equals(commandExecutionsNotFound(), other.commandExecutionsNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCommandExecutionsResponse")
                .add("CommandExecutions", hasCommandExecutions() ? commandExecutions() : null)
                .add("CommandExecutionsNotFound", hasCommandExecutionsNotFound() ? commandExecutionsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commandExecutions":
            return Optional.ofNullable(clazz.cast(commandExecutions()));
        case "commandExecutionsNotFound":
            return Optional.ofNullable(clazz.cast(commandExecutionsNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commandExecutions", COMMAND_EXECUTIONS_FIELD);
        map.put("commandExecutionsNotFound", COMMAND_EXECUTIONS_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCommandExecutionsResponse, T> g) {
        return obj -> g.apply((BatchGetCommandExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeBuildResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetCommandExecutionsResponse> {
        /**
         * <p>
         * Information about the requested command executions.
         * </p>
         * 
         * @param commandExecutions
         *        Information about the requested command executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandExecutions(Collection<CommandExecution> commandExecutions);

        /**
         * <p>
         * Information about the requested command executions.
         * </p>
         * 
         * @param commandExecutions
         *        Information about the requested command executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandExecutions(CommandExecution... commandExecutions);

        /**
         * <p>
         * Information about the requested command executions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.CommandExecution.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codebuild.model.CommandExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.CommandExecution.Builder#build()} is called
         * immediately and its result is passed to {@link #commandExecutions(List<CommandExecution>)}.
         * 
         * @param commandExecutions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.CommandExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commandExecutions(java.util.Collection<CommandExecution>)
         */
        Builder commandExecutions(Consumer<CommandExecution.Builder>... commandExecutions);

        /**
         * <p>
         * The IDs of command executions for which information could not be found.
         * </p>
         * 
         * @param commandExecutionsNotFound
         *        The IDs of command executions for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandExecutionsNotFound(Collection<String> commandExecutionsNotFound);

        /**
         * <p>
         * The IDs of command executions for which information could not be found.
         * </p>
         * 
         * @param commandExecutionsNotFound
         *        The IDs of command executions for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandExecutionsNotFound(String... commandExecutionsNotFound);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private List<CommandExecution> commandExecutions = DefaultSdkAutoConstructList.getInstance();

        private List<String> commandExecutionsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCommandExecutionsResponse model) {
            super(model);
            commandExecutions(model.commandExecutions);
            commandExecutionsNotFound(model.commandExecutionsNotFound);
        }

        public final List<CommandExecution.Builder> getCommandExecutions() {
            List<CommandExecution.Builder> result = CommandExecutionsCopier.copyToBuilder(this.commandExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommandExecutions(Collection<CommandExecution.BuilderImpl> commandExecutions) {
            this.commandExecutions = CommandExecutionsCopier.copyFromBuilder(commandExecutions);
        }

        @Override
        public final Builder commandExecutions(Collection<CommandExecution> commandExecutions) {
            this.commandExecutions = CommandExecutionsCopier.copy(commandExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandExecutions(CommandExecution... commandExecutions) {
            commandExecutions(Arrays.asList(commandExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandExecutions(Consumer<CommandExecution.Builder>... commandExecutions) {
            commandExecutions(Stream.of(commandExecutions).map(c -> CommandExecution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCommandExecutionsNotFound() {
            if (commandExecutionsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return commandExecutionsNotFound;
        }

        public final void setCommandExecutionsNotFound(Collection<String> commandExecutionsNotFound) {
            this.commandExecutionsNotFound = CommandExecutionIdsCopier.copy(commandExecutionsNotFound);
        }

        @Override
        public final Builder commandExecutionsNotFound(Collection<String> commandExecutionsNotFound) {
            this.commandExecutionsNotFound = CommandExecutionIdsCopier.copy(commandExecutionsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandExecutionsNotFound(String... commandExecutionsNotFound) {
            commandExecutionsNotFound(Arrays.asList(commandExecutionsNotFound));
            return this;
        }

        @Override
        public BatchGetCommandExecutionsResponse build() {
            return new BatchGetCommandExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
