/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains code coverage report information.
 * </p>
 * <p>
 * Line coverage measures how many statements your tests cover. A statement is a single instruction, not including
 * comments, conditionals, etc.
 * </p>
 * <p>
 * Branch coverage determines if your tests cover every possible branch of a control structure, such as an
 * <code>if</code> or <code>case</code> statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeCoverage implements SdkPojo, Serializable, ToCopyableBuilder<CodeCoverage.Builder, CodeCoverage> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CodeCoverage::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> REPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportARN").getter(getter(CodeCoverage::reportARN)).setter(setter(Builder::reportARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportARN").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(CodeCoverage::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<Double> LINE_COVERAGE_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("lineCoveragePercentage").getter(getter(CodeCoverage::lineCoveragePercentage))
            .setter(setter(Builder::lineCoveragePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineCoveragePercentage").build())
            .build();

    private static final SdkField<Integer> LINES_COVERED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("linesCovered").getter(getter(CodeCoverage::linesCovered)).setter(setter(Builder::linesCovered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linesCovered").build()).build();

    private static final SdkField<Integer> LINES_MISSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("linesMissed").getter(getter(CodeCoverage::linesMissed)).setter(setter(Builder::linesMissed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linesMissed").build()).build();

    private static final SdkField<Double> BRANCH_COVERAGE_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("branchCoveragePercentage").getter(getter(CodeCoverage::branchCoveragePercentage))
            .setter(setter(Builder::branchCoveragePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchCoveragePercentage").build())
            .build();

    private static final SdkField<Integer> BRANCHES_COVERED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("branchesCovered").getter(getter(CodeCoverage::branchesCovered)).setter(setter(Builder::branchesCovered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchesCovered").build()).build();

    private static final SdkField<Integer> BRANCHES_MISSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("branchesMissed").getter(getter(CodeCoverage::branchesMissed)).setter(setter(Builder::branchesMissed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchesMissed").build()).build();

    private static final SdkField<Instant> EXPIRED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expired").getter(getter(CodeCoverage::expired)).setter(setter(Builder::expired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expired").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REPORT_ARN_FIELD,
            FILE_PATH_FIELD, LINE_COVERAGE_PERCENTAGE_FIELD, LINES_COVERED_FIELD, LINES_MISSED_FIELD,
            BRANCH_COVERAGE_PERCENTAGE_FIELD, BRANCHES_COVERED_FIELD, BRANCHES_MISSED_FIELD, EXPIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String reportARN;

    private final String filePath;

    private final Double lineCoveragePercentage;

    private final Integer linesCovered;

    private final Integer linesMissed;

    private final Double branchCoveragePercentage;

    private final Integer branchesCovered;

    private final Integer branchesMissed;

    private final Instant expired;

    private CodeCoverage(BuilderImpl builder) {
        this.id = builder.id;
        this.reportARN = builder.reportARN;
        this.filePath = builder.filePath;
        this.lineCoveragePercentage = builder.lineCoveragePercentage;
        this.linesCovered = builder.linesCovered;
        this.linesMissed = builder.linesMissed;
        this.branchCoveragePercentage = builder.branchCoveragePercentage;
        this.branchesCovered = builder.branchesCovered;
        this.branchesMissed = builder.branchesMissed;
        this.expired = builder.expired;
    }

    /**
     * <p>
     * The identifier of the code coverage report.
     * </p>
     * 
     * @return The identifier of the code coverage report.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the report.
     * </p>
     * 
     * @return The ARN of the report.
     */
    public final String reportARN() {
        return reportARN;
    }

    /**
     * <p>
     * The path of the test report file.
     * </p>
     * 
     * @return The path of the test report file.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The percentage of lines that are covered by your tests.
     * </p>
     * 
     * @return The percentage of lines that are covered by your tests.
     */
    public final Double lineCoveragePercentage() {
        return lineCoveragePercentage;
    }

    /**
     * <p>
     * The number of lines that are covered by your tests.
     * </p>
     * 
     * @return The number of lines that are covered by your tests.
     */
    public final Integer linesCovered() {
        return linesCovered;
    }

    /**
     * <p>
     * The number of lines that are not covered by your tests.
     * </p>
     * 
     * @return The number of lines that are not covered by your tests.
     */
    public final Integer linesMissed() {
        return linesMissed;
    }

    /**
     * <p>
     * The percentage of branches that are covered by your tests.
     * </p>
     * 
     * @return The percentage of branches that are covered by your tests.
     */
    public final Double branchCoveragePercentage() {
        return branchCoveragePercentage;
    }

    /**
     * <p>
     * The number of conditional branches that are covered by your tests.
     * </p>
     * 
     * @return The number of conditional branches that are covered by your tests.
     */
    public final Integer branchesCovered() {
        return branchesCovered;
    }

    /**
     * <p>
     * The number of conditional branches that are not covered by your tests.
     * </p>
     * 
     * @return The number of conditional branches that are not covered by your tests.
     */
    public final Integer branchesMissed() {
        return branchesMissed;
    }

    /**
     * <p>
     * The date and time that the tests were run.
     * </p>
     * 
     * @return The date and time that the tests were run.
     */
    public final Instant expired() {
        return expired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(reportARN());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(lineCoveragePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(linesCovered());
        hashCode = 31 * hashCode + Objects.hashCode(linesMissed());
        hashCode = 31 * hashCode + Objects.hashCode(branchCoveragePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(branchesCovered());
        hashCode = 31 * hashCode + Objects.hashCode(branchesMissed());
        hashCode = 31 * hashCode + Objects.hashCode(expired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeCoverage)) {
            return false;
        }
        CodeCoverage other = (CodeCoverage) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(reportARN(), other.reportARN())
                && Objects.equals(filePath(), other.filePath())
                && Objects.equals(lineCoveragePercentage(), other.lineCoveragePercentage())
                && Objects.equals(linesCovered(), other.linesCovered()) && Objects.equals(linesMissed(), other.linesMissed())
                && Objects.equals(branchCoveragePercentage(), other.branchCoveragePercentage())
                && Objects.equals(branchesCovered(), other.branchesCovered())
                && Objects.equals(branchesMissed(), other.branchesMissed()) && Objects.equals(expired(), other.expired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeCoverage").add("Id", id()).add("ReportARN", reportARN()).add("FilePath", filePath())
                .add("LineCoveragePercentage", lineCoveragePercentage()).add("LinesCovered", linesCovered())
                .add("LinesMissed", linesMissed()).add("BranchCoveragePercentage", branchCoveragePercentage())
                .add("BranchesCovered", branchesCovered()).add("BranchesMissed", branchesMissed()).add("Expired", expired())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "reportARN":
            return Optional.ofNullable(clazz.cast(reportARN()));
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "lineCoveragePercentage":
            return Optional.ofNullable(clazz.cast(lineCoveragePercentage()));
        case "linesCovered":
            return Optional.ofNullable(clazz.cast(linesCovered()));
        case "linesMissed":
            return Optional.ofNullable(clazz.cast(linesMissed()));
        case "branchCoveragePercentage":
            return Optional.ofNullable(clazz.cast(branchCoveragePercentage()));
        case "branchesCovered":
            return Optional.ofNullable(clazz.cast(branchesCovered()));
        case "branchesMissed":
            return Optional.ofNullable(clazz.cast(branchesMissed()));
        case "expired":
            return Optional.ofNullable(clazz.cast(expired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("reportARN", REPORT_ARN_FIELD);
        map.put("filePath", FILE_PATH_FIELD);
        map.put("lineCoveragePercentage", LINE_COVERAGE_PERCENTAGE_FIELD);
        map.put("linesCovered", LINES_COVERED_FIELD);
        map.put("linesMissed", LINES_MISSED_FIELD);
        map.put("branchCoveragePercentage", BRANCH_COVERAGE_PERCENTAGE_FIELD);
        map.put("branchesCovered", BRANCHES_COVERED_FIELD);
        map.put("branchesMissed", BRANCHES_MISSED_FIELD);
        map.put("expired", EXPIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeCoverage, T> g) {
        return obj -> g.apply((CodeCoverage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeCoverage> {
        /**
         * <p>
         * The identifier of the code coverage report.
         * </p>
         * 
         * @param id
         *        The identifier of the code coverage report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the report.
         * </p>
         * 
         * @param reportARN
         *        The ARN of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportARN(String reportARN);

        /**
         * <p>
         * The path of the test report file.
         * </p>
         * 
         * @param filePath
         *        The path of the test report file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The percentage of lines that are covered by your tests.
         * </p>
         * 
         * @param lineCoveragePercentage
         *        The percentage of lines that are covered by your tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineCoveragePercentage(Double lineCoveragePercentage);

        /**
         * <p>
         * The number of lines that are covered by your tests.
         * </p>
         * 
         * @param linesCovered
         *        The number of lines that are covered by your tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linesCovered(Integer linesCovered);

        /**
         * <p>
         * The number of lines that are not covered by your tests.
         * </p>
         * 
         * @param linesMissed
         *        The number of lines that are not covered by your tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linesMissed(Integer linesMissed);

        /**
         * <p>
         * The percentage of branches that are covered by your tests.
         * </p>
         * 
         * @param branchCoveragePercentage
         *        The percentage of branches that are covered by your tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchCoveragePercentage(Double branchCoveragePercentage);

        /**
         * <p>
         * The number of conditional branches that are covered by your tests.
         * </p>
         * 
         * @param branchesCovered
         *        The number of conditional branches that are covered by your tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchesCovered(Integer branchesCovered);

        /**
         * <p>
         * The number of conditional branches that are not covered by your tests.
         * </p>
         * 
         * @param branchesMissed
         *        The number of conditional branches that are not covered by your tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchesMissed(Integer branchesMissed);

        /**
         * <p>
         * The date and time that the tests were run.
         * </p>
         * 
         * @param expired
         *        The date and time that the tests were run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expired(Instant expired);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String reportARN;

        private String filePath;

        private Double lineCoveragePercentage;

        private Integer linesCovered;

        private Integer linesMissed;

        private Double branchCoveragePercentage;

        private Integer branchesCovered;

        private Integer branchesMissed;

        private Instant expired;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeCoverage model) {
            id(model.id);
            reportARN(model.reportARN);
            filePath(model.filePath);
            lineCoveragePercentage(model.lineCoveragePercentage);
            linesCovered(model.linesCovered);
            linesMissed(model.linesMissed);
            branchCoveragePercentage(model.branchCoveragePercentage);
            branchesCovered(model.branchesCovered);
            branchesMissed(model.branchesMissed);
            expired(model.expired);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getReportARN() {
            return reportARN;
        }

        public final void setReportARN(String reportARN) {
            this.reportARN = reportARN;
        }

        @Override
        public final Builder reportARN(String reportARN) {
            this.reportARN = reportARN;
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final Double getLineCoveragePercentage() {
            return lineCoveragePercentage;
        }

        public final void setLineCoveragePercentage(Double lineCoveragePercentage) {
            this.lineCoveragePercentage = lineCoveragePercentage;
        }

        @Override
        public final Builder lineCoveragePercentage(Double lineCoveragePercentage) {
            this.lineCoveragePercentage = lineCoveragePercentage;
            return this;
        }

        public final Integer getLinesCovered() {
            return linesCovered;
        }

        public final void setLinesCovered(Integer linesCovered) {
            this.linesCovered = linesCovered;
        }

        @Override
        public final Builder linesCovered(Integer linesCovered) {
            this.linesCovered = linesCovered;
            return this;
        }

        public final Integer getLinesMissed() {
            return linesMissed;
        }

        public final void setLinesMissed(Integer linesMissed) {
            this.linesMissed = linesMissed;
        }

        @Override
        public final Builder linesMissed(Integer linesMissed) {
            this.linesMissed = linesMissed;
            return this;
        }

        public final Double getBranchCoveragePercentage() {
            return branchCoveragePercentage;
        }

        public final void setBranchCoveragePercentage(Double branchCoveragePercentage) {
            this.branchCoveragePercentage = branchCoveragePercentage;
        }

        @Override
        public final Builder branchCoveragePercentage(Double branchCoveragePercentage) {
            this.branchCoveragePercentage = branchCoveragePercentage;
            return this;
        }

        public final Integer getBranchesCovered() {
            return branchesCovered;
        }

        public final void setBranchesCovered(Integer branchesCovered) {
            this.branchesCovered = branchesCovered;
        }

        @Override
        public final Builder branchesCovered(Integer branchesCovered) {
            this.branchesCovered = branchesCovered;
            return this;
        }

        public final Integer getBranchesMissed() {
            return branchesMissed;
        }

        public final void setBranchesMissed(Integer branchesMissed) {
            this.branchesMissed = branchesMissed;
        }

        @Override
        public final Builder branchesMissed(Integer branchesMissed) {
            this.branchesMissed = branchesMissed;
            return this;
        }

        public final Instant getExpired() {
            return expired;
        }

        public final void setExpired(Instant expired) {
            this.expired = expired;
        }

        @Override
        public final Builder expired(Instant expired) {
            this.expired = expired;
            return this;
        }

        @Override
        public CodeCoverage build() {
            return new CodeCoverage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
