/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about logs for a build project. These can be logs in CloudWatch Logs, built in a specified S3 bucket, or
 * both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogsConfig implements SdkPojo, Serializable, ToCopyableBuilder<LogsConfig.Builder, LogsConfig> {
    private static final SdkField<CloudWatchLogsConfig> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<CloudWatchLogsConfig> builder(MarshallingType.SDK_POJO).memberName("cloudWatchLogs")
            .getter(getter(LogsConfig::cloudWatchLogs)).setter(setter(Builder::cloudWatchLogs))
            .constructor(CloudWatchLogsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()).build();

    private static final SdkField<S3LogsConfig> S3_LOGS_FIELD = SdkField.<S3LogsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("s3Logs").getter(getter(LogsConfig::s3Logs)).setter(setter(Builder::s3Logs))
            .constructor(S3LogsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD,
            S3_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogsConfig cloudWatchLogs;

    private final S3LogsConfig s3Logs;

    private LogsConfig(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.s3Logs = builder.s3Logs;
    }

    /**
     * <p>
     * Information about CloudWatch Logs for a build project. CloudWatch Logs are enabled by default.
     * </p>
     * 
     * @return Information about CloudWatch Logs for a build project. CloudWatch Logs are enabled by default.
     */
    public final CloudWatchLogsConfig cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * Information about logs built to an S3 bucket for a build project. S3 logs are not enabled by default.
     * </p>
     * 
     * @return Information about logs built to an S3 bucket for a build project. S3 logs are not enabled by default.
     */
    public final S3LogsConfig s3Logs() {
        return s3Logs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(s3Logs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsConfig)) {
            return false;
        }
        LogsConfig other = (LogsConfig) obj;
        return Objects.equals(cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(s3Logs(), other.s3Logs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogsConfig").add("CloudWatchLogs", cloudWatchLogs()).add("S3Logs", s3Logs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "s3Logs":
            return Optional.ofNullable(clazz.cast(s3Logs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("s3Logs", S3_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogsConfig, T> g) {
        return obj -> g.apply((LogsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogsConfig> {
        /**
         * <p>
         * Information about CloudWatch Logs for a build project. CloudWatch Logs are enabled by default.
         * </p>
         * 
         * @param cloudWatchLogs
         *        Information about CloudWatch Logs for a build project. CloudWatch Logs are enabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(CloudWatchLogsConfig cloudWatchLogs);

        /**
         * <p>
         * Information about CloudWatch Logs for a build project. CloudWatch Logs are enabled by default.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogsConfig.Builder} avoiding
         * the need to create one manually via {@link CloudWatchLogsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudWatchLogs(CloudWatchLogsConfig)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link CloudWatchLogsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(CloudWatchLogsConfig)
         */
        default Builder cloudWatchLogs(Consumer<CloudWatchLogsConfig.Builder> cloudWatchLogs) {
            return cloudWatchLogs(CloudWatchLogsConfig.builder().applyMutation(cloudWatchLogs).build());
        }

        /**
         * <p>
         * Information about logs built to an S3 bucket for a build project. S3 logs are not enabled by default.
         * </p>
         * 
         * @param s3Logs
         *        Information about logs built to an S3 bucket for a build project. S3 logs are not enabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Logs(S3LogsConfig s3Logs);

        /**
         * <p>
         * Information about logs built to an S3 bucket for a build project. S3 logs are not enabled by default.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3LogsConfig.Builder} avoiding the need
         * to create one manually via {@link S3LogsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3LogsConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Logs(S3LogsConfig)}.
         * 
         * @param s3Logs
         *        a consumer that will call methods on {@link S3LogsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Logs(S3LogsConfig)
         */
        default Builder s3Logs(Consumer<S3LogsConfig.Builder> s3Logs) {
            return s3Logs(S3LogsConfig.builder().applyMutation(s3Logs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogsConfig cloudWatchLogs;

        private S3LogsConfig s3Logs;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsConfig model) {
            cloudWatchLogs(model.cloudWatchLogs);
            s3Logs(model.s3Logs);
        }

        public final CloudWatchLogsConfig.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsConfig.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsConfig cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final S3LogsConfig.Builder getS3Logs() {
            return s3Logs != null ? s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(S3LogsConfig.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(S3LogsConfig s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        @Override
        public LogsConfig build() {
            return new LogsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
