/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about build logs in CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogsLocation implements SdkPojo, Serializable, ToCopyableBuilder<LogsLocation.Builder, LogsLocation> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupName").getter(getter(LogsLocation::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamName").getter(getter(LogsLocation::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()).build();

    private static final SdkField<String> DEEP_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deepLink").getter(getter(LogsLocation::deepLink)).setter(setter(Builder::deepLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deepLink").build()).build();

    private static final SdkField<String> S3_DEEP_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3DeepLink").getter(getter(LogsLocation::s3DeepLink)).setter(setter(Builder::s3DeepLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DeepLink").build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudWatchLogsArn").getter(getter(LogsLocation::cloudWatchLogsArn))
            .setter(setter(Builder::cloudWatchLogsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogsArn").build()).build();

    private static final SdkField<String> S3_LOGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3LogsArn").getter(getter(LogsLocation::s3LogsArn)).setter(setter(Builder::s3LogsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3LogsArn").build()).build();

    private static final SdkField<CloudWatchLogsConfig> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<CloudWatchLogsConfig> builder(MarshallingType.SDK_POJO).memberName("cloudWatchLogs")
            .getter(getter(LogsLocation::cloudWatchLogs)).setter(setter(Builder::cloudWatchLogs))
            .constructor(CloudWatchLogsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()).build();

    private static final SdkField<S3LogsConfig> S3_LOGS_FIELD = SdkField.<S3LogsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("s3Logs").getter(getter(LogsLocation::s3Logs)).setter(setter(Builder::s3Logs))
            .constructor(S3LogsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            STREAM_NAME_FIELD, DEEP_LINK_FIELD, S3_DEEP_LINK_FIELD, CLOUD_WATCH_LOGS_ARN_FIELD, S3_LOGS_ARN_FIELD,
            CLOUD_WATCH_LOGS_FIELD, S3_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String streamName;

    private final String deepLink;

    private final String s3DeepLink;

    private final String cloudWatchLogsArn;

    private final String s3LogsArn;

    private final CloudWatchLogsConfig cloudWatchLogs;

    private final S3LogsConfig s3Logs;

    private LogsLocation(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.streamName = builder.streamName;
        this.deepLink = builder.deepLink;
        this.s3DeepLink = builder.s3DeepLink;
        this.cloudWatchLogsArn = builder.cloudWatchLogsArn;
        this.s3LogsArn = builder.s3LogsArn;
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.s3Logs = builder.s3Logs;
    }

    /**
     * <p>
     * The name of the CloudWatch Logs group for the build logs.
     * </p>
     * 
     * @return The name of the CloudWatch Logs group for the build logs.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The name of the CloudWatch Logs stream for the build logs.
     * </p>
     * 
     * @return The name of the CloudWatch Logs stream for the build logs.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The URL to an individual build log in CloudWatch Logs. The log stream is created during the PROVISIONING phase of
     * a build and the <code>deeplink</code> will not be valid until it is created.
     * </p>
     * 
     * @return The URL to an individual build log in CloudWatch Logs. The log stream is created during the PROVISIONING
     *         phase of a build and the <code>deeplink</code> will not be valid until it is created.
     */
    public final String deepLink() {
        return deepLink;
    }

    /**
     * <p>
     * The URL to a build log in an S3 bucket.
     * </p>
     * 
     * @return The URL to a build log in an S3 bucket.
     */
    public final String s3DeepLink() {
        return s3DeepLink;
    }

    /**
     * <p>
     * The ARN of the CloudWatch Logs stream for a build execution. Its format is
     * <code>arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}</code>.
     * The CloudWatch Logs stream is created during the PROVISIONING phase of a build and the ARN will not be valid
     * until it is created. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies"
     * >Resources Defined by CloudWatch Logs</a>.
     * </p>
     * 
     * @return The ARN of the CloudWatch Logs stream for a build execution. Its format is
     *         <code>arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}</code>
     *         . The CloudWatch Logs stream is created during the PROVISIONING phase of a build and the ARN will not be
     *         valid until it is created. For more information, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies"
     *         >Resources Defined by CloudWatch Logs</a>.
     */
    public final String cloudWatchLogsArn() {
        return cloudWatchLogsArn;
    }

    /**
     * <p>
     * The ARN of S3 logs for a build project. Its format is
     * <code>arn:${Partition}:s3:::${BucketName}/${ObjectName}</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies"
     * >Resources Defined by Amazon S3</a>.
     * </p>
     * 
     * @return The ARN of S3 logs for a build project. Its format is
     *         <code>arn:${Partition}:s3:::${BucketName}/${ObjectName}</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies"
     *         >Resources Defined by Amazon S3</a>.
     */
    public final String s3LogsArn() {
        return s3LogsArn;
    }

    /**
     * <p>
     * Information about CloudWatch Logs for a build project.
     * </p>
     * 
     * @return Information about CloudWatch Logs for a build project.
     */
    public final CloudWatchLogsConfig cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * Information about S3 logs for a build project.
     * </p>
     * 
     * @return Information about S3 logs for a build project.
     */
    public final S3LogsConfig s3Logs() {
        return s3Logs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(deepLink());
        hashCode = 31 * hashCode + Objects.hashCode(s3DeepLink());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3LogsArn());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(s3Logs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsLocation)) {
            return false;
        }
        LogsLocation other = (LogsLocation) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(streamName(), other.streamName())
                && Objects.equals(deepLink(), other.deepLink()) && Objects.equals(s3DeepLink(), other.s3DeepLink())
                && Objects.equals(cloudWatchLogsArn(), other.cloudWatchLogsArn())
                && Objects.equals(s3LogsArn(), other.s3LogsArn()) && Objects.equals(cloudWatchLogs(), other.cloudWatchLogs())
                && Objects.equals(s3Logs(), other.s3Logs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogsLocation").add("GroupName", groupName()).add("StreamName", streamName())
                .add("DeepLink", deepLink()).add("S3DeepLink", s3DeepLink()).add("CloudWatchLogsArn", cloudWatchLogsArn())
                .add("S3LogsArn", s3LogsArn()).add("CloudWatchLogs", cloudWatchLogs()).add("S3Logs", s3Logs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "streamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "deepLink":
            return Optional.ofNullable(clazz.cast(deepLink()));
        case "s3DeepLink":
            return Optional.ofNullable(clazz.cast(s3DeepLink()));
        case "cloudWatchLogsArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsArn()));
        case "s3LogsArn":
            return Optional.ofNullable(clazz.cast(s3LogsArn()));
        case "cloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "s3Logs":
            return Optional.ofNullable(clazz.cast(s3Logs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("groupName", GROUP_NAME_FIELD);
        map.put("streamName", STREAM_NAME_FIELD);
        map.put("deepLink", DEEP_LINK_FIELD);
        map.put("s3DeepLink", S3_DEEP_LINK_FIELD);
        map.put("cloudWatchLogsArn", CLOUD_WATCH_LOGS_ARN_FIELD);
        map.put("s3LogsArn", S3_LOGS_ARN_FIELD);
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("s3Logs", S3_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogsLocation, T> g) {
        return obj -> g.apply((LogsLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogsLocation> {
        /**
         * <p>
         * The name of the CloudWatch Logs group for the build logs.
         * </p>
         * 
         * @param groupName
         *        The name of the CloudWatch Logs group for the build logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The name of the CloudWatch Logs stream for the build logs.
         * </p>
         * 
         * @param streamName
         *        The name of the CloudWatch Logs stream for the build logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The URL to an individual build log in CloudWatch Logs. The log stream is created during the PROVISIONING
         * phase of a build and the <code>deeplink</code> will not be valid until it is created.
         * </p>
         * 
         * @param deepLink
         *        The URL to an individual build log in CloudWatch Logs. The log stream is created during the
         *        PROVISIONING phase of a build and the <code>deeplink</code> will not be valid until it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deepLink(String deepLink);

        /**
         * <p>
         * The URL to a build log in an S3 bucket.
         * </p>
         * 
         * @param s3DeepLink
         *        The URL to a build log in an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DeepLink(String s3DeepLink);

        /**
         * <p>
         * The ARN of the CloudWatch Logs stream for a build execution. Its format is
         * <code>arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}</code>
         * . The CloudWatch Logs stream is created during the PROVISIONING phase of a build and the ARN will not be
         * valid until it is created. For more information, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies"
         * >Resources Defined by CloudWatch Logs</a>.
         * </p>
         * 
         * @param cloudWatchLogsArn
         *        The ARN of the CloudWatch Logs stream for a build execution. Its format is
         *        <code>arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}</code>
         *        . The CloudWatch Logs stream is created during the PROVISIONING phase of a build and the ARN will not
         *        be valid until it is created. For more information, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies"
         *        >Resources Defined by CloudWatch Logs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsArn(String cloudWatchLogsArn);

        /**
         * <p>
         * The ARN of S3 logs for a build project. Its format is
         * <code>arn:${Partition}:s3:::${BucketName}/${ObjectName}</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies"
         * >Resources Defined by Amazon S3</a>.
         * </p>
         * 
         * @param s3LogsArn
         *        The ARN of S3 logs for a build project. Its format is
         *        <code>arn:${Partition}:s3:::${BucketName}/${ObjectName}</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies"
         *        >Resources Defined by Amazon S3</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3LogsArn(String s3LogsArn);

        /**
         * <p>
         * Information about CloudWatch Logs for a build project.
         * </p>
         * 
         * @param cloudWatchLogs
         *        Information about CloudWatch Logs for a build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(CloudWatchLogsConfig cloudWatchLogs);

        /**
         * <p>
         * Information about CloudWatch Logs for a build project.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogsConfig.Builder} avoiding
         * the need to create one manually via {@link CloudWatchLogsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudWatchLogs(CloudWatchLogsConfig)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link CloudWatchLogsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(CloudWatchLogsConfig)
         */
        default Builder cloudWatchLogs(Consumer<CloudWatchLogsConfig.Builder> cloudWatchLogs) {
            return cloudWatchLogs(CloudWatchLogsConfig.builder().applyMutation(cloudWatchLogs).build());
        }

        /**
         * <p>
         * Information about S3 logs for a build project.
         * </p>
         * 
         * @param s3Logs
         *        Information about S3 logs for a build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Logs(S3LogsConfig s3Logs);

        /**
         * <p>
         * Information about S3 logs for a build project.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3LogsConfig.Builder} avoiding the need
         * to create one manually via {@link S3LogsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3LogsConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Logs(S3LogsConfig)}.
         * 
         * @param s3Logs
         *        a consumer that will call methods on {@link S3LogsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Logs(S3LogsConfig)
         */
        default Builder s3Logs(Consumer<S3LogsConfig.Builder> s3Logs) {
            return s3Logs(S3LogsConfig.builder().applyMutation(s3Logs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String streamName;

        private String deepLink;

        private String s3DeepLink;

        private String cloudWatchLogsArn;

        private String s3LogsArn;

        private CloudWatchLogsConfig cloudWatchLogs;

        private S3LogsConfig s3Logs;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsLocation model) {
            groupName(model.groupName);
            streamName(model.streamName);
            deepLink(model.deepLink);
            s3DeepLink(model.s3DeepLink);
            cloudWatchLogsArn(model.cloudWatchLogsArn);
            s3LogsArn(model.s3LogsArn);
            cloudWatchLogs(model.cloudWatchLogs);
            s3Logs(model.s3Logs);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getDeepLink() {
            return deepLink;
        }

        public final void setDeepLink(String deepLink) {
            this.deepLink = deepLink;
        }

        @Override
        public final Builder deepLink(String deepLink) {
            this.deepLink = deepLink;
            return this;
        }

        public final String getS3DeepLink() {
            return s3DeepLink;
        }

        public final void setS3DeepLink(String s3DeepLink) {
            this.s3DeepLink = s3DeepLink;
        }

        @Override
        public final Builder s3DeepLink(String s3DeepLink) {
            this.s3DeepLink = s3DeepLink;
            return this;
        }

        public final String getCloudWatchLogsArn() {
            return cloudWatchLogsArn;
        }

        public final void setCloudWatchLogsArn(String cloudWatchLogsArn) {
            this.cloudWatchLogsArn = cloudWatchLogsArn;
        }

        @Override
        public final Builder cloudWatchLogsArn(String cloudWatchLogsArn) {
            this.cloudWatchLogsArn = cloudWatchLogsArn;
            return this;
        }

        public final String getS3LogsArn() {
            return s3LogsArn;
        }

        public final void setS3LogsArn(String s3LogsArn) {
            this.s3LogsArn = s3LogsArn;
        }

        @Override
        public final Builder s3LogsArn(String s3LogsArn) {
            this.s3LogsArn = s3LogsArn;
            return this;
        }

        public final CloudWatchLogsConfig.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsConfig.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsConfig cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final S3LogsConfig.Builder getS3Logs() {
            return s3Logs != null ? s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(S3LogsConfig.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(S3LogsConfig s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        @Override
        public LogsLocation build() {
            return new LogsLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
