/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the sandbox session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SandboxSession implements SdkPojo, Serializable, ToCopyableBuilder<SandboxSession.Builder, SandboxSession> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SandboxSession::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SandboxSession::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(SandboxSession::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(SandboxSession::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> CURRENT_PHASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentPhase").getter(getter(SandboxSession::currentPhase)).setter(setter(Builder::currentPhase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPhase").build()).build();

    private static final SdkField<List<SandboxSessionPhase>> PHASES_FIELD = SdkField
            .<List<SandboxSessionPhase>> builder(MarshallingType.LIST)
            .memberName("phases")
            .getter(getter(SandboxSession::phases))
            .setter(setter(Builder::phases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SandboxSessionPhase> builder(MarshallingType.SDK_POJO)
                                            .constructor(SandboxSessionPhase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOLVED_SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolvedSourceVersion").getter(getter(SandboxSession::resolvedSourceVersion))
            .setter(setter(Builder::resolvedSourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedSourceVersion").build())
            .build();

    private static final SdkField<LogsLocation> LOGS_FIELD = SdkField.<LogsLocation> builder(MarshallingType.SDK_POJO)
            .memberName("logs").getter(getter(SandboxSession::logs)).setter(setter(Builder::logs))
            .constructor(LogsLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()).build();

    private static final SdkField<NetworkInterface> NETWORK_INTERFACE_FIELD = SdkField
            .<NetworkInterface> builder(MarshallingType.SDK_POJO).memberName("networkInterface")
            .getter(getter(SandboxSession::networkInterface)).setter(setter(Builder::networkInterface))
            .constructor(NetworkInterface::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterface").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, CURRENT_PHASE_FIELD, PHASES_FIELD, RESOLVED_SOURCE_VERSION_FIELD, LOGS_FIELD,
            NETWORK_INTERFACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String status;

    private final Instant startTime;

    private final Instant endTime;

    private final String currentPhase;

    private final List<SandboxSessionPhase> phases;

    private final String resolvedSourceVersion;

    private final LogsLocation logs;

    private final NetworkInterface networkInterface;

    private SandboxSession(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.currentPhase = builder.currentPhase;
        this.phases = builder.phases;
        this.resolvedSourceVersion = builder.resolvedSourceVersion;
        this.logs = builder.logs;
        this.networkInterface = builder.networkInterface;
    }

    /**
     * <p>
     * The ID of the sandbox session.
     * </p>
     * 
     * @return The ID of the sandbox session.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of the sandbox session.
     * </p>
     * 
     * @return The status of the sandbox session.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * When the sandbox session started, expressed in Unix time format.
     * </p>
     * 
     * @return When the sandbox session started, expressed in Unix time format.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * When the sandbox session ended, expressed in Unix time format.
     * </p>
     * 
     * @return When the sandbox session ended, expressed in Unix time format.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The current phase for the sandbox.
     * </p>
     * 
     * @return The current phase for the sandbox.
     */
    public final String currentPhase() {
        return currentPhase;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPhases() {
        return phases != null && !(phases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>SandboxSessionPhase</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhases} method.
     * </p>
     * 
     * @return An array of <code>SandboxSessionPhase</code> objects.
     */
    public final List<SandboxSessionPhase> phases() {
        return phases;
    }

    /**
     * <p>
     * An identifier for the version of this sandbox's source code.
     * </p>
     * 
     * @return An identifier for the version of this sandbox's source code.
     */
    public final String resolvedSourceVersion() {
        return resolvedSourceVersion;
    }

    /**
     * Returns the value of the Logs property for this object.
     * 
     * @return The value of the Logs property for this object.
     */
    public final LogsLocation logs() {
        return logs;
    }

    /**
     * Returns the value of the NetworkInterface property for this object.
     * 
     * @return The value of the NetworkInterface property for this object.
     */
    public final NetworkInterface networkInterface() {
        return networkInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(currentPhase());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhases() ? phases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resolvedSourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(logs());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterface());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SandboxSession)) {
            return false;
        }
        SandboxSession other = (SandboxSession) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(status(), other.status())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(currentPhase(), other.currentPhase()) && hasPhases() == other.hasPhases()
                && Objects.equals(phases(), other.phases())
                && Objects.equals(resolvedSourceVersion(), other.resolvedSourceVersion()) && Objects.equals(logs(), other.logs())
                && Objects.equals(networkInterface(), other.networkInterface());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SandboxSession").add("Id", id()).add("Status", status()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("CurrentPhase", currentPhase()).add("Phases", hasPhases() ? phases() : null)
                .add("ResolvedSourceVersion", resolvedSourceVersion()).add("Logs", logs())
                .add("NetworkInterface", networkInterface()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "currentPhase":
            return Optional.ofNullable(clazz.cast(currentPhase()));
        case "phases":
            return Optional.ofNullable(clazz.cast(phases()));
        case "resolvedSourceVersion":
            return Optional.ofNullable(clazz.cast(resolvedSourceVersion()));
        case "logs":
            return Optional.ofNullable(clazz.cast(logs()));
        case "networkInterface":
            return Optional.ofNullable(clazz.cast(networkInterface()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("currentPhase", CURRENT_PHASE_FIELD);
        map.put("phases", PHASES_FIELD);
        map.put("resolvedSourceVersion", RESOLVED_SOURCE_VERSION_FIELD);
        map.put("logs", LOGS_FIELD);
        map.put("networkInterface", NETWORK_INTERFACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SandboxSession, T> g) {
        return obj -> g.apply((SandboxSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SandboxSession> {
        /**
         * <p>
         * The ID of the sandbox session.
         * </p>
         * 
         * @param id
         *        The ID of the sandbox session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the sandbox session.
         * </p>
         * 
         * @param status
         *        The status of the sandbox session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * When the sandbox session started, expressed in Unix time format.
         * </p>
         * 
         * @param startTime
         *        When the sandbox session started, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * When the sandbox session ended, expressed in Unix time format.
         * </p>
         * 
         * @param endTime
         *        When the sandbox session ended, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The current phase for the sandbox.
         * </p>
         * 
         * @param currentPhase
         *        The current phase for the sandbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPhase(String currentPhase);

        /**
         * <p>
         * An array of <code>SandboxSessionPhase</code> objects.
         * </p>
         * 
         * @param phases
         *        An array of <code>SandboxSessionPhase</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phases(Collection<SandboxSessionPhase> phases);

        /**
         * <p>
         * An array of <code>SandboxSessionPhase</code> objects.
         * </p>
         * 
         * @param phases
         *        An array of <code>SandboxSessionPhase</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phases(SandboxSessionPhase... phases);

        /**
         * <p>
         * An array of <code>SandboxSessionPhase</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.SandboxSessionPhase.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codebuild.model.SandboxSessionPhase#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.SandboxSessionPhase.Builder#build()} is called
         * immediately and its result is passed to {@link #phases(List<SandboxSessionPhase>)}.
         * 
         * @param phases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.SandboxSessionPhase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phases(java.util.Collection<SandboxSessionPhase>)
         */
        Builder phases(Consumer<SandboxSessionPhase.Builder>... phases);

        /**
         * <p>
         * An identifier for the version of this sandbox's source code.
         * </p>
         * 
         * @param resolvedSourceVersion
         *        An identifier for the version of this sandbox's source code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedSourceVersion(String resolvedSourceVersion);

        /**
         * Sets the value of the Logs property for this object.
         *
         * @param logs
         *        The new value for the Logs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(LogsLocation logs);

        /**
         * Sets the value of the Logs property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LogsLocation.Builder} avoiding the need
         * to create one manually via {@link LogsLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogsLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #logs(LogsLocation)}.
         * 
         * @param logs
         *        a consumer that will call methods on {@link LogsLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logs(LogsLocation)
         */
        default Builder logs(Consumer<LogsLocation.Builder> logs) {
            return logs(LogsLocation.builder().applyMutation(logs).build());
        }

        /**
         * Sets the value of the NetworkInterface property for this object.
         *
         * @param networkInterface
         *        The new value for the NetworkInterface property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterface(NetworkInterface networkInterface);

        /**
         * Sets the value of the NetworkInterface property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NetworkInterface.Builder} avoiding the
         * need to create one manually via {@link NetworkInterface#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkInterface.Builder#build()} is called immediately and its
         * result is passed to {@link #networkInterface(NetworkInterface)}.
         * 
         * @param networkInterface
         *        a consumer that will call methods on {@link NetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterface(NetworkInterface)
         */
        default Builder networkInterface(Consumer<NetworkInterface.Builder> networkInterface) {
            return networkInterface(NetworkInterface.builder().applyMutation(networkInterface).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private Instant startTime;

        private Instant endTime;

        private String currentPhase;

        private List<SandboxSessionPhase> phases = DefaultSdkAutoConstructList.getInstance();

        private String resolvedSourceVersion;

        private LogsLocation logs;

        private NetworkInterface networkInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(SandboxSession model) {
            id(model.id);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            currentPhase(model.currentPhase);
            phases(model.phases);
            resolvedSourceVersion(model.resolvedSourceVersion);
            logs(model.logs);
            networkInterface(model.networkInterface);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getCurrentPhase() {
            return currentPhase;
        }

        public final void setCurrentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
        }

        @Override
        public final Builder currentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
            return this;
        }

        public final List<SandboxSessionPhase.Builder> getPhases() {
            List<SandboxSessionPhase.Builder> result = SandboxSessionPhasesCopier.copyToBuilder(this.phases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhases(Collection<SandboxSessionPhase.BuilderImpl> phases) {
            this.phases = SandboxSessionPhasesCopier.copyFromBuilder(phases);
        }

        @Override
        public final Builder phases(Collection<SandboxSessionPhase> phases) {
            this.phases = SandboxSessionPhasesCopier.copy(phases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(SandboxSessionPhase... phases) {
            phases(Arrays.asList(phases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(Consumer<SandboxSessionPhase.Builder>... phases) {
            phases(Stream.of(phases).map(c -> SandboxSessionPhase.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResolvedSourceVersion() {
            return resolvedSourceVersion;
        }

        public final void setResolvedSourceVersion(String resolvedSourceVersion) {
            this.resolvedSourceVersion = resolvedSourceVersion;
        }

        @Override
        public final Builder resolvedSourceVersion(String resolvedSourceVersion) {
            this.resolvedSourceVersion = resolvedSourceVersion;
            return this;
        }

        public final LogsLocation.Builder getLogs() {
            return logs != null ? logs.toBuilder() : null;
        }

        public final void setLogs(LogsLocation.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public final Builder logs(LogsLocation logs) {
            this.logs = logs;
            return this;
        }

        public final NetworkInterface.Builder getNetworkInterface() {
            return networkInterface != null ? networkInterface.toBuilder() : null;
        }

        public final void setNetworkInterface(NetworkInterface.BuilderImpl networkInterface) {
            this.networkInterface = networkInterface != null ? networkInterface.build() : null;
        }

        @Override
        public final Builder networkInterface(NetworkInterface networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        @Override
        public SandboxSession build() {
            return new SandboxSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
