/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.CodeBuildServiceClientConfiguration;
import software.amazon.awssdk.services.codebuild.internal.CodeBuildServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codebuild.model.AccountLimitExceededException;
import software.amazon.awssdk.services.codebuild.model.AccountSuspendedException;
import software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchDeleteBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildBatchesResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetCommandExecutionsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetCommandExecutionsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetFleetsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetFleetsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetReportsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetSandboxesRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetSandboxesResponse;
import software.amazon.awssdk.services.codebuild.model.CodeBuildException;
import software.amazon.awssdk.services.codebuild.model.CreateFleetRequest;
import software.amazon.awssdk.services.codebuild.model.CreateFleetResponse;
import software.amazon.awssdk.services.codebuild.model.CreateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.CreateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.CreateReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.CreateReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.CreateWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.CreateWebhookResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteFleetRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteFleetResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteReportRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteReportResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest;
import software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse;
import software.amazon.awssdk.services.codebuild.model.DescribeTestCasesRequest;
import software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse;
import software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendRequest;
import software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendResponse;
import software.amazon.awssdk.services.codebuild.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.codebuild.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsRequest;
import software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsResponse;
import software.amazon.awssdk.services.codebuild.model.InvalidInputException;
import software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheRequest;
import software.amazon.awssdk.services.codebuild.model.InvalidateProjectCacheResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildBatchesResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.ListCommandExecutionsForSandboxRequest;
import software.amazon.awssdk.services.codebuild.model.ListCommandExecutionsForSandboxResponse;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesRequest;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse;
import software.amazon.awssdk.services.codebuild.model.ListFleetsRequest;
import software.amazon.awssdk.services.codebuild.model.ListFleetsResponse;
import software.amazon.awssdk.services.codebuild.model.ListProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse;
import software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.ListReportsRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportsResponse;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesRequest;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesResponse;
import software.amazon.awssdk.services.codebuild.model.ListSharedProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSharedProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse;
import software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSourceCredentialsResponse;
import software.amazon.awssdk.services.codebuild.model.OAuthProviderException;
import software.amazon.awssdk.services.codebuild.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.codebuild.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.codebuild.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.codebuild.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codebuild.model.RetryBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.RetryBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.RetryBuildRequest;
import software.amazon.awssdk.services.codebuild.model.RetryBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StartBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.StartBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.StartBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StartBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StartCommandExecutionRequest;
import software.amazon.awssdk.services.codebuild.model.StartCommandExecutionResponse;
import software.amazon.awssdk.services.codebuild.model.StartSandboxConnectionRequest;
import software.amazon.awssdk.services.codebuild.model.StartSandboxConnectionResponse;
import software.amazon.awssdk.services.codebuild.model.StartSandboxRequest;
import software.amazon.awssdk.services.codebuild.model.StartSandboxResponse;
import software.amazon.awssdk.services.codebuild.model.StopBuildBatchRequest;
import software.amazon.awssdk.services.codebuild.model.StopBuildBatchResponse;
import software.amazon.awssdk.services.codebuild.model.StopBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StopBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StopSandboxRequest;
import software.amazon.awssdk.services.codebuild.model.StopSandboxResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateFleetRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateFleetResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectVisibilityResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateReportGroupRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateReportGroupResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateWebhookRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateWebhookResponse;
import software.amazon.awssdk.services.codebuild.transform.BatchDeleteBuildsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetBuildBatchesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetBuildsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetCommandExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetFleetsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetProjectsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetReportGroupsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetReportsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.BatchGetSandboxesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateReportGroupRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.CreateWebhookRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteBuildBatchRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteReportGroupRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteReportRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteSourceCredentialsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DeleteWebhookRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DescribeCodeCoveragesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.DescribeTestCasesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.GetReportGroupTrendRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ImportSourceCredentialsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.InvalidateProjectCacheRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildBatchesForProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildBatchesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildsForProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListBuildsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListCommandExecutionsForSandboxRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListCuratedEnvironmentImagesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListReportGroupsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListReportsForReportGroupRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListReportsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListSandboxesForProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListSandboxesRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListSharedProjectsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListSharedReportGroupsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.ListSourceCredentialsRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.RetryBuildBatchRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.RetryBuildRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartBuildBatchRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartBuildRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartCommandExecutionRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartSandboxConnectionRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StartSandboxRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StopBuildBatchRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StopBuildRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.StopSandboxRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateFleetRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateProjectVisibilityRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateReportGroupRequestMarshaller;
import software.amazon.awssdk.services.codebuild.transform.UpdateWebhookRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCodeBuildClient
implements CodeBuildClient {
    private static final Logger log = Logger.loggerFor(DefaultCodeBuildClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeBuildClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CodeBuild#2.36.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteBuildsResponse batchDeleteBuilds(BatchDeleteBuildsRequest batchDeleteBuildsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteBuildsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteBuildsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, batchDeleteBuildsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteBuilds");
            BatchDeleteBuildsResponse batchDeleteBuildsResponse = (BatchDeleteBuildsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteBuilds").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeleteBuildsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteBuildsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteBuildsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$batchDeleteBuilds$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetBuildBatchesResponse batchGetBuildBatches(BatchGetBuildBatchesRequest batchGetBuildBatchesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetBuildBatchesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetBuildBatchesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, batchGetBuildBatchesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetBuildBatches");
            BatchGetBuildBatchesResponse batchGetBuildBatchesResponse = (BatchGetBuildBatchesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetBuildBatches").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetBuildBatchesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetBuildBatchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetBuildBatchesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$batchGetBuildBatches$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetBuildsResponse batchGetBuilds(BatchGetBuildsRequest batchGetBuildsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetBuildsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetBuildsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, batchGetBuildsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetBuilds");
            BatchGetBuildsResponse batchGetBuildsResponse = (BatchGetBuildsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetBuilds").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetBuildsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetBuildsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetBuildsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$batchGetBuilds$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetCommandExecutionsResponse batchGetCommandExecutions(BatchGetCommandExecutionsRequest batchGetCommandExecutionsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetCommandExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetCommandExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, batchGetCommandExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetCommandExecutions");
            BatchGetCommandExecutionsResponse batchGetCommandExecutionsResponse = (BatchGetCommandExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetCommandExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetCommandExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetCommandExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetCommandExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$batchGetCommandExecutions$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetFleetsResponse batchGetFleets(BatchGetFleetsRequest batchGetFleetsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetFleetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, batchGetFleetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetFleets");
            BatchGetFleetsResponse batchGetFleetsResponse = (BatchGetFleetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetFleets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetFleetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetFleetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetFleetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$batchGetFleets$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetProjectsResponse batchGetProjects(BatchGetProjectsRequest batchGetProjectsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetProjectsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetProjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, batchGetProjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetProjects");
            BatchGetProjectsResponse batchGetProjectsResponse = (BatchGetProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetProjects").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetProjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetProjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetProjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$batchGetProjects$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetReportGroupsResponse batchGetReportGroups(BatchGetReportGroupsRequest batchGetReportGroupsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetReportGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetReportGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, batchGetReportGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetReportGroups");
            BatchGetReportGroupsResponse batchGetReportGroupsResponse = (BatchGetReportGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetReportGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetReportGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetReportGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetReportGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$batchGetReportGroups$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetReportsResponse batchGetReports(BatchGetReportsRequest batchGetReportsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetReportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetReportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, batchGetReportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetReports");
            BatchGetReportsResponse batchGetReportsResponse = (BatchGetReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetReports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetReportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetReportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$batchGetReports$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetSandboxesResponse batchGetSandboxes(BatchGetSandboxesRequest batchGetSandboxesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetSandboxesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetSandboxesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, batchGetSandboxesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetSandboxes");
            BatchGetSandboxesResponse batchGetSandboxesResponse = (BatchGetSandboxesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetSandboxes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetSandboxesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetSandboxesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetSandboxesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$batchGetSandboxes$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws InvalidInputException, ResourceAlreadyExistsException, AccountLimitExceededException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFleetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, createFleetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFleet");
            CreateFleetResponse createFleetResponse = (CreateFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFleet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFleetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFleetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$createFleet$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws InvalidInputException, ResourceAlreadyExistsException, AccountLimitExceededException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, createProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateProject");
            CreateProjectResponse createProjectResponse = (CreateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$createProject$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReportGroupResponse createReportGroup(CreateReportGroupRequest createReportGroupRequest) throws InvalidInputException, ResourceAlreadyExistsException, AccountLimitExceededException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReportGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createReportGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, createReportGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReportGroup");
            CreateReportGroupResponse createReportGroupResponse = (CreateReportGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReportGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createReportGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReportGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReportGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$createReportGroup$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWebhookResponse createWebhook(CreateWebhookRequest createWebhookRequest) throws InvalidInputException, OAuthProviderException, ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWebhookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, createWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWebhook");
            CreateWebhookResponse createWebhookResponse = (CreateWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWebhook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$createWebhook$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBuildBatchResponse deleteBuildBatch(DeleteBuildBatchRequest deleteBuildBatchRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBuildBatchResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBuildBatchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, deleteBuildBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBuildBatch");
            DeleteBuildBatchResponse deleteBuildBatchResponse = (DeleteBuildBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBuildBatch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBuildBatchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBuildBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBuildBatchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$deleteBuildBatch$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFleetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, deleteFleetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFleet");
            DeleteFleetResponse deleteFleetResponse = (DeleteFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFleet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFleetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFleetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$deleteFleet$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, deleteProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteProject");
            DeleteProjectResponse deleteProjectResponse = (DeleteProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$deleteProject$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReportResponse deleteReport(DeleteReportRequest deleteReportRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, deleteReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReport");
            DeleteReportResponse deleteReportResponse = (DeleteReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$deleteReport$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReportGroupResponse deleteReportGroup(DeleteReportGroupRequest deleteReportGroupRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReportGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReportGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, deleteReportGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReportGroup");
            DeleteReportGroupResponse deleteReportGroupResponse = (DeleteReportGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReportGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteReportGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReportGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReportGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$deleteReportGroup$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$deleteResourcePolicy$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSourceCredentialsResponse deleteSourceCredentials(DeleteSourceCredentialsRequest deleteSourceCredentialsRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSourceCredentialsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSourceCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, deleteSourceCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSourceCredentials");
            DeleteSourceCredentialsResponse deleteSourceCredentialsResponse = (DeleteSourceCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSourceCredentials").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSourceCredentialsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSourceCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSourceCredentialsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$deleteSourceCredentials$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWebhookResponse deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) throws InvalidInputException, ResourceNotFoundException, OAuthProviderException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWebhookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, deleteWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWebhook");
            DeleteWebhookResponse deleteWebhookResponse = (DeleteWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWebhook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$deleteWebhook$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCodeCoveragesResponse describeCodeCoverages(DescribeCodeCoveragesRequest describeCodeCoveragesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCodeCoveragesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCodeCoveragesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, describeCodeCoveragesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCodeCoverages");
            DescribeCodeCoveragesResponse describeCodeCoveragesResponse = (DescribeCodeCoveragesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCodeCoverages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCodeCoveragesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCodeCoveragesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCodeCoveragesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$describeCodeCoverages$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTestCasesResponse describeTestCases(DescribeTestCasesRequest describeTestCasesRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTestCasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTestCasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, describeTestCasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTestCases");
            DescribeTestCasesResponse describeTestCasesResponse = (DescribeTestCasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTestCases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTestCasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTestCasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTestCasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$describeTestCases$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReportGroupTrendResponse getReportGroupTrend(GetReportGroupTrendRequest getReportGroupTrendRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReportGroupTrendResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReportGroupTrendRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, getReportGroupTrendRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReportGroupTrend");
            GetReportGroupTrendResponse getReportGroupTrendResponse = (GetReportGroupTrendResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReportGroupTrend").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getReportGroupTrendRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReportGroupTrendRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReportGroupTrendResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$getReportGroupTrend$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            GetResourcePolicyResponse getResourcePolicyResponse = (GetResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$getResourcePolicy$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportSourceCredentialsResponse importSourceCredentials(ImportSourceCredentialsRequest importSourceCredentialsRequest) throws InvalidInputException, AccountLimitExceededException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportSourceCredentialsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importSourceCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, importSourceCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportSourceCredentials");
            ImportSourceCredentialsResponse importSourceCredentialsResponse = (ImportSourceCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportSourceCredentials").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importSourceCredentialsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportSourceCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importSourceCredentialsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$importSourceCredentials$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvalidateProjectCacheResponse invalidateProjectCache(InvalidateProjectCacheRequest invalidateProjectCacheRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InvalidateProjectCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)invalidateProjectCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, invalidateProjectCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InvalidateProjectCache");
            InvalidateProjectCacheResponse invalidateProjectCacheResponse = (InvalidateProjectCacheResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InvalidateProjectCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)invalidateProjectCacheRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InvalidateProjectCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return invalidateProjectCacheResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$invalidateProjectCache$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBuildBatchesResponse listBuildBatches(ListBuildBatchesRequest listBuildBatchesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBuildBatchesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBuildBatchesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listBuildBatchesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBuildBatches");
            ListBuildBatchesResponse listBuildBatchesResponse = (ListBuildBatchesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBuildBatches").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBuildBatchesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBuildBatchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBuildBatchesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listBuildBatches$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBuildBatchesForProjectResponse listBuildBatchesForProject(ListBuildBatchesForProjectRequest listBuildBatchesForProjectRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBuildBatchesForProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBuildBatchesForProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listBuildBatchesForProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBuildBatchesForProject");
            ListBuildBatchesForProjectResponse listBuildBatchesForProjectResponse = (ListBuildBatchesForProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBuildBatchesForProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBuildBatchesForProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBuildBatchesForProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBuildBatchesForProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listBuildBatchesForProject$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBuildsResponse listBuilds(ListBuildsRequest listBuildsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBuildsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBuildsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listBuildsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBuilds");
            ListBuildsResponse listBuildsResponse = (ListBuildsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBuilds").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBuildsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBuildsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBuildsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listBuilds$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBuildsForProjectResponse listBuildsForProject(ListBuildsForProjectRequest listBuildsForProjectRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBuildsForProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBuildsForProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listBuildsForProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBuildsForProject");
            ListBuildsForProjectResponse listBuildsForProjectResponse = (ListBuildsForProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBuildsForProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBuildsForProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBuildsForProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBuildsForProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listBuildsForProject$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCommandExecutionsForSandboxResponse listCommandExecutionsForSandbox(ListCommandExecutionsForSandboxRequest listCommandExecutionsForSandboxRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCommandExecutionsForSandboxResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCommandExecutionsForSandboxRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listCommandExecutionsForSandboxRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCommandExecutionsForSandbox");
            ListCommandExecutionsForSandboxResponse listCommandExecutionsForSandboxResponse = (ListCommandExecutionsForSandboxResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCommandExecutionsForSandbox").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCommandExecutionsForSandboxRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCommandExecutionsForSandboxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCommandExecutionsForSandboxResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listCommandExecutionsForSandbox$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCuratedEnvironmentImagesResponse listCuratedEnvironmentImages(ListCuratedEnvironmentImagesRequest listCuratedEnvironmentImagesRequest) throws AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCuratedEnvironmentImagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCuratedEnvironmentImagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listCuratedEnvironmentImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCuratedEnvironmentImages");
            ListCuratedEnvironmentImagesResponse listCuratedEnvironmentImagesResponse = (ListCuratedEnvironmentImagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCuratedEnvironmentImages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCuratedEnvironmentImagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCuratedEnvironmentImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCuratedEnvironmentImagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listCuratedEnvironmentImages$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFleetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listFleetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFleets");
            ListFleetsResponse listFleetsResponse = (ListFleetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFleets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFleetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFleetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFleetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listFleets$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProjectsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listProjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listProjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProjects");
            ListProjectsResponse listProjectsResponse = (ListProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProjects").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listProjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListProjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listProjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listProjects$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReportGroupsResponse listReportGroups(ListReportGroupsRequest listReportGroupsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReportGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReportGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listReportGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReportGroups");
            ListReportGroupsResponse listReportGroupsResponse = (ListReportGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReportGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listReportGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReportGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReportGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listReportGroups$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReportsResponse listReports(ListReportsRequest listReportsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listReportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReports");
            ListReportsResponse listReportsResponse = (ListReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listReportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listReports$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReportsForReportGroupResponse listReportsForReportGroup(ListReportsForReportGroupRequest listReportsForReportGroupRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReportsForReportGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReportsForReportGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listReportsForReportGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReportsForReportGroup");
            ListReportsForReportGroupResponse listReportsForReportGroupResponse = (ListReportsForReportGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReportsForReportGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listReportsForReportGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReportsForReportGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReportsForReportGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listReportsForReportGroup$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSandboxesResponse listSandboxes(ListSandboxesRequest listSandboxesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSandboxesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSandboxesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listSandboxesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSandboxes");
            ListSandboxesResponse listSandboxesResponse = (ListSandboxesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSandboxes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSandboxesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSandboxesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSandboxesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listSandboxes$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSandboxesForProjectResponse listSandboxesForProject(ListSandboxesForProjectRequest listSandboxesForProjectRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSandboxesForProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSandboxesForProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listSandboxesForProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSandboxesForProject");
            ListSandboxesForProjectResponse listSandboxesForProjectResponse = (ListSandboxesForProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSandboxesForProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSandboxesForProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSandboxesForProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSandboxesForProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listSandboxesForProject$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSharedProjectsResponse listSharedProjects(ListSharedProjectsRequest listSharedProjectsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSharedProjectsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSharedProjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listSharedProjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSharedProjects");
            ListSharedProjectsResponse listSharedProjectsResponse = (ListSharedProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSharedProjects").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSharedProjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSharedProjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSharedProjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listSharedProjects$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSharedReportGroupsResponse listSharedReportGroups(ListSharedReportGroupsRequest listSharedReportGroupsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSharedReportGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSharedReportGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listSharedReportGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSharedReportGroups");
            ListSharedReportGroupsResponse listSharedReportGroupsResponse = (ListSharedReportGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSharedReportGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSharedReportGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSharedReportGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSharedReportGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listSharedReportGroups$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSourceCredentialsResponse listSourceCredentials(ListSourceCredentialsRequest listSourceCredentialsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSourceCredentialsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSourceCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, listSourceCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSourceCredentials");
            ListSourceCredentialsResponse listSourceCredentialsResponse = (ListSourceCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSourceCredentials").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSourceCredentialsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSourceCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSourceCredentialsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$listSourceCredentials$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$putResourcePolicy$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetryBuildResponse retryBuild(RetryBuildRequest retryBuildRequest) throws InvalidInputException, ResourceNotFoundException, AccountLimitExceededException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetryBuildResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retryBuildRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, retryBuildRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetryBuild");
            RetryBuildResponse retryBuildResponse = (RetryBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetryBuild").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)retryBuildRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RetryBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return retryBuildResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$retryBuild$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetryBuildBatchResponse retryBuildBatch(RetryBuildBatchRequest retryBuildBatchRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetryBuildBatchResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retryBuildBatchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, retryBuildBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetryBuildBatch");
            RetryBuildBatchResponse retryBuildBatchResponse = (RetryBuildBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetryBuildBatch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)retryBuildBatchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RetryBuildBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return retryBuildBatchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$retryBuildBatch$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartBuildResponse startBuild(StartBuildRequest startBuildRequest) throws InvalidInputException, ResourceNotFoundException, AccountLimitExceededException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartBuildResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startBuildRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, startBuildRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartBuild");
            StartBuildResponse startBuildResponse = (StartBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartBuild").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startBuildRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startBuildResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$startBuild$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartBuildBatchResponse startBuildBatch(StartBuildBatchRequest startBuildBatchRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartBuildBatchResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startBuildBatchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, startBuildBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartBuildBatch");
            StartBuildBatchResponse startBuildBatchResponse = (StartBuildBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartBuildBatch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startBuildBatchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartBuildBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startBuildBatchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$startBuildBatch$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartCommandExecutionResponse startCommandExecution(StartCommandExecutionRequest startCommandExecutionRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCommandExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startCommandExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, startCommandExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCommandExecution");
            StartCommandExecutionResponse startCommandExecutionResponse = (StartCommandExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCommandExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startCommandExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartCommandExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startCommandExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$startCommandExecution$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSandboxResponse startSandbox(StartSandboxRequest startSandboxRequest) throws InvalidInputException, ResourceNotFoundException, AccountSuspendedException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSandboxResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSandboxRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, startSandboxRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSandbox");
            StartSandboxResponse startSandboxResponse = (StartSandboxResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSandbox").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSandboxRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSandboxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSandboxResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$startSandbox$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSandboxConnectionResponse startSandboxConnection(StartSandboxConnectionRequest startSandboxConnectionRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSandboxConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSandboxConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, startSandboxConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSandboxConnection");
            StartSandboxConnectionResponse startSandboxConnectionResponse = (StartSandboxConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSandboxConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSandboxConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSandboxConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSandboxConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$startSandboxConnection$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopBuildResponse stopBuild(StopBuildRequest stopBuildRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopBuildResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopBuildRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, stopBuildRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopBuild");
            StopBuildResponse stopBuildResponse = (StopBuildResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopBuild").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopBuildRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopBuildRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopBuildResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$stopBuild$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopBuildBatchResponse stopBuildBatch(StopBuildBatchRequest stopBuildBatchRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopBuildBatchResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopBuildBatchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, stopBuildBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopBuildBatch");
            StopBuildBatchResponse stopBuildBatchResponse = (StopBuildBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopBuildBatch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopBuildBatchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopBuildBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopBuildBatchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$stopBuildBatch$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopSandboxResponse stopSandbox(StopSandboxRequest stopSandboxRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopSandboxResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopSandboxRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, stopSandboxRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopSandbox");
            StopSandboxResponse stopSandboxResponse = (StopSandboxResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopSandbox").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopSandboxRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopSandboxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopSandboxResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$stopSandbox$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFleetResponse updateFleet(UpdateFleetRequest updateFleetRequest) throws InvalidInputException, ResourceNotFoundException, AccountLimitExceededException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFleetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, updateFleetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFleet");
            UpdateFleetResponse updateFleetResponse = (UpdateFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFleet").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFleetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFleetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$updateFleet$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProjectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, updateProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateProject");
            UpdateProjectResponse updateProjectResponse = (UpdateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateProjectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateProjectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$updateProject$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateProjectVisibilityResponse updateProjectVisibility(UpdateProjectVisibilityRequest updateProjectVisibilityRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProjectVisibilityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateProjectVisibilityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, updateProjectVisibilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateProjectVisibility");
            UpdateProjectVisibilityResponse updateProjectVisibilityResponse = (UpdateProjectVisibilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProjectVisibility").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateProjectVisibilityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateProjectVisibilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateProjectVisibilityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$updateProjectVisibility$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateReportGroupResponse updateReportGroup(UpdateReportGroupRequest updateReportGroupRequest) throws InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReportGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateReportGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, updateReportGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReportGroup");
            UpdateReportGroupResponse updateReportGroupResponse = (UpdateReportGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReportGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateReportGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateReportGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateReportGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$updateReportGroup$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWebhookResponse updateWebhook(UpdateWebhookRequest updateWebhookRequest) throws InvalidInputException, ResourceNotFoundException, OAuthProviderException, AwsServiceException, SdkClientException, CodeBuildException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWebhookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "OAuthProviderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OAuthProviderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OAuthProviderException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AccountSuspendedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountSuspendedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountSuspendedException::builder).build());
                }
                case "AccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountLimitExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InvalidInputException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeBuildClient.resolveMetricPublishers(clientConfiguration, updateWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeBuild");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWebhook");
            UpdateWebhookResponse updateWebhookResponse = (UpdateWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWebhook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodeBuildClient.lambda$updateWebhook$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "codebuild";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CodeBuildServiceClientConfigurationBuilder serviceConfigBuilder = new CodeBuildServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeBuildException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final CodeBuildServiceClientConfiguration serviceClientConfiguration() {
        return new CodeBuildServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateWebhook$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateReportGroup$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateProjectVisibility$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateProject$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFleet$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopSandbox$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopBuildBatch$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopBuild$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSandboxConnection$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSandbox$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCommandExecution$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startBuildBatch$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startBuild$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retryBuildBatch$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retryBuild$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSourceCredentials$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSharedReportGroups$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSharedProjects$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSandboxesForProject$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSandboxes$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReportsForReportGroup$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReports$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReportGroups$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProjects$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFleets$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCuratedEnvironmentImages$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCommandExecutionsForSandbox$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBuildsForProject$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBuilds$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBuildBatchesForProject$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBuildBatches$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$invalidateProjectCache$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importSourceCredentials$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReportGroupTrend$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTestCases$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCodeCoverages$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWebhook$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSourceCredentials$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReportGroup$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReport$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteProject$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFleet$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBuildBatch$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWebhook$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReportGroup$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createProject$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFleet$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetSandboxes$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetReports$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetReportGroups$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetProjects$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetFleets$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetCommandExecutions$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetBuilds$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetBuildBatches$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteBuilds$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

