/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the proxy rule for your reserved capacity instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetProxyRule implements SdkPojo, Serializable, ToCopyableBuilder<FleetProxyRule.Builder, FleetProxyRule> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FleetProxyRule::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("effect")
            .getter(getter(FleetProxyRule::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effect").build()).build();

    private static final SdkField<List<String>> ENTITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entities")
            .getter(getter(FleetProxyRule::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, EFFECT_FIELD,
            ENTITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String effect;

    private final List<String> entities;

    private FleetProxyRule(BuilderImpl builder) {
        this.type = builder.type;
        this.effect = builder.effect;
        this.entities = builder.entities;
    }

    /**
     * <p>
     * The type of proxy rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetProxyRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of proxy rule.
     * @see FleetProxyRuleType
     */
    public final FleetProxyRuleType type() {
        return FleetProxyRuleType.fromValue(type);
    }

    /**
     * <p>
     * The type of proxy rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetProxyRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of proxy rule.
     * @see FleetProxyRuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The behavior of the proxy rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link FleetProxyRuleEffectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #effectAsString}.
     * </p>
     * 
     * @return The behavior of the proxy rule.
     * @see FleetProxyRuleEffectType
     */
    public final FleetProxyRuleEffectType effect() {
        return FleetProxyRuleEffectType.fromValue(effect);
    }

    /**
     * <p>
     * The behavior of the proxy rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link FleetProxyRuleEffectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #effectAsString}.
     * </p>
     * 
     * @return The behavior of the proxy rule.
     * @see FleetProxyRuleEffectType
     */
    public final String effectAsString() {
        return effect;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination of the proxy rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return The destination of the proxy rule.
     */
    public final List<String> entities() {
        return entities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetProxyRule)) {
            return false;
        }
        FleetProxyRule other = (FleetProxyRule) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(effectAsString(), other.effectAsString())
                && hasEntities() == other.hasEntities() && Objects.equals(entities(), other.entities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetProxyRule").add("Type", typeAsString()).add("Effect", effectAsString())
                .add("Entities", hasEntities() ? entities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        case "entities":
            return Optional.ofNullable(clazz.cast(entities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("effect", EFFECT_FIELD);
        map.put("entities", ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetProxyRule, T> g) {
        return obj -> g.apply((FleetProxyRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetProxyRule> {
        /**
         * <p>
         * The type of proxy rule.
         * </p>
         * 
         * @param type
         *        The type of proxy rule.
         * @see FleetProxyRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetProxyRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of proxy rule.
         * </p>
         * 
         * @param type
         *        The type of proxy rule.
         * @see FleetProxyRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetProxyRuleType
         */
        Builder type(FleetProxyRuleType type);

        /**
         * <p>
         * The behavior of the proxy rule.
         * </p>
         * 
         * @param effect
         *        The behavior of the proxy rule.
         * @see FleetProxyRuleEffectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetProxyRuleEffectType
         */
        Builder effect(String effect);

        /**
         * <p>
         * The behavior of the proxy rule.
         * </p>
         * 
         * @param effect
         *        The behavior of the proxy rule.
         * @see FleetProxyRuleEffectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetProxyRuleEffectType
         */
        Builder effect(FleetProxyRuleEffectType effect);

        /**
         * <p>
         * The destination of the proxy rule.
         * </p>
         * 
         * @param entities
         *        The destination of the proxy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<String> entities);

        /**
         * <p>
         * The destination of the proxy rule.
         * </p>
         * 
         * @param entities
         *        The destination of the proxy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(String... entities);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String effect;

        private List<String> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetProxyRule model) {
            type(model.type);
            effect(model.effect);
            entities(model.entities);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetProxyRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getEffect() {
            return effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(FleetProxyRuleEffectType effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final Collection<String> getEntities() {
            if (entities instanceof SdkAutoConstructList) {
                return null;
            }
            return entities;
        }

        public final void setEntities(Collection<String> entities) {
            this.entities = FleetProxyRuleEntitiesCopier.copy(entities);
        }

        @Override
        public final Builder entities(Collection<String> entities) {
            this.entities = FleetProxyRuleEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(String... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        public FleetProxyRule build() {
            return new FleetProxyRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
