/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the compute fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetStatus implements SdkPojo, Serializable, ToCopyableBuilder<FleetStatus.Builder, FleetStatus> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(FleetStatus::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("context")
            .getter(getter(FleetStatus::contextAsString)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(FleetStatus::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD,
            CONTEXT_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String statusCodeValue;

    private final String context;

    private final String message;

    private FleetStatus(BuilderImpl builder) {
        this.statusCodeValue = builder.statusCodeValue;
        this.context = builder.context;
        this.message = builder.message;
    }

    /**
     * <p>
     * The status code of the compute fleet. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code>: The compute fleet is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code>: The compute fleet is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROTATING</code>: The compute fleet is being rotated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code>: The compute fleet is pending deletion.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: The compute fleet is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code>: The compute fleet has failed to create.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_ROLLBACK_FAILED</code>: The compute fleet has failed to update and could not rollback to previous
     * state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The compute fleet has succeeded and is active.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link FleetStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code of the compute fleet. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code>: The compute fleet is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code>: The compute fleet is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROTATING</code>: The compute fleet is being rotated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_DELETION</code>: The compute fleet is pending deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: The compute fleet is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code>: The compute fleet has failed to create.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_ROLLBACK_FAILED</code>: The compute fleet has failed to update and could not rollback to
     *         previous state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The compute fleet has succeeded and is active.
     *         </p>
     *         </li>
     * @see FleetStatusCode
     */
    public final FleetStatusCode statusCode() {
        return FleetStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * The status code of the compute fleet. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code>: The compute fleet is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code>: The compute fleet is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ROTATING</code>: The compute fleet is being rotated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code>: The compute fleet is pending deletion.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: The compute fleet is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code>: The compute fleet has failed to create.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_ROLLBACK_FAILED</code>: The compute fleet has failed to update and could not rollback to previous
     * state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The compute fleet has succeeded and is active.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link FleetStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code of the compute fleet. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code>: The compute fleet is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code>: The compute fleet is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ROTATING</code>: The compute fleet is being rotated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_DELETION</code>: The compute fleet is pending deletion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: The compute fleet is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code>: The compute fleet has failed to create.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_ROLLBACK_FAILED</code>: The compute fleet has failed to update and could not rollback to
     *         previous state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The compute fleet has succeeded and is active.
     *         </p>
     *         </li>
     * @see FleetStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    /**
     * <p>
     * Additional information about a compute fleet. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code>: The compute fleet has failed to create.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code>: The compute fleet has failed to update.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #context} will
     * return {@link FleetContextCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contextAsString}.
     * </p>
     * 
     * @return Additional information about a compute fleet. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code>: The compute fleet has failed to create.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code>: The compute fleet has failed to update.
     *         </p>
     *         </li>
     * @see FleetContextCode
     */
    public final FleetContextCode context() {
        return FleetContextCode.fromValue(context);
    }

    /**
     * <p>
     * Additional information about a compute fleet. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code>: The compute fleet has failed to create.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_FAILED</code>: The compute fleet has failed to update.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #context} will
     * return {@link FleetContextCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contextAsString}.
     * </p>
     * 
     * @return Additional information about a compute fleet. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code>: The compute fleet has failed to create.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_FAILED</code>: The compute fleet has failed to update.
     *         </p>
     *         </li>
     * @see FleetContextCode
     */
    public final String contextAsString() {
        return context;
    }

    /**
     * <p>
     * A message associated with the status of a compute fleet.
     * </p>
     * 
     * @return A message associated with the status of a compute fleet.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contextAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetStatus)) {
            return false;
        }
        FleetStatus other = (FleetStatus) obj;
        return Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(contextAsString(), other.contextAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetStatus").add("StatusCode", statusCodeAsString()).add("Context", contextAsString())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "context":
            return Optional.ofNullable(clazz.cast(contextAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("statusCode", STATUS_CODE_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetStatus, T> g) {
        return obj -> g.apply((FleetStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetStatus> {
        /**
         * <p>
         * The status code of the compute fleet. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code>: The compute fleet is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code>: The compute fleet is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROTATING</code>: The compute fleet is being rotated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_DELETION</code>: The compute fleet is pending deletion.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: The compute fleet is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code>: The compute fleet has failed to create.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_ROLLBACK_FAILED</code>: The compute fleet has failed to update and could not rollback to
         * previous state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The compute fleet has succeeded and is active.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusCodeValue
         *        The status code of the compute fleet. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code>: The compute fleet is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code>: The compute fleet is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROTATING</code>: The compute fleet is being rotated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_DELETION</code>: The compute fleet is pending deletion.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: The compute fleet is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code>: The compute fleet has failed to create.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_ROLLBACK_FAILED</code>: The compute fleet has failed to update and could not rollback to
         *        previous state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The compute fleet has succeeded and is active.
         *        </p>
         *        </li>
         * @see FleetStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The status code of the compute fleet. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code>: The compute fleet is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code>: The compute fleet is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ROTATING</code>: The compute fleet is being rotated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_DELETION</code>: The compute fleet is pending deletion.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: The compute fleet is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code>: The compute fleet has failed to create.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_ROLLBACK_FAILED</code>: The compute fleet has failed to update and could not rollback to
         * previous state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The compute fleet has succeeded and is active.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusCodeValue
         *        The status code of the compute fleet. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code>: The compute fleet is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code>: The compute fleet is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ROTATING</code>: The compute fleet is being rotated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_DELETION</code>: The compute fleet is pending deletion.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: The compute fleet is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code>: The compute fleet has failed to create.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_ROLLBACK_FAILED</code>: The compute fleet has failed to update and could not rollback to
         *        previous state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The compute fleet has succeeded and is active.
         *        </p>
         *        </li>
         * @see FleetStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatusCode
         */
        Builder statusCode(FleetStatusCode statusCodeValue);

        /**
         * <p>
         * Additional information about a compute fleet. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code>: The compute fleet has failed to create.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code>: The compute fleet has failed to update.
         * </p>
         * </li>
         * </ul>
         * 
         * @param context
         *        Additional information about a compute fleet. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code>: The compute fleet has failed to create.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code>: The compute fleet has failed to update.
         *        </p>
         *        </li>
         * @see FleetContextCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetContextCode
         */
        Builder context(String context);

        /**
         * <p>
         * Additional information about a compute fleet. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code>: The compute fleet has failed to create.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_FAILED</code>: The compute fleet has failed to update.
         * </p>
         * </li>
         * </ul>
         * 
         * @param context
         *        Additional information about a compute fleet. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code>: The compute fleet has failed to create.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_FAILED</code>: The compute fleet has failed to update.
         *        </p>
         *        </li>
         * @see FleetContextCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetContextCode
         */
        Builder context(FleetContextCode context);

        /**
         * <p>
         * A message associated with the status of a compute fleet.
         * </p>
         * 
         * @param message
         *        A message associated with the status of a compute fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String statusCodeValue;

        private String context;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetStatus model) {
            statusCode(model.statusCodeValue);
            context(model.context);
            message(model.message);
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(FleetStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        @Override
        public final Builder context(FleetContextCode context) {
            this.context(context == null ? null : context.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public FleetStatus build() {
            return new FleetStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
