/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCommandExecutionResponse extends CodeBuildResponse implements
        ToCopyableBuilder<StartCommandExecutionResponse.Builder, StartCommandExecutionResponse> {
    private static final SdkField<CommandExecution> COMMAND_EXECUTION_FIELD = SdkField
            .<CommandExecution> builder(MarshallingType.SDK_POJO).memberName("commandExecution")
            .getter(getter(StartCommandExecutionResponse::commandExecution)).setter(setter(Builder::commandExecution))
            .constructor(CommandExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandExecution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_EXECUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CommandExecution commandExecution;

    private StartCommandExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.commandExecution = builder.commandExecution;
    }

    /**
     * <p>
     * Information about the requested command executions.
     * </p>
     * 
     * @return Information about the requested command executions.
     */
    public final CommandExecution commandExecution() {
        return commandExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commandExecution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCommandExecutionResponse)) {
            return false;
        }
        StartCommandExecutionResponse other = (StartCommandExecutionResponse) obj;
        return Objects.equals(commandExecution(), other.commandExecution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCommandExecutionResponse").add("CommandExecution", commandExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commandExecution":
            return Optional.ofNullable(clazz.cast(commandExecution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commandExecution", COMMAND_EXECUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCommandExecutionResponse, T> g) {
        return obj -> g.apply((StartCommandExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartCommandExecutionResponse> {
        /**
         * <p>
         * Information about the requested command executions.
         * </p>
         * 
         * @param commandExecution
         *        Information about the requested command executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandExecution(CommandExecution commandExecution);

        /**
         * <p>
         * Information about the requested command executions.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommandExecution.Builder} avoiding the
         * need to create one manually via {@link CommandExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommandExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #commandExecution(CommandExecution)}.
         * 
         * @param commandExecution
         *        a consumer that will call methods on {@link CommandExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commandExecution(CommandExecution)
         */
        default Builder commandExecution(Consumer<CommandExecution.Builder> commandExecution) {
            return commandExecution(CommandExecution.builder().applyMutation(commandExecution).build());
        }
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private CommandExecution commandExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCommandExecutionResponse model) {
            super(model);
            commandExecution(model.commandExecution);
        }

        public final CommandExecution.Builder getCommandExecution() {
            return commandExecution != null ? commandExecution.toBuilder() : null;
        }

        public final void setCommandExecution(CommandExecution.BuilderImpl commandExecution) {
            this.commandExecution = commandExecution != null ? commandExecution.build() : null;
        }

        @Override
        public final Builder commandExecution(CommandExecution commandExecution) {
            this.commandExecution = commandExecution;
            return this;
        }

        @Override
        public StartCommandExecutionResponse build() {
            return new StartCommandExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
