/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains command execution information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommandExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<CommandExecution.Builder, CommandExecution> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CommandExecution::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> SANDBOX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sandboxId").getter(getter(CommandExecution::sandboxId)).setter(setter(Builder::sandboxId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxId").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("submitTime").getter(getter(CommandExecution::submitTime)).setter(setter(Builder::submitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(CommandExecution::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(CommandExecution::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CommandExecution::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> COMMAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("command")
            .getter(getter(CommandExecution::command)).setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CommandExecution::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> EXIT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exitCode").getter(getter(CommandExecution::exitCode)).setter(setter(Builder::exitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()).build();

    private static final SdkField<String> STANDARD_OUTPUT_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("standardOutputContent").getter(getter(CommandExecution::standardOutputContent))
            .setter(setter(Builder::standardOutputContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardOutputContent").build())
            .build();

    private static final SdkField<String> STANDARD_ERR_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("standardErrContent").getter(getter(CommandExecution::standardErrContent))
            .setter(setter(Builder::standardErrContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardErrContent").build())
            .build();

    private static final SdkField<LogsLocation> LOGS_FIELD = SdkField.<LogsLocation> builder(MarshallingType.SDK_POJO)
            .memberName("logs").getter(getter(CommandExecution::logs)).setter(setter(Builder::logs))
            .constructor(LogsLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()).build();

    private static final SdkField<String> SANDBOX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sandboxArn").getter(getter(CommandExecution::sandboxArn)).setter(setter(Builder::sandboxArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SANDBOX_ID_FIELD,
            SUBMIT_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, COMMAND_FIELD, TYPE_FIELD, EXIT_CODE_FIELD,
            STANDARD_OUTPUT_CONTENT_FIELD, STANDARD_ERR_CONTENT_FIELD, LOGS_FIELD, SANDBOX_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String sandboxId;

    private final Instant submitTime;

    private final Instant startTime;

    private final Instant endTime;

    private final String status;

    private final String command;

    private final String type;

    private final String exitCode;

    private final String standardOutputContent;

    private final String standardErrContent;

    private final LogsLocation logs;

    private final String sandboxArn;

    private CommandExecution(BuilderImpl builder) {
        this.id = builder.id;
        this.sandboxId = builder.sandboxId;
        this.submitTime = builder.submitTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.command = builder.command;
        this.type = builder.type;
        this.exitCode = builder.exitCode;
        this.standardOutputContent = builder.standardOutputContent;
        this.standardErrContent = builder.standardErrContent;
        this.logs = builder.logs;
        this.sandboxArn = builder.sandboxArn;
    }

    /**
     * <p>
     * The ID of the command execution.
     * </p>
     * 
     * @return The ID of the command execution.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A <code>sandboxId</code>.
     * </p>
     * 
     * @return A <code>sandboxId</code>.
     */
    public final String sandboxId() {
        return sandboxId;
    }

    /**
     * <p>
     * When the command execution process was initially submitted, expressed in Unix time format.
     * </p>
     * 
     * @return When the command execution process was initially submitted, expressed in Unix time format.
     */
    public final Instant submitTime() {
        return submitTime;
    }

    /**
     * <p>
     * When the command execution process started, expressed in Unix time format.
     * </p>
     * 
     * @return When the command execution process started, expressed in Unix time format.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * When the command execution process ended, expressed in Unix time format.
     * </p>
     * 
     * @return When the command execution process ended, expressed in Unix time format.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The status of the command execution.
     * </p>
     * 
     * @return The status of the command execution.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The command that needs to be executed.
     * </p>
     * 
     * @return The command that needs to be executed.
     */
    public final String command() {
        return command;
    }

    /**
     * <p>
     * The command type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CommandType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The command type.
     * @see CommandType
     */
    public final CommandType type() {
        return CommandType.fromValue(type);
    }

    /**
     * <p>
     * The command type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CommandType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The command type.
     * @see CommandType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The exit code to return upon completion.
     * </p>
     * 
     * @return The exit code to return upon completion.
     */
    public final String exitCode() {
        return exitCode;
    }

    /**
     * <p>
     * The text written by the command to stdout.
     * </p>
     * 
     * @return The text written by the command to stdout.
     */
    public final String standardOutputContent() {
        return standardOutputContent;
    }

    /**
     * <p>
     * The text written by the command to stderr.
     * </p>
     * 
     * @return The text written by the command to stderr.
     */
    public final String standardErrContent() {
        return standardErrContent;
    }

    /**
     * Returns the value of the Logs property for this object.
     * 
     * @return The value of the Logs property for this object.
     */
    public final LogsLocation logs() {
        return logs;
    }

    /**
     * <p>
     * A <code>sandboxArn</code>.
     * </p>
     * 
     * @return A <code>sandboxArn</code>.
     */
    public final String sandboxArn() {
        return sandboxArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(sandboxId());
        hashCode = 31 * hashCode + Objects.hashCode(submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(standardOutputContent());
        hashCode = 31 * hashCode + Objects.hashCode(standardErrContent());
        hashCode = 31 * hashCode + Objects.hashCode(logs());
        hashCode = 31 * hashCode + Objects.hashCode(sandboxArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandExecution)) {
            return false;
        }
        CommandExecution other = (CommandExecution) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(sandboxId(), other.sandboxId())
                && Objects.equals(submitTime(), other.submitTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(status(), other.status())
                && Objects.equals(command(), other.command()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(exitCode(), other.exitCode())
                && Objects.equals(standardOutputContent(), other.standardOutputContent())
                && Objects.equals(standardErrContent(), other.standardErrContent()) && Objects.equals(logs(), other.logs())
                && Objects.equals(sandboxArn(), other.sandboxArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommandExecution").add("Id", id()).add("SandboxId", sandboxId()).add("SubmitTime", submitTime())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("Status", status())
                .add("Command", command() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("ExitCode", exitCode())
                .add("StandardOutputContent", standardOutputContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StandardErrContent", standardErrContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Logs", logs()).add("SandboxArn", sandboxArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "sandboxId":
            return Optional.ofNullable(clazz.cast(sandboxId()));
        case "submitTime":
            return Optional.ofNullable(clazz.cast(submitTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "exitCode":
            return Optional.ofNullable(clazz.cast(exitCode()));
        case "standardOutputContent":
            return Optional.ofNullable(clazz.cast(standardOutputContent()));
        case "standardErrContent":
            return Optional.ofNullable(clazz.cast(standardErrContent()));
        case "logs":
            return Optional.ofNullable(clazz.cast(logs()));
        case "sandboxArn":
            return Optional.ofNullable(clazz.cast(sandboxArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("sandboxId", SANDBOX_ID_FIELD);
        map.put("submitTime", SUBMIT_TIME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("exitCode", EXIT_CODE_FIELD);
        map.put("standardOutputContent", STANDARD_OUTPUT_CONTENT_FIELD);
        map.put("standardErrContent", STANDARD_ERR_CONTENT_FIELD);
        map.put("logs", LOGS_FIELD);
        map.put("sandboxArn", SANDBOX_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandExecution, T> g) {
        return obj -> g.apply((CommandExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommandExecution> {
        /**
         * <p>
         * The ID of the command execution.
         * </p>
         * 
         * @param id
         *        The ID of the command execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A <code>sandboxId</code>.
         * </p>
         * 
         * @param sandboxId
         *        A <code>sandboxId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sandboxId(String sandboxId);

        /**
         * <p>
         * When the command execution process was initially submitted, expressed in Unix time format.
         * </p>
         * 
         * @param submitTime
         *        When the command execution process was initially submitted, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTime(Instant submitTime);

        /**
         * <p>
         * When the command execution process started, expressed in Unix time format.
         * </p>
         * 
         * @param startTime
         *        When the command execution process started, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * When the command execution process ended, expressed in Unix time format.
         * </p>
         * 
         * @param endTime
         *        When the command execution process ended, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The status of the command execution.
         * </p>
         * 
         * @param status
         *        The status of the command execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The command that needs to be executed.
         * </p>
         * 
         * @param command
         *        The command that needs to be executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String command);

        /**
         * <p>
         * The command type.
         * </p>
         * 
         * @param type
         *        The command type.
         * @see CommandType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandType
         */
        Builder type(String type);

        /**
         * <p>
         * The command type.
         * </p>
         * 
         * @param type
         *        The command type.
         * @see CommandType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandType
         */
        Builder type(CommandType type);

        /**
         * <p>
         * The exit code to return upon completion.
         * </p>
         * 
         * @param exitCode
         *        The exit code to return upon completion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitCode(String exitCode);

        /**
         * <p>
         * The text written by the command to stdout.
         * </p>
         * 
         * @param standardOutputContent
         *        The text written by the command to stdout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutputContent(String standardOutputContent);

        /**
         * <p>
         * The text written by the command to stderr.
         * </p>
         * 
         * @param standardErrContent
         *        The text written by the command to stderr.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardErrContent(String standardErrContent);

        /**
         * Sets the value of the Logs property for this object.
         *
         * @param logs
         *        The new value for the Logs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(LogsLocation logs);

        /**
         * Sets the value of the Logs property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LogsLocation.Builder} avoiding the need
         * to create one manually via {@link LogsLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogsLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #logs(LogsLocation)}.
         * 
         * @param logs
         *        a consumer that will call methods on {@link LogsLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logs(LogsLocation)
         */
        default Builder logs(Consumer<LogsLocation.Builder> logs) {
            return logs(LogsLocation.builder().applyMutation(logs).build());
        }

        /**
         * <p>
         * A <code>sandboxArn</code>.
         * </p>
         * 
         * @param sandboxArn
         *        A <code>sandboxArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sandboxArn(String sandboxArn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String sandboxId;

        private Instant submitTime;

        private Instant startTime;

        private Instant endTime;

        private String status;

        private String command;

        private String type;

        private String exitCode;

        private String standardOutputContent;

        private String standardErrContent;

        private LogsLocation logs;

        private String sandboxArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandExecution model) {
            id(model.id);
            sandboxId(model.sandboxId);
            submitTime(model.submitTime);
            startTime(model.startTime);
            endTime(model.endTime);
            status(model.status);
            command(model.command);
            type(model.type);
            exitCode(model.exitCode);
            standardOutputContent(model.standardOutputContent);
            standardErrContent(model.standardErrContent);
            logs(model.logs);
            sandboxArn(model.sandboxArn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSandboxId() {
            return sandboxId;
        }

        public final void setSandboxId(String sandboxId) {
            this.sandboxId = sandboxId;
        }

        @Override
        public final Builder sandboxId(String sandboxId) {
            this.sandboxId = sandboxId;
            return this;
        }

        public final Instant getSubmitTime() {
            return submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getCommand() {
            return command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CommandType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getExitCode() {
            return exitCode;
        }

        public final void setExitCode(String exitCode) {
            this.exitCode = exitCode;
        }

        @Override
        public final Builder exitCode(String exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final String getStandardOutputContent() {
            return standardOutputContent;
        }

        public final void setStandardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
        }

        @Override
        public final Builder standardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
            return this;
        }

        public final String getStandardErrContent() {
            return standardErrContent;
        }

        public final void setStandardErrContent(String standardErrContent) {
            this.standardErrContent = standardErrContent;
        }

        @Override
        public final Builder standardErrContent(String standardErrContent) {
            this.standardErrContent = standardErrContent;
            return this;
        }

        public final LogsLocation.Builder getLogs() {
            return logs != null ? logs.toBuilder() : null;
        }

        public final void setLogs(LogsLocation.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public final Builder logs(LogsLocation logs) {
            this.logs = logs;
            return this;
        }

        public final String getSandboxArn() {
            return sandboxArn;
        }

        public final void setSandboxArn(String sandboxArn) {
            this.sandboxArn = sandboxArn;
        }

        @Override
        public final Builder sandboxArn(String sandboxArn) {
            this.sandboxArn = sandboxArn;
            return this;
        }

        @Override
        public CommandExecution build() {
            return new CommandExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
