/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReportsResponse extends CodeBuildResponse implements
        ToCopyableBuilder<ListReportsResponse.Builder, ListReportsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> REPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("reports")
            .getter(getter(ListReportsResponse::reports))
            .setter(setter(Builder::reports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REPORTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<String> reports;

    private ListReportsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reports = builder.reports;
    }

    /**
     * <p>
     * During a previous call, the maximum number of items that can be returned is the value specified in
     * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
     * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
     * call. To get all of the items in the list, keep calling this operation with each subsequent next token that is
     * returned, until no more next tokens are returned.
     * </p>
     * 
     * @return During a previous call, the maximum number of items that can be returned is the value specified in
     *         <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
     *         is returned. To get the next batch of items in the list, call this operation again, adding the next token
     *         to the call. To get all of the items in the list, keep calling this operation with each subsequent next
     *         token that is returned, until no more next tokens are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Reports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReports() {
        return reports != null && !(reports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of returned ARNs for the reports in the current Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReports} method.
     * </p>
     * 
     * @return The list of returned ARNs for the reports in the current Amazon Web Services account.
     */
    public final List<String> reports() {
        return reports;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasReports() ? reports() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportsResponse)) {
            return false;
        }
        ListReportsResponse other = (ListReportsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasReports() == other.hasReports()
                && Objects.equals(reports(), other.reports());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReportsResponse").add("NextToken", nextToken())
                .add("Reports", hasReports() ? reports() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "reports":
            return Optional.ofNullable(clazz.cast(reports()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("reports", REPORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReportsResponse, T> g) {
        return obj -> g.apply((ListReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReportsResponse> {
        /**
         * <p>
         * During a previous call, the maximum number of items that can be returned is the value specified in
         * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
         * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
         * call. To get all of the items in the list, keep calling this operation with each subsequent next token that
         * is returned, until no more next tokens are returned.
         * </p>
         * 
         * @param nextToken
         *        During a previous call, the maximum number of items that can be returned is the value specified in
         *        <code>maxResults</code>. If there more items in the list, then a unique string called a
         *        <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again,
         *        adding the next token to the call. To get all of the items in the list, keep calling this operation
         *        with each subsequent next token that is returned, until no more next tokens are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of returned ARNs for the reports in the current Amazon Web Services account.
         * </p>
         * 
         * @param reports
         *        The list of returned ARNs for the reports in the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(Collection<String> reports);

        /**
         * <p>
         * The list of returned ARNs for the reports in the current Amazon Web Services account.
         * </p>
         * 
         * @param reports
         *        The list of returned ARNs for the reports in the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reports(String... reports);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> reports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportsResponse model) {
            super(model);
            nextToken(model.nextToken);
            reports(model.reports);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getReports() {
            if (reports instanceof SdkAutoConstructList) {
                return null;
            }
            return reports;
        }

        public final void setReports(Collection<String> reports) {
            this.reports = ReportArnsCopier.copy(reports);
        }

        @Override
        public final Builder reports(Collection<String> reports) {
            this.reports = ReportArnsCopier.copy(reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(String... reports) {
            reports(Arrays.asList(reports));
            return this;
        }

        @Override
        public ListReportsResponse build() {
            return new ListReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
