/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSandboxConnectionResponse extends CodeBuildResponse implements
        ToCopyableBuilder<StartSandboxConnectionResponse.Builder, StartSandboxConnectionResponse> {
    private static final SdkField<SSMSession> SSM_SESSION_FIELD = SdkField.<SSMSession> builder(MarshallingType.SDK_POJO)
            .memberName("ssmSession").getter(getter(StartSandboxConnectionResponse::ssmSession))
            .setter(setter(Builder::ssmSession)).constructor(SSMSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmSession").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSM_SESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SSMSession ssmSession;

    private StartSandboxConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.ssmSession = builder.ssmSession;
    }

    /**
     * <p>
     * Information about the Session Manager session.
     * </p>
     * 
     * @return Information about the Session Manager session.
     */
    public final SSMSession ssmSession() {
        return ssmSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ssmSession());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSandboxConnectionResponse)) {
            return false;
        }
        StartSandboxConnectionResponse other = (StartSandboxConnectionResponse) obj;
        return Objects.equals(ssmSession(), other.ssmSession());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSandboxConnectionResponse").add("SsmSession", ssmSession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ssmSession":
            return Optional.ofNullable(clazz.cast(ssmSession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ssmSession", SSM_SESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSandboxConnectionResponse, T> g) {
        return obj -> g.apply((StartSandboxConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartSandboxConnectionResponse> {
        /**
         * <p>
         * Information about the Session Manager session.
         * </p>
         * 
         * @param ssmSession
         *        Information about the Session Manager session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmSession(SSMSession ssmSession);

        /**
         * <p>
         * Information about the Session Manager session.
         * </p>
         * This is a convenience method that creates an instance of the {@link SSMSession.Builder} avoiding the need to
         * create one manually via {@link SSMSession#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSMSession.Builder#build()} is called immediately and its result
         * is passed to {@link #ssmSession(SSMSession)}.
         * 
         * @param ssmSession
         *        a consumer that will call methods on {@link SSMSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmSession(SSMSession)
         */
        default Builder ssmSession(Consumer<SSMSession.Builder> ssmSession) {
            return ssmSession(SSMSession.builder().applyMutation(ssmSession).build());
        }
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private SSMSession ssmSession;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSandboxConnectionResponse model) {
            super(model);
            ssmSession(model.ssmSession);
        }

        public final SSMSession.Builder getSsmSession() {
            return ssmSession != null ? ssmSession.toBuilder() : null;
        }

        public final void setSsmSession(SSMSession.BuilderImpl ssmSession) {
            this.ssmSession = ssmSession != null ? ssmSession.build() : null;
        }

        @Override
        public final Builder ssmSession(SSMSession ssmSession) {
            this.ssmSession = ssmSession;
            return this;
        }

        @Override
        public StartSandboxConnectionResponse build() {
            return new StartSandboxConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
