/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopSandboxResponse extends CodeBuildResponse implements
        ToCopyableBuilder<StopSandboxResponse.Builder, StopSandboxResponse> {
    private static final SdkField<Sandbox> SANDBOX_FIELD = SdkField.<Sandbox> builder(MarshallingType.SDK_POJO)
            .memberName("sandbox").getter(getter(StopSandboxResponse::sandbox)).setter(setter(Builder::sandbox))
            .constructor(Sandbox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandbox").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SANDBOX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Sandbox sandbox;

    private StopSandboxResponse(BuilderImpl builder) {
        super(builder);
        this.sandbox = builder.sandbox;
    }

    /**
     * <p>
     * Information about the requested sandbox.
     * </p>
     * 
     * @return Information about the requested sandbox.
     */
    public final Sandbox sandbox() {
        return sandbox;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sandbox());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopSandboxResponse)) {
            return false;
        }
        StopSandboxResponse other = (StopSandboxResponse) obj;
        return Objects.equals(sandbox(), other.sandbox());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopSandboxResponse").add("Sandbox", sandbox()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sandbox":
            return Optional.ofNullable(clazz.cast(sandbox()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sandbox", SANDBOX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopSandboxResponse, T> g) {
        return obj -> g.apply((StopSandboxResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopSandboxResponse> {
        /**
         * <p>
         * Information about the requested sandbox.
         * </p>
         * 
         * @param sandbox
         *        Information about the requested sandbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sandbox(Sandbox sandbox);

        /**
         * <p>
         * Information about the requested sandbox.
         * </p>
         * This is a convenience method that creates an instance of the {@link Sandbox.Builder} avoiding the need to
         * create one manually via {@link Sandbox#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sandbox.Builder#build()} is called immediately and its result is
         * passed to {@link #sandbox(Sandbox)}.
         * 
         * @param sandbox
         *        a consumer that will call methods on {@link Sandbox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sandbox(Sandbox)
         */
        default Builder sandbox(Consumer<Sandbox.Builder> sandbox) {
            return sandbox(Sandbox.builder().applyMutation(sandbox).build());
        }
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private Sandbox sandbox;

        private BuilderImpl() {
        }

        private BuilderImpl(StopSandboxResponse model) {
            super(model);
            sandbox(model.sandbox);
        }

        public final Sandbox.Builder getSandbox() {
            return sandbox != null ? sandbox.toBuilder() : null;
        }

        public final void setSandbox(Sandbox.BuilderImpl sandbox) {
            this.sandbox = sandbox != null ? sandbox.build() : null;
        }

        @Override
        public final Builder sandbox(Sandbox sandbox) {
            this.sandbox = sandbox;
            return this;
        }

        @Override
        public StopSandboxResponse build() {
            return new StopSandboxResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
