/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecatalyst.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowResponse extends CodeCatalystResponse implements
        ToCopyableBuilder<GetWorkflowResponse.Builder, GetWorkflowResponse> {
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spaceName").getter(getter(GetWorkflowResponse::spaceName)).setter(setter(Builder::spaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceName").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(GetWorkflowResponse::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetWorkflowResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetWorkflowResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceRepositoryName").getter(getter(GetWorkflowResponse::sourceRepositoryName))
            .setter(setter(Builder::sourceRepositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRepositoryName").build())
            .build();

    private static final SdkField<String> SOURCE_BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceBranchName").getter(getter(GetWorkflowResponse::sourceBranchName))
            .setter(setter(Builder::sourceBranchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceBranchName").build()).build();

    private static final SdkField<WorkflowDefinition> DEFINITION_FIELD = SdkField
            .<WorkflowDefinition> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(GetWorkflowResponse::definition)).setter(setter(Builder::definition))
            .constructor(WorkflowDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime")
            .getter(getter(GetWorkflowResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime")
            .getter(getter(GetWorkflowResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> RUN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runMode").getter(getter(GetWorkflowResponse::runModeAsString)).setter(setter(Builder::runMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runMode").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetWorkflowResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_NAME_FIELD,
            PROJECT_NAME_FIELD, ID_FIELD, NAME_FIELD, SOURCE_REPOSITORY_NAME_FIELD, SOURCE_BRANCH_NAME_FIELD, DEFINITION_FIELD,
            CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, RUN_MODE_FIELD, STATUS_FIELD));

    private final String spaceName;

    private final String projectName;

    private final String id;

    private final String name;

    private final String sourceRepositoryName;

    private final String sourceBranchName;

    private final WorkflowDefinition definition;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String runMode;

    private final String status;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.id = builder.id;
        this.name = builder.name;
        this.sourceRepositoryName = builder.sourceRepositoryName;
        this.sourceBranchName = builder.sourceBranchName;
        this.definition = builder.definition;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.runMode = builder.runMode;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the space.
     * </p>
     * 
     * @return The name of the space.
     */
    public final String spaceName() {
        return spaceName;
    }

    /**
     * <p>
     * The name of the project in the space.
     * </p>
     * 
     * @return The name of the project in the space.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The ID of the workflow.
     * </p>
     * 
     * @return The ID of the workflow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the source repository where the workflow YAML is stored.
     * </p>
     * 
     * @return The name of the source repository where the workflow YAML is stored.
     */
    public final String sourceRepositoryName() {
        return sourceRepositoryName;
    }

    /**
     * <p>
     * The name of the branch that contains the workflow YAML.
     * </p>
     * 
     * @return The name of the branch that contains the workflow YAML.
     */
    public final String sourceBranchName() {
        return sourceBranchName;
    }

    /**
     * <p>
     * Information about the workflow definition file for the workflow.
     * </p>
     * 
     * @return Information about the workflow definition file for the workflow.
     */
    public final WorkflowDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as specified in
     * <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
     * </p>
     * 
     * @return The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as
     *         specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as
     * specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
     * </p>
     * 
     * @return The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as
     *         specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The behavior to use when multiple workflows occur at the same time. For more information, see <a
     * href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html"
     * >https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html</a> in the Amazon
     * CodeCatalyst User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runMode} will
     * return {@link WorkflowRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runModeAsString}.
     * </p>
     * 
     * @return The behavior to use when multiple workflows occur at the same time. For more information, see <a
     *         href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html"
     *         >https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html</a> in the
     *         Amazon CodeCatalyst User Guide.
     * @see WorkflowRunMode
     */
    public final WorkflowRunMode runMode() {
        return WorkflowRunMode.fromValue(runMode);
    }

    /**
     * <p>
     * The behavior to use when multiple workflows occur at the same time. For more information, see <a
     * href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html"
     * >https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html</a> in the Amazon
     * CodeCatalyst User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runMode} will
     * return {@link WorkflowRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runModeAsString}.
     * </p>
     * 
     * @return The behavior to use when multiple workflows occur at the same time. For more information, see <a
     *         href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html"
     *         >https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html</a> in the
     *         Amazon CodeCatalyst User Guide.
     * @see WorkflowRunMode
     */
    public final String runModeAsString() {
        return runMode;
    }

    /**
     * <p>
     * The status of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the workflow.
     * @see WorkflowStatus
     */
    public final WorkflowStatus status() {
        return WorkflowStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the workflow.
     * @see WorkflowStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRepositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBranchName());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(runModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse) obj;
        return Objects.equals(spaceName(), other.spaceName()) && Objects.equals(projectName(), other.projectName())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(sourceRepositoryName(), other.sourceRepositoryName())
                && Objects.equals(sourceBranchName(), other.sourceBranchName())
                && Objects.equals(definition(), other.definition()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(runModeAsString(), other.runModeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowResponse").add("SpaceName", spaceName()).add("ProjectName", projectName())
                .add("Id", id()).add("Name", name()).add("SourceRepositoryName", sourceRepositoryName())
                .add("SourceBranchName", sourceBranchName()).add("Definition", definition()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("RunMode", runModeAsString()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "spaceName":
            return Optional.ofNullable(clazz.cast(spaceName()));
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sourceRepositoryName":
            return Optional.ofNullable(clazz.cast(sourceRepositoryName()));
        case "sourceBranchName":
            return Optional.ofNullable(clazz.cast(sourceBranchName()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "runMode":
            return Optional.ofNullable(clazz.cast(runModeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCatalystResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowResponse> {
        /**
         * <p>
         * The name of the space.
         * </p>
         * 
         * @param spaceName
         *        The name of the space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceName(String spaceName);

        /**
         * <p>
         * The name of the project in the space.
         * </p>
         * 
         * @param projectName
         *        The name of the project in the space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The ID of the workflow.
         * </p>
         * 
         * @param id
         *        The ID of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the workflow.
         * </p>
         * 
         * @param name
         *        The name of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the source repository where the workflow YAML is stored.
         * </p>
         * 
         * @param sourceRepositoryName
         *        The name of the source repository where the workflow YAML is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRepositoryName(String sourceRepositoryName);

        /**
         * <p>
         * The name of the branch that contains the workflow YAML.
         * </p>
         * 
         * @param sourceBranchName
         *        The name of the branch that contains the workflow YAML.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBranchName(String sourceBranchName);

        /**
         * <p>
         * Information about the workflow definition file for the workflow.
         * </p>
         * 
         * @param definition
         *        Information about the workflow definition file for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(WorkflowDefinition definition);

        /**
         * <p>
         * Information about the workflow definition file for the workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowDefinition.Builder} avoiding the
         * need to create one manually via {@link WorkflowDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(WorkflowDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link WorkflowDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(WorkflowDefinition)
         */
        default Builder definition(Consumer<WorkflowDefinition.Builder> definition) {
            return definition(WorkflowDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as specified
         * in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
         * </p>
         * 
         * @param createdTime
         *        The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as
         *        specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as
         * specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format
         *        as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The behavior to use when multiple workflows occur at the same time. For more information, see <a
         * href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html"
         * >https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html</a> in the Amazon
         * CodeCatalyst User Guide.
         * </p>
         * 
         * @param runMode
         *        The behavior to use when multiple workflows occur at the same time. For more information, see <a
         *        href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html"
         *        >https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html</a> in the
         *        Amazon CodeCatalyst User Guide.
         * @see WorkflowRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowRunMode
         */
        Builder runMode(String runMode);

        /**
         * <p>
         * The behavior to use when multiple workflows occur at the same time. For more information, see <a
         * href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html"
         * >https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html</a> in the Amazon
         * CodeCatalyst User Guide.
         * </p>
         * 
         * @param runMode
         *        The behavior to use when multiple workflows occur at the same time. For more information, see <a
         *        href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html"
         *        >https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html</a> in the
         *        Amazon CodeCatalyst User Guide.
         * @see WorkflowRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowRunMode
         */
        Builder runMode(WorkflowRunMode runMode);

        /**
         * <p>
         * The status of the workflow.
         * </p>
         * 
         * @param status
         *        The status of the workflow.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the workflow.
         * </p>
         * 
         * @param status
         *        The status of the workflow.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder status(WorkflowStatus status);
    }

    static final class BuilderImpl extends CodeCatalystResponse.BuilderImpl implements Builder {
        private String spaceName;

        private String projectName;

        private String id;

        private String name;

        private String sourceRepositoryName;

        private String sourceBranchName;

        private WorkflowDefinition definition;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String runMode;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            spaceName(model.spaceName);
            projectName(model.projectName);
            id(model.id);
            name(model.name);
            sourceRepositoryName(model.sourceRepositoryName);
            sourceBranchName(model.sourceBranchName);
            definition(model.definition);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            runMode(model.runMode);
            status(model.status);
        }

        public final String getSpaceName() {
            return spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceRepositoryName() {
            return sourceRepositoryName;
        }

        public final void setSourceRepositoryName(String sourceRepositoryName) {
            this.sourceRepositoryName = sourceRepositoryName;
        }

        @Override
        public final Builder sourceRepositoryName(String sourceRepositoryName) {
            this.sourceRepositoryName = sourceRepositoryName;
            return this;
        }

        public final String getSourceBranchName() {
            return sourceBranchName;
        }

        public final void setSourceBranchName(String sourceBranchName) {
            this.sourceBranchName = sourceBranchName;
        }

        @Override
        public final Builder sourceBranchName(String sourceBranchName) {
            this.sourceBranchName = sourceBranchName;
            return this;
        }

        public final WorkflowDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(WorkflowDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(WorkflowDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getRunMode() {
            return runMode;
        }

        public final void setRunMode(String runMode) {
            this.runMode = runMode;
        }

        @Override
        public final Builder runMode(String runMode) {
            this.runMode = runMode;
            return this;
        }

        @Override
        public final Builder runMode(WorkflowRunMode runMode) {
            this.runMode(runMode == null ? null : runMode.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
