/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecatalyst.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowSummary implements SdkPojo, Serializable, ToCopyableBuilder<WorkflowSummary.Builder, WorkflowSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(WorkflowSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(WorkflowSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceRepositoryName").getter(getter(WorkflowSummary::sourceRepositoryName))
            .setter(setter(Builder::sourceRepositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRepositoryName").build())
            .build();

    private static final SdkField<String> SOURCE_BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceBranchName").getter(getter(WorkflowSummary::sourceBranchName))
            .setter(setter(Builder::sourceBranchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceBranchName").build()).build();

    private static final SdkField<WorkflowDefinitionSummary> DEFINITION_FIELD = SdkField
            .<WorkflowDefinitionSummary> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(WorkflowSummary::definition)).setter(setter(Builder::definition))
            .constructor(WorkflowDefinitionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime")
            .getter(getter(WorkflowSummary::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime")
            .getter(getter(WorkflowSummary::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> RUN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runMode").getter(getter(WorkflowSummary::runModeAsString)).setter(setter(Builder::runMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runMode").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorkflowSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            SOURCE_REPOSITORY_NAME_FIELD, SOURCE_BRANCH_NAME_FIELD, DEFINITION_FIELD, CREATED_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, RUN_MODE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String sourceRepositoryName;

    private final String sourceBranchName;

    private final WorkflowDefinitionSummary definition;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String runMode;

    private final String status;

    private WorkflowSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.sourceRepositoryName = builder.sourceRepositoryName;
        this.sourceBranchName = builder.sourceBranchName;
        this.definition = builder.definition;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.runMode = builder.runMode;
        this.status = builder.status;
    }

    /**
     * <p>
     * The system-generated unique ID of a workflow.
     * </p>
     * 
     * @return The system-generated unique ID of a workflow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the source repository where the workflow definition file is stored.
     * </p>
     * 
     * @return The name of the source repository where the workflow definition file is stored.
     */
    public final String sourceRepositoryName() {
        return sourceRepositoryName;
    }

    /**
     * <p>
     * The name of the branch of the source repository where the workflow definition file is stored.
     * </p>
     * 
     * @return The name of the branch of the source repository where the workflow definition file is stored.
     */
    public final String sourceBranchName() {
        return sourceBranchName;
    }

    /**
     * <p>
     * Information about the workflow definition file.
     * </p>
     * 
     * @return Information about the workflow definition file.
     */
    public final WorkflowDefinitionSummary definition() {
        return definition;
    }

    /**
     * <p>
     * The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as specified in
     * <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
     * </p>
     * 
     * @return The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as
     *         specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as
     * specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
     * </p>
     * 
     * @return The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as
     *         specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The run mode of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runMode} will
     * return {@link WorkflowRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runModeAsString}.
     * </p>
     * 
     * @return The run mode of the workflow.
     * @see WorkflowRunMode
     */
    public final WorkflowRunMode runMode() {
        return WorkflowRunMode.fromValue(runMode);
    }

    /**
     * <p>
     * The run mode of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runMode} will
     * return {@link WorkflowRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runModeAsString}.
     * </p>
     * 
     * @return The run mode of the workflow.
     * @see WorkflowRunMode
     */
    public final String runModeAsString() {
        return runMode;
    }

    /**
     * <p>
     * The status of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the workflow.
     * @see WorkflowStatus
     */
    public final WorkflowStatus status() {
        return WorkflowStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the workflow.
     * @see WorkflowStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRepositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBranchName());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(runModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowSummary)) {
            return false;
        }
        WorkflowSummary other = (WorkflowSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(sourceRepositoryName(), other.sourceRepositoryName())
                && Objects.equals(sourceBranchName(), other.sourceBranchName())
                && Objects.equals(definition(), other.definition()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(runModeAsString(), other.runModeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowSummary").add("Id", id()).add("Name", name())
                .add("SourceRepositoryName", sourceRepositoryName()).add("SourceBranchName", sourceBranchName())
                .add("Definition", definition()).add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("RunMode", runModeAsString()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sourceRepositoryName":
            return Optional.ofNullable(clazz.cast(sourceRepositoryName()));
        case "sourceBranchName":
            return Optional.ofNullable(clazz.cast(sourceBranchName()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "runMode":
            return Optional.ofNullable(clazz.cast(runModeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sourceRepositoryName", SOURCE_REPOSITORY_NAME_FIELD);
        map.put("sourceBranchName", SOURCE_BRANCH_NAME_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("runMode", RUN_MODE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowSummary, T> g) {
        return obj -> g.apply((WorkflowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowSummary> {
        /**
         * <p>
         * The system-generated unique ID of a workflow.
         * </p>
         * 
         * @param id
         *        The system-generated unique ID of a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the workflow.
         * </p>
         * 
         * @param name
         *        The name of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the source repository where the workflow definition file is stored.
         * </p>
         * 
         * @param sourceRepositoryName
         *        The name of the source repository where the workflow definition file is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRepositoryName(String sourceRepositoryName);

        /**
         * <p>
         * The name of the branch of the source repository where the workflow definition file is stored.
         * </p>
         * 
         * @param sourceBranchName
         *        The name of the branch of the source repository where the workflow definition file is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBranchName(String sourceBranchName);

        /**
         * <p>
         * Information about the workflow definition file.
         * </p>
         * 
         * @param definition
         *        Information about the workflow definition file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(WorkflowDefinitionSummary definition);

        /**
         * <p>
         * Information about the workflow definition file.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowDefinitionSummary.Builder}
         * avoiding the need to create one manually via {@link WorkflowDefinitionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowDefinitionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(WorkflowDefinitionSummary)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link WorkflowDefinitionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(WorkflowDefinitionSummary)
         */
        default Builder definition(Consumer<WorkflowDefinitionSummary.Builder> definition) {
            return definition(WorkflowDefinitionSummary.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as specified
         * in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
         * </p>
         * 
         * @param createdTime
         *        The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as
         *        specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as
         * specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format
         *        as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The run mode of the workflow.
         * </p>
         * 
         * @param runMode
         *        The run mode of the workflow.
         * @see WorkflowRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowRunMode
         */
        Builder runMode(String runMode);

        /**
         * <p>
         * The run mode of the workflow.
         * </p>
         * 
         * @param runMode
         *        The run mode of the workflow.
         * @see WorkflowRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowRunMode
         */
        Builder runMode(WorkflowRunMode runMode);

        /**
         * <p>
         * The status of the workflow.
         * </p>
         * 
         * @param status
         *        The status of the workflow.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the workflow.
         * </p>
         * 
         * @param status
         *        The status of the workflow.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder status(WorkflowStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String sourceRepositoryName;

        private String sourceBranchName;

        private WorkflowDefinitionSummary definition;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String runMode;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowSummary model) {
            id(model.id);
            name(model.name);
            sourceRepositoryName(model.sourceRepositoryName);
            sourceBranchName(model.sourceBranchName);
            definition(model.definition);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            runMode(model.runMode);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceRepositoryName() {
            return sourceRepositoryName;
        }

        public final void setSourceRepositoryName(String sourceRepositoryName) {
            this.sourceRepositoryName = sourceRepositoryName;
        }

        @Override
        public final Builder sourceRepositoryName(String sourceRepositoryName) {
            this.sourceRepositoryName = sourceRepositoryName;
            return this;
        }

        public final String getSourceBranchName() {
            return sourceBranchName;
        }

        public final void setSourceBranchName(String sourceBranchName) {
            this.sourceBranchName = sourceBranchName;
        }

        @Override
        public final Builder sourceBranchName(String sourceBranchName) {
            this.sourceBranchName = sourceBranchName;
            return this;
        }

        public final WorkflowDefinitionSummary.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(WorkflowDefinitionSummary.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(WorkflowDefinitionSummary definition) {
            this.definition = definition;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getRunMode() {
            return runMode;
        }

        public final void setRunMode(String runMode) {
            this.runMode = runMode;
        }

        @Override
        public final Builder runMode(String runMode) {
            this.runMode = runMode;
            return this;
        }

        @Override
        public final Builder runMode(WorkflowRunMode runMode) {
            this.runMode(runMode == null ? null : runMode.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public WorkflowSummary build() {
            return new WorkflowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
