/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.CredentialType;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystServiceClientConfiguration;
import software.amazon.awssdk.services.codecatalyst.internal.CodeCatalystServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codecatalyst.model.AccessDeniedException;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystException;
import software.amazon.awssdk.services.codecatalyst.model.ConflictException;
import software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenRequest;
import software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse;
import software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.CreateProjectRequest;
import software.amazon.awssdk.services.codecatalyst.model.CreateProjectResponse;
import software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryBranchRequest;
import software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryBranchResponse;
import software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryRequest;
import software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryResponse;
import software.amazon.awssdk.services.codecatalyst.model.DeleteAccessTokenRequest;
import software.amazon.awssdk.services.codecatalyst.model.DeleteAccessTokenResponse;
import software.amazon.awssdk.services.codecatalyst.model.DeleteDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.DeleteDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.DeleteProjectRequest;
import software.amazon.awssdk.services.codecatalyst.model.DeleteProjectResponse;
import software.amazon.awssdk.services.codecatalyst.model.DeleteSourceRepositoryRequest;
import software.amazon.awssdk.services.codecatalyst.model.DeleteSourceRepositoryResponse;
import software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceRequest;
import software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetProjectRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetProjectResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryCloneUrlsResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetSpaceRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetSpaceResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetWorkflowRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetWorkflowResponse;
import software.amazon.awssdk.services.codecatalyst.model.GetWorkflowRunRequest;
import software.amazon.awssdk.services.codecatalyst.model.GetWorkflowRunResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListEventLogsResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListProjectsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListProjectsResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListSpacesRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListSpacesResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListWorkflowRunsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListWorkflowRunsResponse;
import software.amazon.awssdk.services.codecatalyst.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.codecatalyst.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codecatalyst.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionRequest;
import software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionResponse;
import software.amazon.awssdk.services.codecatalyst.model.StartWorkflowRunRequest;
import software.amazon.awssdk.services.codecatalyst.model.StartWorkflowRunResponse;
import software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionRequest;
import software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionResponse;
import software.amazon.awssdk.services.codecatalyst.model.ThrottlingException;
import software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentRequest;
import software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentResponse;
import software.amazon.awssdk.services.codecatalyst.model.UpdateProjectRequest;
import software.amazon.awssdk.services.codecatalyst.model.UpdateProjectResponse;
import software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceRequest;
import software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceResponse;
import software.amazon.awssdk.services.codecatalyst.model.ValidationException;
import software.amazon.awssdk.services.codecatalyst.model.VerifySessionRequest;
import software.amazon.awssdk.services.codecatalyst.model.VerifySessionResponse;
import software.amazon.awssdk.services.codecatalyst.transform.CreateAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.CreateDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.CreateSourceRepositoryBranchRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.CreateSourceRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.DeleteAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.DeleteDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.DeleteSourceRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.DeleteSpaceRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetProjectRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetSourceRepositoryCloneUrlsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetSourceRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetSpaceRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetUserDetailsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetWorkflowRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.GetWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListAccessTokensRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListDevEnvironmentSessionsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListDevEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListEventLogsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListSourceRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListSourceRepositoryBranchesRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListSpacesRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListWorkflowRunsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.ListWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.StartDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.StartDevEnvironmentSessionRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.StartWorkflowRunRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.StopDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.StopDevEnvironmentSessionRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.UpdateDevEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.UpdateSpaceRequestMarshaller;
import software.amazon.awssdk.services.codecatalyst.transform.VerifySessionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCodeCatalystAsyncClient
implements CodeCatalystAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeCatalystAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeCatalystAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CodeCatalyst#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateAccessTokenResponse> createAccessToken(CreateAccessTokenRequest createAccessTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAccessTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, createAccessTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccessTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAccessTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)createAccessTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$createAccessToken$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$createAccessToken$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDevEnvironmentResponse> createDevEnvironment(CreateDevEnvironmentRequest createDevEnvironmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDevEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, createDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDevEnvironment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDevEnvironmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDevEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)createDevEnvironmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$createDevEnvironment$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$createDevEnvironment$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, createProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)createProjectRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$createProject$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$createProject$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSourceRepositoryResponse> createSourceRepository(CreateSourceRepositoryRequest createSourceRepositoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSourceRepositoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, createSourceRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSourceRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSourceRepositoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSourceRepository").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSourceRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)createSourceRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$createSourceRepository$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$createSourceRepository$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSourceRepositoryBranchResponse> createSourceRepositoryBranch(CreateSourceRepositoryBranchRequest createSourceRepositoryBranchRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSourceRepositoryBranchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, createSourceRepositoryBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSourceRepositoryBranch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSourceRepositoryBranchResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSourceRepositoryBranch").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSourceRepositoryBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)createSourceRepositoryBranchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$createSourceRepositoryBranch$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$createSourceRepositoryBranch$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAccessTokenResponse> deleteAccessToken(DeleteAccessTokenRequest deleteAccessTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAccessTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAccessTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccessTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAccessTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)deleteAccessTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$deleteAccessToken$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$deleteAccessToken$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDevEnvironmentResponse> deleteDevEnvironment(DeleteDevEnvironmentRequest deleteDevEnvironmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDevEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDevEnvironment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDevEnvironmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDevEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)deleteDevEnvironmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$deleteDevEnvironment$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$deleteDevEnvironment$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, deleteProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)deleteProjectRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$deleteProject$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$deleteProject$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSourceRepositoryResponse> deleteSourceRepository(DeleteSourceRepositoryRequest deleteSourceRepositoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSourceRepositoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSourceRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSourceRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSourceRepositoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSourceRepository").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSourceRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)deleteSourceRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$deleteSourceRepository$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$deleteSourceRepository$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSpaceResponse> deleteSpace(DeleteSpaceRequest deleteSpaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSpaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSpaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSpace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSpaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSpace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSpaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)deleteSpaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$deleteSpace$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$deleteSpace$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDevEnvironmentResponse> getDevEnvironment(GetDevEnvironmentRequest getDevEnvironmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDevEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, getDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDevEnvironment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDevEnvironmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDevEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getDevEnvironmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$getDevEnvironment$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$getDevEnvironment$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetProjectResponse> getProject(GetProjectRequest getProjectRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, getProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getProjectRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$getProject$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$getProject$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSourceRepositoryResponse> getSourceRepository(GetSourceRepositoryRequest getSourceRepositoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSourceRepositoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, getSourceRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSourceRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSourceRepositoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSourceRepository").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSourceRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getSourceRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$getSourceRepository$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$getSourceRepository$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSourceRepositoryCloneUrlsResponse> getSourceRepositoryCloneUrls(GetSourceRepositoryCloneUrlsRequest getSourceRepositoryCloneUrlsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSourceRepositoryCloneUrlsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, getSourceRepositoryCloneUrlsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSourceRepositoryCloneUrls");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSourceRepositoryCloneUrlsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSourceRepositoryCloneUrls").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSourceRepositoryCloneUrlsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getSourceRepositoryCloneUrlsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$getSourceRepositoryCloneUrls$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$getSourceRepositoryCloneUrls$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSpaceResponse> getSpace(GetSpaceRequest getSpaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSpaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, getSpaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSpace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSpaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSpace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSpaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getSpaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$getSpace$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$getSpace$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSubscriptionResponse> getSubscription(GetSubscriptionRequest getSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, getSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getSubscriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$getSubscription$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$getSubscription$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetUserDetailsResponse> getUserDetails(GetUserDetailsRequest getUserDetailsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUserDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, getUserDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUserDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUserDetailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUserDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetUserDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getUserDetailsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$getUserDetails$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$getUserDetails$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWorkflowResponse> getWorkflow(GetWorkflowRequest getWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkflowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkflow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getWorkflowRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$getWorkflow$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$getWorkflow$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWorkflowRunResponse> getWorkflowRun(GetWorkflowRunRequest getWorkflowRunRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWorkflowRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkflowRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkflowRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkflowRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkflowRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWorkflowRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)getWorkflowRunRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$getWorkflowRun$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$getWorkflowRun$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAccessTokensResponse> listAccessTokens(ListAccessTokensRequest listAccessTokensRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAccessTokensRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, listAccessTokensRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessTokens");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccessTokensResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessTokens").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAccessTokensRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listAccessTokensRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$listAccessTokens$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$listAccessTokens$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDevEnvironmentSessionsResponse> listDevEnvironmentSessions(ListDevEnvironmentSessionsRequest listDevEnvironmentSessionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDevEnvironmentSessionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, listDevEnvironmentSessionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevEnvironmentSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevEnvironmentSessionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevEnvironmentSessions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDevEnvironmentSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listDevEnvironmentSessionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$listDevEnvironmentSessions$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$listDevEnvironmentSessions$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDevEnvironmentsResponse> listDevEnvironments(ListDevEnvironmentsRequest listDevEnvironmentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDevEnvironmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, listDevEnvironmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevEnvironments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevEnvironmentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevEnvironments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDevEnvironmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listDevEnvironmentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$listDevEnvironments$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$listDevEnvironments$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEventLogsResponse> listEventLogs(ListEventLogsRequest listEventLogsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventLogsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, listEventLogsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventLogs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventLogsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventLogs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEventLogsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listEventLogsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$listEventLogs$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$listEventLogs$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListProjectsResponse> listProjects(ListProjectsRequest listProjectsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listProjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, listProjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListProjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProjectsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProjects").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListProjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listProjectsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$listProjects$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$listProjects$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSourceRepositoriesResponse> listSourceRepositories(ListSourceRepositoriesRequest listSourceRepositoriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSourceRepositoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, listSourceRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSourceRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSourceRepositoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSourceRepositories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSourceRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listSourceRepositoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$listSourceRepositories$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$listSourceRepositories$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSourceRepositoryBranchesResponse> listSourceRepositoryBranches(ListSourceRepositoryBranchesRequest listSourceRepositoryBranchesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSourceRepositoryBranchesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, listSourceRepositoryBranchesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSourceRepositoryBranches");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSourceRepositoryBranchesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSourceRepositoryBranches").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSourceRepositoryBranchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listSourceRepositoryBranchesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$listSourceRepositoryBranches$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$listSourceRepositoryBranches$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSpacesResponse> listSpaces(ListSpacesRequest listSpacesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSpacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, listSpacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSpaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSpacesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSpaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSpacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listSpacesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$listSpaces$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$listSpaces$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListWorkflowRunsResponse> listWorkflowRuns(ListWorkflowRunsRequest listWorkflowRunsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWorkflowRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, listWorkflowRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkflowRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkflowRunsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkflowRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListWorkflowRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listWorkflowRunsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$listWorkflowRuns$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$listWorkflowRuns$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListWorkflowsResponse> listWorkflows(ListWorkflowsRequest listWorkflowsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWorkflowsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, listWorkflowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkflows");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkflowsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkflows").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListWorkflowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)listWorkflowsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$listWorkflows$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$listWorkflows$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartDevEnvironmentResponse> startDevEnvironment(StartDevEnvironmentRequest startDevEnvironmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDevEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, startDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDevEnvironment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDevEnvironmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDevEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)startDevEnvironmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$startDevEnvironment$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$startDevEnvironment$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartDevEnvironmentSessionResponse> startDevEnvironmentSession(StartDevEnvironmentSessionRequest startDevEnvironmentSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDevEnvironmentSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, startDevEnvironmentSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDevEnvironmentSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDevEnvironmentSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDevEnvironmentSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartDevEnvironmentSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)startDevEnvironmentSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$startDevEnvironmentSession$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$startDevEnvironmentSession$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartWorkflowRunResponse> startWorkflowRun(StartWorkflowRunRequest startWorkflowRunRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startWorkflowRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, startWorkflowRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartWorkflowRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartWorkflowRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartWorkflowRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartWorkflowRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)startWorkflowRunRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$startWorkflowRun$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$startWorkflowRun$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopDevEnvironmentResponse> stopDevEnvironment(StopDevEnvironmentRequest stopDevEnvironmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopDevEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, stopDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDevEnvironment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDevEnvironmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDevEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)stopDevEnvironmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$stopDevEnvironment$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$stopDevEnvironment$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopDevEnvironmentSessionResponse> stopDevEnvironmentSession(StopDevEnvironmentSessionRequest stopDevEnvironmentSessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopDevEnvironmentSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, stopDevEnvironmentSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDevEnvironmentSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDevEnvironmentSessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDevEnvironmentSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopDevEnvironmentSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)stopDevEnvironmentSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$stopDevEnvironmentSession$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$stopDevEnvironmentSession$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDevEnvironmentResponse> updateDevEnvironment(UpdateDevEnvironmentRequest updateDevEnvironmentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDevEnvironmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, updateDevEnvironmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDevEnvironment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDevEnvironmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDevEnvironment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDevEnvironmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)updateDevEnvironmentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$updateDevEnvironment$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$updateDevEnvironment$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateProjectResponse> updateProject(UpdateProjectRequest updateProjectRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, updateProjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProjectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProject").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)updateProjectRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$updateProject$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$updateProject$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSpaceResponse> updateSpace(UpdateSpaceRequest updateSpaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSpaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, updateSpaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSpace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSpaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSpace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSpaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)updateSpaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$updateSpace$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$updateSpace$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<VerifySessionResponse> verifySession(VerifySessionRequest verifySessionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)verifySessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodeCatalystAsyncClient.resolveMetricPublishers(clientConfiguration, verifySessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCatalyst");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"VerifySession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, VerifySessionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(402)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("VerifySession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new VerifySessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).credentialType(CredentialType.TOKEN).withInput((SdkRequest)verifySessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCatalystAsyncClient.lambda$verifySession$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCatalystAsyncClient.lambda$verifySession$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final CodeCatalystServiceClientConfiguration serviceClientConfiguration() {
        return new CodeCatalystServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "codecatalyst";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeCatalystException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CodeCatalystServiceClientConfigurationBuilder serviceConfigBuilder = new CodeCatalystServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$verifySession$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$verifySession$150(List metricPublishers, MetricCollector apiCallMetricCollector, VerifySessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSpace$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSpace$146(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSpaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateProject$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateProject$142(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateProjectResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDevEnvironment$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDevEnvironment$138(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDevEnvironmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopDevEnvironmentSession$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopDevEnvironmentSession$134(List metricPublishers, MetricCollector apiCallMetricCollector, StopDevEnvironmentSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopDevEnvironment$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopDevEnvironment$130(List metricPublishers, MetricCollector apiCallMetricCollector, StopDevEnvironmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startWorkflowRun$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startWorkflowRun$126(List metricPublishers, MetricCollector apiCallMetricCollector, StartWorkflowRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startDevEnvironmentSession$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDevEnvironmentSession$122(List metricPublishers, MetricCollector apiCallMetricCollector, StartDevEnvironmentSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startDevEnvironment$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDevEnvironment$118(List metricPublishers, MetricCollector apiCallMetricCollector, StartDevEnvironmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listWorkflows$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkflows$114(List metricPublishers, MetricCollector apiCallMetricCollector, ListWorkflowsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listWorkflowRuns$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkflowRuns$110(List metricPublishers, MetricCollector apiCallMetricCollector, ListWorkflowRunsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSpaces$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSpaces$106(List metricPublishers, MetricCollector apiCallMetricCollector, ListSpacesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSourceRepositoryBranches$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSourceRepositoryBranches$102(List metricPublishers, MetricCollector apiCallMetricCollector, ListSourceRepositoryBranchesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSourceRepositories$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSourceRepositories$98(List metricPublishers, MetricCollector apiCallMetricCollector, ListSourceRepositoriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listProjects$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listProjects$94(List metricPublishers, MetricCollector apiCallMetricCollector, ListProjectsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEventLogs$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventLogs$90(List metricPublishers, MetricCollector apiCallMetricCollector, ListEventLogsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDevEnvironments$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevEnvironments$86(List metricPublishers, MetricCollector apiCallMetricCollector, ListDevEnvironmentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDevEnvironmentSessions$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevEnvironmentSessions$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListDevEnvironmentSessionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAccessTokens$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessTokens$78(List metricPublishers, MetricCollector apiCallMetricCollector, ListAccessTokensResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkflowRun$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkflowRun$74(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkflowRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkflow$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkflow$70(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkflowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getUserDetails$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUserDetails$66(List metricPublishers, MetricCollector apiCallMetricCollector, GetUserDetailsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSubscription$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSubscription$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSpace$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSpace$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetSpaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSourceRepositoryCloneUrls$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSourceRepositoryCloneUrls$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetSourceRepositoryCloneUrlsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSourceRepository$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSourceRepository$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetSourceRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getProject$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getProject$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetProjectResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDevEnvironment$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDevEnvironment$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetDevEnvironmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSpace$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSpace$38(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSpaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSourceRepository$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSourceRepository$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSourceRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteProject$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteProject$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteProjectResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDevEnvironment$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDevEnvironment$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDevEnvironmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAccessToken$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessToken$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAccessTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSourceRepositoryBranch$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSourceRepositoryBranch$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSourceRepositoryBranchResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSourceRepository$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSourceRepository$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSourceRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createProject$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createProject$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateProjectResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDevEnvironment$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDevEnvironment$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDevEnvironmentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAccessToken$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessToken$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAccessTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

