/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.FileMetadata;
import software.amazon.awssdk.services.codecommit.model.FilesMetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCommitResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, CreateCommitResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommitResponse.getter(CreateCommitResponse::commitId)).setter(CreateCommitResponse.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final SdkField<String> TREE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCommitResponse.getter(CreateCommitResponse::treeId)).setter(CreateCommitResponse.setter(Builder::treeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()}).build();
    private static final SdkField<List<FileMetadata>> FILES_ADDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCommitResponse.getter(CreateCommitResponse::filesAdded)).setter(CreateCommitResponse.setter(Builder::filesAdded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filesAdded").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FileMetadata>> FILES_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCommitResponse.getter(CreateCommitResponse::filesUpdated)).setter(CreateCommitResponse.setter(Builder::filesUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filesUpdated").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FileMetadata>> FILES_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateCommitResponse.getter(CreateCommitResponse::filesDeleted)).setter(CreateCommitResponse.setter(Builder::filesDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filesDeleted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD, TREE_ID_FIELD, FILES_ADDED_FIELD, FILES_UPDATED_FIELD, FILES_DELETED_FIELD));
    private final String commitId;
    private final String treeId;
    private final List<FileMetadata> filesAdded;
    private final List<FileMetadata> filesUpdated;
    private final List<FileMetadata> filesDeleted;

    private CreateCommitResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.treeId = builder.treeId;
        this.filesAdded = builder.filesAdded;
        this.filesUpdated = builder.filesUpdated;
        this.filesDeleted = builder.filesDeleted;
    }

    public String commitId() {
        return this.commitId;
    }

    public String treeId() {
        return this.treeId;
    }

    public List<FileMetadata> filesAdded() {
        return this.filesAdded;
    }

    public List<FileMetadata> filesUpdated() {
        return this.filesUpdated;
    }

    public List<FileMetadata> filesDeleted() {
        return this.filesDeleted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.treeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesAdded());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesDeleted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCommitResponse)) {
            return false;
        }
        CreateCommitResponse other = (CreateCommitResponse)((Object)obj);
        return Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.treeId(), other.treeId()) && Objects.equals(this.filesAdded(), other.filesAdded()) && Objects.equals(this.filesUpdated(), other.filesUpdated()) && Objects.equals(this.filesDeleted(), other.filesDeleted());
    }

    public String toString() {
        return ToString.builder((String)"CreateCommitResponse").add("CommitId", (Object)this.commitId()).add("TreeId", (Object)this.treeId()).add("FilesAdded", this.filesAdded()).add("FilesUpdated", this.filesUpdated()).add("FilesDeleted", this.filesDeleted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "treeId": {
                return Optional.ofNullable(clazz.cast(this.treeId()));
            }
            case "filesAdded": {
                return Optional.ofNullable(clazz.cast(this.filesAdded()));
            }
            case "filesUpdated": {
                return Optional.ofNullable(clazz.cast(this.filesUpdated()));
            }
            case "filesDeleted": {
                return Optional.ofNullable(clazz.cast(this.filesDeleted()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCommitResponse, T> g) {
        return obj -> g.apply((CreateCommitResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private String commitId;
        private String treeId;
        private List<FileMetadata> filesAdded = DefaultSdkAutoConstructList.getInstance();
        private List<FileMetadata> filesUpdated = DefaultSdkAutoConstructList.getInstance();
        private List<FileMetadata> filesDeleted = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCommitResponse model) {
            super(model);
            this.commitId(model.commitId);
            this.treeId(model.treeId);
            this.filesAdded(model.filesAdded);
            this.filesUpdated(model.filesUpdated);
            this.filesDeleted(model.filesDeleted);
        }

        public final String getCommitId() {
            return this.commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public final String getTreeId() {
            return this.treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        public final Collection<FileMetadata.Builder> getFilesAdded() {
            return this.filesAdded != null ? (Collection)this.filesAdded.stream().map(FileMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filesAdded(Collection<FileMetadata> filesAdded) {
            this.filesAdded = FilesMetadataCopier.copy(filesAdded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesAdded(FileMetadata ... filesAdded) {
            this.filesAdded(Arrays.asList(filesAdded));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesAdded(Consumer<FileMetadata.Builder> ... filesAdded) {
            this.filesAdded(Stream.of(filesAdded).map(c -> (FileMetadata)((FileMetadata.Builder)FileMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilesAdded(Collection<FileMetadata.BuilderImpl> filesAdded) {
            this.filesAdded = FilesMetadataCopier.copyFromBuilder(filesAdded);
        }

        public final Collection<FileMetadata.Builder> getFilesUpdated() {
            return this.filesUpdated != null ? (Collection)this.filesUpdated.stream().map(FileMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filesUpdated(Collection<FileMetadata> filesUpdated) {
            this.filesUpdated = FilesMetadataCopier.copy(filesUpdated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesUpdated(FileMetadata ... filesUpdated) {
            this.filesUpdated(Arrays.asList(filesUpdated));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesUpdated(Consumer<FileMetadata.Builder> ... filesUpdated) {
            this.filesUpdated(Stream.of(filesUpdated).map(c -> (FileMetadata)((FileMetadata.Builder)FileMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilesUpdated(Collection<FileMetadata.BuilderImpl> filesUpdated) {
            this.filesUpdated = FilesMetadataCopier.copyFromBuilder(filesUpdated);
        }

        public final Collection<FileMetadata.Builder> getFilesDeleted() {
            return this.filesDeleted != null ? (Collection)this.filesDeleted.stream().map(FileMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filesDeleted(Collection<FileMetadata> filesDeleted) {
            this.filesDeleted = FilesMetadataCopier.copy(filesDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesDeleted(FileMetadata ... filesDeleted) {
            this.filesDeleted(Arrays.asList(filesDeleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filesDeleted(Consumer<FileMetadata.Builder> ... filesDeleted) {
            this.filesDeleted(Stream.of(filesDeleted).map(c -> (FileMetadata)((FileMetadata.Builder)FileMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilesDeleted(Collection<FileMetadata.BuilderImpl> filesDeleted) {
            this.filesDeleted = FilesMetadataCopier.copyFromBuilder(filesDeleted);
        }

        @Override
        public CreateCommitResponse build() {
            return new CreateCommitResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCommitResponse> {
        public Builder commitId(String var1);

        public Builder treeId(String var1);

        public Builder filesAdded(Collection<FileMetadata> var1);

        public Builder filesAdded(FileMetadata ... var1);

        public Builder filesAdded(Consumer<FileMetadata.Builder> ... var1);

        public Builder filesUpdated(Collection<FileMetadata> var1);

        public Builder filesUpdated(FileMetadata ... var1);

        public Builder filesUpdated(Consumer<FileMetadata.Builder> ... var1);

        public Builder filesDeleted(Collection<FileMetadata> var1);

        public Builder filesDeleted(FileMetadata ... var1);

        public Builder filesDeleted(Consumer<FileMetadata.Builder> ... var1);
    }
}

