/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codecommit.model.ActorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleNameAlreadyExistsException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateInUseException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateNameAlreadyExistsException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalStateRequiredException;
import software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.AuthorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BeforeCommitIdAndAfterCommitIdAreSameException;
import software.amazon.awssdk.services.codecommit.model.BlobIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BlobIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.BranchDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BranchNameExistsException;
import software.amazon.awssdk.services.codecommit.model.BranchNameIsTagNameException;
import software.amazon.awssdk.services.codecommit.model.BranchNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.CannotDeleteApprovalRuleFromTemplateException;
import software.amazon.awssdk.services.codecommit.model.CannotModifyApprovalRuleFromTemplateException;
import software.amazon.awssdk.services.codecommit.model.ClientRequestTokenRequiredException;
import software.amazon.awssdk.services.codecommit.model.CodeCommitException;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CommentContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommentDeletedException;
import software.amazon.awssdk.services.codecommit.model.CommentDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommentIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentNotCreatedByCallerException;
import software.amazon.awssdk.services.codecommit.model.CommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitIdsLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitIdsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitMessageLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitRequiredException;
import software.amazon.awssdk.services.codecommit.model.ConcurrentReferenceUpdateException;
import software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.CreateBranchRequest;
import software.amazon.awssdk.services.codecommit.model.CreateBranchResponse;
import software.amazon.awssdk.services.codecommit.model.CreateCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateCommitResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.DefaultBranchCannotBeDeletedException;
import software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteFileRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteFileResponse;
import software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleRequest;
import software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse;
import software.amazon.awssdk.services.codecommit.model.DirectoryNameConflictsWithFileNameException;
import software.amazon.awssdk.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.EncryptionIntegrityChecksFailedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyAccessDeniedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyDisabledException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyNotFoundException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyUnavailableException;
import software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesRequest;
import software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse;
import software.amazon.awssdk.services.codecommit.model.FileContentAndSourceFileSpecifiedException;
import software.amazon.awssdk.services.codecommit.model.FileContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FileDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.FileEntryRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileModeRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileNameConflictsWithDirectoryNameException;
import software.amazon.awssdk.services.codecommit.model.FilePathConflictsWithSubmodulePathException;
import software.amazon.awssdk.services.codecommit.model.FileTooLargeException;
import software.amazon.awssdk.services.codecommit.model.FolderContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FolderDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.GetApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.GetApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.GetBlobRequest;
import software.amazon.awssdk.services.codecommit.model.GetBlobResponse;
import software.amazon.awssdk.services.codecommit.model.GetBranchRequest;
import software.amazon.awssdk.services.codecommit.model.GetBranchResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse;
import software.amazon.awssdk.services.codecommit.model.GetFileRequest;
import software.amazon.awssdk.services.codecommit.model.GetFileResponse;
import software.amazon.awssdk.services.codecommit.model.GetFolderRequest;
import software.amazon.awssdk.services.codecommit.model.GetFolderResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.IdempotencyParameterMismatchException;
import software.amazon.awssdk.services.codecommit.model.InvalidActorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalStateException;
import software.amazon.awssdk.services.codecommit.model.InvalidAuthorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidBlobIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidClientRequestTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommentIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictDetailLevelException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictResolutionException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictResolutionStrategyException;
import software.amazon.awssdk.services.codecommit.model.InvalidContinuationTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidDeletionParameterException;
import software.amazon.awssdk.services.codecommit.model.InvalidDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidDestinationCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidEmailException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileLocationException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileModeException;
import software.amazon.awssdk.services.codecommit.model.InvalidFilePositionException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxConflictFilesException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxMergeHunksException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.codecommit.model.InvalidMergeOptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidOrderException;
import software.amazon.awssdk.services.codecommit.model.InvalidOverrideStatusException;
import software.amazon.awssdk.services.codecommit.model.InvalidParentCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPathException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestEventTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusUpdateException;
import software.amazon.awssdk.services.codecommit.model.InvalidReferenceNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRelativeFileVersionEnumException;
import software.amazon.awssdk.services.codecommit.model.InvalidReplacementContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidReplacementTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerCustomDataException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerDestinationArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerEventsException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerRegionException;
import software.amazon.awssdk.services.codecommit.model.InvalidResourceArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidRevisionIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidRuleContentSha256Exception;
import software.amazon.awssdk.services.codecommit.model.InvalidSortByException;
import software.amazon.awssdk.services.codecommit.model.InvalidSourceCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidSystemTagUsageException;
import software.amazon.awssdk.services.codecommit.model.InvalidTagKeysListException;
import software.amazon.awssdk.services.codecommit.model.InvalidTagsMapException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetBranchException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetsException;
import software.amazon.awssdk.services.codecommit.model.InvalidTitleException;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse;
import software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.ListBranchesRequest;
import software.amazon.awssdk.services.codecommit.model.ListBranchesResponse;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codecommit.model.ManualMergeRequiredException;
import software.amazon.awssdk.services.codecommit.model.MaximumBranchesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumConflictResolutionEntriesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumFileContentToLoadExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumFileEntriesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumItemsToCompareExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumNumberOfApprovalsExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumOpenPullRequestsExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryNamesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryTriggersExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRuleTemplatesAssociatedWithRepositoryException;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MergeOptionRequiredException;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MultipleConflictResolutionEntriesException;
import software.amazon.awssdk.services.codecommit.model.MultipleRepositoriesInPullRequestException;
import software.amazon.awssdk.services.codecommit.model.NameLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.NoChangeException;
import software.amazon.awssdk.services.codecommit.model.NumberOfRuleTemplatesExceededException;
import software.amazon.awssdk.services.codecommit.model.NumberOfRulesExceededException;
import software.amazon.awssdk.services.codecommit.model.OverrideAlreadySetException;
import software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesRequest;
import software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesResponse;
import software.amazon.awssdk.services.codecommit.model.OverrideStatusRequiredException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdOutdatedException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PathDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PathRequiredException;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyResponse;
import software.amazon.awssdk.services.codecommit.model.PullRequestAlreadyClosedException;
import software.amazon.awssdk.services.codecommit.model.PullRequestApprovalRulesNotSatisfiedException;
import software.amazon.awssdk.services.codecommit.model.PullRequestCannotBeApprovedByAuthorException;
import software.amazon.awssdk.services.codecommit.model.PullRequestDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PullRequestIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusRequiredException;
import software.amazon.awssdk.services.codecommit.model.PutFileEntryConflictException;
import software.amazon.awssdk.services.codecommit.model.PutFileRequest;
import software.amazon.awssdk.services.codecommit.model.PutFileResponse;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.ReferenceDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ReferenceNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReferenceTypeNotSupportedException;
import software.amazon.awssdk.services.codecommit.model.ReplacementContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReplacementTypeRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.RepositoryLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameExistsException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNamesRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNotAssociatedWithPullRequestException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerBranchNameListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerDestinationArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggersListRequiredException;
import software.amazon.awssdk.services.codecommit.model.ResourceArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RestrictedSourceFileException;
import software.amazon.awssdk.services.codecommit.model.RevisionIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.RevisionNotCurrentException;
import software.amazon.awssdk.services.codecommit.model.SameFileContentException;
import software.amazon.awssdk.services.codecommit.model.SamePathRequestException;
import software.amazon.awssdk.services.codecommit.model.SourceAndDestinationAreSameException;
import software.amazon.awssdk.services.codecommit.model.SourceFileOrContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.TagKeysListRequiredException;
import software.amazon.awssdk.services.codecommit.model.TagPolicyException;
import software.amazon.awssdk.services.codecommit.model.TagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.TagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.TagsMapRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetsRequiredException;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.TipOfSourceReferenceIsDifferentException;
import software.amazon.awssdk.services.codecommit.model.TipsDivergenceExceededException;
import software.amazon.awssdk.services.codecommit.model.TitleRequiredException;
import software.amazon.awssdk.services.codecommit.model.TooManyTagsException;
import software.amazon.awssdk.services.codecommit.model.UntagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.UntagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameResponse;
import software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsIterable;
import software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsIterable;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitIterable;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestIterable;
import software.amazon.awssdk.services.codecommit.paginators.GetDifferencesIterable;
import software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsIterable;
import software.amazon.awssdk.services.codecommit.paginators.ListApprovalRuleTemplatesIterable;
import software.amazon.awssdk.services.codecommit.paginators.ListAssociatedApprovalRuleTemplatesForRepositoryIterable;
import software.amazon.awssdk.services.codecommit.paginators.ListBranchesIterable;
import software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsIterable;
import software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesForApprovalRuleTemplateIterable;
import software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesIterable;
import software.amazon.awssdk.services.codecommit.transform.AssociateApprovalRuleTemplateWithRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchAssociateApprovalRuleTemplateWithRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchDescribeMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchGetCommitsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchGetRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreatePullRequestApprovalRuleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreatePullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateUnreferencedMergeCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteCommentContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeletePullRequestApprovalRuleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribeMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribePullRequestEventsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DisassociateApprovalRuleTemplateFromRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.EvaluatePullRequestApprovalRulesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBlobRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetDifferencesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFolderRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeOptionsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestApprovalStatesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestOverrideStateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListApprovalRuleTemplatesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListAssociatedApprovalRuleTemplatesForRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListBranchesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListPullRequestsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListRepositoriesForApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesBySquashRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesByThreeWayRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestBySquashRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByThreeWayRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.OverridePullRequestApprovalRulesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentReplyRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TestRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateNameRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateDefaultBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestApprovalRuleContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestApprovalStateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestStatusRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestTitleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryNameRequestMarshaller;

/**
 * Internal implementation of {@link CodeCommitClient}.
 *
 * @see CodeCommitClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeCommitClient implements CodeCommitClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeCommitClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates an association between an approval rule template and a specified repository. Then, the next time a pull
     * request is created in the repository where the destination reference (if specified) matches the destination
     * reference (branch) for the pull request, an approval rule that matches the template conditions is automatically
     * created for that pull request. If no destination references are specified in the template, an approval rule that
     * matches the template contents is created for all pull requests in that repository.
     * </p>
     *
     * @param associateApprovalRuleTemplateWithRepositoryRequest
     * @return Result of the AssociateApprovalRuleTemplateWithRepository operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the AWS Region where the template was created, and then try again.
     * @throws MaximumRuleTemplatesAssociatedWithRepositoryException
     *         The maximum number of approval rule templates for a repository has been exceeded. You cannot associate
     *         more than 25 approval rule templates with a repository.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.AssociateApprovalRuleTemplateWithRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/AssociateApprovalRuleTemplateWithRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateApprovalRuleTemplateWithRepositoryResponse associateApprovalRuleTemplateWithRepository(
            AssociateApprovalRuleTemplateWithRepositoryRequest associateApprovalRuleTemplateWithRepositoryRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateDoesNotExistException, MaximumRuleTemplatesAssociatedWithRepositoryException,
            RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateApprovalRuleTemplateWithRepositoryResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, AssociateApprovalRuleTemplateWithRepositoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<AssociateApprovalRuleTemplateWithRepositoryRequest, AssociateApprovalRuleTemplateWithRepositoryResponse>()
                        .withOperationName("AssociateApprovalRuleTemplateWithRepository").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler)
                        .withInput(associateApprovalRuleTemplateWithRepositoryRequest)
                        .withMarshaller(new AssociateApprovalRuleTemplateWithRepositoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an association between an approval rule template and one or more specified repositories.
     * </p>
     *
     * @param batchAssociateApprovalRuleTemplateWithRepositoriesRequest
     * @return Result of the BatchAssociateApprovalRuleTemplateWithRepositories operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the AWS Region where the template was created, and then try again.
     * @throws RepositoryNamesRequiredException
     *         At least one repository name object is required, but was not specified.
     * @throws MaximumRepositoryNamesExceededException
     *         The maximum number of allowed repository names was exceeded. Currently, this number is 100.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.BatchAssociateApprovalRuleTemplateWithRepositories
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchAssociateApprovalRuleTemplateWithRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchAssociateApprovalRuleTemplateWithRepositoriesResponse batchAssociateApprovalRuleTemplateWithRepositories(
            BatchAssociateApprovalRuleTemplateWithRepositoriesRequest batchAssociateApprovalRuleTemplateWithRepositoriesRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateDoesNotExistException, RepositoryNamesRequiredException, MaximumRepositoryNamesExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<BatchAssociateApprovalRuleTemplateWithRepositoriesRequest, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse>()
                        .withOperationName("BatchAssociateApprovalRuleTemplateWithRepositories")
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(batchAssociateApprovalRuleTemplateWithRepositoriesRequest)
                        .withMarshaller(new BatchAssociateApprovalRuleTemplateWithRepositoriesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy.
     * </p>
     *
     * @param batchDescribeMergeConflictsRequest
     * @return Result of the BatchDescribeMergeConflicts operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws MergeOptionRequiredException
     *         A merge option or stategy is required, and none was provided.
     * @throws InvalidMergeOptionException
     *         The specified merge option is not valid for this operation. Not all merge strategies are supported for
     *         all operations.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws InvalidMaxConflictFilesException
     *         The specified value for the number of conflict files to return is not valid.
     * @throws InvalidMaxMergeHunksException
     *         The specified value for the number of merge hunks to return is not valid.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.BatchDescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchDescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDescribeMergeConflictsResponse batchDescribeMergeConflicts(
            BatchDescribeMergeConflictsRequest batchDescribeMergeConflictsRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, MergeOptionRequiredException,
            InvalidMergeOptionException, InvalidContinuationTokenException, CommitRequiredException, CommitDoesNotExistException,
            InvalidCommitException, TipsDivergenceExceededException, InvalidMaxConflictFilesException,
            InvalidMaxMergeHunksException, InvalidConflictDetailLevelException, InvalidConflictResolutionStrategyException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDescribeMergeConflictsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDescribeMergeConflictsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<BatchDescribeMergeConflictsRequest, BatchDescribeMergeConflictsResponse>()
                        .withOperationName("BatchDescribeMergeConflicts").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(batchDescribeMergeConflictsRequest)
                        .withMarshaller(new BatchDescribeMergeConflictsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes the association between an approval rule template and one or more specified repositories.
     * </p>
     *
     * @param batchDisassociateApprovalRuleTemplateFromRepositoriesRequest
     * @return Result of the BatchDisassociateApprovalRuleTemplateFromRepositories operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the AWS Region where the template was created, and then try again.
     * @throws RepositoryNamesRequiredException
     *         At least one repository name object is required, but was not specified.
     * @throws MaximumRepositoryNamesExceededException
     *         The maximum number of allowed repository names was exceeded. Currently, this number is 100.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.BatchDisassociateApprovalRuleTemplateFromRepositories
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchDisassociateApprovalRuleTemplateFromRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse batchDisassociateApprovalRuleTemplateFromRepositories(
            BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest batchDisassociateApprovalRuleTemplateFromRepositoriesRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateDoesNotExistException, RepositoryNamesRequiredException, MaximumRepositoryNamesExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse>()
                        .withOperationName("BatchDisassociateApprovalRuleTemplateFromRepositories")
                        .withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler)
                        .withInput(batchDisassociateApprovalRuleTemplateFromRepositoriesRequest)
                        .withMarshaller(
                                new BatchDisassociateApprovalRuleTemplateFromRepositoriesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about the contents of one or more commits in a repository.
     * </p>
     *
     * @param batchGetCommitsRequest
     * @return Result of the BatchGetCommits operation returned by the service.
     * @throws CommitIdsListRequiredException
     *         A list of commit IDs is required, but was either not specified or the list was empty.
     * @throws CommitIdsLimitExceededException
     *         The maximum number of allowed commit IDs in a batch request is 100. Verify that your batch requests
     *         contains no more than 100 commit IDs, and then try again.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.BatchGetCommits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetCommits" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchGetCommitsResponse batchGetCommits(BatchGetCommitsRequest batchGetCommitsRequest)
            throws CommitIdsListRequiredException, CommitIdsLimitExceededException, RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetCommitsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetCommitsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchGetCommitsRequest, BatchGetCommitsResponse>()
                .withOperationName("BatchGetCommits").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchGetCommitsRequest)
                .withMarshaller(new BatchGetCommitsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about one or more repositories.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a webpage.
     * </p>
     * </note>
     *
     * @param batchGetRepositoriesRequest
     *        Represents the input of a batch get repositories operation.
     * @return Result of the BatchGetRepositories operation returned by the service.
     * @throws RepositoryNamesRequiredException
     *         At least one repository name object is required, but was not specified.
     * @throws MaximumRepositoryNamesExceededException
     *         The maximum number of allowed repository names was exceeded. Currently, this number is 100.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.BatchGetRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetRepositoriesResponse batchGetRepositories(BatchGetRepositoriesRequest batchGetRepositoriesRequest)
            throws RepositoryNamesRequiredException, MaximumRepositoryNamesExceededException, InvalidRepositoryNameException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetRepositoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetRepositoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<BatchGetRepositoriesRequest, BatchGetRepositoriesResponse>()
                .withOperationName("BatchGetRepositories").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(batchGetRepositoriesRequest)
                .withMarshaller(new BatchGetRepositoriesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a template for approval rules that can then be associated with one or more repositories in your AWS
     * account. When you associate a template with a repository, AWS CodeCommit creates an approval rule that matches
     * the conditions of the template for all pull requests that meet the conditions of the template. For more
     * information, see <a>AssociateApprovalRuleTemplateWithRepository</a>.
     * </p>
     *
     * @param createApprovalRuleTemplateRequest
     * @return Result of the CreateApprovalRuleTemplate operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateNameAlreadyExistsException
     *         You cannot create an approval rule template with that name because a template with that name already
     *         exists in this AWS Region for your AWS account. Approval rule template names must be unique.
     * @throws ApprovalRuleTemplateContentRequiredException
     *         The content for the approval rule template is empty. You must provide some content for an approval rule
     *         template. The content cannot be null.
     * @throws InvalidApprovalRuleTemplateContentException
     *         The content of the approval rule template is not valid.
     * @throws InvalidApprovalRuleTemplateDescriptionException
     *         The description for the approval rule template is not valid because it exceeds the maximum characters
     *         allowed for a description. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws NumberOfRuleTemplatesExceededException
     *         The maximum number of approval rule templates has been exceeded for this AWS Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreateApprovalRuleTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateApprovalRuleTemplateResponse createApprovalRuleTemplate(
            CreateApprovalRuleTemplateRequest createApprovalRuleTemplateRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateNameAlreadyExistsException, ApprovalRuleTemplateContentRequiredException,
            InvalidApprovalRuleTemplateContentException, InvalidApprovalRuleTemplateDescriptionException,
            NumberOfRuleTemplatesExceededException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApprovalRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateApprovalRuleTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateApprovalRuleTemplateRequest, CreateApprovalRuleTemplateResponse>()
                        .withOperationName("CreateApprovalRuleTemplate").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createApprovalRuleTemplateRequest)
                        .withMarshaller(new CreateApprovalRuleTemplateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a branch in a repository and points the branch to a commit.
     * </p>
     * <note>
     * <p>
     * Calling the create branch operation does not set a repository's default branch. To do this, call the update
     * default branch operation.
     * </p>
     * </note>
     *
     * @param createBranchRequest
     *        Represents the input of a create branch operation.
     * @return Result of the CreateBranch operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws BranchNameExistsException
     *         The specified branch name already exists.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws CommitIdRequiredException
     *         A commit ID was not specified.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreateBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateBranchResponse createBranch(CreateBranchRequest createBranchRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, BranchNameRequiredException,
            BranchNameExistsException, InvalidBranchNameException, CommitIdRequiredException, CommitDoesNotExistException,
            InvalidCommitIdException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBranchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBranchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateBranchRequest, CreateBranchResponse>()
                .withOperationName("CreateBranch").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createBranchRequest)
                .withMarshaller(new CreateBranchRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a commit for a repository on the tip of a specified branch.
     * </p>
     *
     * @param createCommitRequest
     * @return Result of the CreateCommit operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws ParentCommitIdRequiredException
     *         A parent commit ID is required. To view the full commit ID of a branch in a repository, use
     *         <a>GetBranch</a> or a Git command (for example, git pull or git log).
     * @throws InvalidParentCommitIdException
     *         The parent commit ID is not valid. The commit ID cannot be empty, and must match the head commit ID for
     *         the branch of the repository where you want to add or update a file.
     * @throws ParentCommitDoesNotExistException
     *         The parent commit ID is not valid because it does not exist. The specified parent commit ID does not
     *         exist in the specified branch of the repository.
     * @throws ParentCommitIdOutdatedException
     *         The file could not be added because the provided parent commit ID is not the current tip of the specified
     *         branch. To view the full commit ID of the current head of the branch, use <a>GetBranch</a>.
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws BranchDoesNotExistException
     *         The specified branch does not exist.
     * @throws BranchNameIsTagNameException
     *         The specified branch name is not valid because it is a tag name. Enter the name of a branch in the
     *         repository. For a list of valid branch names, use <a>ListBranches</a>.
     * @throws FileEntryRequiredException
     *         The commit cannot be created because no files have been specified as added, updated, or changed (PutFile
     *         or DeleteFile) for the commit.
     * @throws MaximumFileEntriesExceededException
     *         The number of specified files to change as part of this commit exceeds the maximum number of files that
     *         can be changed in a single commit. Consider using a Git client for these changes.
     * @throws PutFileEntryConflictException
     *         The commit cannot be created because one or more files specified in the commit reference both a file and
     *         a folder.
     * @throws SourceFileOrContentRequiredException
     *         The commit cannot be created because no source files or file content have been specified for the commit.
     * @throws FileContentAndSourceFileSpecifiedException
     *         The commit cannot be created because both a source file and file content have been specified for the same
     *         file. You cannot provide both. Either specify a source file or provide the file content directly.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws SamePathRequestException
     *         The commit cannot be created because one or more changes in this commit duplicate actions in the same
     *         file path. For example, you cannot make the same delete request to the same file in the same file path
     *         twice, or make a delete request and a move request to the same file as part of the same commit.
     * @throws FileDoesNotExistException
     *         The specified file does not exist. Verify that you have used the correct file name, full path, and
     *         extension.
     * @throws FileContentSizeLimitExceededException
     *         The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file
     *         content change size is 7 MB. Consider making these changes using a Git client.
     * @throws FolderContentSizeLimitExceededException
     *         The commit cannot be created because at least one of the overall changes in the commit results in a
     *         folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or
     *         split the changes across multiple folders.
     * @throws InvalidDeletionParameterException
     *         The specified deletion parameter is not valid.
     * @throws RestrictedSourceFileException
     *         The commit cannot be created because one of the changes specifies copying or moving a .gitkeep file.
     * @throws FileModeRequiredException
     *         The commit cannot be created because no file mode has been specified. A file mode is required to update
     *         mode permissions for a file.
     * @throws InvalidFileModeException
     *         The specified file mode permission is not valid. For a list of valid file mode permissions, see
     *         <a>PutFile</a>.
     * @throws NameLengthExceededException
     *         The user name is not valid because it has exceeded the character limit for author names.
     * @throws InvalidEmailException
     *         The specified email address either contains one or more characters that are not allowed, or it exceeds
     *         the maximum number of characters allowed for an email address.
     * @throws CommitMessageLengthExceededException
     *         The commit message is too long. Provide a shorter string.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws NoChangeException
     *         The commit cannot be created because no changes will be made to the repository as a result of this
     *         commit. A commit must contain at least one change.
     * @throws FileNameConflictsWithDirectoryNameException
     *         A file cannot be added to the repository because the specified file name has the same name as a directory
     *         in this repository. Either provide another name for the file, or add the file in a directory that does
     *         not match the file name.
     * @throws DirectoryNameConflictsWithFileNameException
     *         A file cannot be added to the repository because the specified path name has the same name as a file that
     *         already exists in this repository. Either provide a different name for the file, or specify a different
     *         path for the file.
     * @throws FilePathConflictsWithSubmodulePathException
     *         The commit cannot be created because a specified file path points to a submodule. Verify that the
     *         destination files have valid file paths that do not point to a submodule.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreateCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateCommit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCommitResponse createCommit(CreateCommitRequest createCommitRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, ParentCommitIdRequiredException,
            InvalidParentCommitIdException, ParentCommitDoesNotExistException, ParentCommitIdOutdatedException,
            BranchNameRequiredException, InvalidBranchNameException, BranchDoesNotExistException, BranchNameIsTagNameException,
            FileEntryRequiredException, MaximumFileEntriesExceededException, PutFileEntryConflictException,
            SourceFileOrContentRequiredException, FileContentAndSourceFileSpecifiedException, PathRequiredException,
            InvalidPathException, SamePathRequestException, FileDoesNotExistException, FileContentSizeLimitExceededException,
            FolderContentSizeLimitExceededException, InvalidDeletionParameterException, RestrictedSourceFileException,
            FileModeRequiredException, InvalidFileModeException, NameLengthExceededException, InvalidEmailException,
            CommitMessageLengthExceededException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, NoChangeException,
            FileNameConflictsWithDirectoryNameException, DirectoryNameConflictsWithFileNameException,
            FilePathConflictsWithSubmodulePathException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCommitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCommitResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateCommitRequest, CreateCommitResponse>()
                .withOperationName("CreateCommit").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createCommitRequest)
                .withMarshaller(new CreateCommitRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a pull request in the specified repository.
     * </p>
     *
     * @param createPullRequestRequest
     * @return Result of the CreatePullRequest operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws ClientRequestTokenRequiredException
     *         A client request token is required. A client request token is an unique, client-generated idempotency
     *         token that, when provided in a request, ensures the request cannot be repeated with a changed parameter.
     *         If a request is received with the same parameters and a token is included, the request returns
     *         information about the initial request that used that token.
     * @throws InvalidClientRequestTokenException
     *         The client request token is not valid.
     * @throws IdempotencyParameterMismatchException
     *         The client request token is not valid. Either the token is not in a valid format, or the token has been
     *         used in a previous request and cannot be reused.
     * @throws ReferenceNameRequiredException
     *         A reference name is required, but none was provided.
     * @throws InvalidReferenceNameException
     *         The specified reference name format is not valid. Reference names must conform to the Git references
     *         format (for example, refs/heads/master). For more information, see <a
     *         href="https://git-scm.com/book/en/v2/Git-Internals-Git-References">Git Internals - Git References</a> or
     *         consult your Git documentation.
     * @throws ReferenceDoesNotExistException
     *         The specified reference does not exist. You must provide a full commit ID.
     * @throws ReferenceTypeNotSupportedException
     *         The specified reference is not a supported type.
     * @throws TitleRequiredException
     *         A pull request title is required. It cannot be empty or null.
     * @throws InvalidTitleException
     *         The title of the pull request is not valid. Pull request titles cannot exceed 100 characters in length.
     * @throws InvalidDescriptionException
     *         The pull request description is not valid. Descriptions cannot be more than 1,000 characters.
     * @throws TargetsRequiredException
     *         An array of target objects is required. It cannot be empty or null.
     * @throws InvalidTargetsException
     *         The targets for the pull request is not valid or not in a valid format. Targets are a list of target
     *         objects. Each target object must contain the full values for the repository name, source branch, and
     *         destination branch for a pull request.
     * @throws TargetRequiredException
     *         A pull request target is required. It cannot be empty or null. A pull request target must contain the
     *         full values for the repository name, source branch, and destination branch for the pull request.
     * @throws InvalidTargetException
     *         The target for the pull request is not valid. A target must contain the full values for the repository
     *         name, source branch, and destination branch for the pull request.
     * @throws MultipleRepositoriesInPullRequestException
     *         You cannot include more than one repository in a pull request. Make sure you have specified only one
     *         repository name in your request, and then try again.
     * @throws MaximumOpenPullRequestsExceededException
     *         You cannot create the pull request because the repository has too many open pull requests. The maximum
     *         number of open pull requests for a repository is 1,000. Close one or more open pull requests, and then
     *         try again.
     * @throws SourceAndDestinationAreSameException
     *         The source branch and destination branch for the pull request are the same. You must specify different
     *         branches for the source and destination.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreatePullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequest" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreatePullRequestResponse createPullRequest(CreatePullRequestRequest createPullRequestRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, ClientRequestTokenRequiredException,
            InvalidClientRequestTokenException, IdempotencyParameterMismatchException, ReferenceNameRequiredException,
            InvalidReferenceNameException, ReferenceDoesNotExistException, ReferenceTypeNotSupportedException,
            TitleRequiredException, InvalidTitleException, InvalidDescriptionException, TargetsRequiredException,
            InvalidTargetsException, TargetRequiredException, InvalidTargetException, MultipleRepositoriesInPullRequestException,
            MaximumOpenPullRequestsExceededException, SourceAndDestinationAreSameException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePullRequestResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePullRequestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreatePullRequestRequest, CreatePullRequestResponse>()
                .withOperationName("CreatePullRequest").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createPullRequestRequest)
                .withMarshaller(new CreatePullRequestRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an approval rule for a pull request.
     * </p>
     *
     * @param createPullRequestApprovalRuleRequest
     * @return Result of the CreatePullRequestApprovalRule operation returned by the service.
     * @throws ApprovalRuleNameRequiredException
     *         An approval rule name is required, but was not specified.
     * @throws InvalidApprovalRuleNameException
     *         The name for the approval rule is not valid.
     * @throws ApprovalRuleNameAlreadyExistsException
     *         An approval rule with that name already exists. Approval rule names must be unique within the scope of a
     *         pull request.
     * @throws ApprovalRuleContentRequiredException
     *         The content for the approval rule is empty. You must provide some content for an approval rule. The
     *         content cannot be null.
     * @throws InvalidApprovalRuleContentException
     *         The content for the approval rule is not valid.
     * @throws NumberOfRulesExceededException
     *         The approval rule cannot be added. The pull request has the maximum number of approval rules associated
     *         with it.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreatePullRequestApprovalRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequestApprovalRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePullRequestApprovalRuleResponse createPullRequestApprovalRule(
            CreatePullRequestApprovalRuleRequest createPullRequestApprovalRuleRequest) throws ApprovalRuleNameRequiredException,
            InvalidApprovalRuleNameException, ApprovalRuleNameAlreadyExistsException, ApprovalRuleContentRequiredException,
            InvalidApprovalRuleContentException, NumberOfRulesExceededException, PullRequestDoesNotExistException,
            InvalidPullRequestIdException, PullRequestIdRequiredException, PullRequestAlreadyClosedException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePullRequestApprovalRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePullRequestApprovalRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreatePullRequestApprovalRuleRequest, CreatePullRequestApprovalRuleResponse>()
                        .withOperationName("CreatePullRequestApprovalRule").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createPullRequestApprovalRuleRequest)
                        .withMarshaller(new CreatePullRequestApprovalRuleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new, empty repository.
     * </p>
     *
     * @param createRepositoryRequest
     *        Represents the input of a create repository operation.
     * @return Result of the CreateRepository operation returned by the service.
     * @throws RepositoryNameExistsException
     *         The specified repository name already exists.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws InvalidRepositoryDescriptionException
     *         The specified repository description is not valid.
     * @throws RepositoryLimitExceededException
     *         A repository resource limit was exceeded.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws InvalidTagsMapException
     *         The map of tags is not valid.
     * @throws TooManyTagsException
     *         The maximum number of tags for an AWS CodeCommit resource has been exceeded.
     * @throws InvalidSystemTagUsageException
     *         The specified tag is not valid. Key names cannot be prefixed with aws:.
     * @throws TagPolicyException
     *         The tag policy is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreateRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest)
            throws RepositoryNameExistsException, RepositoryNameRequiredException, InvalidRepositoryNameException,
            InvalidRepositoryDescriptionException, RepositoryLimitExceededException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, InvalidTagsMapException, TooManyTagsException, InvalidSystemTagUsageException,
            TagPolicyException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRepositoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateRepositoryRequest, CreateRepositoryResponse>()
                .withOperationName("CreateRepository").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createRepositoryRequest)
                .withMarshaller(new CreateRepositoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an unreferenced commit that represents the result of merging two branches using a specified merge
     * strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the
     * fast-forward merge strategy because that strategy does not create a merge commit.
     * </p>
     * <note>
     * <p>
     * This unreferenced merge commit can only be accessed using the GetCommit API or through git commands such as git
     * fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.
     * </p>
     * </note>
     *
     * @param createUnreferencedMergeCommitRequest
     * @return Result of the CreateUnreferencedMergeCommit operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws MergeOptionRequiredException
     *         A merge option or stategy is required, and none was provided.
     * @throws InvalidMergeOptionException
     *         The specified merge option is not valid for this operation. Not all merge strategies are supported for
     *         all operations.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws InvalidConflictResolutionException
     *         The specified conflict resolution list is not valid.
     * @throws ManualMergeRequiredException
     *         The pull request cannot be merged automatically into the destination branch. You must manually merge the
     *         branches and resolve any conflicts.
     * @throws MaximumConflictResolutionEntriesExceededException
     *         The number of allowed conflict resolution entries was exceeded.
     * @throws MultipleConflictResolutionEntriesException
     *         More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict
     *         resolution entry.
     * @throws ReplacementTypeRequiredException
     *         A replacement type is required.
     * @throws InvalidReplacementTypeException
     *         Automerge was specified for resolving the conflict, but the specified replacement type is not valid.
     * @throws ReplacementContentRequiredException
     *         USE_NEW_CONTENT was specified, but no replacement content has been provided.
     * @throws InvalidReplacementContentException
     *         Automerge was specified for resolving the conflict, but the replacement type is not valid or content is
     *         missing.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws FileContentSizeLimitExceededException
     *         The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file
     *         content change size is 7 MB. Consider making these changes using a Git client.
     * @throws FolderContentSizeLimitExceededException
     *         The commit cannot be created because at least one of the overall changes in the commit results in a
     *         folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or
     *         split the changes across multiple folders.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws ConcurrentReferenceUpdateException
     *         The merge cannot be completed because the target branch has been modified. Another user might have
     *         modified the target branch while the merge was in progress. Wait a few minutes, and then try again.
     * @throws FileModeRequiredException
     *         The commit cannot be created because no file mode has been specified. A file mode is required to update
     *         mode permissions for a file.
     * @throws InvalidFileModeException
     *         The specified file mode permission is not valid. For a list of valid file mode permissions, see
     *         <a>PutFile</a>.
     * @throws NameLengthExceededException
     *         The user name is not valid because it has exceeded the character limit for author names.
     * @throws InvalidEmailException
     *         The specified email address either contains one or more characters that are not allowed, or it exceeds
     *         the maximum number of characters allowed for an email address.
     * @throws CommitMessageLengthExceededException
     *         The commit message is too long. Provide a shorter string.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreateUnreferencedMergeCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateUnreferencedMergeCommit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUnreferencedMergeCommitResponse createUnreferencedMergeCommit(
            CreateUnreferencedMergeCommitRequest createUnreferencedMergeCommitRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, TipsDivergenceExceededException,
            CommitRequiredException, InvalidCommitException, CommitDoesNotExistException, MergeOptionRequiredException,
            InvalidMergeOptionException, InvalidConflictDetailLevelException, InvalidConflictResolutionStrategyException,
            InvalidConflictResolutionException, ManualMergeRequiredException, MaximumConflictResolutionEntriesExceededException,
            MultipleConflictResolutionEntriesException, ReplacementTypeRequiredException, InvalidReplacementTypeException,
            ReplacementContentRequiredException, InvalidReplacementContentException, PathRequiredException, InvalidPathException,
            FileContentSizeLimitExceededException, FolderContentSizeLimitExceededException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException,
            ConcurrentReferenceUpdateException, FileModeRequiredException, InvalidFileModeException, NameLengthExceededException,
            InvalidEmailException, CommitMessageLengthExceededException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUnreferencedMergeCommitResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUnreferencedMergeCommitResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateUnreferencedMergeCommitRequest, CreateUnreferencedMergeCommitResponse>()
                        .withOperationName("CreateUnreferencedMergeCommit").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createUnreferencedMergeCommitRequest)
                        .withMarshaller(new CreateUnreferencedMergeCommitRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests
     * already created with the template.
     * </p>
     *
     * @param deleteApprovalRuleTemplateRequest
     * @return Result of the DeleteApprovalRuleTemplate operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateInUseException
     *         The approval rule template is associated with one or more repositories. You cannot delete a template that
     *         is associated with a repository. Remove all associations, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DeleteApprovalRuleTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteApprovalRuleTemplateResponse deleteApprovalRuleTemplate(
            DeleteApprovalRuleTemplateRequest deleteApprovalRuleTemplateRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateInUseException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApprovalRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteApprovalRuleTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteApprovalRuleTemplateRequest, DeleteApprovalRuleTemplateResponse>()
                        .withOperationName("DeleteApprovalRuleTemplate").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteApprovalRuleTemplateRequest)
                        .withMarshaller(new DeleteApprovalRuleTemplateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a branch from a repository, unless that branch is the default branch for the repository.
     * </p>
     *
     * @param deleteBranchRequest
     *        Represents the input of a delete branch operation.
     * @return Result of the DeleteBranch operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws DefaultBranchCannotBeDeletedException
     *         The specified branch is the default branch for the repository, and cannot be deleted. To delete this
     *         branch, you must first set another branch as the default branch.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DeleteBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteBranch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBranchResponse deleteBranch(DeleteBranchRequest deleteBranchRequest) throws RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, BranchNameRequiredException,
            InvalidBranchNameException, DefaultBranchCannotBeDeletedException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBranchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBranchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteBranchRequest, DeleteBranchResponse>()
                .withOperationName("DeleteBranch").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteBranchRequest)
                .withMarshaller(new DeleteBranchRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the content of a comment made on a change, file, or commit in a repository.
     * </p>
     *
     * @param deleteCommentContentRequest
     * @return Result of the DeleteCommentContent operation returned by the service.
     * @throws CommentDoesNotExistException
     *         No comment exists with the provided ID. Verify that you have used the correct ID, and then try again.
     * @throws CommentIdRequiredException
     *         The comment ID is missing or null. A comment ID is required.
     * @throws InvalidCommentIdException
     *         The comment ID is not in a valid format. Make sure that you have provided the full comment ID.
     * @throws CommentDeletedException
     *         This comment has already been deleted. You cannot edit or delete a deleted comment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DeleteCommentContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteCommentContent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCommentContentResponse deleteCommentContent(DeleteCommentContentRequest deleteCommentContentRequest)
            throws CommentDoesNotExistException, CommentIdRequiredException, InvalidCommentIdException, CommentDeletedException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCommentContentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCommentContentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteCommentContentRequest, DeleteCommentContentResponse>()
                .withOperationName("DeleteCommentContent").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteCommentContentRequest)
                .withMarshaller(new DeleteCommentContentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision.
     * The file still exists in the commits earlier to the commit that contains the deletion.
     * </p>
     *
     * @param deleteFileRequest
     * @return Result of the DeleteFile operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws ParentCommitIdRequiredException
     *         A parent commit ID is required. To view the full commit ID of a branch in a repository, use
     *         <a>GetBranch</a> or a Git command (for example, git pull or git log).
     * @throws InvalidParentCommitIdException
     *         The parent commit ID is not valid. The commit ID cannot be empty, and must match the head commit ID for
     *         the branch of the repository where you want to add or update a file.
     * @throws ParentCommitDoesNotExistException
     *         The parent commit ID is not valid because it does not exist. The specified parent commit ID does not
     *         exist in the specified branch of the repository.
     * @throws ParentCommitIdOutdatedException
     *         The file could not be added because the provided parent commit ID is not the current tip of the specified
     *         branch. To view the full commit ID of the current head of the branch, use <a>GetBranch</a>.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws FileDoesNotExistException
     *         The specified file does not exist. Verify that you have used the correct file name, full path, and
     *         extension.
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws BranchDoesNotExistException
     *         The specified branch does not exist.
     * @throws BranchNameIsTagNameException
     *         The specified branch name is not valid because it is a tag name. Enter the name of a branch in the
     *         repository. For a list of valid branch names, use <a>ListBranches</a>.
     * @throws NameLengthExceededException
     *         The user name is not valid because it has exceeded the character limit for author names.
     * @throws InvalidEmailException
     *         The specified email address either contains one or more characters that are not allowed, or it exceeds
     *         the maximum number of characters allowed for an email address.
     * @throws CommitMessageLengthExceededException
     *         The commit message is too long. Provide a shorter string.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DeleteFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteFile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFileResponse deleteFile(DeleteFileRequest deleteFileRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, ParentCommitIdRequiredException,
            InvalidParentCommitIdException, ParentCommitDoesNotExistException, ParentCommitIdOutdatedException,
            PathRequiredException, InvalidPathException, FileDoesNotExistException, BranchNameRequiredException,
            InvalidBranchNameException, BranchDoesNotExistException, BranchNameIsTagNameException, NameLengthExceededException,
            InvalidEmailException, CommitMessageLengthExceededException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteFileRequest, DeleteFileResponse>()
                .withOperationName("DeleteFile").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteFileRequest)
                .withMarshaller(new DeleteFileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if
     * the pull request is open, and if the approval rule was created specifically for a pull request and not generated
     * from an approval rule template associated with the repository where the pull request was created. You cannot
     * delete an approval rule from a merged or closed pull request.
     * </p>
     *
     * @param deletePullRequestApprovalRuleRequest
     * @return Result of the DeletePullRequestApprovalRule operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws ApprovalRuleNameRequiredException
     *         An approval rule name is required, but was not specified.
     * @throws InvalidApprovalRuleNameException
     *         The name for the approval rule is not valid.
     * @throws CannotDeleteApprovalRuleFromTemplateException
     *         The approval rule cannot be deleted from the pull request because it was created by an approval rule
     *         template and applied to the pull request automatically.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DeletePullRequestApprovalRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeletePullRequestApprovalRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePullRequestApprovalRuleResponse deletePullRequestApprovalRule(
            DeletePullRequestApprovalRuleRequest deletePullRequestApprovalRuleRequest) throws PullRequestDoesNotExistException,
            InvalidPullRequestIdException, PullRequestIdRequiredException, PullRequestAlreadyClosedException,
            ApprovalRuleNameRequiredException, InvalidApprovalRuleNameException, CannotDeleteApprovalRuleFromTemplateException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePullRequestApprovalRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePullRequestApprovalRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeletePullRequestApprovalRuleRequest, DeletePullRequestApprovalRuleResponse>()
                        .withOperationName("DeletePullRequestApprovalRule").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deletePullRequestApprovalRuleRequest)
                        .withMarshaller(new DeletePullRequestApprovalRuleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a repository. If a specified repository was already deleted, a null repository ID is returned.
     * </p>
     * <important>
     * <p>
     * Deleting a repository also deletes all associated objects and metadata. After a repository is deleted, all future
     * push calls to the deleted repository fail.
     * </p>
     * </important>
     *
     * @param deleteRepositoryRequest
     *        Represents the input of a delete repository operation.
     * @return Result of the DeleteRepository operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DeleteRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteRepository" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRepositoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteRepositoryRequest, DeleteRepositoryResponse>()
                .withOperationName("DeleteRepository").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteRepositoryRequest)
                .withMarshaller(new DeleteRepositoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy. If the merge option for the attempted merge is specified as
     * FAST_FORWARD_MERGE, an exception is thrown.
     * </p>
     *
     * @param describeMergeConflictsRequest
     * @return Result of the DescribeMergeConflicts operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws MergeOptionRequiredException
     *         A merge option or stategy is required, and none was provided.
     * @throws InvalidMergeOptionException
     *         The specified merge option is not valid for this operation. Not all merge strategies are supported for
     *         all operations.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws FileDoesNotExistException
     *         The specified file does not exist. Verify that you have used the correct file name, full path, and
     *         extension.
     * @throws InvalidMaxMergeHunksException
     *         The specified value for the number of merge hunks to return is not valid.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMergeConflictsResponse describeMergeConflicts(DescribeMergeConflictsRequest describeMergeConflictsRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            MergeOptionRequiredException, InvalidMergeOptionException, InvalidContinuationTokenException,
            CommitRequiredException, CommitDoesNotExistException, InvalidCommitException, TipsDivergenceExceededException,
            PathRequiredException, InvalidPathException, FileDoesNotExistException, InvalidMaxMergeHunksException,
            InvalidConflictDetailLevelException, InvalidConflictResolutionStrategyException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMergeConflictsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMergeConflictsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DescribeMergeConflictsRequest, DescribeMergeConflictsResponse>()
                .withOperationName("DescribeMergeConflicts").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeMergeConflictsRequest)
                .withMarshaller(new DescribeMergeConflictsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy. If the merge option for the attempted merge is specified as
     * FAST_FORWARD_MERGE, an exception is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMergeConflicts(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsIterable responses = client.describeMergeConflictsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsIterable responses = client
     *             .describeMergeConflictsPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsIterable responses = client.describeMergeConflictsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMergeConflicts(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMergeConflictsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws MergeOptionRequiredException
     *         A merge option or stategy is required, and none was provided.
     * @throws InvalidMergeOptionException
     *         The specified merge option is not valid for this operation. Not all merge strategies are supported for
     *         all operations.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws FileDoesNotExistException
     *         The specified file does not exist. Verify that you have used the correct file name, full path, and
     *         extension.
     * @throws InvalidMaxMergeHunksException
     *         The specified value for the number of merge hunks to return is not valid.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMergeConflictsIterable describeMergeConflictsPaginator(
            DescribeMergeConflictsRequest describeMergeConflictsRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, MergeOptionRequiredException,
            InvalidMergeOptionException, InvalidContinuationTokenException, CommitRequiredException, CommitDoesNotExistException,
            InvalidCommitException, TipsDivergenceExceededException, PathRequiredException, InvalidPathException,
            FileDoesNotExistException, InvalidMaxMergeHunksException, InvalidConflictDetailLevelException,
            InvalidConflictResolutionStrategyException, MaximumFileContentToLoadExceededException,
            MaximumItemsToCompareExceededException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException,
            AwsServiceException, SdkClientException, CodeCommitException {
        return new DescribeMergeConflictsIterable(this, applyPaginatorUserAgent(describeMergeConflictsRequest));
    }

    /**
     * <p>
     * Returns information about one or more pull request events.
     * </p>
     *
     * @param describePullRequestEventsRequest
     * @return Result of the DescribePullRequestEvents operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidPullRequestEventTypeException
     *         The pull request event type is not valid.
     * @throws InvalidActorArnException
     *         The Amazon Resource Name (ARN) is not valid. Make sure that you have provided the full ARN for the user
     *         who initiated the change for the pull request, and then try again.
     * @throws ActorDoesNotExistException
     *         The specified Amazon Resource Name (ARN) does not exist in the AWS account.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DescribePullRequestEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribePullRequestEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePullRequestEventsResponse describePullRequestEvents(
            DescribePullRequestEventsRequest describePullRequestEventsRequest) throws PullRequestDoesNotExistException,
            InvalidPullRequestIdException, PullRequestIdRequiredException, InvalidPullRequestEventTypeException,
            InvalidActorArnException, ActorDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePullRequestEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePullRequestEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DescribePullRequestEventsRequest, DescribePullRequestEventsResponse>()
                        .withOperationName("DescribePullRequestEvents").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describePullRequestEventsRequest)
                        .withMarshaller(new DescribePullRequestEventsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about one or more pull request events.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePullRequestEvents(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsIterable responses = client.describePullRequestEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsIterable responses = client
     *             .describePullRequestEventsPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsIterable responses = client.describePullRequestEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePullRequestEvents(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePullRequestEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidPullRequestEventTypeException
     *         The pull request event type is not valid.
     * @throws InvalidActorArnException
     *         The Amazon Resource Name (ARN) is not valid. Make sure that you have provided the full ARN for the user
     *         who initiated the change for the pull request, and then try again.
     * @throws ActorDoesNotExistException
     *         The specified Amazon Resource Name (ARN) does not exist in the AWS account.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DescribePullRequestEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribePullRequestEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePullRequestEventsIterable describePullRequestEventsPaginator(
            DescribePullRequestEventsRequest describePullRequestEventsRequest) throws PullRequestDoesNotExistException,
            InvalidPullRequestIdException, PullRequestIdRequiredException, InvalidPullRequestEventTypeException,
            InvalidActorArnException, ActorDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        return new DescribePullRequestEventsIterable(this, applyPaginatorUserAgent(describePullRequestEventsRequest));
    }

    /**
     * <p>
     * Removes the association between a template and a repository so that approval rules based on the template are not
     * automatically created when pull requests are created in the specified repository. This does not delete any
     * approval rules previously created for pull requests through the template association.
     * </p>
     *
     * @param disassociateApprovalRuleTemplateFromRepositoryRequest
     * @return Result of the DisassociateApprovalRuleTemplateFromRepository operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the AWS Region where the template was created, and then try again.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DisassociateApprovalRuleTemplateFromRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DisassociateApprovalRuleTemplateFromRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateApprovalRuleTemplateFromRepositoryResponse disassociateApprovalRuleTemplateFromRepository(
            DisassociateApprovalRuleTemplateFromRepositoryRequest disassociateApprovalRuleTemplateFromRepositoryRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateDoesNotExistException, RepositoryNameRequiredException, InvalidRepositoryNameException,
            RepositoryDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateApprovalRuleTemplateFromRepositoryResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DisassociateApprovalRuleTemplateFromRepositoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateApprovalRuleTemplateFromRepositoryRequest, DisassociateApprovalRuleTemplateFromRepositoryResponse>()
                        .withOperationName("DisassociateApprovalRuleTemplateFromRepository").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler)
                        .withInput(disassociateApprovalRuleTemplateFromRepositoryRequest)
                        .withMarshaller(new DisassociateApprovalRuleTemplateFromRepositoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Evaluates whether a pull request has met all the conditions specified in its associated approval rules.
     * </p>
     *
     * @param evaluatePullRequestApprovalRulesRequest
     * @return Result of the EvaluatePullRequestApprovalRules operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidRevisionIdException
     *         The revision ID is not valid. Use GetPullRequest to determine the value.
     * @throws RevisionIdRequiredException
     *         A revision ID is required, but was not provided.
     * @throws RevisionNotCurrentException
     *         The revision ID provided in the request does not match the current revision ID. Use GetPullRequest to
     *         retrieve the current revision ID.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.EvaluatePullRequestApprovalRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/EvaluatePullRequestApprovalRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public EvaluatePullRequestApprovalRulesResponse evaluatePullRequestApprovalRules(
            EvaluatePullRequestApprovalRulesRequest evaluatePullRequestApprovalRulesRequest)
            throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException,
            InvalidRevisionIdException, RevisionIdRequiredException, RevisionNotCurrentException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EvaluatePullRequestApprovalRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, EvaluatePullRequestApprovalRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<EvaluatePullRequestApprovalRulesRequest, EvaluatePullRequestApprovalRulesResponse>()
                        .withOperationName("EvaluatePullRequestApprovalRules").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(evaluatePullRequestApprovalRulesRequest)
                        .withMarshaller(new EvaluatePullRequestApprovalRulesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a specified approval rule template.
     * </p>
     *
     * @param getApprovalRuleTemplateRequest
     * @return Result of the GetApprovalRuleTemplate operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the AWS Region where the template was created, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetApprovalRuleTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApprovalRuleTemplateResponse getApprovalRuleTemplate(GetApprovalRuleTemplateRequest getApprovalRuleTemplateRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateDoesNotExistException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApprovalRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApprovalRuleTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetApprovalRuleTemplateRequest, GetApprovalRuleTemplateResponse>()
                .withOperationName("GetApprovalRuleTemplate").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getApprovalRuleTemplateRequest)
                .withMarshaller(new GetApprovalRuleTemplateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the base-64 encoded content of an individual blob in a repository.
     * </p>
     *
     * @param getBlobRequest
     *        Represents the input of a get blob operation.
     * @return Result of the GetBlob operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws BlobIdRequiredException
     *         A blob ID is required, but was not specified.
     * @throws InvalidBlobIdException
     *         The specified blob is not valid.
     * @throws BlobIdDoesNotExistException
     *         The specified blob does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws FileTooLargeException
     *         The specified file exceeds the file size limit for AWS CodeCommit. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBlob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBlobResponse getBlob(GetBlobRequest getBlobRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, BlobIdRequiredException, InvalidBlobIdException,
            BlobIdDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException,
            FileTooLargeException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBlobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBlobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetBlobRequest, GetBlobResponse>().withOperationName("GetBlob")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getBlobRequest)
                .withMarshaller(new GetBlobRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a repository branch, including its name and the last commit ID.
     * </p>
     *
     * @param getBranchRequest
     *        Represents the input of a get branch operation.
     * @return Result of the GetBranch operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws BranchDoesNotExistException
     *         The specified branch does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBranch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBranchResponse getBranch(GetBranchRequest getBranchRequest) throws RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, BranchNameRequiredException,
            InvalidBranchNameException, BranchDoesNotExistException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBranchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBranchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetBranchRequest, GetBranchResponse>()
                .withOperationName("GetBranch").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBranchRequest)
                .withMarshaller(new GetBranchRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the content of a comment made on a change, file, or commit in a repository.
     * </p>
     *
     * @param getCommentRequest
     * @return Result of the GetComment operation returned by the service.
     * @throws CommentDoesNotExistException
     *         No comment exists with the provided ID. Verify that you have used the correct ID, and then try again.
     * @throws CommentIdRequiredException
     *         The comment ID is missing or null. A comment ID is required.
     * @throws InvalidCommentIdException
     *         The comment ID is not in a valid format. Make sure that you have provided the full comment ID.
     * @throws CommentDeletedException
     *         This comment has already been deleted. You cannot edit or delete a deleted comment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetComment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCommentResponse getComment(GetCommentRequest getCommentRequest) throws CommentDoesNotExistException,
            CommentIdRequiredException, InvalidCommentIdException, CommentDeletedException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCommentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCommentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCommentRequest, GetCommentResponse>()
                .withOperationName("GetComment").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCommentRequest)
                .withMarshaller(new GetCommentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about comments made on the comparison between two commits.
     * </p>
     *
     * @param getCommentsForComparedCommitRequest
     * @return Result of the GetCommentsForComparedCommit operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws CommitIdRequiredException
     *         A commit ID was not specified.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetCommentsForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCommentsForComparedCommitResponse getCommentsForComparedCommit(
            GetCommentsForComparedCommitRequest getCommentsForComparedCommitRequest) throws RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, CommitIdRequiredException, InvalidCommitIdException,
            CommitDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCommentsForComparedCommitResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCommentsForComparedCommitResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetCommentsForComparedCommitRequest, GetCommentsForComparedCommitResponse>()
                        .withOperationName("GetCommentsForComparedCommit").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getCommentsForComparedCommitRequest)
                        .withMarshaller(new GetCommentsForComparedCommitRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about comments made on the comparison between two commits.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCommentsForComparedCommit(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitIterable responses = client.getCommentsForComparedCommitPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitIterable responses = client
     *             .getCommentsForComparedCommitPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitIterable responses = client.getCommentsForComparedCommitPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCommentsForComparedCommit(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCommentsForComparedCommitRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws CommitIdRequiredException
     *         A commit ID was not specified.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetCommentsForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCommentsForComparedCommitIterable getCommentsForComparedCommitPaginator(
            GetCommentsForComparedCommitRequest getCommentsForComparedCommitRequest) throws RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, CommitIdRequiredException, InvalidCommitIdException,
            CommitDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        return new GetCommentsForComparedCommitIterable(this, applyPaginatorUserAgent(getCommentsForComparedCommitRequest));
    }

    /**
     * <p>
     * Returns comments made on a pull request.
     * </p>
     *
     * @param getCommentsForPullRequestRequest
     * @return Result of the GetCommentsForPullRequest operation returned by the service.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws CommitIdRequiredException
     *         A commit ID was not specified.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws RepositoryNotAssociatedWithPullRequestException
     *         The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify
     *         the correct repository name for the pull request ID.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetCommentsForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCommentsForPullRequestResponse getCommentsForPullRequest(
            GetCommentsForPullRequestRequest getCommentsForPullRequestRequest) throws PullRequestIdRequiredException,
            PullRequestDoesNotExistException, InvalidPullRequestIdException, RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, CommitIdRequiredException, InvalidCommitIdException,
            CommitDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException,
            RepositoryNotAssociatedWithPullRequestException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCommentsForPullRequestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCommentsForPullRequestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetCommentsForPullRequestRequest, GetCommentsForPullRequestResponse>()
                        .withOperationName("GetCommentsForPullRequest").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getCommentsForPullRequestRequest)
                        .withMarshaller(new GetCommentsForPullRequestRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns comments made on a pull request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCommentsForPullRequest(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestIterable responses = client.getCommentsForPullRequestPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestIterable responses = client
     *             .getCommentsForPullRequestPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestIterable responses = client.getCommentsForPullRequestPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCommentsForPullRequest(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCommentsForPullRequestRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws CommitIdRequiredException
     *         A commit ID was not specified.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws RepositoryNotAssociatedWithPullRequestException
     *         The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify
     *         the correct repository name for the pull request ID.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetCommentsForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCommentsForPullRequestIterable getCommentsForPullRequestPaginator(
            GetCommentsForPullRequestRequest getCommentsForPullRequestRequest) throws PullRequestIdRequiredException,
            PullRequestDoesNotExistException, InvalidPullRequestIdException, RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, CommitIdRequiredException, InvalidCommitIdException,
            CommitDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException,
            RepositoryNotAssociatedWithPullRequestException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        return new GetCommentsForPullRequestIterable(this, applyPaginatorUserAgent(getCommentsForPullRequestRequest));
    }

    /**
     * <p>
     * Returns information about a commit, including commit message and committer information.
     * </p>
     *
     * @param getCommitRequest
     *        Represents the input of a get commit operation.
     * @return Result of the GetCommit operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws CommitIdRequiredException
     *         A commit ID was not specified.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws CommitIdDoesNotExistException
     *         The specified commit ID does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCommitResponse getCommit(GetCommitRequest getCommitRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, CommitIdRequiredException, InvalidCommitIdException,
            CommitIdDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCommitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCommitResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCommitRequest, GetCommitResponse>()
                .withOperationName("GetCommit").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCommitRequest)
                .withMarshaller(new GetCommitRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or
     * other fully qualified reference). Results can be limited to a specified path.
     * </p>
     *
     * @param getDifferencesRequest
     * @return Result of the GetDifferences operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws PathDoesNotExistException
     *         The specified path does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetDifferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDifferencesResponse getDifferences(GetDifferencesRequest getDifferencesRequest)
            throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException,
            InvalidContinuationTokenException, InvalidMaxResultsException, InvalidCommitIdException, CommitRequiredException,
            InvalidCommitException, CommitDoesNotExistException, InvalidPathException, PathDoesNotExistException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDifferencesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDifferencesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDifferencesRequest, GetDifferencesResponse>()
                .withOperationName("GetDifferences").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDifferencesRequest)
                .withMarshaller(new GetDifferencesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or
     * other fully qualified reference). Results can be limited to a specified path.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDifferences(software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetDifferencesIterable responses = client.getDifferencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.GetDifferencesIterable responses = client
     *             .getDifferencesPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetDifferencesIterable responses = client.getDifferencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDifferences(software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest)} operation.</b>
     * </p>
     *
     * @param getDifferencesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws PathDoesNotExistException
     *         The specified path does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetDifferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDifferencesIterable getDifferencesPaginator(GetDifferencesRequest getDifferencesRequest)
            throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException,
            InvalidContinuationTokenException, InvalidMaxResultsException, InvalidCommitIdException, CommitRequiredException,
            InvalidCommitException, CommitDoesNotExistException, InvalidPathException, PathDoesNotExistException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        return new GetDifferencesIterable(this, applyPaginatorUserAgent(getDifferencesRequest));
    }

    /**
     * <p>
     * Returns the base-64 encoded contents of a specified file and its metadata.
     * </p>
     *
     * @param getFileRequest
     * @return Result of the GetFile operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws FileDoesNotExistException
     *         The specified file does not exist. Verify that you have used the correct file name, full path, and
     *         extension.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws FileTooLargeException
     *         The specified file exceeds the file size limit for AWS CodeCommit. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetFile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFileResponse getFile(GetFileRequest getFileRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, InvalidCommitException, CommitDoesNotExistException,
            PathRequiredException, InvalidPathException, FileDoesNotExistException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, FileTooLargeException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetFileRequest, GetFileResponse>().withOperationName("GetFile")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getFileRequest)
                .withMarshaller(new GetFileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the contents of a specified folder in a repository.
     * </p>
     *
     * @param getFolderRequest
     * @return Result of the GetFolder operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws FolderDoesNotExistException
     *         The specified folder does not exist. Either the folder name is not correct, or you did not enter the full
     *         path to the folder.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetFolder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFolderResponse getFolder(GetFolderRequest getFolderRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, InvalidCommitException, CommitDoesNotExistException,
            PathRequiredException, InvalidPathException, FolderDoesNotExistException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFolderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetFolderRequest, GetFolderResponse>()
                .withOperationName("GetFolder").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getFolderRequest)
                .withMarshaller(new GetFolderRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a specified merge commit.
     * </p>
     *
     * @param getMergeCommitRequest
     * @return Result of the GetMergeCommit operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetMergeCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeCommit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMergeCommitResponse getMergeCommit(GetMergeCommitRequest getMergeCommitRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            CommitRequiredException, InvalidCommitException, CommitDoesNotExistException, InvalidConflictDetailLevelException,
            InvalidConflictResolutionStrategyException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMergeCommitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMergeCommitResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMergeCommitRequest, GetMergeCommitResponse>()
                .withOperationName("GetMergeCommit").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMergeCommitRequest)
                .withMarshaller(new GetMergeCommitRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about merge conflicts between the before and after commit IDs for a pull request in a
     * repository.
     * </p>
     *
     * @param getMergeConflictsRequest
     * @return Result of the GetMergeConflicts operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws MergeOptionRequiredException
     *         A merge option or stategy is required, and none was provided.
     * @throws InvalidMergeOptionException
     *         The specified merge option is not valid for this operation. Not all merge strategies are supported for
     *         all operations.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws InvalidMaxConflictFilesException
     *         The specified value for the number of conflict files to return is not valid.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidDestinationCommitSpecifierException
     *         The destination commit specifier is not valid. You must provide a valid branch name, tag, or full commit
     *         ID.
     * @throws InvalidSourceCommitSpecifierException
     *         The source commit specifier is not valid. You must provide a valid branch name, tag, or full commit ID.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetMergeConflictsResponse getMergeConflicts(GetMergeConflictsRequest getMergeConflictsRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            MergeOptionRequiredException, InvalidMergeOptionException, InvalidContinuationTokenException,
            CommitRequiredException, CommitDoesNotExistException, InvalidCommitException, TipsDivergenceExceededException,
            InvalidMaxConflictFilesException, InvalidConflictDetailLevelException, InvalidDestinationCommitSpecifierException,
            InvalidSourceCommitSpecifierException, InvalidConflictResolutionStrategyException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMergeConflictsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMergeConflictsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMergeConflictsRequest, GetMergeConflictsResponse>()
                .withOperationName("GetMergeConflicts").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMergeConflictsRequest)
                .withMarshaller(new GetMergeConflictsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about merge conflicts between the before and after commit IDs for a pull request in a
     * repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getMergeConflicts(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsIterable responses = client.getMergeConflictsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsIterable responses = client
     *             .getMergeConflictsPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsIterable responses = client.getMergeConflictsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMergeConflicts(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getMergeConflictsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws MergeOptionRequiredException
     *         A merge option or stategy is required, and none was provided.
     * @throws InvalidMergeOptionException
     *         The specified merge option is not valid for this operation. Not all merge strategies are supported for
     *         all operations.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws InvalidMaxConflictFilesException
     *         The specified value for the number of conflict files to return is not valid.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidDestinationCommitSpecifierException
     *         The destination commit specifier is not valid. You must provide a valid branch name, tag, or full commit
     *         ID.
     * @throws InvalidSourceCommitSpecifierException
     *         The source commit specifier is not valid. You must provide a valid branch name, tag, or full commit ID.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetMergeConflictsIterable getMergeConflictsPaginator(GetMergeConflictsRequest getMergeConflictsRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            MergeOptionRequiredException, InvalidMergeOptionException, InvalidContinuationTokenException,
            CommitRequiredException, CommitDoesNotExistException, InvalidCommitException, TipsDivergenceExceededException,
            InvalidMaxConflictFilesException, InvalidConflictDetailLevelException, InvalidDestinationCommitSpecifierException,
            InvalidSourceCommitSpecifierException, InvalidConflictResolutionStrategyException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        return new GetMergeConflictsIterable(this, applyPaginatorUserAgent(getMergeConflictsRequest));
    }

    /**
     * <p>
     * Returns information about the merge options available for merging two specified branches. For details about why a
     * merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.
     * </p>
     *
     * @param getMergeOptionsRequest
     * @return Result of the GetMergeOptions operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetMergeOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMergeOptionsResponse getMergeOptions(GetMergeOptionsRequest getMergeOptionsRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            CommitRequiredException, CommitDoesNotExistException, InvalidCommitException, TipsDivergenceExceededException,
            InvalidConflictDetailLevelException, InvalidConflictResolutionStrategyException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMergeOptionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMergeOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMergeOptionsRequest, GetMergeOptionsResponse>()
                .withOperationName("GetMergeOptions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMergeOptionsRequest)
                .withMarshaller(new GetMergeOptionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about a pull request in a specified repository.
     * </p>
     *
     * @param getPullRequestRequest
     * @return Result of the GetPullRequest operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequest" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPullRequestResponse getPullRequest(GetPullRequestRequest getPullRequestRequest)
            throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPullRequestResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPullRequestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetPullRequestRequest, GetPullRequestResponse>()
                .withOperationName("GetPullRequest").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getPullRequestRequest)
                .withMarshaller(new GetPullRequestRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about the approval states for a specified pull request. Approval states only apply to pull
     * requests that have one or more approval rules applied to them.
     * </p>
     *
     * @param getPullRequestApprovalStatesRequest
     * @return Result of the GetPullRequestApprovalStates operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidRevisionIdException
     *         The revision ID is not valid. Use GetPullRequest to determine the value.
     * @throws RevisionIdRequiredException
     *         A revision ID is required, but was not provided.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetPullRequestApprovalStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequestApprovalStates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPullRequestApprovalStatesResponse getPullRequestApprovalStates(
            GetPullRequestApprovalStatesRequest getPullRequestApprovalStatesRequest) throws PullRequestDoesNotExistException,
            InvalidPullRequestIdException, PullRequestIdRequiredException, InvalidRevisionIdException,
            RevisionIdRequiredException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPullRequestApprovalStatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPullRequestApprovalStatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetPullRequestApprovalStatesRequest, GetPullRequestApprovalStatesResponse>()
                        .withOperationName("GetPullRequestApprovalStates").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getPullRequestApprovalStatesRequest)
                        .withMarshaller(new GetPullRequestApprovalStatesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so,
     * the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the
     * pull request.
     * </p>
     *
     * @param getPullRequestOverrideStateRequest
     * @return Result of the GetPullRequestOverrideState operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidRevisionIdException
     *         The revision ID is not valid. Use GetPullRequest to determine the value.
     * @throws RevisionIdRequiredException
     *         A revision ID is required, but was not provided.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetPullRequestOverrideState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequestOverrideState"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPullRequestOverrideStateResponse getPullRequestOverrideState(
            GetPullRequestOverrideStateRequest getPullRequestOverrideStateRequest) throws PullRequestDoesNotExistException,
            InvalidPullRequestIdException, PullRequestIdRequiredException, InvalidRevisionIdException,
            RevisionIdRequiredException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPullRequestOverrideStateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPullRequestOverrideStateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetPullRequestOverrideStateRequest, GetPullRequestOverrideStateResponse>()
                        .withOperationName("GetPullRequestOverrideState").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getPullRequestOverrideStateRequest)
                        .withMarshaller(new GetPullRequestOverrideStateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a repository.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a webpage.
     * </p>
     * </note>
     *
     * @param getRepositoryRequest
     *        Represents the input of a get repository operation.
     * @return Result of the GetRepository operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepository" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRepositoryResponse getRepository(GetRepositoryRequest getRepositoryRequest) throws RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRepositoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetRepositoryRequest, GetRepositoryResponse>()
                .withOperationName("GetRepository").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getRepositoryRequest)
                .withMarshaller(new GetRepositoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about triggers configured for a repository.
     * </p>
     *
     * @param getRepositoryTriggersRequest
     *        Represents the input of a get repository triggers operation.
     * @return Result of the GetRepositoryTriggers operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.GetRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRepositoryTriggersResponse getRepositoryTriggers(GetRepositoryTriggersRequest getRepositoryTriggersRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRepositoryTriggersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRepositoryTriggersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetRepositoryTriggersRequest, GetRepositoryTriggersResponse>()
                .withOperationName("GetRepositoryTriggers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getRepositoryTriggersRequest)
                .withMarshaller(new GetRepositoryTriggersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not
     * specified, the AWS Region where you are signed in is used.
     * </p>
     *
     * @param listApprovalRuleTemplatesRequest
     * @return Result of the ListApprovalRuleTemplates operation returned by the service.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListApprovalRuleTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListApprovalRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListApprovalRuleTemplatesResponse listApprovalRuleTemplates(
            ListApprovalRuleTemplatesRequest listApprovalRuleTemplatesRequest) throws InvalidMaxResultsException,
            InvalidContinuationTokenException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListApprovalRuleTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListApprovalRuleTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListApprovalRuleTemplatesRequest, ListApprovalRuleTemplatesResponse>()
                        .withOperationName("ListApprovalRuleTemplates").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listApprovalRuleTemplatesRequest)
                        .withMarshaller(new ListApprovalRuleTemplatesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not
     * specified, the AWS Region where you are signed in is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApprovalRuleTemplates(software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListApprovalRuleTemplatesIterable responses = client.listApprovalRuleTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.ListApprovalRuleTemplatesIterable responses = client
     *             .listApprovalRuleTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListApprovalRuleTemplatesIterable responses = client.listApprovalRuleTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApprovalRuleTemplates(software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApprovalRuleTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListApprovalRuleTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListApprovalRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListApprovalRuleTemplatesIterable listApprovalRuleTemplatesPaginator(
            ListApprovalRuleTemplatesRequest listApprovalRuleTemplatesRequest) throws InvalidMaxResultsException,
            InvalidContinuationTokenException, AwsServiceException, SdkClientException, CodeCommitException {
        return new ListApprovalRuleTemplatesIterable(this, applyPaginatorUserAgent(listApprovalRuleTemplatesRequest));
    }

    /**
     * <p>
     * Lists all approval rule templates that are associated with a specified repository.
     * </p>
     *
     * @param listAssociatedApprovalRuleTemplatesForRepositoryRequest
     * @return Result of the ListAssociatedApprovalRuleTemplatesForRepository operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListAssociatedApprovalRuleTemplatesForRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListAssociatedApprovalRuleTemplatesForRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAssociatedApprovalRuleTemplatesForRepositoryResponse listAssociatedApprovalRuleTemplatesForRepository(
            ListAssociatedApprovalRuleTemplatesForRepositoryRequest listAssociatedApprovalRuleTemplatesForRepositoryRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            InvalidMaxResultsException, InvalidContinuationTokenException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssociatedApprovalRuleTemplatesForRepositoryResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListAssociatedApprovalRuleTemplatesForRepositoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListAssociatedApprovalRuleTemplatesForRepositoryRequest, ListAssociatedApprovalRuleTemplatesForRepositoryResponse>()
                        .withOperationName("ListAssociatedApprovalRuleTemplatesForRepository")
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listAssociatedApprovalRuleTemplatesForRepositoryRequest)
                        .withMarshaller(new ListAssociatedApprovalRuleTemplatesForRepositoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all approval rule templates that are associated with a specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedApprovalRuleTemplatesForRepository(software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListAssociatedApprovalRuleTemplatesForRepositoryIterable responses = client.listAssociatedApprovalRuleTemplatesForRepositoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.ListAssociatedApprovalRuleTemplatesForRepositoryIterable responses = client
     *             .listAssociatedApprovalRuleTemplatesForRepositoryPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListAssociatedApprovalRuleTemplatesForRepositoryIterable responses = client.listAssociatedApprovalRuleTemplatesForRepositoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedApprovalRuleTemplatesForRepository(software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociatedApprovalRuleTemplatesForRepositoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListAssociatedApprovalRuleTemplatesForRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListAssociatedApprovalRuleTemplatesForRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAssociatedApprovalRuleTemplatesForRepositoryIterable listAssociatedApprovalRuleTemplatesForRepositoryPaginator(
            ListAssociatedApprovalRuleTemplatesForRepositoryRequest listAssociatedApprovalRuleTemplatesForRepositoryRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            InvalidMaxResultsException, InvalidContinuationTokenException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        return new ListAssociatedApprovalRuleTemplatesForRepositoryIterable(this,
                applyPaginatorUserAgent(listAssociatedApprovalRuleTemplatesForRepositoryRequest));
    }

    /**
     * <p>
     * Gets information about one or more branches in a repository.
     * </p>
     *
     * @param listBranchesRequest
     *        Represents the input of a list branches operation.
     * @return Result of the ListBranches operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListBranchesResponse listBranches(ListBranchesRequest listBranchesRequest) throws RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, InvalidContinuationTokenException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBranchesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBranchesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListBranchesRequest, ListBranchesResponse>()
                .withOperationName("ListBranches").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listBranchesRequest)
                .withMarshaller(new ListBranchesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about one or more branches in a repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBranches(software.amazon.awssdk.services.codecommit.model.ListBranchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListBranchesIterable responses = client.listBranchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.ListBranchesIterable responses = client.listBranchesPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.ListBranchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListBranchesIterable responses = client.listBranchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBranches(software.amazon.awssdk.services.codecommit.model.ListBranchesRequest)} operation.</b>
     * </p>
     *
     * @param listBranchesRequest
     *        Represents the input of a list branches operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListBranchesIterable listBranchesPaginator(ListBranchesRequest listBranchesRequest)
            throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, InvalidContinuationTokenException,
            AwsServiceException, SdkClientException, CodeCommitException {
        return new ListBranchesIterable(this, applyPaginatorUserAgent(listBranchesRequest));
    }

    /**
     * <p>
     * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status
     * or pull request author ARN.
     * </p>
     *
     * @param listPullRequestsRequest
     * @return Result of the ListPullRequests operation returned by the service.
     * @throws InvalidPullRequestStatusException
     *         The pull request status is not valid. The only valid values are <code>OPEN</code> and <code>CLOSED</code>
     *         .
     * @throws InvalidAuthorArnException
     *         The Amazon Resource Name (ARN) is not valid. Make sure that you have provided the full ARN for the author
     *         of the pull request, and then try again.
     * @throws AuthorDoesNotExistException
     *         The specified Amazon Resource Name (ARN) does not exist in the AWS account.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListPullRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPullRequestsResponse listPullRequests(ListPullRequestsRequest listPullRequestsRequest)
            throws InvalidPullRequestStatusException, InvalidAuthorArnException, AuthorDoesNotExistException,
            RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            InvalidMaxResultsException, InvalidContinuationTokenException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPullRequestsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPullRequestsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListPullRequestsRequest, ListPullRequestsResponse>()
                .withOperationName("ListPullRequests").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listPullRequestsRequest)
                .withMarshaller(new ListPullRequestsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status
     * or pull request author ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPullRequests(software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsIterable responses = client.listPullRequestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsIterable responses = client
     *             .listPullRequestsPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsIterable responses = client.listPullRequestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPullRequests(software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPullRequestsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidPullRequestStatusException
     *         The pull request status is not valid. The only valid values are <code>OPEN</code> and <code>CLOSED</code>
     *         .
     * @throws InvalidAuthorArnException
     *         The Amazon Resource Name (ARN) is not valid. Make sure that you have provided the full ARN for the author
     *         of the pull request, and then try again.
     * @throws AuthorDoesNotExistException
     *         The specified Amazon Resource Name (ARN) does not exist in the AWS account.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListPullRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPullRequestsIterable listPullRequestsPaginator(ListPullRequestsRequest listPullRequestsRequest)
            throws InvalidPullRequestStatusException, InvalidAuthorArnException, AuthorDoesNotExistException,
            RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            InvalidMaxResultsException, InvalidContinuationTokenException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        return new ListPullRequestsIterable(this, applyPaginatorUserAgent(listPullRequestsRequest));
    }

    /**
     * <p>
     * Gets information about one or more repositories.
     * </p>
     *
     * @param listRepositoriesRequest
     *        Represents the input of a list repositories operation.
     * @return Result of the ListRepositories operation returned by the service.
     * @throws InvalidSortByException
     *         The specified sort by value is not valid.
     * @throws InvalidOrderException
     *         The specified sort order is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListRepositoriesResponse listRepositories(ListRepositoriesRequest listRepositoriesRequest)
            throws InvalidSortByException, InvalidOrderException, InvalidContinuationTokenException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRepositoriesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRepositoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListRepositoriesRequest, ListRepositoriesResponse>()
                .withOperationName("ListRepositories").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listRepositoriesRequest)
                .withMarshaller(new ListRepositoriesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about one or more repositories.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositories(software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesIterable responses = client.listRepositoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesIterable responses = client
     *             .listRepositoriesPaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesIterable responses = client.listRepositoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositories(software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRepositoriesRequest
     *        Represents the input of a list repositories operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidSortByException
     *         The specified sort by value is not valid.
     * @throws InvalidOrderException
     *         The specified sort order is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListRepositoriesIterable listRepositoriesPaginator(ListRepositoriesRequest listRepositoriesRequest)
            throws InvalidSortByException, InvalidOrderException, InvalidContinuationTokenException, AwsServiceException,
            SdkClientException, CodeCommitException {
        return new ListRepositoriesIterable(this, applyPaginatorUserAgent(listRepositoriesRequest));
    }

    /**
     * <p>
     * Lists all repositories associated with the specified approval rule template.
     * </p>
     *
     * @param listRepositoriesForApprovalRuleTemplateRequest
     * @return Result of the ListRepositoriesForApprovalRuleTemplate operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the AWS Region where the template was created, and then try again.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListRepositoriesForApprovalRuleTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositoriesForApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRepositoriesForApprovalRuleTemplateResponse listRepositoriesForApprovalRuleTemplate(
            ListRepositoriesForApprovalRuleTemplateRequest listRepositoriesForApprovalRuleTemplateRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRepositoriesForApprovalRuleTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListRepositoriesForApprovalRuleTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListRepositoriesForApprovalRuleTemplateRequest, ListRepositoriesForApprovalRuleTemplateResponse>()
                        .withOperationName("ListRepositoriesForApprovalRuleTemplate").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listRepositoriesForApprovalRuleTemplateRequest)
                        .withMarshaller(new ListRepositoriesForApprovalRuleTemplateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all repositories associated with the specified approval rule template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositoriesForApprovalRuleTemplate(software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesForApprovalRuleTemplateIterable responses = client.listRepositoriesForApprovalRuleTemplatePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesForApprovalRuleTemplateIterable responses = client
     *             .listRepositoriesForApprovalRuleTemplatePaginator(request);
     *     for (software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesForApprovalRuleTemplateIterable responses = client.listRepositoriesForApprovalRuleTemplatePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositoriesForApprovalRuleTemplate(software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRepositoriesForApprovalRuleTemplateRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the AWS Region where the template was created, and then try again.
     * @throws InvalidMaxResultsException
     *         The specified number of maximum results is not valid.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListRepositoriesForApprovalRuleTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositoriesForApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRepositoriesForApprovalRuleTemplateIterable listRepositoriesForApprovalRuleTemplatePaginator(
            ListRepositoriesForApprovalRuleTemplateRequest listRepositoriesForApprovalRuleTemplateRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        return new ListRepositoriesForApprovalRuleTemplateIterable(this,
                applyPaginatorUserAgent(listRepositoriesForApprovalRuleTemplateRequest));
    }

    /**
     * <p>
     * Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit. For a list of valid
     * resources in AWS CodeCommit, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the<i> AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws ResourceArnRequiredException
     *         A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is required. For a list of valid
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.
     * @throws InvalidResourceArnException
     *         The value for the resource ARN is not valid. For more information about resources in AWS CodeCommit, see
     *         <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws RepositoryDoesNotExistException, InvalidRepositoryNameException, ResourceArnRequiredException,
            InvalidResourceArnException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Merges two branches using the fast-forward merge strategy.
     * </p>
     *
     * @param mergeBranchesByFastForwardRequest
     * @return Result of the MergeBranchesByFastForward operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidTargetBranchException
     *         The specified target branch is not valid.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws BranchNameIsTagNameException
     *         The specified branch name is not valid because it is a tag name. Enter the name of a branch in the
     *         repository. For a list of valid branch names, use <a>ListBranches</a>.
     * @throws BranchDoesNotExistException
     *         The specified branch does not exist.
     * @throws ManualMergeRequiredException
     *         The pull request cannot be merged automatically into the destination branch. You must manually merge the
     *         branches and resolve any conflicts.
     * @throws ConcurrentReferenceUpdateException
     *         The merge cannot be completed because the target branch has been modified. Another user might have
     *         modified the target branch while the merge was in progress. Wait a few minutes, and then try again.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.MergeBranchesByFastForward
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesByFastForward"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public MergeBranchesByFastForwardResponse mergeBranchesByFastForward(
            MergeBranchesByFastForwardRequest mergeBranchesByFastForwardRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, TipsDivergenceExceededException,
            CommitRequiredException, InvalidCommitException, CommitDoesNotExistException, InvalidTargetBranchException,
            InvalidBranchNameException, BranchNameRequiredException, BranchNameIsTagNameException, BranchDoesNotExistException,
            ManualMergeRequiredException, ConcurrentReferenceUpdateException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<MergeBranchesByFastForwardResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, MergeBranchesByFastForwardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<MergeBranchesByFastForwardRequest, MergeBranchesByFastForwardResponse>()
                        .withOperationName("MergeBranchesByFastForward").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(mergeBranchesByFastForwardRequest)
                        .withMarshaller(new MergeBranchesByFastForwardRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Merges two branches using the squash merge strategy.
     * </p>
     *
     * @param mergeBranchesBySquashRequest
     * @return Result of the MergeBranchesBySquash operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidTargetBranchException
     *         The specified target branch is not valid.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws BranchNameIsTagNameException
     *         The specified branch name is not valid because it is a tag name. Enter the name of a branch in the
     *         repository. For a list of valid branch names, use <a>ListBranches</a>.
     * @throws BranchDoesNotExistException
     *         The specified branch does not exist.
     * @throws ManualMergeRequiredException
     *         The pull request cannot be merged automatically into the destination branch. You must manually merge the
     *         branches and resolve any conflicts.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws InvalidConflictResolutionException
     *         The specified conflict resolution list is not valid.
     * @throws MaximumConflictResolutionEntriesExceededException
     *         The number of allowed conflict resolution entries was exceeded.
     * @throws MultipleConflictResolutionEntriesException
     *         More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict
     *         resolution entry.
     * @throws ReplacementTypeRequiredException
     *         A replacement type is required.
     * @throws InvalidReplacementTypeException
     *         Automerge was specified for resolving the conflict, but the specified replacement type is not valid.
     * @throws ReplacementContentRequiredException
     *         USE_NEW_CONTENT was specified, but no replacement content has been provided.
     * @throws InvalidReplacementContentException
     *         Automerge was specified for resolving the conflict, but the replacement type is not valid or content is
     *         missing.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws FileContentSizeLimitExceededException
     *         The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file
     *         content change size is 7 MB. Consider making these changes using a Git client.
     * @throws FolderContentSizeLimitExceededException
     *         The commit cannot be created because at least one of the overall changes in the commit results in a
     *         folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or
     *         split the changes across multiple folders.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws FileModeRequiredException
     *         The commit cannot be created because no file mode has been specified. A file mode is required to update
     *         mode permissions for a file.
     * @throws InvalidFileModeException
     *         The specified file mode permission is not valid. For a list of valid file mode permissions, see
     *         <a>PutFile</a>.
     * @throws NameLengthExceededException
     *         The user name is not valid because it has exceeded the character limit for author names.
     * @throws InvalidEmailException
     *         The specified email address either contains one or more characters that are not allowed, or it exceeds
     *         the maximum number of characters allowed for an email address.
     * @throws CommitMessageLengthExceededException
     *         The commit message is too long. Provide a shorter string.
     * @throws ConcurrentReferenceUpdateException
     *         The merge cannot be completed because the target branch has been modified. Another user might have
     *         modified the target branch while the merge was in progress. Wait a few minutes, and then try again.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.MergeBranchesBySquash
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesBySquash"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public MergeBranchesBySquashResponse mergeBranchesBySquash(MergeBranchesBySquashRequest mergeBranchesBySquashRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            TipsDivergenceExceededException, CommitRequiredException, InvalidCommitException, CommitDoesNotExistException,
            InvalidTargetBranchException, InvalidBranchNameException, BranchNameRequiredException, BranchNameIsTagNameException,
            BranchDoesNotExistException, ManualMergeRequiredException, InvalidConflictDetailLevelException,
            InvalidConflictResolutionStrategyException, InvalidConflictResolutionException,
            MaximumConflictResolutionEntriesExceededException, MultipleConflictResolutionEntriesException,
            ReplacementTypeRequiredException, InvalidReplacementTypeException, ReplacementContentRequiredException,
            InvalidReplacementContentException, PathRequiredException, InvalidPathException,
            FileContentSizeLimitExceededException, FolderContentSizeLimitExceededException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException, FileModeRequiredException,
            InvalidFileModeException, NameLengthExceededException, InvalidEmailException, CommitMessageLengthExceededException,
            ConcurrentReferenceUpdateException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<MergeBranchesBySquashResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, MergeBranchesBySquashResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<MergeBranchesBySquashRequest, MergeBranchesBySquashResponse>()
                .withOperationName("MergeBranchesBySquash").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(mergeBranchesBySquashRequest)
                .withMarshaller(new MergeBranchesBySquashRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Merges two specified branches using the three-way merge strategy.
     * </p>
     *
     * @param mergeBranchesByThreeWayRequest
     * @return Result of the MergeBranchesByThreeWay operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidTargetBranchException
     *         The specified target branch is not valid.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws BranchNameIsTagNameException
     *         The specified branch name is not valid because it is a tag name. Enter the name of a branch in the
     *         repository. For a list of valid branch names, use <a>ListBranches</a>.
     * @throws BranchDoesNotExistException
     *         The specified branch does not exist.
     * @throws ManualMergeRequiredException
     *         The pull request cannot be merged automatically into the destination branch. You must manually merge the
     *         branches and resolve any conflicts.
     * @throws ConcurrentReferenceUpdateException
     *         The merge cannot be completed because the target branch has been modified. Another user might have
     *         modified the target branch while the merge was in progress. Wait a few minutes, and then try again.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws InvalidConflictResolutionException
     *         The specified conflict resolution list is not valid.
     * @throws MaximumConflictResolutionEntriesExceededException
     *         The number of allowed conflict resolution entries was exceeded.
     * @throws MultipleConflictResolutionEntriesException
     *         More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict
     *         resolution entry.
     * @throws ReplacementTypeRequiredException
     *         A replacement type is required.
     * @throws InvalidReplacementTypeException
     *         Automerge was specified for resolving the conflict, but the specified replacement type is not valid.
     * @throws ReplacementContentRequiredException
     *         USE_NEW_CONTENT was specified, but no replacement content has been provided.
     * @throws InvalidReplacementContentException
     *         Automerge was specified for resolving the conflict, but the replacement type is not valid or content is
     *         missing.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws FileContentSizeLimitExceededException
     *         The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file
     *         content change size is 7 MB. Consider making these changes using a Git client.
     * @throws FolderContentSizeLimitExceededException
     *         The commit cannot be created because at least one of the overall changes in the commit results in a
     *         folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or
     *         split the changes across multiple folders.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws FileModeRequiredException
     *         The commit cannot be created because no file mode has been specified. A file mode is required to update
     *         mode permissions for a file.
     * @throws InvalidFileModeException
     *         The specified file mode permission is not valid. For a list of valid file mode permissions, see
     *         <a>PutFile</a>.
     * @throws NameLengthExceededException
     *         The user name is not valid because it has exceeded the character limit for author names.
     * @throws InvalidEmailException
     *         The specified email address either contains one or more characters that are not allowed, or it exceeds
     *         the maximum number of characters allowed for an email address.
     * @throws CommitMessageLengthExceededException
     *         The commit message is too long. Provide a shorter string.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.MergeBranchesByThreeWay
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesByThreeWay"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public MergeBranchesByThreeWayResponse mergeBranchesByThreeWay(MergeBranchesByThreeWayRequest mergeBranchesByThreeWayRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            TipsDivergenceExceededException, CommitRequiredException, InvalidCommitException, CommitDoesNotExistException,
            InvalidTargetBranchException, InvalidBranchNameException, BranchNameRequiredException, BranchNameIsTagNameException,
            BranchDoesNotExistException, ManualMergeRequiredException, ConcurrentReferenceUpdateException,
            InvalidConflictDetailLevelException, InvalidConflictResolutionStrategyException, InvalidConflictResolutionException,
            MaximumConflictResolutionEntriesExceededException, MultipleConflictResolutionEntriesException,
            ReplacementTypeRequiredException, InvalidReplacementTypeException, ReplacementContentRequiredException,
            InvalidReplacementContentException, PathRequiredException, InvalidPathException,
            FileContentSizeLimitExceededException, FolderContentSizeLimitExceededException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException, FileModeRequiredException,
            InvalidFileModeException, NameLengthExceededException, InvalidEmailException, CommitMessageLengthExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<MergeBranchesByThreeWayResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, MergeBranchesByThreeWayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<MergeBranchesByThreeWayRequest, MergeBranchesByThreeWayResponse>()
                .withOperationName("MergeBranchesByThreeWay").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(mergeBranchesByThreeWayRequest)
                .withMarshaller(new MergeBranchesByThreeWayRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull
     * request.
     * </p>
     *
     * @param mergePullRequestByFastForwardRequest
     * @return Result of the MergePullRequestByFastForward operation returned by the service.
     * @throws ManualMergeRequiredException
     *         The pull request cannot be merged automatically into the destination branch. You must manually merge the
     *         branches and resolve any conflicts.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws TipOfSourceReferenceIsDifferentException
     *         The tip of the source branch in the destination repository does not match the tip of the source branch
     *         specified in your request. The pull request might have been updated. Make sure that you have the latest
     *         changes.
     * @throws ReferenceDoesNotExistException
     *         The specified reference does not exist. You must provide a full commit ID.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws RepositoryNotAssociatedWithPullRequestException
     *         The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify
     *         the correct repository name for the pull request ID.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws ConcurrentReferenceUpdateException
     *         The merge cannot be completed because the target branch has been modified. Another user might have
     *         modified the target branch while the merge was in progress. Wait a few minutes, and then try again.
     * @throws PullRequestApprovalRulesNotSatisfiedException
     *         The pull request cannot be merged because one or more approval rules applied to the pull request have
     *         conditions that have not been met.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.MergePullRequestByFastForward
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestByFastForward"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public MergePullRequestByFastForwardResponse mergePullRequestByFastForward(
            MergePullRequestByFastForwardRequest mergePullRequestByFastForwardRequest) throws ManualMergeRequiredException,
            PullRequestAlreadyClosedException, PullRequestDoesNotExistException, InvalidPullRequestIdException,
            PullRequestIdRequiredException, TipOfSourceReferenceIsDifferentException, ReferenceDoesNotExistException,
            InvalidCommitIdException, RepositoryNotAssociatedWithPullRequestException, RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, ConcurrentReferenceUpdateException,
            PullRequestApprovalRulesNotSatisfiedException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<MergePullRequestByFastForwardResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, MergePullRequestByFastForwardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<MergePullRequestByFastForwardRequest, MergePullRequestByFastForwardResponse>()
                        .withOperationName("MergePullRequestByFastForward").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(mergePullRequestByFastForwardRequest)
                        .withMarshaller(new MergePullRequestByFastForwardRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.
     * </p>
     *
     * @param mergePullRequestBySquashRequest
     * @return Result of the MergePullRequestBySquash operation returned by the service.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws ManualMergeRequiredException
     *         The pull request cannot be merged automatically into the destination branch. You must manually merge the
     *         branches and resolve any conflicts.
     * @throws TipOfSourceReferenceIsDifferentException
     *         The tip of the source branch in the destination repository does not match the tip of the source branch
     *         specified in your request. The pull request might have been updated. Make sure that you have the latest
     *         changes.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws NameLengthExceededException
     *         The user name is not valid because it has exceeded the character limit for author names.
     * @throws InvalidEmailException
     *         The specified email address either contains one or more characters that are not allowed, or it exceeds
     *         the maximum number of characters allowed for an email address.
     * @throws CommitMessageLengthExceededException
     *         The commit message is too long. Provide a shorter string.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws InvalidConflictResolutionException
     *         The specified conflict resolution list is not valid.
     * @throws ReplacementTypeRequiredException
     *         A replacement type is required.
     * @throws InvalidReplacementTypeException
     *         Automerge was specified for resolving the conflict, but the specified replacement type is not valid.
     * @throws MultipleConflictResolutionEntriesException
     *         More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict
     *         resolution entry.
     * @throws ReplacementContentRequiredException
     *         USE_NEW_CONTENT was specified, but no replacement content has been provided.
     * @throws MaximumConflictResolutionEntriesExceededException
     *         The number of allowed conflict resolution entries was exceeded.
     * @throws ConcurrentReferenceUpdateException
     *         The merge cannot be completed because the target branch has been modified. Another user might have
     *         modified the target branch while the merge was in progress. Wait a few minutes, and then try again.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws InvalidFileModeException
     *         The specified file mode permission is not valid. For a list of valid file mode permissions, see
     *         <a>PutFile</a>.
     * @throws InvalidReplacementContentException
     *         Automerge was specified for resolving the conflict, but the replacement type is not valid or content is
     *         missing.
     * @throws FileContentSizeLimitExceededException
     *         The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file
     *         content change size is 7 MB. Consider making these changes using a Git client.
     * @throws FolderContentSizeLimitExceededException
     *         The commit cannot be created because at least one of the overall changes in the commit results in a
     *         folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or
     *         split the changes across multiple folders.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws RepositoryNotAssociatedWithPullRequestException
     *         The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify
     *         the correct repository name for the pull request ID.
     * @throws PullRequestApprovalRulesNotSatisfiedException
     *         The pull request cannot be merged because one or more approval rules applied to the pull request have
     *         conditions that have not been met.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.MergePullRequestBySquash
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestBySquash"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public MergePullRequestBySquashResponse mergePullRequestBySquash(
            MergePullRequestBySquashRequest mergePullRequestBySquashRequest) throws PullRequestAlreadyClosedException,
            PullRequestDoesNotExistException, PullRequestIdRequiredException, InvalidPullRequestIdException,
            InvalidCommitIdException, ManualMergeRequiredException, TipOfSourceReferenceIsDifferentException,
            TipsDivergenceExceededException, NameLengthExceededException, InvalidEmailException,
            CommitMessageLengthExceededException, InvalidConflictDetailLevelException,
            InvalidConflictResolutionStrategyException, InvalidConflictResolutionException, ReplacementTypeRequiredException,
            InvalidReplacementTypeException, MultipleConflictResolutionEntriesException, ReplacementContentRequiredException,
            MaximumConflictResolutionEntriesExceededException, ConcurrentReferenceUpdateException, PathRequiredException,
            InvalidPathException, InvalidFileModeException, InvalidReplacementContentException,
            FileContentSizeLimitExceededException, FolderContentSizeLimitExceededException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException, RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, RepositoryNotAssociatedWithPullRequestException,
            PullRequestApprovalRulesNotSatisfiedException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<MergePullRequestBySquashResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, MergePullRequestBySquashResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<MergePullRequestBySquashRequest, MergePullRequestBySquashResponse>()
                        .withOperationName("MergePullRequestBySquash").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(mergePullRequestBySquashRequest)
                        .withMarshaller(new MergePullRequestBySquashRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull
     * request.
     * </p>
     *
     * @param mergePullRequestByThreeWayRequest
     * @return Result of the MergePullRequestByThreeWay operation returned by the service.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws ManualMergeRequiredException
     *         The pull request cannot be merged automatically into the destination branch. You must manually merge the
     *         branches and resolve any conflicts.
     * @throws TipOfSourceReferenceIsDifferentException
     *         The tip of the source branch in the destination repository does not match the tip of the source branch
     *         specified in your request. The pull request might have been updated. Make sure that you have the latest
     *         changes.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws NameLengthExceededException
     *         The user name is not valid because it has exceeded the character limit for author names.
     * @throws InvalidEmailException
     *         The specified email address either contains one or more characters that are not allowed, or it exceeds
     *         the maximum number of characters allowed for an email address.
     * @throws CommitMessageLengthExceededException
     *         The commit message is too long. Provide a shorter string.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws InvalidConflictResolutionException
     *         The specified conflict resolution list is not valid.
     * @throws ReplacementTypeRequiredException
     *         A replacement type is required.
     * @throws InvalidReplacementTypeException
     *         Automerge was specified for resolving the conflict, but the specified replacement type is not valid.
     * @throws MultipleConflictResolutionEntriesException
     *         More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict
     *         resolution entry.
     * @throws ReplacementContentRequiredException
     *         USE_NEW_CONTENT was specified, but no replacement content has been provided.
     * @throws MaximumConflictResolutionEntriesExceededException
     *         The number of allowed conflict resolution entries was exceeded.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws InvalidFileModeException
     *         The specified file mode permission is not valid. For a list of valid file mode permissions, see
     *         <a>PutFile</a>.
     * @throws InvalidReplacementContentException
     *         Automerge was specified for resolving the conflict, but the replacement type is not valid or content is
     *         missing.
     * @throws FileContentSizeLimitExceededException
     *         The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file
     *         content change size is 7 MB. Consider making these changes using a Git client.
     * @throws FolderContentSizeLimitExceededException
     *         The commit cannot be created because at least one of the overall changes in the commit results in a
     *         folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or
     *         split the changes across multiple folders.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws RepositoryNotAssociatedWithPullRequestException
     *         The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify
     *         the correct repository name for the pull request ID.
     * @throws ConcurrentReferenceUpdateException
     *         The merge cannot be completed because the target branch has been modified. Another user might have
     *         modified the target branch while the merge was in progress. Wait a few minutes, and then try again.
     * @throws PullRequestApprovalRulesNotSatisfiedException
     *         The pull request cannot be merged because one or more approval rules applied to the pull request have
     *         conditions that have not been met.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.MergePullRequestByThreeWay
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestByThreeWay"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public MergePullRequestByThreeWayResponse mergePullRequestByThreeWay(
            MergePullRequestByThreeWayRequest mergePullRequestByThreeWayRequest) throws PullRequestAlreadyClosedException,
            PullRequestDoesNotExistException, PullRequestIdRequiredException, InvalidPullRequestIdException,
            InvalidCommitIdException, ManualMergeRequiredException, TipOfSourceReferenceIsDifferentException,
            TipsDivergenceExceededException, NameLengthExceededException, InvalidEmailException,
            CommitMessageLengthExceededException, InvalidConflictDetailLevelException,
            InvalidConflictResolutionStrategyException, InvalidConflictResolutionException, ReplacementTypeRequiredException,
            InvalidReplacementTypeException, MultipleConflictResolutionEntriesException, ReplacementContentRequiredException,
            MaximumConflictResolutionEntriesExceededException, PathRequiredException, InvalidPathException,
            InvalidFileModeException, InvalidReplacementContentException, FileContentSizeLimitExceededException,
            FolderContentSizeLimitExceededException, MaximumFileContentToLoadExceededException,
            MaximumItemsToCompareExceededException, RepositoryNameRequiredException, InvalidRepositoryNameException,
            RepositoryDoesNotExistException, RepositoryNotAssociatedWithPullRequestException, ConcurrentReferenceUpdateException,
            PullRequestApprovalRulesNotSatisfiedException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<MergePullRequestByThreeWayResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, MergePullRequestByThreeWayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<MergePullRequestByThreeWayRequest, MergePullRequestByThreeWayResponse>()
                        .withOperationName("MergePullRequestByThreeWay").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(mergePullRequestByThreeWayRequest)
                        .withMarshaller(new MergePullRequestByThreeWayRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Sets aside (overrides) all approval rule requirements for a specified pull request.
     * </p>
     *
     * @param overridePullRequestApprovalRulesRequest
     * @return Result of the OverridePullRequestApprovalRules operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidRevisionIdException
     *         The revision ID is not valid. Use GetPullRequest to determine the value.
     * @throws RevisionIdRequiredException
     *         A revision ID is required, but was not provided.
     * @throws InvalidOverrideStatusException
     *         The override status is not valid. Valid statuses are OVERRIDE and REVOKE.
     * @throws OverrideStatusRequiredException
     *         An override status is required, but no value was provided. Valid values include OVERRIDE and REVOKE.
     * @throws OverrideAlreadySetException
     *         The pull request has already had its approval rules set to override.
     * @throws RevisionNotCurrentException
     *         The revision ID provided in the request does not match the current revision ID. Use GetPullRequest to
     *         retrieve the current revision ID.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.OverridePullRequestApprovalRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/OverridePullRequestApprovalRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public OverridePullRequestApprovalRulesResponse overridePullRequestApprovalRules(
            OverridePullRequestApprovalRulesRequest overridePullRequestApprovalRulesRequest)
            throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException,
            InvalidRevisionIdException, RevisionIdRequiredException, InvalidOverrideStatusException,
            OverrideStatusRequiredException, OverrideAlreadySetException, RevisionNotCurrentException,
            PullRequestAlreadyClosedException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<OverridePullRequestApprovalRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, OverridePullRequestApprovalRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<OverridePullRequestApprovalRulesRequest, OverridePullRequestApprovalRulesResponse>()
                        .withOperationName("OverridePullRequestApprovalRules").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(overridePullRequestApprovalRulesRequest)
                        .withMarshaller(new OverridePullRequestApprovalRulesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Posts a comment on the comparison between two commits.
     * </p>
     *
     * @param postCommentForComparedCommitRequest
     * @return Result of the PostCommentForComparedCommit operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws ClientRequestTokenRequiredException
     *         A client request token is required. A client request token is an unique, client-generated idempotency
     *         token that, when provided in a request, ensures the request cannot be repeated with a changed parameter.
     *         If a request is received with the same parameters and a token is included, the request returns
     *         information about the initial request that used that token.
     * @throws InvalidClientRequestTokenException
     *         The client request token is not valid.
     * @throws IdempotencyParameterMismatchException
     *         The client request token is not valid. Either the token is not in a valid format, or the token has been
     *         used in a previous request and cannot be reused.
     * @throws CommentContentRequiredException
     *         The comment is empty. You must provide some content for a comment. The content cannot be null.
     * @throws CommentContentSizeLimitExceededException
     *         The comment is too large. Comments are limited to 1,000 characters.
     * @throws InvalidFileLocationException
     *         The location of the file is not valid. Make sure that you include the file name and extension.
     * @throws InvalidRelativeFileVersionEnumException
     *         Either the enum is not in a valid format, or the specified file version enum is not valid in respect to
     *         the current file version.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidFilePositionException
     *         The position is not valid. Make sure that the line number exists in the version of the file you want to
     *         comment on.
     * @throws CommitIdRequiredException
     *         A commit ID was not specified.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws BeforeCommitIdAndAfterCommitIdAreSameException
     *         The before commit ID and the after commit ID are the same, which is not valid. The before commit ID and
     *         the after commit ID must be different commit IDs.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws PathDoesNotExistException
     *         The specified path does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.PostCommentForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PostCommentForComparedCommitResponse postCommentForComparedCommit(
            PostCommentForComparedCommitRequest postCommentForComparedCommitRequest) throws RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, ClientRequestTokenRequiredException,
            InvalidClientRequestTokenException, IdempotencyParameterMismatchException, CommentContentRequiredException,
            CommentContentSizeLimitExceededException, InvalidFileLocationException, InvalidRelativeFileVersionEnumException,
            PathRequiredException, InvalidFilePositionException, CommitIdRequiredException, InvalidCommitIdException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, BeforeCommitIdAndAfterCommitIdAreSameException,
            CommitDoesNotExistException, InvalidPathException, PathDoesNotExistException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PostCommentForComparedCommitResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PostCommentForComparedCommitResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<PostCommentForComparedCommitRequest, PostCommentForComparedCommitResponse>()
                        .withOperationName("PostCommentForComparedCommit").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(postCommentForComparedCommitRequest)
                        .withMarshaller(new PostCommentForComparedCommitRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Posts a comment on a pull request.
     * </p>
     *
     * @param postCommentForPullRequestRequest
     * @return Result of the PostCommentForPullRequest operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws RepositoryNotAssociatedWithPullRequestException
     *         The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify
     *         the correct repository name for the pull request ID.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws ClientRequestTokenRequiredException
     *         A client request token is required. A client request token is an unique, client-generated idempotency
     *         token that, when provided in a request, ensures the request cannot be repeated with a changed parameter.
     *         If a request is received with the same parameters and a token is included, the request returns
     *         information about the initial request that used that token.
     * @throws InvalidClientRequestTokenException
     *         The client request token is not valid.
     * @throws IdempotencyParameterMismatchException
     *         The client request token is not valid. Either the token is not in a valid format, or the token has been
     *         used in a previous request and cannot be reused.
     * @throws CommentContentRequiredException
     *         The comment is empty. You must provide some content for a comment. The content cannot be null.
     * @throws CommentContentSizeLimitExceededException
     *         The comment is too large. Comments are limited to 1,000 characters.
     * @throws InvalidFileLocationException
     *         The location of the file is not valid. Make sure that you include the file name and extension.
     * @throws InvalidRelativeFileVersionEnumException
     *         Either the enum is not in a valid format, or the specified file version enum is not valid in respect to
     *         the current file version.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidFilePositionException
     *         The position is not valid. Make sure that the line number exists in the version of the file you want to
     *         comment on.
     * @throws CommitIdRequiredException
     *         A commit ID was not specified.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws PathDoesNotExistException
     *         The specified path does not exist.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws BeforeCommitIdAndAfterCommitIdAreSameException
     *         The before commit ID and the after commit ID are the same, which is not valid. The before commit ID and
     *         the after commit ID must be different commit IDs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.PostCommentForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PostCommentForPullRequestResponse postCommentForPullRequest(
            PostCommentForPullRequestRequest postCommentForPullRequestRequest) throws PullRequestDoesNotExistException,
            InvalidPullRequestIdException, PullRequestIdRequiredException, RepositoryNotAssociatedWithPullRequestException,
            RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException,
            ClientRequestTokenRequiredException, InvalidClientRequestTokenException, IdempotencyParameterMismatchException,
            CommentContentRequiredException, CommentContentSizeLimitExceededException, InvalidFileLocationException,
            InvalidRelativeFileVersionEnumException, PathRequiredException, InvalidFilePositionException,
            CommitIdRequiredException, InvalidCommitIdException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, CommitDoesNotExistException, InvalidPathException, PathDoesNotExistException,
            BeforeCommitIdAndAfterCommitIdAreSameException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PostCommentForPullRequestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PostCommentForPullRequestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<PostCommentForPullRequestRequest, PostCommentForPullRequestResponse>()
                        .withOperationName("PostCommentForPullRequest").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(postCommentForPullRequestRequest)
                        .withMarshaller(new PostCommentForPullRequestRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Posts a comment in reply to an existing comment on a comparison between commits or a pull request.
     * </p>
     *
     * @param postCommentReplyRequest
     * @return Result of the PostCommentReply operation returned by the service.
     * @throws ClientRequestTokenRequiredException
     *         A client request token is required. A client request token is an unique, client-generated idempotency
     *         token that, when provided in a request, ensures the request cannot be repeated with a changed parameter.
     *         If a request is received with the same parameters and a token is included, the request returns
     *         information about the initial request that used that token.
     * @throws InvalidClientRequestTokenException
     *         The client request token is not valid.
     * @throws IdempotencyParameterMismatchException
     *         The client request token is not valid. Either the token is not in a valid format, or the token has been
     *         used in a previous request and cannot be reused.
     * @throws CommentContentRequiredException
     *         The comment is empty. You must provide some content for a comment. The content cannot be null.
     * @throws CommentContentSizeLimitExceededException
     *         The comment is too large. Comments are limited to 1,000 characters.
     * @throws CommentDoesNotExistException
     *         No comment exists with the provided ID. Verify that you have used the correct ID, and then try again.
     * @throws CommentIdRequiredException
     *         The comment ID is missing or null. A comment ID is required.
     * @throws InvalidCommentIdException
     *         The comment ID is not in a valid format. Make sure that you have provided the full comment ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.PostCommentReply
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentReply" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PostCommentReplyResponse postCommentReply(PostCommentReplyRequest postCommentReplyRequest)
            throws ClientRequestTokenRequiredException, InvalidClientRequestTokenException,
            IdempotencyParameterMismatchException, CommentContentRequiredException, CommentContentSizeLimitExceededException,
            CommentDoesNotExistException, CommentIdRequiredException, InvalidCommentIdException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PostCommentReplyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PostCommentReplyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PostCommentReplyRequest, PostCommentReplyResponse>()
                .withOperationName("PostCommentReply").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(postCommentReplyRequest)
                .withMarshaller(new PostCommentReplyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in
     * the specified branch.
     * </p>
     *
     * @param putFileRequest
     * @return Result of the PutFile operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws ParentCommitIdRequiredException
     *         A parent commit ID is required. To view the full commit ID of a branch in a repository, use
     *         <a>GetBranch</a> or a Git command (for example, git pull or git log).
     * @throws InvalidParentCommitIdException
     *         The parent commit ID is not valid. The commit ID cannot be empty, and must match the head commit ID for
     *         the branch of the repository where you want to add or update a file.
     * @throws ParentCommitDoesNotExistException
     *         The parent commit ID is not valid because it does not exist. The specified parent commit ID does not
     *         exist in the specified branch of the repository.
     * @throws ParentCommitIdOutdatedException
     *         The file could not be added because the provided parent commit ID is not the current tip of the specified
     *         branch. To view the full commit ID of the current head of the branch, use <a>GetBranch</a>.
     * @throws FileContentRequiredException
     *         The file cannot be added because it is empty. Empty files cannot be added to the repository with this
     *         API.
     * @throws FileContentSizeLimitExceededException
     *         The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file
     *         content change size is 7 MB. Consider making these changes using a Git client.
     * @throws FolderContentSizeLimitExceededException
     *         The commit cannot be created because at least one of the overall changes in the commit results in a
     *         folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or
     *         split the changes across multiple folders.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws BranchDoesNotExistException
     *         The specified branch does not exist.
     * @throws BranchNameIsTagNameException
     *         The specified branch name is not valid because it is a tag name. Enter the name of a branch in the
     *         repository. For a list of valid branch names, use <a>ListBranches</a>.
     * @throws InvalidFileModeException
     *         The specified file mode permission is not valid. For a list of valid file mode permissions, see
     *         <a>PutFile</a>.
     * @throws NameLengthExceededException
     *         The user name is not valid because it has exceeded the character limit for author names.
     * @throws InvalidEmailException
     *         The specified email address either contains one or more characters that are not allowed, or it exceeds
     *         the maximum number of characters allowed for an email address.
     * @throws CommitMessageLengthExceededException
     *         The commit message is too long. Provide a shorter string.
     * @throws InvalidDeletionParameterException
     *         The specified deletion parameter is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SameFileContentException
     *         The file was not added or updated because the content of the file is exactly the same as the content of
     *         that file in the repository and branch that you specified.
     * @throws FileNameConflictsWithDirectoryNameException
     *         A file cannot be added to the repository because the specified file name has the same name as a directory
     *         in this repository. Either provide another name for the file, or add the file in a directory that does
     *         not match the file name.
     * @throws DirectoryNameConflictsWithFileNameException
     *         A file cannot be added to the repository because the specified path name has the same name as a file that
     *         already exists in this repository. Either provide a different name for the file, or specify a different
     *         path for the file.
     * @throws FilePathConflictsWithSubmodulePathException
     *         The commit cannot be created because a specified file path points to a submodule. Verify that the
     *         destination files have valid file paths that do not point to a submodule.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.PutFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutFile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutFileResponse putFile(PutFileRequest putFileRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, ParentCommitIdRequiredException,
            InvalidParentCommitIdException, ParentCommitDoesNotExistException, ParentCommitIdOutdatedException,
            FileContentRequiredException, FileContentSizeLimitExceededException, FolderContentSizeLimitExceededException,
            PathRequiredException, InvalidPathException, BranchNameRequiredException, InvalidBranchNameException,
            BranchDoesNotExistException, BranchNameIsTagNameException, InvalidFileModeException, NameLengthExceededException,
            InvalidEmailException, CommitMessageLengthExceededException, InvalidDeletionParameterException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, SameFileContentException,
            FileNameConflictsWithDirectoryNameException, DirectoryNameConflictsWithFileNameException,
            FilePathConflictsWithSubmodulePathException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutFileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutFileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutFileRequest, PutFileResponse>().withOperationName("PutFile")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putFileRequest)
                .withMarshaller(new PutFileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Replaces all triggers for a repository. Used to create or delete triggers.
     * </p>
     *
     * @param putRepositoryTriggersRequest
     *        Represents the input of a put repository triggers operation.
     * @return Result of the PutRepositoryTriggers operation returned by the service.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryTriggersListRequiredException
     *         The list of triggers for the repository is required, but was not specified.
     * @throws MaximumRepositoryTriggersExceededException
     *         The number of triggers allowed for the repository was exceeded.
     * @throws InvalidRepositoryTriggerNameException
     *         The name of the trigger is not valid.
     * @throws InvalidRepositoryTriggerDestinationArnException
     *         The Amazon Resource Name (ARN) for the trigger is not valid for the specified destination. The most
     *         common reason for this error is that the ARN does not meet the requirements for the service type.
     * @throws InvalidRepositoryTriggerRegionException
     *         The AWS Region for the trigger target does not match the AWS Region for the repository. Triggers must be
     *         created in the same Region as the target for the trigger.
     * @throws InvalidRepositoryTriggerCustomDataException
     *         The custom data provided for the trigger is not valid.
     * @throws MaximumBranchesExceededException
     *         The number of branches for the trigger was exceeded.
     * @throws InvalidRepositoryTriggerBranchNameException
     *         One or more branch names specified for the trigger is not valid.
     * @throws InvalidRepositoryTriggerEventsException
     *         One or more events specified for the trigger is not valid. Check to make sure that all events specified
     *         match the requirements for allowed events.
     * @throws RepositoryTriggerNameRequiredException
     *         A name for the trigger is required, but was not specified.
     * @throws RepositoryTriggerDestinationArnRequiredException
     *         A destination ARN for the target service for the trigger is required, but was not specified.
     * @throws RepositoryTriggerBranchNameListRequiredException
     *         At least one branch name is required, but was not specified in the trigger configuration.
     * @throws RepositoryTriggerEventsListRequiredException
     *         At least one event for the trigger is required, but was not specified.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.PutRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutRepositoryTriggersResponse putRepositoryTriggers(PutRepositoryTriggersRequest putRepositoryTriggersRequest)
            throws RepositoryDoesNotExistException, RepositoryNameRequiredException, InvalidRepositoryNameException,
            RepositoryTriggersListRequiredException, MaximumRepositoryTriggersExceededException,
            InvalidRepositoryTriggerNameException, InvalidRepositoryTriggerDestinationArnException,
            InvalidRepositoryTriggerRegionException, InvalidRepositoryTriggerCustomDataException,
            MaximumBranchesExceededException, InvalidRepositoryTriggerBranchNameException,
            InvalidRepositoryTriggerEventsException, RepositoryTriggerNameRequiredException,
            RepositoryTriggerDestinationArnRequiredException, RepositoryTriggerBranchNameListRequiredException,
            RepositoryTriggerEventsListRequiredException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRepositoryTriggersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutRepositoryTriggersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutRepositoryTriggersRequest, PutRepositoryTriggersResponse>()
                .withOperationName("PutRepositoryTriggers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putRepositoryTriggersRequest)
                .withMarshaller(new PutRepositoryTriggersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a
     * href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws ResourceArnRequiredException
     *         A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is required. For a list of valid
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.
     * @throws InvalidResourceArnException
     *         The value for the resource ARN is not valid. For more information about resources in AWS CodeCommit, see
     *         <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.
     * @throws TagsMapRequiredException
     *         A map of tags is required.
     * @throws InvalidTagsMapException
     *         The map of tags is not valid.
     * @throws TooManyTagsException
     *         The maximum number of tags for an AWS CodeCommit resource has been exceeded.
     * @throws InvalidSystemTagUsageException
     *         The specified tag is not valid. Key names cannot be prefixed with aws:.
     * @throws TagPolicyException
     *         The tag policy is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws RepositoryDoesNotExistException,
            InvalidRepositoryNameException, ResourceArnRequiredException, InvalidResourceArnException, TagsMapRequiredException,
            InvalidTagsMapException, TooManyTagsException, InvalidSystemTagUsageException, TagPolicyException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withOperationName("TagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Tests the functionality of repository triggers by sending information to the trigger target. If real data is
     * available in the repository, the test sends data from the last commit. If no data is available, sample data is
     * generated.
     * </p>
     *
     * @param testRepositoryTriggersRequest
     *        Represents the input of a test repository triggers operation.
     * @return Result of the TestRepositoryTriggers operation returned by the service.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryTriggersListRequiredException
     *         The list of triggers for the repository is required, but was not specified.
     * @throws MaximumRepositoryTriggersExceededException
     *         The number of triggers allowed for the repository was exceeded.
     * @throws InvalidRepositoryTriggerNameException
     *         The name of the trigger is not valid.
     * @throws InvalidRepositoryTriggerDestinationArnException
     *         The Amazon Resource Name (ARN) for the trigger is not valid for the specified destination. The most
     *         common reason for this error is that the ARN does not meet the requirements for the service type.
     * @throws InvalidRepositoryTriggerRegionException
     *         The AWS Region for the trigger target does not match the AWS Region for the repository. Triggers must be
     *         created in the same Region as the target for the trigger.
     * @throws InvalidRepositoryTriggerCustomDataException
     *         The custom data provided for the trigger is not valid.
     * @throws MaximumBranchesExceededException
     *         The number of branches for the trigger was exceeded.
     * @throws InvalidRepositoryTriggerBranchNameException
     *         One or more branch names specified for the trigger is not valid.
     * @throws InvalidRepositoryTriggerEventsException
     *         One or more events specified for the trigger is not valid. Check to make sure that all events specified
     *         match the requirements for allowed events.
     * @throws RepositoryTriggerNameRequiredException
     *         A name for the trigger is required, but was not specified.
     * @throws RepositoryTriggerDestinationArnRequiredException
     *         A destination ARN for the target service for the trigger is required, but was not specified.
     * @throws RepositoryTriggerBranchNameListRequiredException
     *         At least one branch name is required, but was not specified in the trigger configuration.
     * @throws RepositoryTriggerEventsListRequiredException
     *         At least one event for the trigger is required, but was not specified.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.TestRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TestRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TestRepositoryTriggersResponse testRepositoryTriggers(TestRepositoryTriggersRequest testRepositoryTriggersRequest)
            throws RepositoryDoesNotExistException, RepositoryNameRequiredException, InvalidRepositoryNameException,
            RepositoryTriggersListRequiredException, MaximumRepositoryTriggersExceededException,
            InvalidRepositoryTriggerNameException, InvalidRepositoryTriggerDestinationArnException,
            InvalidRepositoryTriggerRegionException, InvalidRepositoryTriggerCustomDataException,
            MaximumBranchesExceededException, InvalidRepositoryTriggerBranchNameException,
            InvalidRepositoryTriggerEventsException, RepositoryTriggerNameRequiredException,
            RepositoryTriggerDestinationArnRequiredException, RepositoryTriggerBranchNameListRequiredException,
            RepositoryTriggerEventsListRequiredException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TestRepositoryTriggersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TestRepositoryTriggersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<TestRepositoryTriggersRequest, TestRepositoryTriggersResponse>()
                .withOperationName("TestRepositoryTriggers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(testRepositoryTriggersRequest)
                .withMarshaller(new TestRepositoryTriggersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws ResourceArnRequiredException
     *         A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is required. For a list of valid
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.
     * @throws InvalidResourceArnException
     *         The value for the resource ARN is not valid. For more information about resources in AWS CodeCommit, see
     *         <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.
     * @throws TagKeysListRequiredException
     *         A list of tag keys is required. The list cannot be empty or null.
     * @throws InvalidTagKeysListException
     *         The list of tags is not valid.
     * @throws TooManyTagsException
     *         The maximum number of tags for an AWS CodeCommit resource has been exceeded.
     * @throws InvalidSystemTagUsageException
     *         The specified tag is not valid. Key names cannot be prefixed with aws:.
     * @throws TagPolicyException
     *         The tag policy is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws RepositoryDoesNotExistException,
            InvalidRepositoryNameException, ResourceArnRequiredException, InvalidResourceArnException,
            TagKeysListRequiredException, InvalidTagKeysListException, TooManyTagsException, InvalidSystemTagUsageException,
            TagPolicyException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withOperationName("UntagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the content of an approval rule template. You can change the number of required approvals, the membership
     * of the approval rule, and whether an approval pool is defined.
     * </p>
     *
     * @param updateApprovalRuleTemplateContentRequest
     * @return Result of the UpdateApprovalRuleTemplateContent operation returned by the service.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the AWS Region where the template was created, and then try again.
     * @throws InvalidApprovalRuleTemplateContentException
     *         The content of the approval rule template is not valid.
     * @throws InvalidRuleContentSha256Exception
     *         The SHA-256 hash signature for the rule content is not valid.
     * @throws ApprovalRuleTemplateContentRequiredException
     *         The content for the approval rule template is empty. You must provide some content for an approval rule
     *         template. The content cannot be null.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdateApprovalRuleTemplateContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateApprovalRuleTemplateContent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApprovalRuleTemplateContentResponse updateApprovalRuleTemplateContent(
            UpdateApprovalRuleTemplateContentRequest updateApprovalRuleTemplateContentRequest)
            throws InvalidApprovalRuleTemplateNameException, ApprovalRuleTemplateNameRequiredException,
            ApprovalRuleTemplateDoesNotExistException, InvalidApprovalRuleTemplateContentException,
            InvalidRuleContentSha256Exception, ApprovalRuleTemplateContentRequiredException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApprovalRuleTemplateContentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApprovalRuleTemplateContentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateApprovalRuleTemplateContentRequest, UpdateApprovalRuleTemplateContentResponse>()
                        .withOperationName("UpdateApprovalRuleTemplateContent").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateApprovalRuleTemplateContentRequest)
                        .withMarshaller(new UpdateApprovalRuleTemplateContentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the description for a specified approval rule template.
     * </p>
     *
     * @param updateApprovalRuleTemplateDescriptionRequest
     * @return Result of the UpdateApprovalRuleTemplateDescription operation returned by the service.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the AWS Region where the template was created, and then try again.
     * @throws InvalidApprovalRuleTemplateDescriptionException
     *         The description for the approval rule template is not valid because it exceeds the maximum characters
     *         allowed for a description. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdateApprovalRuleTemplateDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateApprovalRuleTemplateDescription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApprovalRuleTemplateDescriptionResponse updateApprovalRuleTemplateDescription(
            UpdateApprovalRuleTemplateDescriptionRequest updateApprovalRuleTemplateDescriptionRequest)
            throws InvalidApprovalRuleTemplateNameException, ApprovalRuleTemplateNameRequiredException,
            ApprovalRuleTemplateDoesNotExistException, InvalidApprovalRuleTemplateDescriptionException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApprovalRuleTemplateDescriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateApprovalRuleTemplateDescriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateApprovalRuleTemplateDescriptionRequest, UpdateApprovalRuleTemplateDescriptionResponse>()
                        .withOperationName("UpdateApprovalRuleTemplateDescription").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateApprovalRuleTemplateDescriptionRequest)
                        .withMarshaller(new UpdateApprovalRuleTemplateDescriptionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the name of a specified approval rule template.
     * </p>
     *
     * @param updateApprovalRuleTemplateNameRequest
     * @return Result of the UpdateApprovalRuleTemplateName operation returned by the service.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the AWS Region where the template was created, and then try again.
     * @throws ApprovalRuleTemplateNameAlreadyExistsException
     *         You cannot create an approval rule template with that name because a template with that name already
     *         exists in this AWS Region for your AWS account. Approval rule template names must be unique.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdateApprovalRuleTemplateName
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateApprovalRuleTemplateName"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApprovalRuleTemplateNameResponse updateApprovalRuleTemplateName(
            UpdateApprovalRuleTemplateNameRequest updateApprovalRuleTemplateNameRequest)
            throws InvalidApprovalRuleTemplateNameException, ApprovalRuleTemplateNameRequiredException,
            ApprovalRuleTemplateDoesNotExistException, ApprovalRuleTemplateNameAlreadyExistsException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApprovalRuleTemplateNameResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApprovalRuleTemplateNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateApprovalRuleTemplateNameRequest, UpdateApprovalRuleTemplateNameResponse>()
                        .withOperationName("UpdateApprovalRuleTemplateName").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateApprovalRuleTemplateNameRequest)
                        .withMarshaller(new UpdateApprovalRuleTemplateNameRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Replaces the contents of a comment.
     * </p>
     *
     * @param updateCommentRequest
     * @return Result of the UpdateComment operation returned by the service.
     * @throws CommentContentRequiredException
     *         The comment is empty. You must provide some content for a comment. The content cannot be null.
     * @throws CommentContentSizeLimitExceededException
     *         The comment is too large. Comments are limited to 1,000 characters.
     * @throws CommentDoesNotExistException
     *         No comment exists with the provided ID. Verify that you have used the correct ID, and then try again.
     * @throws CommentIdRequiredException
     *         The comment ID is missing or null. A comment ID is required.
     * @throws InvalidCommentIdException
     *         The comment ID is not in a valid format. Make sure that you have provided the full comment ID.
     * @throws CommentNotCreatedByCallerException
     *         You cannot modify or delete this comment. Only comment authors can modify or delete their comments.
     * @throws CommentDeletedException
     *         This comment has already been deleted. You cannot edit or delete a deleted comment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdateComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateComment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateCommentResponse updateComment(UpdateCommentRequest updateCommentRequest) throws CommentContentRequiredException,
            CommentContentSizeLimitExceededException, CommentDoesNotExistException, CommentIdRequiredException,
            InvalidCommentIdException, CommentNotCreatedByCallerException, CommentDeletedException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCommentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateCommentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateCommentRequest, UpdateCommentResponse>()
                .withOperationName("UpdateComment").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateCommentRequest)
                .withMarshaller(new UpdateCommentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Sets or changes the default branch name for the specified repository.
     * </p>
     * <note>
     * <p>
     * If you use this operation to change the default branch name to the current default branch name, a success message
     * is returned even though the default branch did not change.
     * </p>
     * </note>
     *
     * @param updateDefaultBranchRequest
     *        Represents the input of an update default branch operation.
     * @return Result of the UpdateDefaultBranch operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws BranchDoesNotExistException
     *         The specified branch does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdateDefaultBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranch" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDefaultBranchResponse updateDefaultBranch(UpdateDefaultBranchRequest updateDefaultBranchRequest)
            throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException,
            BranchNameRequiredException, InvalidBranchNameException, BranchDoesNotExistException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDefaultBranchResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDefaultBranchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateDefaultBranchRequest, UpdateDefaultBranchResponse>()
                .withOperationName("UpdateDefaultBranch").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateDefaultBranchRequest)
                .withMarshaller(new UpdateDefaultBranchRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the structure of an approval rule created specifically for a pull request. For example, you can change
     * the number of required approvers and the approval pool for approvers.
     * </p>
     *
     * @param updatePullRequestApprovalRuleContentRequest
     * @return Result of the UpdatePullRequestApprovalRuleContent operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws ApprovalRuleNameRequiredException
     *         An approval rule name is required, but was not specified.
     * @throws InvalidApprovalRuleNameException
     *         The name for the approval rule is not valid.
     * @throws ApprovalRuleDoesNotExistException
     *         The specified approval rule does not exist.
     * @throws InvalidRuleContentSha256Exception
     *         The SHA-256 hash signature for the rule content is not valid.
     * @throws ApprovalRuleContentRequiredException
     *         The content for the approval rule is empty. You must provide some content for an approval rule. The
     *         content cannot be null.
     * @throws InvalidApprovalRuleContentException
     *         The content for the approval rule is not valid.
     * @throws CannotModifyApprovalRuleFromTemplateException
     *         The approval rule cannot be modified for the pull request because it was created by an approval rule
     *         template and applied to the pull request automatically.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdatePullRequestApprovalRuleContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestApprovalRuleContent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePullRequestApprovalRuleContentResponse updatePullRequestApprovalRuleContent(
            UpdatePullRequestApprovalRuleContentRequest updatePullRequestApprovalRuleContentRequest)
            throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException,
            PullRequestAlreadyClosedException, ApprovalRuleNameRequiredException, InvalidApprovalRuleNameException,
            ApprovalRuleDoesNotExistException, InvalidRuleContentSha256Exception, ApprovalRuleContentRequiredException,
            InvalidApprovalRuleContentException, CannotModifyApprovalRuleFromTemplateException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePullRequestApprovalRuleContentResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdatePullRequestApprovalRuleContentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdatePullRequestApprovalRuleContentRequest, UpdatePullRequestApprovalRuleContentResponse>()
                        .withOperationName("UpdatePullRequestApprovalRuleContent").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updatePullRequestApprovalRuleContentRequest)
                        .withMarshaller(new UpdatePullRequestApprovalRuleContentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the state of a user's approval on a pull request. The user is derived from the signed-in account when the
     * request is made.
     * </p>
     *
     * @param updatePullRequestApprovalStateRequest
     * @return Result of the UpdatePullRequestApprovalState operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidRevisionIdException
     *         The revision ID is not valid. Use GetPullRequest to determine the value.
     * @throws RevisionIdRequiredException
     *         A revision ID is required, but was not provided.
     * @throws InvalidApprovalStateException
     *         The state for the approval is not valid. Valid values include APPROVE and REVOKE.
     * @throws ApprovalStateRequiredException
     *         An approval state is required, but was not specified.
     * @throws PullRequestCannotBeApprovedByAuthorException
     *         The approval cannot be applied because the user approving the pull request matches the user who created
     *         the pull request. You cannot approve a pull request that you created.
     * @throws RevisionNotCurrentException
     *         The revision ID provided in the request does not match the current revision ID. Use GetPullRequest to
     *         retrieve the current revision ID.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws MaximumNumberOfApprovalsExceededException
     *         The number of approvals required for the approval rule exceeds the maximum number allowed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdatePullRequestApprovalState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestApprovalState"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePullRequestApprovalStateResponse updatePullRequestApprovalState(
            UpdatePullRequestApprovalStateRequest updatePullRequestApprovalStateRequest) throws PullRequestDoesNotExistException,
            InvalidPullRequestIdException, PullRequestIdRequiredException, InvalidRevisionIdException,
            RevisionIdRequiredException, InvalidApprovalStateException, ApprovalStateRequiredException,
            PullRequestCannotBeApprovedByAuthorException, RevisionNotCurrentException, PullRequestAlreadyClosedException,
            MaximumNumberOfApprovalsExceededException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePullRequestApprovalStateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePullRequestApprovalStateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdatePullRequestApprovalStateRequest, UpdatePullRequestApprovalStateResponse>()
                        .withOperationName("UpdatePullRequestApprovalState").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updatePullRequestApprovalStateRequest)
                        .withMarshaller(new UpdatePullRequestApprovalStateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Replaces the contents of the description of a pull request.
     * </p>
     *
     * @param updatePullRequestDescriptionRequest
     * @return Result of the UpdatePullRequestDescription operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidDescriptionException
     *         The pull request description is not valid. Descriptions cannot be more than 1,000 characters.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdatePullRequestDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestDescription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePullRequestDescriptionResponse updatePullRequestDescription(
            UpdatePullRequestDescriptionRequest updatePullRequestDescriptionRequest) throws PullRequestDoesNotExistException,
            InvalidPullRequestIdException, PullRequestIdRequiredException, InvalidDescriptionException,
            PullRequestAlreadyClosedException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePullRequestDescriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePullRequestDescriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdatePullRequestDescriptionRequest, UpdatePullRequestDescriptionResponse>()
                        .withOperationName("UpdatePullRequestDescription").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updatePullRequestDescriptionRequest)
                        .withMarshaller(new UpdatePullRequestDescriptionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the status of a pull request.
     * </p>
     *
     * @param updatePullRequestStatusRequest
     * @return Result of the UpdatePullRequestStatus operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws InvalidPullRequestStatusUpdateException
     *         The pull request status update is not valid. The only valid update is from <code>OPEN</code> to
     *         <code>CLOSED</code>.
     * @throws InvalidPullRequestStatusException
     *         The pull request status is not valid. The only valid values are <code>OPEN</code> and <code>CLOSED</code>
     *         .
     * @throws PullRequestStatusRequiredException
     *         A pull request status is required, but none was provided.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdatePullRequestStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePullRequestStatusResponse updatePullRequestStatus(UpdatePullRequestStatusRequest updatePullRequestStatusRequest)
            throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException,
            InvalidPullRequestStatusUpdateException, InvalidPullRequestStatusException, PullRequestStatusRequiredException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePullRequestStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePullRequestStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdatePullRequestStatusRequest, UpdatePullRequestStatusResponse>()
                .withOperationName("UpdatePullRequestStatus").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updatePullRequestStatusRequest)
                .withMarshaller(new UpdatePullRequestStatusRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Replaces the title of a pull request.
     * </p>
     *
     * @param updatePullRequestTitleRequest
     * @return Result of the UpdatePullRequestTitle operation returned by the service.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws TitleRequiredException
     *         A pull request title is required. It cannot be empty or null.
     * @throws InvalidTitleException
     *         The title of the pull request is not valid. Pull request titles cannot exceed 100 characters in length.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdatePullRequestTitle
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestTitle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePullRequestTitleResponse updatePullRequestTitle(UpdatePullRequestTitleRequest updatePullRequestTitleRequest)
            throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException,
            TitleRequiredException, InvalidTitleException, PullRequestAlreadyClosedException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePullRequestTitleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePullRequestTitleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdatePullRequestTitleRequest, UpdatePullRequestTitleResponse>()
                .withOperationName("UpdatePullRequestTitle").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updatePullRequestTitleRequest)
                .withMarshaller(new UpdatePullRequestTitleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Sets or changes the comment or description for a repository.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a webpage.
     * </p>
     * </note>
     *
     * @param updateRepositoryDescriptionRequest
     *        Represents the input of an update repository description operation.
     * @return Result of the UpdateRepositoryDescription operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws InvalidRepositoryDescriptionException
     *         The specified repository description is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdateRepositoryDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryDescription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRepositoryDescriptionResponse updateRepositoryDescription(
            UpdateRepositoryDescriptionRequest updateRepositoryDescriptionRequest) throws RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, InvalidRepositoryDescriptionException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRepositoryDescriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRepositoryDescriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateRepositoryDescriptionRequest, UpdateRepositoryDescriptionResponse>()
                        .withOperationName("UpdateRepositoryDescription").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateRepositoryDescriptionRequest)
                        .withMarshaller(new UpdateRepositoryDescriptionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Renames a repository. The repository name must be unique across the calling AWS account. Repository names are
     * limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. The suffix
     * .git is prohibited. For more information about the limits on repository names, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the AWS CodeCommit User
     * Guide.
     * </p>
     *
     * @param updateRepositoryNameRequest
     *        Represents the input of an update repository description operation.
     * @return Result of the UpdateRepositoryName operation returned by the service.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws RepositoryNameExistsException
     *         The specified repository name already exists.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.UpdateRepositoryName
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryName"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRepositoryNameResponse updateRepositoryName(UpdateRepositoryNameRequest updateRepositoryNameRequest)
            throws RepositoryDoesNotExistException, RepositoryNameExistsException, RepositoryNameRequiredException,
            InvalidRepositoryNameException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRepositoryNameResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRepositoryNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateRepositoryNameRequest, UpdateRepositoryNameResponse>()
                .withOperationName("UpdateRepositoryName").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateRepositoryNameRequest)
                .withMarshaller(new UpdateRepositoryNameRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CodeCommitException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileContentRequiredException")
                                .exceptionBuilderSupplier(FileContentRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                                .exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentDeletedException")
                                .exceptionBuilderSupplier(CommentDeletedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                                .exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidBlobIdException")
                                .exceptionBuilderSupplier(InvalidBlobIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                                .exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentDoesNotExistException")
                                .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                                .exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                                .exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                                .exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RevisionIdRequiredException")
                                .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException")
                                .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                                .exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                                .exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                                .exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileModeRequiredException")
                                .exceptionBuilderSupplier(FileModeRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitDoesNotExistException")
                                .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceArnRequiredException")
                                .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                                .exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFileLocationException")
                                .exceptionBuilderSupplier(InvalidFileLocationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException")
                                .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                                .exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagKeysListRequiredException")
                                .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                                .exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                                .exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException")
                                .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidReferenceNameException")
                                .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentContentRequiredException")
                                .exceptionBuilderSupplier(CommentContentRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagKeysListException")
                                .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagsMapRequiredException")
                                .exceptionBuilderSupplier(TagsMapRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PathRequiredException")
                                .exceptionBuilderSupplier(PathRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException")
                                .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException")
                                .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException")
                                .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException")
                                .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException")
                                .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                                .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                                .exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCommentIdException")
                                .exceptionBuilderSupplier(InvalidCommentIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidApprovalStateException")
                                .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCommitException")
                                .exceptionBuilderSupplier(InvalidCommitException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoChangeException")
                                .exceptionBuilderSupplier(NoChangeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException")
                                .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                                .exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException")
                                .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MergeOptionRequiredException")
                                .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException")
                                .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                                .exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileDoesNotExistException")
                                .exceptionBuilderSupplier(FileDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryNameExistsException")
                                .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PathDoesNotExistException")
                                .exceptionBuilderSupplier(PathDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BranchNameExistsException")
                                .exceptionBuilderSupplier(BranchNameExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                                .exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCommitIdException")
                                .exceptionBuilderSupplier(InvalidCommitIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOrderException")
                                .exceptionBuilderSupplier(InvalidOrderException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException")
                                .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BranchNameRequiredException")
                                .exceptionBuilderSupplier(BranchNameRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMergeOptionException")
                                .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException")
                                .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException")
                                .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException")
                                .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                                .exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                                .exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                                .exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NameLengthExceededException")
                                .exceptionBuilderSupplier(NameLengthExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException")
                                .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                                .exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                                .exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ManualMergeRequiredException")
                                .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                                .exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SameFileContentException")
                                .exceptionBuilderSupplier(SameFileContentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTargetException")
                                .exceptionBuilderSupplier(InvalidTargetException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                                .exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMaxResultsException")
                                .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException")
                                .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileEntryRequiredException")
                                .exceptionBuilderSupplier(FileEntryRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidActorArnException")
                                .exceptionBuilderSupplier(InvalidActorArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException")
                                .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                                .exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                                .exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException")
                                .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                                .exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                                .exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTitleException")
                                .exceptionBuilderSupplier(InvalidTitleException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException")
                                .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException")
                                .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidBranchNameException")
                                .exceptionBuilderSupplier(InvalidBranchNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetsRequiredException")
                                .exceptionBuilderSupplier(TargetsRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException")
                                .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException")
                                .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitIdRequiredException")
                                .exceptionBuilderSupplier(CommitIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TitleRequiredException")
                                .exceptionBuilderSupplier(TitleRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTargetsException")
                                .exceptionBuilderSupplier(InvalidTargetsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                                .exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BlobIdRequiredException")
                                .exceptionBuilderSupplier(BlobIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException")
                                .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException")
                                .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException")
                                .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilePositionException")
                                .exceptionBuilderSupplier(InvalidFilePositionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                                .exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceArnException")
                                .exceptionBuilderSupplier(InvalidResourceArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                                .exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                                .exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BranchDoesNotExistException")
                                .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                                .exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                                .exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                                .exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                                .exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException")
                                .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRevisionIdException")
                                .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                                .exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                                .exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException")
                                .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPathException")
                                .exceptionBuilderSupplier(InvalidPathException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                                .exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                                .exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                                .exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                                .exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAuthorArnException")
                                .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTargetBranchException")
                                .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException")
                                .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                                .exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException")
                                .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException")
                                .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OverrideAlreadySetException")
                                .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException")
                                .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException")
                                .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException")
                                .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                                .exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException")
                                .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                                .exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ActorDoesNotExistException")
                                .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                                .exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                                .exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDescriptionException")
                                .exceptionBuilderSupplier(InvalidDescriptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FolderDoesNotExistException")
                                .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException")
                                .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                                .exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                                .exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                                .exceptionBuilderSupplier(InvalidReplacementContentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                                .exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException")
                                .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEmailException")
                                .exceptionBuilderSupplier(InvalidEmailException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException")
                                .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception")
                                .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                                .exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentIdRequiredException")
                                .exceptionBuilderSupplier(CommentIdRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommitRequiredException")
                                .exceptionBuilderSupplier(CommitRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RevisionNotCurrentException")
                                .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                                .exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                                .exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetRequiredException")
                                .exceptionBuilderSupplier(TargetRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagsMapException")
                                .exceptionBuilderSupplier(InvalidTagsMapException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RestrictedSourceFileException")
                                .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileTooLargeException")
                                .exceptionBuilderSupplier(FileTooLargeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PutFileEntryConflictException")
                                .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                                .exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                                .exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                                .exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SamePathRequestException")
                                .exceptionBuilderSupplier(SamePathRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException")
                                .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSortByException")
                                .exceptionBuilderSupplier(InvalidSortByException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                                .exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException")
                                .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException")
                                .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                                .exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagPolicyException")
                                .exceptionBuilderSupplier(TagPolicyException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFileModeException")
                                .exceptionBuilderSupplier(InvalidFileModeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                                .exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                                .exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                                .exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends CodeCommitRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
