/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeMergeConflictsRequest extends CodeCommitRequest implements
        ToCopyableBuilder<BatchDescribeMergeConflictsRequest.Builder, BatchDescribeMergeConflictsRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDescribeMergeConflictsRequest::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDescribeMergeConflictsRequest::destinationCommitSpecifier))
            .setter(setter(Builder::destinationCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build())
            .build();

    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDescribeMergeConflictsRequest::sourceCommitSpecifier))
            .setter(setter(Builder::sourceCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build())
            .build();

    private static final SdkField<String> MERGE_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDescribeMergeConflictsRequest::mergeOptionAsString)).setter(setter(Builder::mergeOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOption").build()).build();

    private static final SdkField<Integer> MAX_MERGE_HUNKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchDescribeMergeConflictsRequest::maxMergeHunks)).setter(setter(Builder::maxMergeHunks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxMergeHunks").build()).build();

    private static final SdkField<Integer> MAX_CONFLICT_FILES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchDescribeMergeConflictsRequest::maxConflictFiles)).setter(setter(Builder::maxConflictFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConflictFiles").build()).build();

    private static final SdkField<List<String>> FILE_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchDescribeMergeConflictsRequest::filePaths))
            .setter(setter(Builder::filePaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONFLICT_DETAIL_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDescribeMergeConflictsRequest::conflictDetailLevelAsString))
            .setter(setter(Builder::conflictDetailLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetailLevel").build())
            .build();

    private static final SdkField<String> CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDescribeMergeConflictsRequest::conflictResolutionStrategyAsString))
            .setter(setter(Builder::conflictResolutionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolutionStrategy").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDescribeMergeConflictsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            DESTINATION_COMMIT_SPECIFIER_FIELD, SOURCE_COMMIT_SPECIFIER_FIELD, MERGE_OPTION_FIELD, MAX_MERGE_HUNKS_FIELD,
            MAX_CONFLICT_FILES_FIELD, FILE_PATHS_FIELD, CONFLICT_DETAIL_LEVEL_FIELD, CONFLICT_RESOLUTION_STRATEGY_FIELD,
            NEXT_TOKEN_FIELD));

    private final String repositoryName;

    private final String destinationCommitSpecifier;

    private final String sourceCommitSpecifier;

    private final String mergeOption;

    private final Integer maxMergeHunks;

    private final Integer maxConflictFiles;

    private final List<String> filePaths;

    private final String conflictDetailLevel;

    private final String conflictResolutionStrategy;

    private final String nextToken;

    private BatchDescribeMergeConflictsRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.mergeOption = builder.mergeOption;
        this.maxMergeHunks = builder.maxMergeHunks;
        this.maxConflictFiles = builder.maxConflictFiles;
        this.filePaths = builder.filePaths;
        this.conflictDetailLevel = builder.conflictDetailLevel;
        this.conflictResolutionStrategy = builder.conflictResolutionStrategy;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the repository that contains the merge conflicts you want to review.
     * </p>
     * 
     * @return The name of the repository that contains the merge conflicts you want to review.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name
     * or a full commit ID).
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
     *         branch name or a full commit ID).
     */
    public String destinationCommitSpecifier() {
        return destinationCommitSpecifier;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name
     * or a full commit ID).
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
     *         branch name or a full commit ID).
     */
    public String sourceCommitSpecifier() {
        return sourceCommitSpecifier;
    }

    /**
     * <p>
     * The merge option or strategy you want to use to merge the code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeOption} will
     * return {@link MergeOptionTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mergeOptionAsString}.
     * </p>
     * 
     * @return The merge option or strategy you want to use to merge the code.
     * @see MergeOptionTypeEnum
     */
    public MergeOptionTypeEnum mergeOption() {
        return MergeOptionTypeEnum.fromValue(mergeOption);
    }

    /**
     * <p>
     * The merge option or strategy you want to use to merge the code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeOption} will
     * return {@link MergeOptionTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mergeOptionAsString}.
     * </p>
     * 
     * @return The merge option or strategy you want to use to merge the code.
     * @see MergeOptionTypeEnum
     */
    public String mergeOptionAsString() {
        return mergeOption;
    }

    /**
     * <p>
     * The maximum number of merge hunks to include in the output.
     * </p>
     * 
     * @return The maximum number of merge hunks to include in the output.
     */
    public Integer maxMergeHunks() {
        return maxMergeHunks;
    }

    /**
     * <p>
     * The maximum number of files to include in the output.
     * </p>
     * 
     * @return The maximum number of files to include in the output.
     */
    public Integer maxConflictFiles() {
        return maxConflictFiles;
    }

    /**
     * <p>
     * The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The path of the target files used to describe the conflicts. If not specified, the default is all
     *         conflict files.
     */
    public List<String> filePaths() {
        return filePaths;
    }

    /**
     * <p>
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is
     * considered not mergeable if the same file in both branches has differences on the same line.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictDetailLevel} will return {@link ConflictDetailLevelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #conflictDetailLevelAsString}.
     * </p>
     * 
     * @return The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     *         not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
     *         conflict is considered not mergeable if the same file in both branches has differences on the same line.
     * @see ConflictDetailLevelTypeEnum
     */
    public ConflictDetailLevelTypeEnum conflictDetailLevel() {
        return ConflictDetailLevelTypeEnum.fromValue(conflictDetailLevel);
    }

    /**
     * <p>
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is
     * considered not mergeable if the same file in both branches has differences on the same line.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictDetailLevel} will return {@link ConflictDetailLevelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #conflictDetailLevelAsString}.
     * </p>
     * 
     * @return The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     *         not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
     *         conflict is considered not mergeable if the same file in both branches has differences on the same line.
     * @see ConflictDetailLevelTypeEnum
     */
    public String conflictDetailLevelAsString() {
        return conflictDetailLevel;
    }

    /**
     * <p>
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions
     * of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation
     * is successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolutionStrategy} will return {@link ConflictResolutionStrategyTypeEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
     *         versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
     *         merge operation is successful.
     * @see ConflictResolutionStrategyTypeEnum
     */
    public ConflictResolutionStrategyTypeEnum conflictResolutionStrategy() {
        return ConflictResolutionStrategyTypeEnum.fromValue(conflictResolutionStrategy);
    }

    /**
     * <p>
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions
     * of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation
     * is successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolutionStrategy} will return {@link ConflictResolutionStrategyTypeEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
     *         versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
     *         merge operation is successful.
     * @see ConflictResolutionStrategyTypeEnum
     */
    public String conflictResolutionStrategyAsString() {
        return conflictResolutionStrategy;
    }

    /**
     * <p>
     * An enumeration token that, when provided in a request, returns the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that, when provided in a request, returns the next batch of the results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(mergeOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxMergeHunks());
        hashCode = 31 * hashCode + Objects.hashCode(maxConflictFiles());
        hashCode = 31 * hashCode + Objects.hashCode(filePaths());
        hashCode = 31 * hashCode + Objects.hashCode(conflictDetailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeMergeConflictsRequest)) {
            return false;
        }
        BatchDescribeMergeConflictsRequest other = (BatchDescribeMergeConflictsRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(destinationCommitSpecifier(), other.destinationCommitSpecifier())
                && Objects.equals(sourceCommitSpecifier(), other.sourceCommitSpecifier())
                && Objects.equals(mergeOptionAsString(), other.mergeOptionAsString())
                && Objects.equals(maxMergeHunks(), other.maxMergeHunks())
                && Objects.equals(maxConflictFiles(), other.maxConflictFiles()) && Objects.equals(filePaths(), other.filePaths())
                && Objects.equals(conflictDetailLevelAsString(), other.conflictDetailLevelAsString())
                && Objects.equals(conflictResolutionStrategyAsString(), other.conflictResolutionStrategyAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDescribeMergeConflictsRequest").add("RepositoryName", repositoryName())
                .add("DestinationCommitSpecifier", destinationCommitSpecifier())
                .add("SourceCommitSpecifier", sourceCommitSpecifier()).add("MergeOption", mergeOptionAsString())
                .add("MaxMergeHunks", maxMergeHunks()).add("MaxConflictFiles", maxConflictFiles()).add("FilePaths", filePaths())
                .add("ConflictDetailLevel", conflictDetailLevelAsString())
                .add("ConflictResolutionStrategy", conflictResolutionStrategyAsString()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "destinationCommitSpecifier":
            return Optional.ofNullable(clazz.cast(destinationCommitSpecifier()));
        case "sourceCommitSpecifier":
            return Optional.ofNullable(clazz.cast(sourceCommitSpecifier()));
        case "mergeOption":
            return Optional.ofNullable(clazz.cast(mergeOptionAsString()));
        case "maxMergeHunks":
            return Optional.ofNullable(clazz.cast(maxMergeHunks()));
        case "maxConflictFiles":
            return Optional.ofNullable(clazz.cast(maxConflictFiles()));
        case "filePaths":
            return Optional.ofNullable(clazz.cast(filePaths()));
        case "conflictDetailLevel":
            return Optional.ofNullable(clazz.cast(conflictDetailLevelAsString()));
        case "conflictResolutionStrategy":
            return Optional.ofNullable(clazz.cast(conflictResolutionStrategyAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeMergeConflictsRequest, T> g) {
        return obj -> g.apply((BatchDescribeMergeConflictsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDescribeMergeConflictsRequest> {
        /**
         * <p>
         * The name of the repository that contains the merge conflicts you want to review.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the merge conflicts you want to review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch
         * name or a full commit ID).
         * </p>
         * 
         * @param destinationCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
         *        branch name or a full commit ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitSpecifier(String destinationCommitSpecifier);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch
         * name or a full commit ID).
         * </p>
         * 
         * @param sourceCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
         *        branch name or a full commit ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitSpecifier(String sourceCommitSpecifier);

        /**
         * <p>
         * The merge option or strategy you want to use to merge the code.
         * </p>
         * 
         * @param mergeOption
         *        The merge option or strategy you want to use to merge the code.
         * @see MergeOptionTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeOptionTypeEnum
         */
        Builder mergeOption(String mergeOption);

        /**
         * <p>
         * The merge option or strategy you want to use to merge the code.
         * </p>
         * 
         * @param mergeOption
         *        The merge option or strategy you want to use to merge the code.
         * @see MergeOptionTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeOptionTypeEnum
         */
        Builder mergeOption(MergeOptionTypeEnum mergeOption);

        /**
         * <p>
         * The maximum number of merge hunks to include in the output.
         * </p>
         * 
         * @param maxMergeHunks
         *        The maximum number of merge hunks to include in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxMergeHunks(Integer maxMergeHunks);

        /**
         * <p>
         * The maximum number of files to include in the output.
         * </p>
         * 
         * @param maxConflictFiles
         *        The maximum number of files to include in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConflictFiles(Integer maxConflictFiles);

        /**
         * <p>
         * The path of the target files used to describe the conflicts. If not specified, the default is all conflict
         * files.
         * </p>
         * 
         * @param filePaths
         *        The path of the target files used to describe the conflicts. If not specified, the default is all
         *        conflict files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePaths(Collection<String> filePaths);

        /**
         * <p>
         * The path of the target files used to describe the conflicts. If not specified, the default is all conflict
         * files.
         * </p>
         * 
         * @param filePaths
         *        The path of the target files used to describe the conflicts. If not specified, the default is all
         *        conflict files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePaths(String... filePaths);

        /**
         * <p>
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         * conflict is considered not mergeable if the same file in both branches has differences on the same line.
         * </p>
         * 
         * @param conflictDetailLevel
         *        The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         *        not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         *        conflict is considered not mergeable if the same file in both branches has differences on the same
         *        line.
         * @see ConflictDetailLevelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetailLevelTypeEnum
         */
        Builder conflictDetailLevel(String conflictDetailLevel);

        /**
         * <p>
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         * conflict is considered not mergeable if the same file in both branches has differences on the same line.
         * </p>
         * 
         * @param conflictDetailLevel
         *        The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         *        not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         *        conflict is considered not mergeable if the same file in both branches has differences on the same
         *        line.
         * @see ConflictDetailLevelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetailLevelTypeEnum
         */
        Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel);

        /**
         * <p>
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
         * versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
         * merge operation is successful.
         * </p>
         * 
         * @param conflictResolutionStrategy
         *        Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging
         *        two versions of a file. The default is NONE, which requires any conflicts to be resolved manually
         *        before the merge operation is successful.
         * @see ConflictResolutionStrategyTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolutionStrategyTypeEnum
         */
        Builder conflictResolutionStrategy(String conflictResolutionStrategy);

        /**
         * <p>
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
         * versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
         * merge operation is successful.
         * </p>
         * 
         * @param conflictResolutionStrategy
         *        Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging
         *        two versions of a file. The default is NONE, which requires any conflicts to be resolved manually
         *        before the merge operation is successful.
         * @see ConflictResolutionStrategyTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolutionStrategyTypeEnum
         */
        Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy);

        /**
         * <p>
         * An enumeration token that, when provided in a request, returns the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that, when provided in a request, returns the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String destinationCommitSpecifier;

        private String sourceCommitSpecifier;

        private String mergeOption;

        private Integer maxMergeHunks;

        private Integer maxConflictFiles;

        private List<String> filePaths = DefaultSdkAutoConstructList.getInstance();

        private String conflictDetailLevel;

        private String conflictResolutionStrategy;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeMergeConflictsRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            destinationCommitSpecifier(model.destinationCommitSpecifier);
            sourceCommitSpecifier(model.sourceCommitSpecifier);
            mergeOption(model.mergeOption);
            maxMergeHunks(model.maxMergeHunks);
            maxConflictFiles(model.maxConflictFiles);
            filePaths(model.filePaths);
            conflictDetailLevel(model.conflictDetailLevel);
            conflictResolutionStrategy(model.conflictResolutionStrategy);
            nextToken(model.nextToken);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getDestinationCommitSpecifier() {
            return destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        public final String getSourceCommitSpecifier() {
            return sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        public final String getMergeOptionAsString() {
            return mergeOption;
        }

        @Override
        public final Builder mergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
            return this;
        }

        @Override
        public final Builder mergeOption(MergeOptionTypeEnum mergeOption) {
            this.mergeOption(mergeOption == null ? null : mergeOption.toString());
            return this;
        }

        public final void setMergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
        }

        public final Integer getMaxMergeHunks() {
            return maxMergeHunks;
        }

        @Override
        public final Builder maxMergeHunks(Integer maxMergeHunks) {
            this.maxMergeHunks = maxMergeHunks;
            return this;
        }

        public final void setMaxMergeHunks(Integer maxMergeHunks) {
            this.maxMergeHunks = maxMergeHunks;
        }

        public final Integer getMaxConflictFiles() {
            return maxConflictFiles;
        }

        @Override
        public final Builder maxConflictFiles(Integer maxConflictFiles) {
            this.maxConflictFiles = maxConflictFiles;
            return this;
        }

        public final void setMaxConflictFiles(Integer maxConflictFiles) {
            this.maxConflictFiles = maxConflictFiles;
        }

        public final Collection<String> getFilePaths() {
            return filePaths;
        }

        @Override
        public final Builder filePaths(Collection<String> filePaths) {
            this.filePaths = FilePathsCopier.copy(filePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filePaths(String... filePaths) {
            filePaths(Arrays.asList(filePaths));
            return this;
        }

        public final void setFilePaths(Collection<String> filePaths) {
            this.filePaths = FilePathsCopier.copy(filePaths);
        }

        public final String getConflictDetailLevelAsString() {
            return conflictDetailLevel;
        }

        @Override
        public final Builder conflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
            return this;
        }

        @Override
        public final Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel) {
            this.conflictDetailLevel(conflictDetailLevel == null ? null : conflictDetailLevel.toString());
            return this;
        }

        public final void setConflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
        }

        public final String getConflictResolutionStrategyAsString() {
            return conflictResolutionStrategy;
        }

        @Override
        public final Builder conflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy) {
            this.conflictResolutionStrategy(conflictResolutionStrategy == null ? null : conflictResolutionStrategy.toString());
            return this;
        }

        public final void setConflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDescribeMergeConflictsRequest build() {
            return new BatchDescribeMergeConflictsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
