/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCommitsRequest extends CodeCommitRequest implements
        ToCopyableBuilder<BatchGetCommitsRequest.Builder, BatchGetCommitsRequest> {
    private static final SdkField<List<String>> COMMIT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetCommitsRequest::commitIds))
            .setter(setter(Builder::commitIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchGetCommitsRequest::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_IDS_FIELD,
            REPOSITORY_NAME_FIELD));

    private final List<String> commitIds;

    private final String repositoryName;

    private BatchGetCommitsRequest(BuilderImpl builder) {
        super(builder);
        this.commitIds = builder.commitIds;
        this.repositoryName = builder.repositoryName;
    }

    /**
     * <p>
     * The full commit IDs of the commits to get information about.
     * </p>
     * <note>
     * <p>
     * You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The full commit IDs of the commits to get information about.</p> <note>
     *         <p>
     *         You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.
     *         </p>
     */
    public List<String> commitIds() {
        return commitIds;
    }

    /**
     * <p>
     * The name of the repository that contains the commits.
     * </p>
     * 
     * @return The name of the repository that contains the commits.
     */
    public String repositoryName() {
        return repositoryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commitIds());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCommitsRequest)) {
            return false;
        }
        BatchGetCommitsRequest other = (BatchGetCommitsRequest) obj;
        return Objects.equals(commitIds(), other.commitIds()) && Objects.equals(repositoryName(), other.repositoryName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetCommitsRequest").add("CommitIds", commitIds()).add("RepositoryName", repositoryName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitIds":
            return Optional.ofNullable(clazz.cast(commitIds()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCommitsRequest, T> g) {
        return obj -> g.apply((BatchGetCommitsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetCommitsRequest> {
        /**
         * <p>
         * The full commit IDs of the commits to get information about.
         * </p>
         * <note>
         * <p>
         * You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.
         * </p>
         * </note>
         * 
         * @param commitIds
         *        The full commit IDs of the commits to get information about.</p> <note>
         *        <p>
         *        You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitIds(Collection<String> commitIds);

        /**
         * <p>
         * The full commit IDs of the commits to get information about.
         * </p>
         * <note>
         * <p>
         * You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.
         * </p>
         * </note>
         * 
         * @param commitIds
         *        The full commit IDs of the commits to get information about.</p> <note>
         *        <p>
         *        You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitIds(String... commitIds);

        /**
         * <p>
         * The name of the repository that contains the commits.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the commits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private List<String> commitIds = DefaultSdkAutoConstructList.getInstance();

        private String repositoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCommitsRequest model) {
            super(model);
            commitIds(model.commitIds);
            repositoryName(model.repositoryName);
        }

        public final Collection<String> getCommitIds() {
            return commitIds;
        }

        @Override
        public final Builder commitIds(Collection<String> commitIds) {
            this.commitIds = CommitIdsInputListCopier.copy(commitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commitIds(String... commitIds) {
            commitIds(Arrays.asList(commitIds));
            return this;
        }

        public final void setCommitIds(Collection<String> commitIds) {
            this.commitIds = CommitIdsInputListCopier.copy(commitIds);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetCommitsRequest build() {
            return new BatchGetCommitsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
