/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a batch get repositories operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRepositoriesResponse extends CodeCommitResponse implements
        ToCopyableBuilder<BatchGetRepositoriesResponse.Builder, BatchGetRepositoriesResponse> {
    private static final SdkField<List<RepositoryMetadata>> REPOSITORIES_FIELD = SdkField
            .<List<RepositoryMetadata>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetRepositoriesResponse::repositories))
            .setter(setter(Builder::repositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REPOSITORIES_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetRepositoriesResponse::repositoriesNotFound))
            .setter(setter(Builder::repositoriesNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoriesNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORIES_FIELD,
            REPOSITORIES_NOT_FOUND_FIELD));

    private final List<RepositoryMetadata> repositories;

    private final List<String> repositoriesNotFound;

    private BatchGetRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.repositories = builder.repositories;
        this.repositoriesNotFound = builder.repositoriesNotFound;
    }

    /**
     * <p>
     * A list of repositories returned by the batch get repositories operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of repositories returned by the batch get repositories operation.
     */
    public List<RepositoryMetadata> repositories() {
        return repositories;
    }

    /**
     * <p>
     * Returns a list of repository names for which information could not be found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns a list of repository names for which information could not be found.
     */
    public List<String> repositoriesNotFound() {
        return repositoriesNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositories());
        hashCode = 31 * hashCode + Objects.hashCode(repositoriesNotFound());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRepositoriesResponse)) {
            return false;
        }
        BatchGetRepositoriesResponse other = (BatchGetRepositoriesResponse) obj;
        return Objects.equals(repositories(), other.repositories())
                && Objects.equals(repositoriesNotFound(), other.repositoriesNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetRepositoriesResponse").add("Repositories", repositories())
                .add("RepositoriesNotFound", repositoriesNotFound()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositories":
            return Optional.ofNullable(clazz.cast(repositories()));
        case "repositoriesNotFound":
            return Optional.ofNullable(clazz.cast(repositoriesNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRepositoriesResponse, T> g) {
        return obj -> g.apply((BatchGetRepositoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetRepositoriesResponse> {
        /**
         * <p>
         * A list of repositories returned by the batch get repositories operation.
         * </p>
         * 
         * @param repositories
         *        A list of repositories returned by the batch get repositories operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(Collection<RepositoryMetadata> repositories);

        /**
         * <p>
         * A list of repositories returned by the batch get repositories operation.
         * </p>
         * 
         * @param repositories
         *        A list of repositories returned by the batch get repositories operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(RepositoryMetadata... repositories);

        /**
         * <p>
         * A list of repositories returned by the batch get repositories operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RepositoryMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<RepositoryMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RepositoryMetadata>.Builder#build()} is called immediately
         * and its result is passed to {@link #repositories(List<RepositoryMetadata>)}.
         * 
         * @param repositories
         *        a consumer that will call methods on {@link List<RepositoryMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositories(List<RepositoryMetadata>)
         */
        Builder repositories(Consumer<RepositoryMetadata.Builder>... repositories);

        /**
         * <p>
         * Returns a list of repository names for which information could not be found.
         * </p>
         * 
         * @param repositoriesNotFound
         *        Returns a list of repository names for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoriesNotFound(Collection<String> repositoriesNotFound);

        /**
         * <p>
         * Returns a list of repository names for which information could not be found.
         * </p>
         * 
         * @param repositoriesNotFound
         *        Returns a list of repository names for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoriesNotFound(String... repositoriesNotFound);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<RepositoryMetadata> repositories = DefaultSdkAutoConstructList.getInstance();

        private List<String> repositoriesNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRepositoriesResponse model) {
            super(model);
            repositories(model.repositories);
            repositoriesNotFound(model.repositoriesNotFound);
        }

        public final Collection<RepositoryMetadata.Builder> getRepositories() {
            return repositories != null ? repositories.stream().map(RepositoryMetadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder repositories(Collection<RepositoryMetadata> repositories) {
            this.repositories = RepositoryMetadataListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(RepositoryMetadata... repositories) {
            repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<RepositoryMetadata.Builder>... repositories) {
            repositories(Stream.of(repositories).map(c -> RepositoryMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRepositories(Collection<RepositoryMetadata.BuilderImpl> repositories) {
            this.repositories = RepositoryMetadataListCopier.copyFromBuilder(repositories);
        }

        public final Collection<String> getRepositoriesNotFound() {
            return repositoriesNotFound;
        }

        @Override
        public final Builder repositoriesNotFound(Collection<String> repositoriesNotFound) {
            this.repositoriesNotFound = RepositoryNotFoundListCopier.copy(repositoriesNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoriesNotFound(String... repositoriesNotFound) {
            repositoriesNotFound(Arrays.asList(repositoriesNotFound));
            return this;
        }

        public final void setRepositoriesNotFound(Collection<String> repositoriesNotFound) {
            this.repositoriesNotFound = RepositoryNotFoundListCopier.copy(repositoriesNotFound);
        }

        @Override
        public BatchGetRepositoriesResponse build() {
            return new BatchGetRepositoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
