/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a specific comment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Comment implements SdkPojo, Serializable, ToCopyableBuilder<Comment.Builder, Comment> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Comment::commentId)).setter(setter(Builder::commentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentId").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Comment::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> IN_REPLY_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Comment::inReplyTo)).setter(setter(Builder::inReplyTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inReplyTo").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Comment::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Comment::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<String> AUTHOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Comment::authorArn)).setter(setter(Builder::authorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorArn").build()).build();

    private static final SdkField<Boolean> DELETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Comment::deleted)).setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Comment::clientRequestToken)).setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD,
            CONTENT_FIELD, IN_REPLY_TO_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, AUTHOR_ARN_FIELD, DELETED_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String commentId;

    private final String content;

    private final String inReplyTo;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final String authorArn;

    private final Boolean deleted;

    private final String clientRequestToken;

    private Comment(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.content = builder.content;
        this.inReplyTo = builder.inReplyTo;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.authorArn = builder.authorArn;
        this.deleted = builder.deleted;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The system-generated comment ID.
     * </p>
     * 
     * @return The system-generated comment ID.
     */
    public String commentId() {
        return commentId;
    }

    /**
     * <p>
     * The content of the comment.
     * </p>
     * 
     * @return The content of the comment.
     */
    public String content() {
        return content;
    }

    /**
     * <p>
     * The ID of the comment for which this comment is a reply, if any.
     * </p>
     * 
     * @return The ID of the comment for which this comment is a reply, if any.
     */
    public String inReplyTo() {
        return inReplyTo;
    }

    /**
     * <p>
     * The date and time the comment was created, in timestamp format.
     * </p>
     * 
     * @return The date and time the comment was created, in timestamp format.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time the comment was most recently modified, in timestamp format.
     * </p>
     * 
     * @return The date and time the comment was most recently modified, in timestamp format.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the person who posted the comment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the person who posted the comment.
     */
    public String authorArn() {
        return authorArn;
    }

    /**
     * <p>
     * A Boolean value indicating whether the comment has been deleted.
     * </p>
     * 
     * @return A Boolean value indicating whether the comment has been deleted.
     */
    public Boolean deleted() {
        return deleted;
    }

    /**
     * <p>
     * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be
     * repeated with a changed parameter. If a request is received with the same parameters and a token is included, the
     * request returns information about the initial request that used that token.
     * </p>
     * 
     * @return A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commentId());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(inReplyTo());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(authorArn());
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Comment)) {
            return false;
        }
        Comment other = (Comment) obj;
        return Objects.equals(commentId(), other.commentId()) && Objects.equals(content(), other.content())
                && Objects.equals(inReplyTo(), other.inReplyTo()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(authorArn(), other.authorArn())
                && Objects.equals(deleted(), other.deleted()) && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Comment").add("CommentId", commentId()).add("Content", content()).add("InReplyTo", inReplyTo())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate()).add("AuthorArn", authorArn())
                .add("Deleted", deleted()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commentId":
            return Optional.ofNullable(clazz.cast(commentId()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "inReplyTo":
            return Optional.ofNullable(clazz.cast(inReplyTo()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "authorArn":
            return Optional.ofNullable(clazz.cast(authorArn()));
        case "deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Comment, T> g) {
        return obj -> g.apply((Comment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Comment> {
        /**
         * <p>
         * The system-generated comment ID.
         * </p>
         * 
         * @param commentId
         *        The system-generated comment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentId(String commentId);

        /**
         * <p>
         * The content of the comment.
         * </p>
         * 
         * @param content
         *        The content of the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The ID of the comment for which this comment is a reply, if any.
         * </p>
         * 
         * @param inReplyTo
         *        The ID of the comment for which this comment is a reply, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inReplyTo(String inReplyTo);

        /**
         * <p>
         * The date and time the comment was created, in timestamp format.
         * </p>
         * 
         * @param creationDate
         *        The date and time the comment was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time the comment was most recently modified, in timestamp format.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time the comment was most recently modified, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the person who posted the comment.
         * </p>
         * 
         * @param authorArn
         *        The Amazon Resource Name (ARN) of the person who posted the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorArn(String authorArn);

        /**
         * <p>
         * A Boolean value indicating whether the comment has been deleted.
         * </p>
         * 
         * @param deleted
         *        A Boolean value indicating whether the comment has been deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Boolean deleted);

        /**
         * <p>
         * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be
         * repeated with a changed parameter. If a request is received with the same parameters and a token is included,
         * the request returns information about the initial request that used that token.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, client-generated idempotency token that, when provided in a request, ensures the request
         *        cannot be repeated with a changed parameter. If a request is received with the same parameters and a
         *        token is included, the request returns information about the initial request that used that token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);
    }

    static final class BuilderImpl implements Builder {
        private String commentId;

        private String content;

        private String inReplyTo;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private String authorArn;

        private Boolean deleted;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Comment model) {
            commentId(model.commentId);
            content(model.content);
            inReplyTo(model.inReplyTo);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            authorArn(model.authorArn);
            deleted(model.deleted);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getCommentId() {
            return commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getInReplyTo() {
            return inReplyTo;
        }

        @Override
        public final Builder inReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
            return this;
        }

        public final void setInReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getAuthorArn() {
            return authorArn;
        }

        @Override
        public final Builder authorArn(String authorArn) {
            this.authorArn = authorArn;
            return this;
        }

        public final void setAuthorArn(String authorArn) {
            this.authorArn = authorArn;
        }

        public final Boolean getDeleted() {
            return deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Comment build() {
            return new Comment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
