/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePullRequestApprovalRuleRequest extends CodeCommitRequest implements
        ToCopyableBuilder<CreatePullRequestApprovalRuleRequest.Builder, CreatePullRequestApprovalRuleRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePullRequestApprovalRuleRequest::pullRequestId)).setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> APPROVAL_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePullRequestApprovalRuleRequest::approvalRuleName)).setter(setter(Builder::approvalRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleName").build()).build();

    private static final SdkField<String> APPROVAL_RULE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePullRequestApprovalRuleRequest::approvalRuleContent))
            .setter(setter(Builder::approvalRuleContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleContent").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            APPROVAL_RULE_NAME_FIELD, APPROVAL_RULE_CONTENT_FIELD));

    private final String pullRequestId;

    private final String approvalRuleName;

    private final String approvalRuleContent;

    private CreatePullRequestApprovalRuleRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.approvalRuleName = builder.approvalRuleName;
        this.approvalRuleContent = builder.approvalRuleContent;
    }

    /**
     * <p>
     * The system-generated ID of the pull request for which you want to create the approval rule.
     * </p>
     * 
     * @return The system-generated ID of the pull request for which you want to create the approval rule.
     */
    public String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The name for the approval rule.
     * </p>
     * 
     * @return The name for the approval rule.
     */
    public String approvalRuleName() {
        return approvalRuleName;
    }

    /**
     * <p>
     * The content of the approval rule, including the number of approvals needed and the structure of an approval pool
     * defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.
     * </p>
     * <note>
     * <p>
     * When you create the content of the approval rule, you can specify approvers in an approval pool in one of two
     * ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM
     * users and federated access users whose name matches the provided resource name. This is a very powerful option
     * that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and
     * <i>Mary_Major</i>, all of the following would be counted as approvals coming from that user:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)
     * </p>
     * </li>
     * <li>
     * <p>
     * A federated user identified in IAM as Mary_Major
     * (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role
     * session name of <i>Mary_Major</i>
     * (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard
     * (*Mary_Major).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of
     * the IAM user or role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about IAM ARNs, wildcards, and formats, see <a
     * href="https://docs.aws.amazon.com/iam/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The content of the approval rule, including the number of approvals needed and the structure of an
     *         approval pool defined for approvals, if any. For more information about approval pools, see the AWS
     *         CodeCommit User Guide.</p> <note>
     *         <p>
     *         When you create the content of the approval rule, you can specify approvers in an approval pool in one of
     *         two ways:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for
     *         both IAM users and federated access users whose name matches the provided resource name. This is a very
     *         powerful option that offers a great deal of flexibility. For example, if you specify the AWS account
     *         <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals coming from
     *         that user:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A federated user identified in IAM as Mary_Major
     *         (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This option does not recognize an active session of someone assuming the role of CodeCommitReview with a
     *         role session name of <i>Mary_Major</i>
     *         (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a
     *         wildcard (*Mary_Major).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name
     *         (ARN) of the IAM user or role.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about IAM ARNs, wildcards, and formats, see <a
     *         href="https://docs.aws.amazon.com/iam/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in
     *         the <i>IAM User Guide</i>.
     *         </p>
     */
    public String approvalRuleContent() {
        return approvalRuleContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleContent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePullRequestApprovalRuleRequest)) {
            return false;
        }
        CreatePullRequestApprovalRuleRequest other = (CreatePullRequestApprovalRuleRequest) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId())
                && Objects.equals(approvalRuleName(), other.approvalRuleName())
                && Objects.equals(approvalRuleContent(), other.approvalRuleContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreatePullRequestApprovalRuleRequest").add("PullRequestId", pullRequestId())
                .add("ApprovalRuleName", approvalRuleName()).add("ApprovalRuleContent", approvalRuleContent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "approvalRuleName":
            return Optional.ofNullable(clazz.cast(approvalRuleName()));
        case "approvalRuleContent":
            return Optional.ofNullable(clazz.cast(approvalRuleContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePullRequestApprovalRuleRequest, T> g) {
        return obj -> g.apply((CreatePullRequestApprovalRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePullRequestApprovalRuleRequest> {
        /**
         * <p>
         * The system-generated ID of the pull request for which you want to create the approval rule.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request for which you want to create the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The name for the approval rule.
         * </p>
         * 
         * @param approvalRuleName
         *        The name for the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleName(String approvalRuleName);

        /**
         * <p>
         * The content of the approval rule, including the number of approvals needed and the structure of an approval
         * pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User
         * Guide.
         * </p>
         * <note>
         * <p>
         * When you create the content of the approval rule, you can specify approvers in an approval pool in one of two
         * ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both
         * IAM users and federated access users whose name matches the provided resource name. This is a very powerful
         * option that offers a great deal of flexibility. For example, if you specify the AWS account
         * <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals coming from
         * that user:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)
         * </p>
         * </li>
         * <li>
         * <p>
         * A federated user identified in IAM as Mary_Major
         * (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role
         * session name of <i>Mary_Major</i>
         * (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a
         * wildcard (*Mary_Major).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN)
         * of the IAM user or role.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about IAM ARNs, wildcards, and formats, see <a
         * href="https://docs.aws.amazon.com/iam/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * </note>
         * 
         * @param approvalRuleContent
         *        The content of the approval rule, including the number of approvals needed and the structure of an
         *        approval pool defined for approvals, if any. For more information about approval pools, see the AWS
         *        CodeCommit User Guide.</p> <note>
         *        <p>
         *        When you create the content of the approval rule, you can specify approvers in an approval pool in one
         *        of two ways:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used
         *        for both IAM users and federated access users whose name matches the provided resource name. This is a
         *        very powerful option that offers a great deal of flexibility. For example, if you specify the AWS
         *        account <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals
         *        coming from that user:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A federated user identified in IAM as Mary_Major
         *        (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This option does not recognize an active session of someone assuming the role of CodeCommitReview with
         *        a role session name of <i>Mary_Major</i>
         *        (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include
         *        a wildcard (*Mary_Major).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name
         *        (ARN) of the IAM user or role.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about IAM ARNs, wildcards, and formats, see <a
         *        href="https://docs.aws.amazon.com/iam/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a>
         *        in the <i>IAM User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleContent(String approvalRuleContent);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String pullRequestId;

        private String approvalRuleName;

        private String approvalRuleContent;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePullRequestApprovalRuleRequest model) {
            super(model);
            pullRequestId(model.pullRequestId);
            approvalRuleName(model.approvalRuleName);
            approvalRuleContent(model.approvalRuleContent);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getApprovalRuleName() {
            return approvalRuleName;
        }

        @Override
        public final Builder approvalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
            return this;
        }

        public final void setApprovalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
        }

        public final String getApprovalRuleContent() {
            return approvalRuleContent;
        }

        @Override
        public final Builder approvalRuleContent(String approvalRuleContent) {
            this.approvalRuleContent = approvalRuleContent;
            return this;
        }

        public final void setApprovalRuleContent(String approvalRuleContent) {
            this.approvalRuleContent = approvalRuleContent;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePullRequestApprovalRuleRequest build() {
            return new CreatePullRequestApprovalRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
