/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApprovalRuleTemplateResponse extends CodeCommitResponse implements
        ToCopyableBuilder<DeleteApprovalRuleTemplateResponse.Builder, DeleteApprovalRuleTemplateResponse> {
    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteApprovalRuleTemplateResponse::approvalRuleTemplateId))
            .setter(setter(Builder::approvalRuleTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPROVAL_RULE_TEMPLATE_ID_FIELD));

    private final String approvalRuleTemplateId;

    private DeleteApprovalRuleTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.approvalRuleTemplateId = builder.approvalRuleTemplateId;
    }

    /**
     * <p>
     * The system-generated ID of the deleted approval rule template. If the template has been previously deleted, the
     * only response is a 200 OK.
     * </p>
     * 
     * @return The system-generated ID of the deleted approval rule template. If the template has been previously
     *         deleted, the only response is a 200 OK.
     */
    public String approvalRuleTemplateId() {
        return approvalRuleTemplateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApprovalRuleTemplateResponse)) {
            return false;
        }
        DeleteApprovalRuleTemplateResponse other = (DeleteApprovalRuleTemplateResponse) obj;
        return Objects.equals(approvalRuleTemplateId(), other.approvalRuleTemplateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteApprovalRuleTemplateResponse").add("ApprovalRuleTemplateId", approvalRuleTemplateId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleTemplateId":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApprovalRuleTemplateResponse, T> g) {
        return obj -> g.apply((DeleteApprovalRuleTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteApprovalRuleTemplateResponse> {
        /**
         * <p>
         * The system-generated ID of the deleted approval rule template. If the template has been previously deleted,
         * the only response is a 200 OK.
         * </p>
         * 
         * @param approvalRuleTemplateId
         *        The system-generated ID of the deleted approval rule template. If the template has been previously
         *        deleted, the only response is a 200 OK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateId(String approvalRuleTemplateId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String approvalRuleTemplateId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApprovalRuleTemplateResponse model) {
            super(model);
            approvalRuleTemplateId(model.approvalRuleTemplateId);
        }

        public final String getApprovalRuleTemplateId() {
            return approvalRuleTemplateId;
        }

        @Override
        public final Builder approvalRuleTemplateId(String approvalRuleTemplateId) {
            this.approvalRuleTemplateId = approvalRuleTemplateId;
            return this;
        }

        public final void setApprovalRuleTemplateId(String approvalRuleTemplateId) {
            this.approvalRuleTemplateId = approvalRuleTemplateId;
        }

        @Override
        public DeleteApprovalRuleTemplateResponse build() {
            return new DeleteApprovalRuleTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
