/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluatePullRequestApprovalRulesResponse extends CodeCommitResponse implements
        ToCopyableBuilder<EvaluatePullRequestApprovalRulesResponse.Builder, EvaluatePullRequestApprovalRulesResponse> {
    private static final SdkField<Evaluation> EVALUATION_FIELD = SdkField.<Evaluation> builder(MarshallingType.SDK_POJO)
            .getter(getter(EvaluatePullRequestApprovalRulesResponse::evaluation)).setter(setter(Builder::evaluation))
            .constructor(Evaluation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FIELD));

    private final Evaluation evaluation;

    private EvaluatePullRequestApprovalRulesResponse(BuilderImpl builder) {
        super(builder);
        this.evaluation = builder.evaluation;
    }

    /**
     * <p>
     * The result of the evaluation, including the names of the rules whose conditions have been met (if any), the names
     * of the rules whose conditions have not been met (if any), whether the pull request is in the approved state, and
     * whether the pull request approval rule has been set aside by an override.
     * </p>
     * 
     * @return The result of the evaluation, including the names of the rules whose conditions have been met (if any),
     *         the names of the rules whose conditions have not been met (if any), whether the pull request is in the
     *         approved state, and whether the pull request approval rule has been set aside by an override.
     */
    public Evaluation evaluation() {
        return evaluation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(evaluation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatePullRequestApprovalRulesResponse)) {
            return false;
        }
        EvaluatePullRequestApprovalRulesResponse other = (EvaluatePullRequestApprovalRulesResponse) obj;
        return Objects.equals(evaluation(), other.evaluation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EvaluatePullRequestApprovalRulesResponse").add("Evaluation", evaluation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "evaluation":
            return Optional.ofNullable(clazz.cast(evaluation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluatePullRequestApprovalRulesResponse, T> g) {
        return obj -> g.apply((EvaluatePullRequestApprovalRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, EvaluatePullRequestApprovalRulesResponse> {
        /**
         * <p>
         * The result of the evaluation, including the names of the rules whose conditions have been met (if any), the
         * names of the rules whose conditions have not been met (if any), whether the pull request is in the approved
         * state, and whether the pull request approval rule has been set aside by an override.
         * </p>
         * 
         * @param evaluation
         *        The result of the evaluation, including the names of the rules whose conditions have been met (if
         *        any), the names of the rules whose conditions have not been met (if any), whether the pull request is
         *        in the approved state, and whether the pull request approval rule has been set aside by an override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluation(Evaluation evaluation);

        /**
         * <p>
         * The result of the evaluation, including the names of the rules whose conditions have been met (if any), the
         * names of the rules whose conditions have not been met (if any), whether the pull request is in the approved
         * state, and whether the pull request approval rule has been set aside by an override.
         * </p>
         * This is a convenience that creates an instance of the {@link Evaluation.Builder} avoiding the need to create
         * one manually via {@link Evaluation#builder()}.
         *
         * When the {@link Consumer} completes, {@link Evaluation.Builder#build()} is called immediately and its result
         * is passed to {@link #evaluation(Evaluation)}.
         * 
         * @param evaluation
         *        a consumer that will call methods on {@link Evaluation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluation(Evaluation)
         */
        default Builder evaluation(Consumer<Evaluation.Builder> evaluation) {
            return evaluation(Evaluation.builder().applyMutation(evaluation).build());
        }
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private Evaluation evaluation;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluatePullRequestApprovalRulesResponse model) {
            super(model);
            evaluation(model.evaluation);
        }

        public final Evaluation.Builder getEvaluation() {
            return evaluation != null ? evaluation.toBuilder() : null;
        }

        @Override
        public final Builder evaluation(Evaluation evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        public final void setEvaluation(Evaluation.BuilderImpl evaluation) {
            this.evaluation = evaluation != null ? evaluation.build() : null;
        }

        @Override
        public EvaluatePullRequestApprovalRulesResponse build() {
            return new EvaluatePullRequestApprovalRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
