/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A file to be added, updated, or deleted as part of a commit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileMetadata implements SdkPojo, Serializable, ToCopyableBuilder<FileMetadata.Builder, FileMetadata> {
    private static final SdkField<String> ABSOLUTE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FileMetadata::absolutePath)).setter(setter(Builder::absolutePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("absolutePath").build()).build();

    private static final SdkField<String> BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FileMetadata::blobId)).setter(setter(Builder::blobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()).build();

    private static final SdkField<String> FILE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FileMetadata::fileModeAsString)).setter(setter(Builder::fileMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ABSOLUTE_PATH_FIELD,
            BLOB_ID_FIELD, FILE_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String absolutePath;

    private final String blobId;

    private final String fileMode;

    private FileMetadata(BuilderImpl builder) {
        this.absolutePath = builder.absolutePath;
        this.blobId = builder.blobId;
        this.fileMode = builder.fileMode;
    }

    /**
     * <p>
     * The full path to the file to be added or updated, including the name of the file.
     * </p>
     * 
     * @return The full path to the file to be added or updated, including the name of the file.
     */
    public String absolutePath() {
        return absolutePath;
    }

    /**
     * <p>
     * The blob ID that contains the file information.
     * </p>
     * 
     * @return The blob ID that contains the file information.
     */
    public String blobId() {
        return blobId;
    }

    /**
     * <p>
     * The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileMode} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileModeAsString}.
     * </p>
     * 
     * @return The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.
     * @see FileModeTypeEnum
     */
    public FileModeTypeEnum fileMode() {
        return FileModeTypeEnum.fromValue(fileMode);
    }

    /**
     * <p>
     * The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileMode} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileModeAsString}.
     * </p>
     * 
     * @return The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.
     * @see FileModeTypeEnum
     */
    public String fileModeAsString() {
        return fileMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(absolutePath());
        hashCode = 31 * hashCode + Objects.hashCode(blobId());
        hashCode = 31 * hashCode + Objects.hashCode(fileModeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileMetadata)) {
            return false;
        }
        FileMetadata other = (FileMetadata) obj;
        return Objects.equals(absolutePath(), other.absolutePath()) && Objects.equals(blobId(), other.blobId())
                && Objects.equals(fileModeAsString(), other.fileModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FileMetadata").add("AbsolutePath", absolutePath()).add("BlobId", blobId())
                .add("FileMode", fileModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "absolutePath":
            return Optional.ofNullable(clazz.cast(absolutePath()));
        case "blobId":
            return Optional.ofNullable(clazz.cast(blobId()));
        case "fileMode":
            return Optional.ofNullable(clazz.cast(fileModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileMetadata, T> g) {
        return obj -> g.apply((FileMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileMetadata> {
        /**
         * <p>
         * The full path to the file to be added or updated, including the name of the file.
         * </p>
         * 
         * @param absolutePath
         *        The full path to the file to be added or updated, including the name of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder absolutePath(String absolutePath);

        /**
         * <p>
         * The blob ID that contains the file information.
         * </p>
         * 
         * @param blobId
         *        The blob ID that contains the file information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobId(String blobId);

        /**
         * <p>
         * The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.
         * </p>
         * 
         * @param fileMode
         *        The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder fileMode(String fileMode);

        /**
         * <p>
         * The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.
         * </p>
         * 
         * @param fileMode
         *        The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder fileMode(FileModeTypeEnum fileMode);
    }

    static final class BuilderImpl implements Builder {
        private String absolutePath;

        private String blobId;

        private String fileMode;

        private BuilderImpl() {
        }

        private BuilderImpl(FileMetadata model) {
            absolutePath(model.absolutePath);
            blobId(model.blobId);
            fileMode(model.fileMode);
        }

        public final String getAbsolutePath() {
            return absolutePath;
        }

        @Override
        public final Builder absolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
            return this;
        }

        public final void setAbsolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        public final String getBlobId() {
            return blobId;
        }

        @Override
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        public final String getFileModeAsString() {
            return fileMode;
        }

        @Override
        public final Builder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        @Override
        public final Builder fileMode(FileModeTypeEnum fileMode) {
            this.fileMode(fileMode == null ? null : fileMode.toString());
            return this;
        }

        public final void setFileMode(String fileMode) {
            this.fileMode = fileMode;
        }

        @Override
        public FileMetadata build() {
            return new FileMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
