/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMergeConflictsResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetMergeConflictsResponse.Builder, GetMergeConflictsResponse> {
    private static final SdkField<Boolean> MERGEABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetMergeConflictsResponse::mergeable)).setter(setter(Builder::mergeable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeable").build()).build();

    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeConflictsResponse::destinationCommitId)).setter(setter(Builder::destinationCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build())
            .build();

    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeConflictsResponse::sourceCommitId)).setter(setter(Builder::sourceCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()).build();

    private static final SdkField<String> BASE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeConflictsResponse::baseCommitId)).setter(setter(Builder::baseCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCommitId").build()).build();

    private static final SdkField<List<ConflictMetadata>> CONFLICT_METADATA_LIST_FIELD = SdkField
            .<List<ConflictMetadata>> builder(MarshallingType.LIST)
            .getter(getter(GetMergeConflictsResponse::conflictMetadataList))
            .setter(setter(Builder::conflictMetadataList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictMetadataList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConflictMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConflictMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetMergeConflictsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGEABLE_FIELD,
            DESTINATION_COMMIT_ID_FIELD, SOURCE_COMMIT_ID_FIELD, BASE_COMMIT_ID_FIELD, CONFLICT_METADATA_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final Boolean mergeable;

    private final String destinationCommitId;

    private final String sourceCommitId;

    private final String baseCommitId;

    private final List<ConflictMetadata> conflictMetadataList;

    private final String nextToken;

    private GetMergeConflictsResponse(BuilderImpl builder) {
        super(builder);
        this.mergeable = builder.mergeable;
        this.destinationCommitId = builder.destinationCommitId;
        this.sourceCommitId = builder.sourceCommitId;
        this.baseCommitId = builder.baseCommitId;
        this.conflictMetadataList = builder.conflictMetadataList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A Boolean value that indicates whether the code is mergeable by the specified merge option.
     * </p>
     * 
     * @return A Boolean value that indicates whether the code is mergeable by the specified merge option.
     */
    public Boolean mergeable() {
        return mergeable;
    }

    /**
     * <p>
     * The commit ID of the destination commit specifier that was used in the merge evaluation.
     * </p>
     * 
     * @return The commit ID of the destination commit specifier that was used in the merge evaluation.
     */
    public String destinationCommitId() {
        return destinationCommitId;
    }

    /**
     * <p>
     * The commit ID of the source commit specifier that was used in the merge evaluation.
     * </p>
     * 
     * @return The commit ID of the source commit specifier that was used in the merge evaluation.
     */
    public String sourceCommitId() {
        return sourceCommitId;
    }

    /**
     * <p>
     * The commit ID of the merge base.
     * </p>
     * 
     * @return The commit ID of the merge base.
     */
    public String baseCommitId() {
        return baseCommitId;
    }

    /**
     * <p>
     * A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE, this list is
     * always empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE, this
     *         list is always empty.
     */
    public List<ConflictMetadata> conflictMetadataList() {
        return conflictMetadataList;
    }

    /**
     * <p>
     * An enumeration token that can be used in a request to return the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that can be used in a request to return the next batch of the results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mergeable());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(baseCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(conflictMetadataList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeConflictsResponse)) {
            return false;
        }
        GetMergeConflictsResponse other = (GetMergeConflictsResponse) obj;
        return Objects.equals(mergeable(), other.mergeable())
                && Objects.equals(destinationCommitId(), other.destinationCommitId())
                && Objects.equals(sourceCommitId(), other.sourceCommitId())
                && Objects.equals(baseCommitId(), other.baseCommitId())
                && Objects.equals(conflictMetadataList(), other.conflictMetadataList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMergeConflictsResponse").add("Mergeable", mergeable())
                .add("DestinationCommitId", destinationCommitId()).add("SourceCommitId", sourceCommitId())
                .add("BaseCommitId", baseCommitId()).add("ConflictMetadataList", conflictMetadataList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mergeable":
            return Optional.ofNullable(clazz.cast(mergeable()));
        case "destinationCommitId":
            return Optional.ofNullable(clazz.cast(destinationCommitId()));
        case "sourceCommitId":
            return Optional.ofNullable(clazz.cast(sourceCommitId()));
        case "baseCommitId":
            return Optional.ofNullable(clazz.cast(baseCommitId()));
        case "conflictMetadataList":
            return Optional.ofNullable(clazz.cast(conflictMetadataList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMergeConflictsResponse, T> g) {
        return obj -> g.apply((GetMergeConflictsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMergeConflictsResponse> {
        /**
         * <p>
         * A Boolean value that indicates whether the code is mergeable by the specified merge option.
         * </p>
         * 
         * @param mergeable
         *        A Boolean value that indicates whether the code is mergeable by the specified merge option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeable(Boolean mergeable);

        /**
         * <p>
         * The commit ID of the destination commit specifier that was used in the merge evaluation.
         * </p>
         * 
         * @param destinationCommitId
         *        The commit ID of the destination commit specifier that was used in the merge evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitId(String destinationCommitId);

        /**
         * <p>
         * The commit ID of the source commit specifier that was used in the merge evaluation.
         * </p>
         * 
         * @param sourceCommitId
         *        The commit ID of the source commit specifier that was used in the merge evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitId(String sourceCommitId);

        /**
         * <p>
         * The commit ID of the merge base.
         * </p>
         * 
         * @param baseCommitId
         *        The commit ID of the merge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseCommitId(String baseCommitId);

        /**
         * <p>
         * A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE, this
         * list is always empty.
         * </p>
         * 
         * @param conflictMetadataList
         *        A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE,
         *        this list is always empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictMetadataList(Collection<ConflictMetadata> conflictMetadataList);

        /**
         * <p>
         * A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE, this
         * list is always empty.
         * </p>
         * 
         * @param conflictMetadataList
         *        A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE,
         *        this list is always empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictMetadataList(ConflictMetadata... conflictMetadataList);

        /**
         * <p>
         * A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE, this
         * list is always empty.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConflictMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<ConflictMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConflictMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #conflictMetadataList(List<ConflictMetadata>)}.
         * 
         * @param conflictMetadataList
         *        a consumer that will call methods on {@link List<ConflictMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflictMetadataList(List<ConflictMetadata>)
         */
        Builder conflictMetadataList(Consumer<ConflictMetadata.Builder>... conflictMetadataList);

        /**
         * <p>
         * An enumeration token that can be used in a request to return the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used in a request to return the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private Boolean mergeable;

        private String destinationCommitId;

        private String sourceCommitId;

        private String baseCommitId;

        private List<ConflictMetadata> conflictMetadataList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMergeConflictsResponse model) {
            super(model);
            mergeable(model.mergeable);
            destinationCommitId(model.destinationCommitId);
            sourceCommitId(model.sourceCommitId);
            baseCommitId(model.baseCommitId);
            conflictMetadataList(model.conflictMetadataList);
            nextToken(model.nextToken);
        }

        public final Boolean getMergeable() {
            return mergeable;
        }

        @Override
        public final Builder mergeable(Boolean mergeable) {
            this.mergeable = mergeable;
            return this;
        }

        public final void setMergeable(Boolean mergeable) {
            this.mergeable = mergeable;
        }

        public final String getDestinationCommitId() {
            return destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        public final String getSourceCommitId() {
            return sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        public final String getBaseCommitId() {
            return baseCommitId;
        }

        @Override
        public final Builder baseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
            return this;
        }

        public final void setBaseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
        }

        public final Collection<ConflictMetadata.Builder> getConflictMetadataList() {
            return conflictMetadataList != null ? conflictMetadataList.stream().map(ConflictMetadata::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conflictMetadataList(Collection<ConflictMetadata> conflictMetadataList) {
            this.conflictMetadataList = ConflictMetadataListCopier.copy(conflictMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflictMetadataList(ConflictMetadata... conflictMetadataList) {
            conflictMetadataList(Arrays.asList(conflictMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflictMetadataList(Consumer<ConflictMetadata.Builder>... conflictMetadataList) {
            conflictMetadataList(Stream.of(conflictMetadataList).map(c -> ConflictMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConflictMetadataList(Collection<ConflictMetadata.BuilderImpl> conflictMetadataList) {
            this.conflictMetadataList = ConflictMetadataListCopier.copyFromBuilder(conflictMetadataList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetMergeConflictsResponse build() {
            return new GetMergeConflictsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
