/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPullRequestApprovalStatesRequest extends CodeCommitRequest implements
        ToCopyableBuilder<GetPullRequestApprovalStatesRequest.Builder, GetPullRequestApprovalStatesRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPullRequestApprovalStatesRequest::pullRequestId)).setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPullRequestApprovalStatesRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            REVISION_ID_FIELD));

    private final String pullRequestId;

    private final String revisionId;

    private GetPullRequestApprovalStatesRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The system-generated ID for the pull request.
     * </p>
     * 
     * @return The system-generated ID for the pull request.
     */
    public String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * The system-generated ID for the pull request revision.
     * </p>
     * 
     * @return The system-generated ID for the pull request revision.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPullRequestApprovalStatesRequest)) {
            return false;
        }
        GetPullRequestApprovalStatesRequest other = (GetPullRequestApprovalStatesRequest) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId()) && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPullRequestApprovalStatesRequest").add("PullRequestId", pullRequestId())
                .add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPullRequestApprovalStatesRequest, T> g) {
        return obj -> g.apply((GetPullRequestApprovalStatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPullRequestApprovalStatesRequest> {
        /**
         * <p>
         * The system-generated ID for the pull request.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID for the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * The system-generated ID for the pull request revision.
         * </p>
         * 
         * @param revisionId
         *        The system-generated ID for the pull request revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String pullRequestId;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPullRequestApprovalStatesRequest model) {
            super(model);
            pullRequestId(model.pullRequestId);
            revisionId(model.revisionId);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPullRequestApprovalStatesRequest build() {
            return new GetPullRequestApprovalStatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
