/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeBranchesBySquashResponse extends CodeCommitResponse implements
        ToCopyableBuilder<MergeBranchesBySquashResponse.Builder, MergeBranchesBySquashResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashResponse::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final SdkField<String> TREE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MergeBranchesBySquashResponse::treeId)).setter(setter(Builder::treeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COMMIT_ID_FIELD, TREE_ID_FIELD));

    private final String commitId;

    private final String treeId;

    private MergeBranchesBySquashResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.treeId = builder.treeId;
    }

    /**
     * <p>
     * The commit ID of the merge in the destination or target branch.
     * </p>
     * 
     * @return The commit ID of the merge in the destination or target branch.
     */
    public String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The tree ID of the merge in the destination or target branch.
     * </p>
     * 
     * @return The tree ID of the merge in the destination or target branch.
     */
    public String treeId() {
        return treeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(treeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeBranchesBySquashResponse)) {
            return false;
        }
        MergeBranchesBySquashResponse other = (MergeBranchesBySquashResponse) obj;
        return Objects.equals(commitId(), other.commitId()) && Objects.equals(treeId(), other.treeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MergeBranchesBySquashResponse").add("CommitId", commitId()).add("TreeId", treeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "treeId":
            return Optional.ofNullable(clazz.cast(treeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeBranchesBySquashResponse, T> g) {
        return obj -> g.apply((MergeBranchesBySquashResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, MergeBranchesBySquashResponse> {
        /**
         * <p>
         * The commit ID of the merge in the destination or target branch.
         * </p>
         * 
         * @param commitId
         *        The commit ID of the merge in the destination or target branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The tree ID of the merge in the destination or target branch.
         * </p>
         * 
         * @param treeId
         *        The tree ID of the merge in the destination or target branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeId(String treeId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String commitId;

        private String treeId;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeBranchesBySquashResponse model) {
            super(model);
            commitId(model.commitId);
            treeId(model.treeId);
        }

        public final String getCommitId() {
            return commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public final String getTreeId() {
            return treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        @Override
        public MergeBranchesBySquashResponse build() {
            return new MergeBranchesBySquashResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
