/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a pull request target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PullRequestTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<PullRequestTarget.Builder, PullRequestTarget> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PullRequestTarget::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> SOURCE_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PullRequestTarget::sourceReference)).setter(setter(Builder::sourceReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceReference").build()).build();

    private static final SdkField<String> DESTINATION_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PullRequestTarget::destinationReference)).setter(setter(Builder::destinationReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationReference").build())
            .build();

    private static final SdkField<String> DESTINATION_COMMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PullRequestTarget::destinationCommit)).setter(setter(Builder::destinationCommit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommit").build()).build();

    private static final SdkField<String> SOURCE_COMMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PullRequestTarget::sourceCommit)).setter(setter(Builder::sourceCommit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommit").build()).build();

    private static final SdkField<String> MERGE_BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PullRequestTarget::mergeBase)).setter(setter(Builder::mergeBase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeBase").build()).build();

    private static final SdkField<MergeMetadata> MERGE_METADATA_FIELD = SdkField
            .<MergeMetadata> builder(MarshallingType.SDK_POJO).getter(getter(PullRequestTarget::mergeMetadata))
            .setter(setter(Builder::mergeMetadata)).constructor(MergeMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            SOURCE_REFERENCE_FIELD, DESTINATION_REFERENCE_FIELD, DESTINATION_COMMIT_FIELD, SOURCE_COMMIT_FIELD, MERGE_BASE_FIELD,
            MERGE_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryName;

    private final String sourceReference;

    private final String destinationReference;

    private final String destinationCommit;

    private final String sourceCommit;

    private final String mergeBase;

    private final MergeMetadata mergeMetadata;

    private PullRequestTarget(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.sourceReference = builder.sourceReference;
        this.destinationReference = builder.destinationReference;
        this.destinationCommit = builder.destinationCommit;
        this.sourceCommit = builder.sourceCommit;
        this.mergeBase = builder.mergeBase;
        this.mergeMetadata = builder.mergeMetadata;
    }

    /**
     * <p>
     * The name of the repository that contains the pull request source and destination branches.
     * </p>
     * 
     * @return The name of the repository that contains the pull request source and destination branches.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The branch of the repository that contains the changes for the pull request. Also known as the source branch.
     * </p>
     * 
     * @return The branch of the repository that contains the changes for the pull request. Also known as the source
     *         branch.
     */
    public String sourceReference() {
        return sourceReference;
    }

    /**
     * <p>
     * The branch of the repository where the pull request changes are merged. Also known as the destination branch.
     * </p>
     * 
     * @return The branch of the repository where the pull request changes are merged. Also known as the destination
     *         branch.
     */
    public String destinationReference() {
        return destinationReference;
    }

    /**
     * <p>
     * The full commit ID that is the tip of the destination branch. This is the commit where the pull request was or
     * will be merged.
     * </p>
     * 
     * @return The full commit ID that is the tip of the destination branch. This is the commit where the pull request
     *         was or will be merged.
     */
    public String destinationCommit() {
        return destinationCommit;
    }

    /**
     * <p>
     * The full commit ID of the tip of the source branch used to create the pull request. If the pull request branch is
     * updated by a push while the pull request is open, the commit ID changes to reflect the new tip of the branch.
     * </p>
     * 
     * @return The full commit ID of the tip of the source branch used to create the pull request. If the pull request
     *         branch is updated by a push while the pull request is open, the commit ID changes to reflect the new tip
     *         of the branch.
     */
    public String sourceCommit() {
        return sourceCommit;
    }

    /**
     * <p>
     * The commit ID of the most recent commit that the source branch and the destination branch have in common.
     * </p>
     * 
     * @return The commit ID of the most recent commit that the source branch and the destination branch have in common.
     */
    public String mergeBase() {
        return mergeBase;
    }

    /**
     * <p>
     * Returns metadata about the state of the merge, including whether the merge has been made.
     * </p>
     * 
     * @return Returns metadata about the state of the merge, including whether the merge has been made.
     */
    public MergeMetadata mergeMetadata() {
        return mergeMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceReference());
        hashCode = 31 * hashCode + Objects.hashCode(destinationReference());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommit());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommit());
        hashCode = 31 * hashCode + Objects.hashCode(mergeBase());
        hashCode = 31 * hashCode + Objects.hashCode(mergeMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestTarget)) {
            return false;
        }
        PullRequestTarget other = (PullRequestTarget) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(sourceReference(), other.sourceReference())
                && Objects.equals(destinationReference(), other.destinationReference())
                && Objects.equals(destinationCommit(), other.destinationCommit())
                && Objects.equals(sourceCommit(), other.sourceCommit()) && Objects.equals(mergeBase(), other.mergeBase())
                && Objects.equals(mergeMetadata(), other.mergeMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PullRequestTarget").add("RepositoryName", repositoryName())
                .add("SourceReference", sourceReference()).add("DestinationReference", destinationReference())
                .add("DestinationCommit", destinationCommit()).add("SourceCommit", sourceCommit()).add("MergeBase", mergeBase())
                .add("MergeMetadata", mergeMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "sourceReference":
            return Optional.ofNullable(clazz.cast(sourceReference()));
        case "destinationReference":
            return Optional.ofNullable(clazz.cast(destinationReference()));
        case "destinationCommit":
            return Optional.ofNullable(clazz.cast(destinationCommit()));
        case "sourceCommit":
            return Optional.ofNullable(clazz.cast(sourceCommit()));
        case "mergeBase":
            return Optional.ofNullable(clazz.cast(mergeBase()));
        case "mergeMetadata":
            return Optional.ofNullable(clazz.cast(mergeMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PullRequestTarget, T> g) {
        return obj -> g.apply((PullRequestTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PullRequestTarget> {
        /**
         * <p>
         * The name of the repository that contains the pull request source and destination branches.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the pull request source and destination branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The branch of the repository that contains the changes for the pull request. Also known as the source branch.
         * </p>
         * 
         * @param sourceReference
         *        The branch of the repository that contains the changes for the pull request. Also known as the source
         *        branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceReference(String sourceReference);

        /**
         * <p>
         * The branch of the repository where the pull request changes are merged. Also known as the destination branch.
         * </p>
         * 
         * @param destinationReference
         *        The branch of the repository where the pull request changes are merged. Also known as the destination
         *        branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationReference(String destinationReference);

        /**
         * <p>
         * The full commit ID that is the tip of the destination branch. This is the commit where the pull request was
         * or will be merged.
         * </p>
         * 
         * @param destinationCommit
         *        The full commit ID that is the tip of the destination branch. This is the commit where the pull
         *        request was or will be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommit(String destinationCommit);

        /**
         * <p>
         * The full commit ID of the tip of the source branch used to create the pull request. If the pull request
         * branch is updated by a push while the pull request is open, the commit ID changes to reflect the new tip of
         * the branch.
         * </p>
         * 
         * @param sourceCommit
         *        The full commit ID of the tip of the source branch used to create the pull request. If the pull
         *        request branch is updated by a push while the pull request is open, the commit ID changes to reflect
         *        the new tip of the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommit(String sourceCommit);

        /**
         * <p>
         * The commit ID of the most recent commit that the source branch and the destination branch have in common.
         * </p>
         * 
         * @param mergeBase
         *        The commit ID of the most recent commit that the source branch and the destination branch have in
         *        common.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeBase(String mergeBase);

        /**
         * <p>
         * Returns metadata about the state of the merge, including whether the merge has been made.
         * </p>
         * 
         * @param mergeMetadata
         *        Returns metadata about the state of the merge, including whether the merge has been made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeMetadata(MergeMetadata mergeMetadata);

        /**
         * <p>
         * Returns metadata about the state of the merge, including whether the merge has been made.
         * </p>
         * This is a convenience that creates an instance of the {@link MergeMetadata.Builder} avoiding the need to
         * create one manually via {@link MergeMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link MergeMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #mergeMetadata(MergeMetadata)}.
         * 
         * @param mergeMetadata
         *        a consumer that will call methods on {@link MergeMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mergeMetadata(MergeMetadata)
         */
        default Builder mergeMetadata(Consumer<MergeMetadata.Builder> mergeMetadata) {
            return mergeMetadata(MergeMetadata.builder().applyMutation(mergeMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String repositoryName;

        private String sourceReference;

        private String destinationReference;

        private String destinationCommit;

        private String sourceCommit;

        private String mergeBase;

        private MergeMetadata mergeMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestTarget model) {
            repositoryName(model.repositoryName);
            sourceReference(model.sourceReference);
            destinationReference(model.destinationReference);
            destinationCommit(model.destinationCommit);
            sourceCommit(model.sourceCommit);
            mergeBase(model.mergeBase);
            mergeMetadata(model.mergeMetadata);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getSourceReference() {
            return sourceReference;
        }

        @Override
        public final Builder sourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public final void setSourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
        }

        public final String getDestinationReference() {
            return destinationReference;
        }

        @Override
        public final Builder destinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
            return this;
        }

        public final void setDestinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
        }

        public final String getDestinationCommit() {
            return destinationCommit;
        }

        @Override
        public final Builder destinationCommit(String destinationCommit) {
            this.destinationCommit = destinationCommit;
            return this;
        }

        public final void setDestinationCommit(String destinationCommit) {
            this.destinationCommit = destinationCommit;
        }

        public final String getSourceCommit() {
            return sourceCommit;
        }

        @Override
        public final Builder sourceCommit(String sourceCommit) {
            this.sourceCommit = sourceCommit;
            return this;
        }

        public final void setSourceCommit(String sourceCommit) {
            this.sourceCommit = sourceCommit;
        }

        public final String getMergeBase() {
            return mergeBase;
        }

        @Override
        public final Builder mergeBase(String mergeBase) {
            this.mergeBase = mergeBase;
            return this;
        }

        public final void setMergeBase(String mergeBase) {
            this.mergeBase = mergeBase;
        }

        public final MergeMetadata.Builder getMergeMetadata() {
            return mergeMetadata != null ? mergeMetadata.toBuilder() : null;
        }

        @Override
        public final Builder mergeMetadata(MergeMetadata mergeMetadata) {
            this.mergeMetadata = mergeMetadata;
            return this;
        }

        public final void setMergeMetadata(MergeMetadata.BuilderImpl mergeMetadata) {
            this.mergeMetadata = mergeMetadata != null ? mergeMetadata.build() : null;
        }

        @Override
        public PullRequestTarget build() {
            return new PullRequestTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
