/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a target for a pull request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Target implements SdkPojo, Serializable, ToCopyableBuilder<Target.Builder, Target> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Target::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> SOURCE_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Target::sourceReference)).setter(setter(Builder::sourceReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceReference").build()).build();

    private static final SdkField<String> DESTINATION_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Target::destinationReference)).setter(setter(Builder::destinationReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationReference").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            SOURCE_REFERENCE_FIELD, DESTINATION_REFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryName;

    private final String sourceReference;

    private final String destinationReference;

    private Target(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.sourceReference = builder.sourceReference;
        this.destinationReference = builder.destinationReference;
    }

    /**
     * <p>
     * The name of the repository that contains the pull request.
     * </p>
     * 
     * @return The name of the repository that contains the pull request.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The branch of the repository that contains the changes for the pull request. Also known as the source branch.
     * </p>
     * 
     * @return The branch of the repository that contains the changes for the pull request. Also known as the source
     *         branch.
     */
    public String sourceReference() {
        return sourceReference;
    }

    /**
     * <p>
     * The branch of the repository where the pull request changes are merged. Also known as the destination branch.
     * </p>
     * 
     * @return The branch of the repository where the pull request changes are merged. Also known as the destination
     *         branch.
     */
    public String destinationReference() {
        return destinationReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceReference());
        hashCode = 31 * hashCode + Objects.hashCode(destinationReference());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(sourceReference(), other.sourceReference())
                && Objects.equals(destinationReference(), other.destinationReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Target").add("RepositoryName", repositoryName()).add("SourceReference", sourceReference())
                .add("DestinationReference", destinationReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "sourceReference":
            return Optional.ofNullable(clazz.cast(sourceReference()));
        case "destinationReference":
            return Optional.ofNullable(clazz.cast(destinationReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Target> {
        /**
         * <p>
         * The name of the repository that contains the pull request.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The branch of the repository that contains the changes for the pull request. Also known as the source branch.
         * </p>
         * 
         * @param sourceReference
         *        The branch of the repository that contains the changes for the pull request. Also known as the source
         *        branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceReference(String sourceReference);

        /**
         * <p>
         * The branch of the repository where the pull request changes are merged. Also known as the destination branch.
         * </p>
         * 
         * @param destinationReference
         *        The branch of the repository where the pull request changes are merged. Also known as the destination
         *        branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationReference(String destinationReference);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryName;

        private String sourceReference;

        private String destinationReference;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            repositoryName(model.repositoryName);
            sourceReference(model.sourceReference);
            destinationReference(model.destinationReference);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getSourceReference() {
            return sourceReference;
        }

        @Override
        public final Builder sourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public final void setSourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
        }

        public final String getDestinationReference() {
            return destinationReference;
        }

        @Override
        public final Builder destinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
            return this;
        }

        public final void setDestinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
        }

        @Override
        public Target build() {
            return new Target(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
