/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApprovalRuleTemplateDescriptionResponse extends CodeCommitResponse implements
        ToCopyableBuilder<UpdateApprovalRuleTemplateDescriptionResponse.Builder, UpdateApprovalRuleTemplateDescriptionResponse> {
    private static final SdkField<ApprovalRuleTemplate> APPROVAL_RULE_TEMPLATE_FIELD = SdkField
            .<ApprovalRuleTemplate> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateApprovalRuleTemplateDescriptionResponse::approvalRuleTemplate))
            .setter(setter(Builder::approvalRuleTemplate)).constructor(ApprovalRuleTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVAL_RULE_TEMPLATE_FIELD));

    private final ApprovalRuleTemplate approvalRuleTemplate;

    private UpdateApprovalRuleTemplateDescriptionResponse(BuilderImpl builder) {
        super(builder);
        this.approvalRuleTemplate = builder.approvalRuleTemplate;
    }

    /**
     * <p>
     * The structure and content of the updated approval rule template.
     * </p>
     * 
     * @return The structure and content of the updated approval rule template.
     */
    public ApprovalRuleTemplate approvalRuleTemplate() {
        return approvalRuleTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApprovalRuleTemplateDescriptionResponse)) {
            return false;
        }
        UpdateApprovalRuleTemplateDescriptionResponse other = (UpdateApprovalRuleTemplateDescriptionResponse) obj;
        return Objects.equals(approvalRuleTemplate(), other.approvalRuleTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateApprovalRuleTemplateDescriptionResponse")
                .add("ApprovalRuleTemplate", approvalRuleTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleTemplate":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApprovalRuleTemplateDescriptionResponse, T> g) {
        return obj -> g.apply((UpdateApprovalRuleTemplateDescriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApprovalRuleTemplateDescriptionResponse> {
        /**
         * <p>
         * The structure and content of the updated approval rule template.
         * </p>
         * 
         * @param approvalRuleTemplate
         *        The structure and content of the updated approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplate(ApprovalRuleTemplate approvalRuleTemplate);

        /**
         * <p>
         * The structure and content of the updated approval rule template.
         * </p>
         * This is a convenience that creates an instance of the {@link ApprovalRuleTemplate.Builder} avoiding the need
         * to create one manually via {@link ApprovalRuleTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApprovalRuleTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #approvalRuleTemplate(ApprovalRuleTemplate)}.
         * 
         * @param approvalRuleTemplate
         *        a consumer that will call methods on {@link ApprovalRuleTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalRuleTemplate(ApprovalRuleTemplate)
         */
        default Builder approvalRuleTemplate(Consumer<ApprovalRuleTemplate.Builder> approvalRuleTemplate) {
            return approvalRuleTemplate(ApprovalRuleTemplate.builder().applyMutation(approvalRuleTemplate).build());
        }
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private ApprovalRuleTemplate approvalRuleTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApprovalRuleTemplateDescriptionResponse model) {
            super(model);
            approvalRuleTemplate(model.approvalRuleTemplate);
        }

        public final ApprovalRuleTemplate.Builder getApprovalRuleTemplate() {
            return approvalRuleTemplate != null ? approvalRuleTemplate.toBuilder() : null;
        }

        @Override
        public final Builder approvalRuleTemplate(ApprovalRuleTemplate approvalRuleTemplate) {
            this.approvalRuleTemplate = approvalRuleTemplate;
            return this;
        }

        public final void setApprovalRuleTemplate(ApprovalRuleTemplate.BuilderImpl approvalRuleTemplate) {
            this.approvalRuleTemplate = approvalRuleTemplate != null ? approvalRuleTemplate.build() : null;
        }

        @Override
        public UpdateApprovalRuleTemplateDescriptionResponse build() {
            return new UpdateApprovalRuleTemplateDescriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
