/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.ApprovalState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Approval
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Approval> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Approval.getter(Approval::userArn)).setter(Approval.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()}).build();
    private static final SdkField<String> APPROVAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Approval.getter(Approval::approvalStateAsString)).setter(Approval.setter(Builder::approvalState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD, APPROVAL_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userArn;
    private final String approvalState;

    private Approval(BuilderImpl builder) {
        this.userArn = builder.userArn;
        this.approvalState = builder.approvalState;
    }

    public String userArn() {
        return this.userArn;
    }

    public ApprovalState approvalState() {
        return ApprovalState.fromValue(this.approvalState);
    }

    public String approvalStateAsString() {
        return this.approvalState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalStateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Approval)) {
            return false;
        }
        Approval other = (Approval)obj;
        return Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.approvalStateAsString(), other.approvalStateAsString());
    }

    public String toString() {
        return ToString.builder((String)"Approval").add("UserArn", (Object)this.userArn()).add("ApprovalState", (Object)this.approvalStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "approvalState": {
                return Optional.ofNullable(clazz.cast(this.approvalStateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Approval, T> g) {
        return obj -> g.apply((Approval)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userArn;
        private String approvalState;

        private BuilderImpl() {
        }

        private BuilderImpl(Approval model) {
            this.userArn(model.userArn);
            this.approvalState(model.approvalState);
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getApprovalStateAsString() {
            return this.approvalState;
        }

        @Override
        public final Builder approvalState(String approvalState) {
            this.approvalState = approvalState;
            return this;
        }

        @Override
        public final Builder approvalState(ApprovalState approvalState) {
            this.approvalState(approvalState == null ? null : approvalState.toString());
            return this;
        }

        public final void setApprovalState(String approvalState) {
            this.approvalState = approvalState;
        }

        public Approval build() {
            return new Approval(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Approval> {
        public Builder userArn(String var1);

        public Builder approvalState(String var1);

        public Builder approvalState(ApprovalState var1);
    }
}

