/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.Approval;
import software.amazon.awssdk.services.codecommit.model.ApprovalListCopier;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPullRequestApprovalStatesResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetPullRequestApprovalStatesResponse> {
    private static final SdkField<List<Approval>> APPROVALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetPullRequestApprovalStatesResponse.getter(GetPullRequestApprovalStatesResponse::approvals)).setter(GetPullRequestApprovalStatesResponse.setter(Builder::approvals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Approval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVALS_FIELD));
    private final List<Approval> approvals;

    private GetPullRequestApprovalStatesResponse(BuilderImpl builder) {
        super(builder);
        this.approvals = builder.approvals;
    }

    public List<Approval> approvals() {
        return this.approvals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.approvals());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPullRequestApprovalStatesResponse)) {
            return false;
        }
        GetPullRequestApprovalStatesResponse other = (GetPullRequestApprovalStatesResponse)((Object)obj);
        return Objects.equals(this.approvals(), other.approvals());
    }

    public String toString() {
        return ToString.builder((String)"GetPullRequestApprovalStatesResponse").add("Approvals", this.approvals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "approvals": {
                return Optional.ofNullable(clazz.cast(this.approvals()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPullRequestApprovalStatesResponse, T> g) {
        return obj -> g.apply((GetPullRequestApprovalStatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<Approval> approvals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPullRequestApprovalStatesResponse model) {
            super(model);
            this.approvals(model.approvals);
        }

        public final Collection<Approval.Builder> getApprovals() {
            return this.approvals != null ? (Collection)this.approvals.stream().map(Approval::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder approvals(Collection<Approval> approvals) {
            this.approvals = ApprovalListCopier.copy(approvals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvals(Approval ... approvals) {
            this.approvals(Arrays.asList(approvals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvals(Consumer<Approval.Builder> ... approvals) {
            this.approvals(Stream.of(approvals).map(c -> (Approval)((Approval.Builder)Approval.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApprovals(Collection<Approval.BuilderImpl> approvals) {
            this.approvals = ApprovalListCopier.copyFromBuilder(approvals);
        }

        @Override
        public GetPullRequestApprovalStatesResponse build() {
            return new GetPullRequestApprovalStatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPullRequestApprovalStatesResponse> {
        public Builder approvals(Collection<Approval> var1);

        public Builder approvals(Approval ... var1);

        public Builder approvals(Consumer<Approval.Builder> ... var1);
    }
}

