/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePullRequestStatusRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, UpdatePullRequestStatusRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePullRequestStatusRequest.getter(UpdatePullRequestStatusRequest::pullRequestId)).setter(UpdatePullRequestStatusRequest.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<String> PULL_REQUEST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePullRequestStatusRequest.getter(UpdatePullRequestStatusRequest::pullRequestStatusAsString)).setter(UpdatePullRequestStatusRequest.setter(Builder::pullRequestStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, PULL_REQUEST_STATUS_FIELD));
    private final String pullRequestId;
    private final String pullRequestStatus;

    private UpdatePullRequestStatusRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.pullRequestStatus = builder.pullRequestStatus;
    }

    public String pullRequestId() {
        return this.pullRequestId;
    }

    public PullRequestStatusEnum pullRequestStatus() {
        return PullRequestStatusEnum.fromValue(this.pullRequestStatus);
    }

    public String pullRequestStatusAsString() {
        return this.pullRequestStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePullRequestStatusRequest)) {
            return false;
        }
        UpdatePullRequestStatusRequest other = (UpdatePullRequestStatusRequest)((Object)obj);
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.pullRequestStatusAsString(), other.pullRequestStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePullRequestStatusRequest").add("PullRequestId", (Object)this.pullRequestId()).add("PullRequestStatus", (Object)this.pullRequestStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "pullRequestStatus": {
                return Optional.ofNullable(clazz.cast(this.pullRequestStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePullRequestStatusRequest, T> g) {
        return obj -> g.apply((UpdatePullRequestStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String pullRequestId;
        private String pullRequestStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePullRequestStatusRequest model) {
            super(model);
            this.pullRequestId(model.pullRequestId);
            this.pullRequestStatus(model.pullRequestStatus);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getPullRequestStatusAsString() {
            return this.pullRequestStatus;
        }

        @Override
        public final Builder pullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
            return this;
        }

        @Override
        public final Builder pullRequestStatus(PullRequestStatusEnum pullRequestStatus) {
            this.pullRequestStatus(pullRequestStatus == null ? null : pullRequestStatus.toString());
            return this;
        }

        public final void setPullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePullRequestStatusRequest build() {
            return new UpdatePullRequestStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePullRequestStatusRequest> {
        public Builder pullRequestId(String var1);

        public Builder pullRequestStatus(String var1);

        public Builder pullRequestStatus(PullRequestStatusEnum var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

