/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about an event for an approval rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApprovalRuleEventMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ApprovalRuleEventMetadata.Builder, ApprovalRuleEventMetadata> {
    private static final SdkField<String> APPROVAL_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApprovalRuleEventMetadata::approvalRuleName)).setter(setter(Builder::approvalRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleName").build()).build();

    private static final SdkField<String> APPROVAL_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApprovalRuleEventMetadata::approvalRuleId)).setter(setter(Builder::approvalRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleId").build()).build();

    private static final SdkField<String> APPROVAL_RULE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApprovalRuleEventMetadata::approvalRuleContent)).setter(setter(Builder::approvalRuleContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleContent").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVAL_RULE_NAME_FIELD,
            APPROVAL_RULE_ID_FIELD, APPROVAL_RULE_CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String approvalRuleName;

    private final String approvalRuleId;

    private final String approvalRuleContent;

    private ApprovalRuleEventMetadata(BuilderImpl builder) {
        this.approvalRuleName = builder.approvalRuleName;
        this.approvalRuleId = builder.approvalRuleId;
        this.approvalRuleContent = builder.approvalRuleContent;
    }

    /**
     * <p>
     * The name of the approval rule.
     * </p>
     * 
     * @return The name of the approval rule.
     */
    public String approvalRuleName() {
        return approvalRuleName;
    }

    /**
     * <p>
     * The system-generated ID of the approval rule.
     * </p>
     * 
     * @return The system-generated ID of the approval rule.
     */
    public String approvalRuleId() {
        return approvalRuleId;
    }

    /**
     * <p>
     * The content of the approval rule.
     * </p>
     * 
     * @return The content of the approval rule.
     */
    public String approvalRuleContent() {
        return approvalRuleContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleContent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalRuleEventMetadata)) {
            return false;
        }
        ApprovalRuleEventMetadata other = (ApprovalRuleEventMetadata) obj;
        return Objects.equals(approvalRuleName(), other.approvalRuleName())
                && Objects.equals(approvalRuleId(), other.approvalRuleId())
                && Objects.equals(approvalRuleContent(), other.approvalRuleContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApprovalRuleEventMetadata").add("ApprovalRuleName", approvalRuleName())
                .add("ApprovalRuleId", approvalRuleId()).add("ApprovalRuleContent", approvalRuleContent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleName":
            return Optional.ofNullable(clazz.cast(approvalRuleName()));
        case "approvalRuleId":
            return Optional.ofNullable(clazz.cast(approvalRuleId()));
        case "approvalRuleContent":
            return Optional.ofNullable(clazz.cast(approvalRuleContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApprovalRuleEventMetadata, T> g) {
        return obj -> g.apply((ApprovalRuleEventMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApprovalRuleEventMetadata> {
        /**
         * <p>
         * The name of the approval rule.
         * </p>
         * 
         * @param approvalRuleName
         *        The name of the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleName(String approvalRuleName);

        /**
         * <p>
         * The system-generated ID of the approval rule.
         * </p>
         * 
         * @param approvalRuleId
         *        The system-generated ID of the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleId(String approvalRuleId);

        /**
         * <p>
         * The content of the approval rule.
         * </p>
         * 
         * @param approvalRuleContent
         *        The content of the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleContent(String approvalRuleContent);
    }

    static final class BuilderImpl implements Builder {
        private String approvalRuleName;

        private String approvalRuleId;

        private String approvalRuleContent;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalRuleEventMetadata model) {
            approvalRuleName(model.approvalRuleName);
            approvalRuleId(model.approvalRuleId);
            approvalRuleContent(model.approvalRuleContent);
        }

        public final String getApprovalRuleName() {
            return approvalRuleName;
        }

        @Override
        public final Builder approvalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
            return this;
        }

        public final void setApprovalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
        }

        public final String getApprovalRuleId() {
            return approvalRuleId;
        }

        @Override
        public final Builder approvalRuleId(String approvalRuleId) {
            this.approvalRuleId = approvalRuleId;
            return this;
        }

        public final void setApprovalRuleId(String approvalRuleId) {
            this.approvalRuleId = approvalRuleId;
        }

        public final String getApprovalRuleContent() {
            return approvalRuleContent;
        }

        @Override
        public final Builder approvalRuleContent(String approvalRuleContent) {
            this.approvalRuleContent = approvalRuleContent;
            return this;
        }

        public final void setApprovalRuleContent(String approvalRuleContent) {
            this.approvalRuleContent = approvalRuleContent;
        }

        @Override
        public ApprovalRuleEventMetadata build() {
            return new ApprovalRuleEventMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
