/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictResolution implements SdkPojo, Serializable,
        ToCopyableBuilder<ConflictResolution.Builder, ConflictResolution> {
    private static final SdkField<List<ReplaceContentEntry>> REPLACE_CONTENTS_FIELD = SdkField
            .<List<ReplaceContentEntry>> builder(MarshallingType.LIST)
            .getter(getter(ConflictResolution::replaceContents))
            .setter(setter(Builder::replaceContents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replaceContents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplaceContentEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplaceContentEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DeleteFileEntry>> DELETE_FILES_FIELD = SdkField
            .<List<DeleteFileEntry>> builder(MarshallingType.LIST)
            .getter(getter(ConflictResolution::deleteFiles))
            .setter(setter(Builder::deleteFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteFiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeleteFileEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteFileEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SetFileModeEntry>> SET_FILE_MODES_FIELD = SdkField
            .<List<SetFileModeEntry>> builder(MarshallingType.LIST)
            .getter(getter(ConflictResolution::setFileModes))
            .setter(setter(Builder::setFileModes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setFileModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SetFileModeEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(SetFileModeEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACE_CONTENTS_FIELD,
            DELETE_FILES_FIELD, SET_FILE_MODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ReplaceContentEntry> replaceContents;

    private final List<DeleteFileEntry> deleteFiles;

    private final List<SetFileModeEntry> setFileModes;

    private ConflictResolution(BuilderImpl builder) {
        this.replaceContents = builder.replaceContents;
        this.deleteFiles = builder.deleteFiles;
        this.setFileModes = builder.setFileModes;
    }

    /**
     * Returns true if the ReplaceContents property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReplaceContents() {
        return replaceContents != null && !(replaceContents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Files to have content replaced as part of the merge conflict resolution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplaceContents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Files to have content replaced as part of the merge conflict resolution.
     */
    public List<ReplaceContentEntry> replaceContents() {
        return replaceContents;
    }

    /**
     * Returns true if the DeleteFiles property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDeleteFiles() {
        return deleteFiles != null && !(deleteFiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Files to be deleted as part of the merge conflict resolution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeleteFiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Files to be deleted as part of the merge conflict resolution.
     */
    public List<DeleteFileEntry> deleteFiles() {
        return deleteFiles;
    }

    /**
     * Returns true if the SetFileModes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSetFileModes() {
        return setFileModes != null && !(setFileModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * File modes that are set as part of the merge conflict resolution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSetFileModes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return File modes that are set as part of the merge conflict resolution.
     */
    public List<SetFileModeEntry> setFileModes() {
        return setFileModes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replaceContents());
        hashCode = 31 * hashCode + Objects.hashCode(deleteFiles());
        hashCode = 31 * hashCode + Objects.hashCode(setFileModes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictResolution)) {
            return false;
        }
        ConflictResolution other = (ConflictResolution) obj;
        return Objects.equals(replaceContents(), other.replaceContents()) && Objects.equals(deleteFiles(), other.deleteFiles())
                && Objects.equals(setFileModes(), other.setFileModes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConflictResolution").add("ReplaceContents", replaceContents()).add("DeleteFiles", deleteFiles())
                .add("SetFileModes", setFileModes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replaceContents":
            return Optional.ofNullable(clazz.cast(replaceContents()));
        case "deleteFiles":
            return Optional.ofNullable(clazz.cast(deleteFiles()));
        case "setFileModes":
            return Optional.ofNullable(clazz.cast(setFileModes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictResolution, T> g) {
        return obj -> g.apply((ConflictResolution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictResolution> {
        /**
         * <p>
         * Files to have content replaced as part of the merge conflict resolution.
         * </p>
         * 
         * @param replaceContents
         *        Files to have content replaced as part of the merge conflict resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceContents(Collection<ReplaceContentEntry> replaceContents);

        /**
         * <p>
         * Files to have content replaced as part of the merge conflict resolution.
         * </p>
         * 
         * @param replaceContents
         *        Files to have content replaced as part of the merge conflict resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceContents(ReplaceContentEntry... replaceContents);

        /**
         * <p>
         * Files to have content replaced as part of the merge conflict resolution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplaceContentEntry>.Builder} avoiding the
         * need to create one manually via {@link List<ReplaceContentEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplaceContentEntry>.Builder#build()} is called immediately
         * and its result is passed to {@link #replaceContents(List<ReplaceContentEntry>)}.
         * 
         * @param replaceContents
         *        a consumer that will call methods on {@link List<ReplaceContentEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replaceContents(List<ReplaceContentEntry>)
         */
        Builder replaceContents(Consumer<ReplaceContentEntry.Builder>... replaceContents);

        /**
         * <p>
         * Files to be deleted as part of the merge conflict resolution.
         * </p>
         * 
         * @param deleteFiles
         *        Files to be deleted as part of the merge conflict resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteFiles(Collection<DeleteFileEntry> deleteFiles);

        /**
         * <p>
         * Files to be deleted as part of the merge conflict resolution.
         * </p>
         * 
         * @param deleteFiles
         *        Files to be deleted as part of the merge conflict resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteFiles(DeleteFileEntry... deleteFiles);

        /**
         * <p>
         * Files to be deleted as part of the merge conflict resolution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeleteFileEntry>.Builder} avoiding the need
         * to create one manually via {@link List<DeleteFileEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeleteFileEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #deleteFiles(List<DeleteFileEntry>)}.
         * 
         * @param deleteFiles
         *        a consumer that will call methods on {@link List<DeleteFileEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteFiles(List<DeleteFileEntry>)
         */
        Builder deleteFiles(Consumer<DeleteFileEntry.Builder>... deleteFiles);

        /**
         * <p>
         * File modes that are set as part of the merge conflict resolution.
         * </p>
         * 
         * @param setFileModes
         *        File modes that are set as part of the merge conflict resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setFileModes(Collection<SetFileModeEntry> setFileModes);

        /**
         * <p>
         * File modes that are set as part of the merge conflict resolution.
         * </p>
         * 
         * @param setFileModes
         *        File modes that are set as part of the merge conflict resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setFileModes(SetFileModeEntry... setFileModes);

        /**
         * <p>
         * File modes that are set as part of the merge conflict resolution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SetFileModeEntry>.Builder} avoiding the
         * need to create one manually via {@link List<SetFileModeEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SetFileModeEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #setFileModes(List<SetFileModeEntry>)}.
         * 
         * @param setFileModes
         *        a consumer that will call methods on {@link List<SetFileModeEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setFileModes(List<SetFileModeEntry>)
         */
        Builder setFileModes(Consumer<SetFileModeEntry.Builder>... setFileModes);
    }

    static final class BuilderImpl implements Builder {
        private List<ReplaceContentEntry> replaceContents = DefaultSdkAutoConstructList.getInstance();

        private List<DeleteFileEntry> deleteFiles = DefaultSdkAutoConstructList.getInstance();

        private List<SetFileModeEntry> setFileModes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictResolution model) {
            replaceContents(model.replaceContents);
            deleteFiles(model.deleteFiles);
            setFileModes(model.setFileModes);
        }

        public final Collection<ReplaceContentEntry.Builder> getReplaceContents() {
            return replaceContents != null ? replaceContents.stream().map(ReplaceContentEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replaceContents(Collection<ReplaceContentEntry> replaceContents) {
            this.replaceContents = ReplaceContentEntriesCopier.copy(replaceContents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replaceContents(ReplaceContentEntry... replaceContents) {
            replaceContents(Arrays.asList(replaceContents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replaceContents(Consumer<ReplaceContentEntry.Builder>... replaceContents) {
            replaceContents(Stream.of(replaceContents).map(c -> ReplaceContentEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplaceContents(Collection<ReplaceContentEntry.BuilderImpl> replaceContents) {
            this.replaceContents = ReplaceContentEntriesCopier.copyFromBuilder(replaceContents);
        }

        public final Collection<DeleteFileEntry.Builder> getDeleteFiles() {
            return deleteFiles != null ? deleteFiles.stream().map(DeleteFileEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deleteFiles(Collection<DeleteFileEntry> deleteFiles) {
            this.deleteFiles = DeleteFileEntriesCopier.copy(deleteFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteFiles(DeleteFileEntry... deleteFiles) {
            deleteFiles(Arrays.asList(deleteFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteFiles(Consumer<DeleteFileEntry.Builder>... deleteFiles) {
            deleteFiles(Stream.of(deleteFiles).map(c -> DeleteFileEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDeleteFiles(Collection<DeleteFileEntry.BuilderImpl> deleteFiles) {
            this.deleteFiles = DeleteFileEntriesCopier.copyFromBuilder(deleteFiles);
        }

        public final Collection<SetFileModeEntry.Builder> getSetFileModes() {
            return setFileModes != null ? setFileModes.stream().map(SetFileModeEntry::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder setFileModes(Collection<SetFileModeEntry> setFileModes) {
            this.setFileModes = SetFileModeEntriesCopier.copy(setFileModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder setFileModes(SetFileModeEntry... setFileModes) {
            setFileModes(Arrays.asList(setFileModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder setFileModes(Consumer<SetFileModeEntry.Builder>... setFileModes) {
            setFileModes(Stream.of(setFileModes).map(c -> SetFileModeEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSetFileModes(Collection<SetFileModeEntry.BuilderImpl> setFileModes) {
            this.setFileModes = SetFileModeEntriesCopier.copyFromBuilder(setFileModes);
        }

        @Override
        public ConflictResolution build() {
            return new ConflictResolution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
